/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.service;

import com.trs.DreamFactory;
import com.trs.cms.auth.persistent.User;
import com.trs.components.metadata.definition.IMetaDataDefCacheMgr;
import com.trs.components.metadata.definition.IMetaDataDefMgr;
import com.trs.components.metadata.definition.MetaDBTable;
import com.trs.components.metadata.definition.MetaView;
import com.trs.components.metadata.definition.MetaViewField;
import com.trs.components.metadata.definition.MetaViewFields;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyString;
import java.util.List;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;

public class MetaViewImporter {
    private static Logger logger = Logger.getLogger(MetaViewImporter.class);
    private IMetaDataDefMgr m_oMetaDataDefMgr = null;
    private IMetaDataDefCacheMgr m_oDataDefCacheMgr = null;
    private MetaView m_oView = null;
    private User m_oCurrUser = null;
    private MetaDBTable m_oMainDBTable = null;

    public MetaViewImporter(User _currUser, MetaView _view) {
        this.m_oView = _view;
        this.m_oCurrUser = _currUser;
        this.m_oMetaDataDefMgr = (IMetaDataDefMgr)DreamFactory.createObjectById("IMetaDataDefMgr");
        this.m_oDataDefCacheMgr = (IMetaDataDefCacheMgr)DreamFactory.createObjectById("IMetaDataDefCacheMgr");
    }

    public MetaView importFromXML(String _sXML) throws Exception {
        Document root = DocumentHelper.parseText((String)_sXML);
        Element rootElement = root.getRootElement();
        this.saveCurrView(rootElement);
        MetaViewFields fields = new MetaViewFields(this.m_oCurrUser, rootElement.nodeCount() / 3, 1);
        int nCurrOrder = rootElement.nodeCount();
        int nFieldCount = 0;
        int i = 0;
        int nSize = rootElement.nodeCount();
        while (i < nSize) {
            Node node = rootElement.node(i);
            if (node != null && node instanceof Element) {
                try {
                    ++nFieldCount;
                    MetaViewField viewField = this.saveMetaViewField((Element)node, nCurrOrder);
                    if (viewField != null) {
                        fields.addElement(viewField);
                    }
                }
                catch (Throwable e) {
                    logger.error((Object)(I18NMessage.get(MetaViewImporter.class, "MetaViewImporter.label1", "\u4ea7\u751f\u7b2c[") + nFieldCount + I18NMessage.get(MetaViewImporter.class, "MetaViewImporter.label2", "]\u4e2a\u89c6\u56fe\u5b57\u6bb5\u53d1\u751f\u5f02\u5e38\uff01")), e);
                    logger.error((Object)node.asXML());
                }
            }
            ++i;
            --nCurrOrder;
        }
        String sIds = fields.getIdListAsString();
        String sDeleteSQL = null;
        sDeleteSQL = CMyString.isEmpty(sIds) ? "delete from XWCMVIEWFIELDINFO where ViewId=" + this.m_oView.getId() : "delete from XWCMVIEWFIELDINFO where ViewId=" + this.m_oView.getId() + " and VIEWFIELDINFOID not in(" + sIds + ")";
        DBManager.getDBManager().sqlExecuteUpdate(sDeleteSQL);
        this.m_oDataDefCacheMgr.reloadViewCache(this.m_oView.getId());
        this.m_oMetaDataDefMgr.createViewRelations(this.m_oCurrUser, this.m_oView);
        return this.m_oView;
    }

    private void saveCurrView(Element _rootElement) throws WCMException {
        int nViewId = 0;
        String sViewId = _rootElement.attributeValue("id");
        if (!CMyString.isEmpty(sViewId)) {
            nViewId = Integer.parseInt(sViewId);
        }
        String sEName = _rootElement.attributeValue("ename");
        String sCName = _rootElement.attributeValue("cname");
        this.makeMainTable(_rootElement, sEName, sCName);
        if (nViewId <= 0) {
            this.saveMetaView(_rootElement, sCName);
        } else {
            if (this.m_oView == null) {
                this.m_oView = MetaView.findById(nViewId);
                if (this.m_oView == null) {
                    throw new WCMException(I18NMessage.get(MetaViewImporter.class, "MetaViewImporter.label3", "\u6307\u5b9a\u7684\u89c6\u56fe\u6ca1\u6709\u83b7\u53d6\u5230\uff01[Id=") + nViewId + "]");
                }
            }
            this.saveMetaView(_rootElement, sCName);
        }
    }

    private MetaViewField saveMetaViewField(Element _elViewField, int _nOrder) throws WCMException {
        Element elDBField;
        int iDBFieldId;
        MetaViewField _oViewField;
        List elements;
        int nId = 0;
        String sId = _elViewField.attributeValue("id");
        if (!CMyString.isEmpty(sId)) {
            nId = Integer.parseInt(sId);
        }
        if (nId == 0 && this.m_oView != null && (elements = _elViewField.elements("DBField")).size() > 0 && (_oViewField = this.m_oMetaDataDefMgr.getMetaViewField(this.m_oView, iDBFieldId = Integer.parseInt((elDBField = (Element)elements.get(0)).getTextTrim()))) != null) {
            nId = _oViewField.getId();
        }
        MetaViewField oViewField = null;
        if (nId == 0) {
            oViewField = MetaViewField.createNewInstance();
        } else {
            oViewField = MetaViewField.findById(nId);
            if (oViewField == null) {
                logger.error((Object)(I18NMessage.get(MetaViewImporter.class, "MetaViewImporter.label4", "\u6307\u5b9a\u7684\u89c6\u56fe\u5b57\u6bb5\u6ca1\u6709\u83b7\u53d6\u5230\uff01[Id=") + nId + "]"));
                return null;
            }
            oViewField.validCanEditAndLock(this.m_oCurrUser);
        }
        int nPropertySize = _elViewField.nodeCount();
        for (int j = 0; j < nPropertySize; ++j) {
            Node nodeTemp = _elViewField.node(j);
            if (nodeTemp == null || !(nodeTemp instanceof Element)) continue;
            oViewField.setPropertyWithString(nodeTemp.getName(), nodeTemp.getText());
        }
        oViewField.setOrder(_nOrder);
        return this.m_oMetaDataDefMgr.save(this.m_oCurrUser, this.m_oView, oViewField);
    }

    private void saveMetaView(Element _rootElement, String _sCName) throws WCMException {
        if (this.m_oView == null) {
            this.m_oView = MetaView.createNewInstance();
        } else {
            this.m_oView.validCanEditAndLock(this.m_oCurrUser);
        }
        this.m_oView.setDesc(_sCName);
        this.m_oView.setMainTable(this.m_oMainDBTable);
        this.m_oView.setOtherTableIds(_rootElement.attributeValue("other-table-ids"));
        this.m_oView.setPropertyWithString("hiddenFileAppendix", _rootElement.attributeValue("hiddenFileAppendix"));
        this.m_oView.setPropertyWithString("hiddenImgAppendix", _rootElement.attributeValue("hiddenImgAppendix"));
        this.m_oView.setPropertyWithString("hiddenLinkAppendix", _rootElement.attributeValue("hiddenLinkAppendix"));
        this.m_oView = this.m_oMetaDataDefMgr.save(this.m_oCurrUser, this.m_oView);
    }

    private void makeMainTable(Element _rootElement, String _sEName, String _sCName) throws WCMException {
        int nMainTableId = 0;
        String sTemp = _rootElement.attributeValue("main-table-id");
        if (!CMyString.isEmpty(sTemp)) {
            nMainTableId = Integer.parseInt(sTemp);
        }
        if (nMainTableId == 0) {
            MetaDBTable oNewTable = MetaDBTable.createNewInstance();
            oNewTable.setName(_sEName);
            oNewTable.setAnotherName(_sCName);
            this.m_oMainDBTable = this.m_oMetaDataDefMgr.save(this.m_oCurrUser, oNewTable);
        } else {
            this.m_oMainDBTable = MetaDBTable.findById(nMainTableId);
            if (this.m_oMainDBTable == null) {
                throw new WCMException(I18NMessage.get(MetaViewImporter.class, "MetaViewImporter.label5", "\u6307\u5b9a\u7684\u8868\u6ca1\u6709\u83b7\u53d6\u5230\uff01[Id=") + nMainTableId + "]");
            }
        }
    }
}

