/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.publish;

import com.trs.DreamFactory;
import com.trs.cms.content.CMSBaseObjs;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.publish.config.PublishServerConfigMapper;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.tagparser.BaseTagParser4List;
import com.trs.components.common.publish.domain.tagparser.TagItem;
import com.trs.components.common.publish.domain.tagparser.TagParseHelper;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.common.publish.persistent.template.TemplateQuote;
import com.trs.components.metadata.center.IMetaViewEmployerMgr;
import com.trs.components.metadata.center.MetaViewDatas;
import com.trs.components.metadata.definition.MetaView;
import com.trs.components.wcm.content.domain.DocumentMgr;
import com.trs.components.wcm.content.domain.DocumentsGetHelper;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.components.wcm.publish.IFolderPubStatusCacheMgr;
import com.trs.components.wcm.publish.tagparser.WCMTagParserHelper;
import com.trs.components.wcm.resource.Status;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.DebugTimer;
import com.trs.infra.util.SQLUtil;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class WCMTagParserViewDatas
extends BaseTagParser4List {
    private static final Logger LOG = Logger.getLogger(WCMTagParserViewDatas.class);
    private static ArrayList FIELDS_DEFAULT_LIST_OF_DOCUMENT = new ArrayList(16);
    private static ArrayList FIELDS_DEFAULT_LIST_OF_METADATA;
    private IMetaViewEmployerMgr m_oViewEmployerMgr = null;
    private MetaView m_oCurrView = null;
    private BaseChannel m_oChannel = null;
    private TagItem m_oTagItem = null;
    private Logger m_oLogger = Logger.getLogger(WCMTagParserViewDatas.class);

    public WCMTagParserViewDatas() {
        this.m_oViewEmployerMgr = (IMetaViewEmployerMgr)DreamFactory.createObjectById("IMetaViewEmployerMgr");
    }

    @Override
    public String[] parse(PublishTagContext _context) throws WCMException {
        this.makeCurrChannel(_context);
        if (this.m_oChannel != null) {
            this.m_oCurrFolder = (IPublishFolder)PublishElementFactory.makeElementFrom(this.m_oChannel);
        }
        return super.parse(_context);
    }

    public void makeCurrChannel(PublishTagContext _context) {
        try {
            int nChannelId = _context.getAttribute("ChannelId", 0);
            this.m_oChannel = nChannelId != 0 ? Channel.findById(nChannelId) : WCMTagParserHelper.findFolderHost(_context.getTagItem(), _context, false);
        }
        catch (Exception e) {
            this.m_oLogger.debug((Object)e);
        }
    }

    @Override
    protected CMSBaseObjs findObjects(PublishTagContext _context) throws WCMException {
        this.makeCurrView(_context);
        String sMetaDataIds = _context.getAttribute("MetaDataIds");
        if (sMetaDataIds != null && (sMetaDataIds = sMetaDataIds.trim()).length() > 0) {
            return MetaViewDatas.findByIds(this.m_oCurrView, sMetaDataIds);
        }
        String sExtraWhere = _context.getAttribute("Where");
        String sOrder = _context.getAttribute("Order");
        if (this.m_oChannel == null || _context.getAttribute("DirectFromMetaTable", false)) {
            WCMFilter filter = new WCMFilter(null, null, null);
            StringBuffer sbWhere = new StringBuffer(300);
            sbWhere.append("exists(select WCMChnlDoc.DocId from WCMChnlDoc where WCMChnlDoc.ChnlId>=1 and WCMChnlDoc.Modal>=1 and WCMChnlDoc.DocId=");
            sbWhere.append(this.m_oCurrView.getTrueTableName() + ".MetaDataId");
            sbWhere.append(" and WCMChnlDoc.docKind =? ");
            filter.addSearchValues(this.m_oCurrView.getId());
            int[] _pStatuses = Status.getStatusCanDoPubInOutline();
            if (_context.isPreview() && this.m_oChannel != null) {
                IPublishFolder folder = (IPublishFolder)PublishElementFactory.makeElementFrom(this.m_oChannel);
                _pStatuses = this.getPreviewStatus(folder);
            }
            sbWhere.append(" and WCMChnlDoc.DOCSTATUS in(");
            for (int i = 0; i < _pStatuses.length; ++i) {
                sbWhere.append("?,");
                filter.addSearchValues(_pStatuses[i]);
            }
            if (_pStatuses.length > 0) {
                sbWhere.setLength(sbWhere.length() - 1);
            }
            sbWhere.append(")");
            if (this.m_oChannel != null && !_context.getAttribute("IgnoreChannel", false)) {
                if (this.m_oChannel.isSite()) {
                    sbWhere.append(" and WCMChnlDoc.ChnlId in(select WCMChannel.ChannelId from WCMChannel where WCMChannel.SiteId=?)");
                    filter.addSearchValues(this.m_oChannel.getId());
                } else {
                    String sQuery;
                    Channel oChannel = (Channel)this.m_oChannel;
                    if (!oChannel.isOnlySearch()) {
                        sbWhere.append(" and WCMChnlDoc.ChnlId=?");
                        filter.addSearchValues(this.m_oChannel.getId());
                    }
                    if ((sQuery = oChannel.getQuery()) != null && sQuery.length() > 0) {
                        sbWhere.append(sbWhere.length() > 0 ? " and (" : "(");
                        sbWhere.append(sQuery);
                        sbWhere.append(')');
                    }
                }
            }
            sbWhere.append(")");
            if (!CMyString.isEmpty(sExtraWhere)) {
                sbWhere.append(" and (" + sExtraWhere + ")");
            }
            filter.setWhere(sbWhere.toString());
            if (CMyString.isEmpty(sOrder) || !SQLUtil.isValidOrder(this.m_oCurrView.getTrueTableName(), sOrder)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Invalid order by:" + sOrder));
                }
                sOrder = "MetaDataId desc";
            }
            filter.setOrder(sOrder);
            MetaViewDatas viewDatas = new MetaViewDatas(this.m_oCurrView);
            String sSelectFields = this.getSelectFields(this.m_oCurrView.getTrueTableName().toUpperCase(), "TRS_VIEWDATA", _context);
            viewDatas.setSelectFieldsOfMetaTable(sSelectFields);
            int nMaxNum = _context.getAttribute("NUM", -1);
            if (nMaxNum == -1) {
                nMaxNum = 300;
                _context.getTagItem().setAttribute("NUM", nMaxNum);
            }
            viewDatas.setPageSize(nMaxNum);
            viewDatas.setMaxBufferSize(nMaxNum);
            viewDatas.open(filter);
            return viewDatas;
        }
        WCMFilter extraFilter = new WCMFilter(null, null, sOrder);
        sExtraWhere = !CMyString.isEmpty(sExtraWhere) ? "exists(select " + this.m_oCurrView.getTrueTableName() + ".MetaDataId from " + this.m_oCurrView.getTrueTableName() + " where (" + sExtraWhere + ") and WCMChnlDoc.DocId=" + this.m_oCurrView.getTrueTableName() + ".MetaDataId)" : "exists(select " + this.m_oCurrView.getTrueTableName() + ".MetaDataId from " + this.m_oCurrView.getTrueTableName() + " where  WCMChnlDoc.DocId=" + this.m_oCurrView.getTrueTableName() + ".MetaDataId)";
        extraFilter.setWhere(sExtraWhere);
        WCMFilter filter = new WCMFilter("WCMChnlDoc", "WCMChnlDoc.DocKind=?", "", this.getSelectFields("WCMDOCUMENT", "TRS_DOCUMENT", _context));
        filter.mergeWith(extraFilter);
        filter.addSearchValues(this.m_oCurrView.getId());
        IPublishFolder folder = (IPublishFolder)PublishElementFactory.makeElementFrom(this.m_oChannel);
        if (_context.isPreview()) {
            return this.getPreviewContents(folder, filter);
        }
        return this.getPublishedContents(filter);
    }

    @Override
    protected boolean isValidate(PublishTagContext _context) throws WCMException {
        this.makeCurrView(_context);
        return true;
    }

    private void makeCurrView(PublishTagContext _context) throws WCMException {
        if (this.m_oCurrView != null) {
            return;
        }
        int nViewId = _context.getAttribute("ViewId", 0);
        if (nViewId > 0) {
            this.m_oCurrView = MetaView.findById(nViewId);
        } else {
            IPublishElement upperHost = _context.getUpperHost();
            CMSObj subinstance = upperHost.getSubstance();
            if (subinstance instanceof MetaView) {
                this.m_oCurrView = (MetaView)subinstance;
            } else {
                if (this.m_oChannel == null || !(this.m_oChannel instanceof Channel)) {
                    throw new WCMException(I18NMessage.get(WCMTagParserViewDatas.class, "WCMTagParserViewDatas.label1", "\u7f6e\u6807\u4f7f\u7528\u573a\u666f\u4e0d\u5bf9\uff0c\u53ea\u80fd\u7528\u5728\u5143\u6570\u636e\u89c6\u56fe\u3001\u6307\u5b9a\u680f\u76ee\u6216\u8005\u6307\u5b9a\u6587\u6863\u4e0a\uff01\u5f53\u524d\u5bf9\u8c61\u662f[") + subinstance.getClassName(true) + I18NMessage.get(WCMTagParserViewDatas.class, "WCMTagParserViewDatas.label2", "]\u7684\u5b9e\u4f8b"));
                }
                this.m_oCurrView = this.m_oViewEmployerMgr.getViewOfEmployer((Channel)this.m_oChannel);
            }
        }
        if (this.m_oCurrView == null) {
            throw new WCMException(I18NMessage.get(WCMTagParserViewDatas.class, "WCMTagParserViewDatas.label3", "\u6ca1\u6709\u5173\u8054\u7684\u89c6\u56fe\uff01"));
        }
        HashMap<String, MetaView> hExtraAttributes = _context.getExtraAttributes();
        if (hExtraAttributes == null) {
            hExtraAttributes = new HashMap<String, MetaView>(1);
            _context.setExtraAttributes(hExtraAttributes);
        }
        hExtraAttributes.put("Curr.View", this.m_oCurrView);
    }

    private int[] getPreviewStatus(IPublishFolder _folder) throws WCMException {
        IPublishFolder root = _folder.getRoot();
        IFolderPubStatusCacheMgr m_oCacheMgr = (IFolderPubStatusCacheMgr)DreamFactory.createObjectById("IFolderPubStatusCacheMgr");
        int[] pCanDoPubStatusIds = m_oCacheMgr.findStatusesCanDoIncreasePub(root.getType(), root.getId());
        int[] pCanDoPubLogicIds = Status.getStatusCanDoPubInOutline();
        if (pCanDoPubStatusIds == null) {
            return pCanDoPubLogicIds;
        }
        int[] pStatusIds = new int[pCanDoPubStatusIds.length + pCanDoPubLogicIds.length];
        System.arraycopy(pCanDoPubStatusIds, 0, pStatusIds, 0, pCanDoPubStatusIds.length);
        System.arraycopy(pCanDoPubLogicIds, 0, pStatusIds, pCanDoPubStatusIds.length, pCanDoPubLogicIds.length);
        return pStatusIds;
    }

    private int[] getPublishStatus() throws WCMException {
        return Status.getStatusCanDoPubInOutline();
    }

    private CMSBaseObjs getPreviewContents(IPublishFolder _folder, WCMFilter _filter) throws WCMException {
        return this.getContents(this.getPreviewStatus(_folder), _filter);
    }

    private CMSBaseObjs getPublishedContents(WCMFilter _filter) throws WCMException {
        return this.getContents(this.getPublishStatus(), _filter);
    }

    private CMSBaseObjs getContents(int[] _pStatuses, WCMFilter _filter) throws WCMException {
        if (_pStatuses == null || _pStatuses.length <= 0) {
            return null;
        }
        DebugTimer aTimer = new DebugTimer();
        aTimer.start();
        WCMFilter filter = new WCMFilter("", "", "");
        filter.setMaxRowNumber(PublishServerConfigMapper.getTemplateParseConfig().getWcmOutlineContentsMaxNum());
        String sWhere = "WCMCHNLDOC.DOCSTATUS in(?";
        filter.addSearchValues(0, _pStatuses[0]);
        int nSize = _pStatuses.length;
        for (int i = 1; i < nSize; ++i) {
            sWhere = sWhere + ",?";
            filter.addSearchValues(i, _pStatuses[i]);
        }
        sWhere = sWhere + ")";
        filter.setWhere(sWhere);
        if (_filter != null) {
            filter.mergeWith(_filter);
        }
        this.m_oLogger.debug((Object)filter);
        Documents docs = null;
        if (Document.DOCUMENTS_GET_OPTIMIZE) {
            if (this.m_oChannel == null || !(this.m_oChannel instanceof Channel)) {
                throw new WCMException(I18NMessage.get(WCMTagParserViewDatas.class, "WCMTagParserViewDatas.label4", "\u7f6e\u6807\u4f7f\u7528\u573a\u666f\u4e0d\u5bf9\uff0c\u53ea\u80fd\u7528\u5728\u5143\u6570\u636e\u89c6\u56fe\u6216\u6307\u5b9a\u680f\u76ee\u4e0a\uff01\u5f53\u524d\u5bf9\u8c61\u662f[") + this.m_oChannel + I18NMessage.get(WCMTagParserViewDatas.class, "WCMTagParserViewDatas.label2", "]\u7684\u5b9e\u4f8b"));
            }
            docs = DocumentsGetHelper.getDocuments((Channel)this.m_oChannel, filter);
        } else {
            DocumentMgr mgr = (DocumentMgr)DreamFactory.createObjectById("DocumentMgr");
            docs = mgr.getDocuments(this.m_oChannel, filter);
        }
        aTimer.stop();
        return docs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getSelectFields(String _sTableName, String _sElementTagName, PublishTagContext _tagContext) {
        String sKey = (_sTableName + ".SELECT").toUpperCase();
        String sSelectFields = _tagContext.getTagItem().getExtraAttributeValue(sKey);
        if (sSelectFields == null) {
            TagItem tagItem = _tagContext.getTagItem();
            synchronized (tagItem) {
                sSelectFields = _tagContext.getTagItem().getExtraAttributeValue(sKey);
                if (sSelectFields == null) {
                    sSelectFields = this.makeSelectFields(_sTableName, _sElementTagName, _tagContext);
                    _tagContext.getTagItem().setExtraAttribute(sKey, sSelectFields);
                }
            }
        }
        return sSelectFields;
    }

    private String makeSelectFields(String _sTableName, String _sTagName, PublishTagContext _tagContext) {
        ArrayList arDefaultFields = null;
        arDefaultFields = _sTableName.equalsIgnoreCase("WCMDOCUMENT") ? FIELDS_DEFAULT_LIST_OF_DOCUMENT : FIELDS_DEFAULT_LIST_OF_METADATA;
        String sSelectFields = (String)arDefaultFields.get(0);
        int nSize = arDefaultFields.size();
        for (int i = 1; i < nSize; ++i) {
            sSelectFields = sSelectFields + "," + arDefaultFields.get(i);
        }
        ArrayList listChildFields = TagParseHelper.makeSelectFields(_tagContext.getTagItem(), _sTagName);
        DBManager dbMgr = DBManager.getDBManager();
        int nSize2 = listChildFields.size();
        for (int i = 0; i < nSize2; ++i) {
            String sFieldName = (String)listChildFields.get(i);
            if (arDefaultFields.indexOf(sFieldName) >= 0) continue;
            try {
                if (dbMgr.getFieldInfo(_sTableName, sFieldName) == null) {
                    _tagContext.addWarning(I18NMessage.get(WCMTagParserViewDatas.class, "WCMTagParserViewDatas.label5", "TRS_DOCUMENT\u7f6e\u6807\u6307\u5b9a\u7684Field[") + sFieldName + I18NMessage.get(WCMTagParserViewDatas.class, "WCMTagParserViewDatas.label6", "]\u5728WCMDocument\u8868\u4e2d\u4e0d\u5b58\u5728\uff01"));
                    continue;
                }
            }
            catch (WCMException ex) {
                ex.printStackTrace();
                try {
                    _tagContext.addWarning(I18NMessage.get(WCMTagParserViewDatas.class, "WCMTagParserViewDatas.label7", "\u83b7\u53d6\u6307\u5b9a\u7684Field[") + sFieldName + I18NMessage.get(WCMTagParserViewDatas.class, "WCMTagParserViewDatas.label8", "]\u4eceWCMDocument\u8868\u4e2d\u53d1\u751f\u5f02\u5e38\uff01") + CMyException.getStackTraceText(ex));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            sSelectFields = sSelectFields + "," + sFieldName;
        }
        if (!_sTableName.equalsIgnoreCase("WCMDOCUMENT")) {
            ArrayList listChildFieldsForOther = TagParseHelper.makeSelectFields(_tagContext.getTagItem(), "TRS_RELNEWS");
            int nSize3 = listChildFieldsForOther.size();
            for (int i = 0; i < nSize3; ++i) {
                String sFieldName = (String)listChildFieldsForOther.get(i);
                if (arDefaultFields.indexOf(sFieldName) >= 0 || listChildFields.indexOf(sFieldName) >= 0) continue;
                try {
                    if (dbMgr.getFieldInfo(_sTableName, sFieldName) == null) {
                        _tagContext.addWarning(I18NMessage.get(WCMTagParserViewDatas.class, "WCMTagParserViewDatas.label5", "TRS_DOCUMENT\u7f6e\u6807\u6307\u5b9a\u7684Field[") + sFieldName + I18NMessage.get(WCMTagParserViewDatas.class, "WCMTagParserViewDatas.label6", "]\u5728WCMDocument\u8868\u4e2d\u4e0d\u5b58\u5728\uff01"));
                        continue;
                    }
                }
                catch (WCMException ex) {
                    ex.printStackTrace();
                    try {
                        _tagContext.addWarning(I18NMessage.get(WCMTagParserViewDatas.class, "WCMTagParserViewDatas.label7", "\u83b7\u53d6\u6307\u5b9a\u7684Field[") + sFieldName + I18NMessage.get(WCMTagParserViewDatas.class, "WCMTagParserViewDatas.label8", "]\u4eceWCMDocument\u8868\u4e2d\u53d1\u751f\u5f02\u5e38\uff01") + CMyException.getStackTraceText(ex));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                sSelectFields = sSelectFields + "," + sFieldName;
            }
        }
        return sSelectFields;
    }

    @Override
    public void setTagItem(TagItem _item) {
        this.m_oTagItem = _item;
    }

    @Override
    public TemplateQuote[] analyzeQuotes(IPublishFolder _root) throws WCMException {
        String sChannelIds = this.m_oTagItem.getAttributeTrim("triggerChannelIds");
        if (CMyString.isEmpty(sChannelIds)) {
            sChannelIds = this.m_oTagItem.getAttribute("ChannelId");
        }
        if (CMyString.isEmpty(sChannelIds)) {
            String sChnlName = this.m_oTagItem.getAttributeTrim("ID");
            try {
                Channel channel = Channel.findByName(_root.getId(), sChnlName);
                sChannelIds = String.valueOf(channel.getId());
            }
            catch (Exception channel) {
                // empty catch block
            }
        }
        if (CMyString.isEmpty(sChannelIds)) {
            return null;
        }
        Channels oChannels = Channels.findByIds(null, sChannelIds);
        TemplateQuote[] pTemplateQuote = new TemplateQuote[oChannels.size()];
        int nSize = oChannels.size();
        for (int i = 0; i < nSize; ++i) {
            Channel oChannel = (Channel)oChannels.getAt(i);
            if (oChannel == null) continue;
            TemplateQuote aQuote = new TemplateQuote();
            aQuote.setQuoteType(1);
            aQuote.setQuotedFolder(oChannel.getWCMType(), oChannel.getId(), -1);
            pTemplateQuote[i] = aQuote;
        }
        return pTemplateQuote;
    }

    static {
        FIELDS_DEFAULT_LIST_OF_DOCUMENT.add("DOCID");
        FIELDS_DEFAULT_LIST_OF_DOCUMENT.add("DOCCHANNEL");
        FIELDS_DEFAULT_LIST_OF_DOCUMENT.add("DOCSTATUS");
        FIELDS_DEFAULT_LIST_OF_DOCUMENT.add("DOCTITLE");
        FIELDS_DEFAULT_LIST_OF_DOCUMENT.add("DOCKIND");
        FIELDS_DEFAULT_LIST_OF_DOCUMENT.add("DOCVERSION");
        FIELDS_DEFAULT_LIST_OF_DOCUMENT.add("DOCRELTIME");
        FIELDS_DEFAULT_LIST_OF_DOCUMENT.add("DOCPUBTIME");
        FIELDS_DEFAULT_LIST_OF_DOCUMENT.add("CRTIME");
        FIELDS_DEFAULT_LIST_OF_METADATA = new ArrayList(4);
        FIELDS_DEFAULT_LIST_OF_METADATA.add("MetaDataId");
        FIELDS_DEFAULT_LIST_OF_METADATA.add("ChannelId");
        FIELDS_DEFAULT_LIST_OF_METADATA.add("CRTIME");
    }
}

