/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.publish;

import com.trs.DreamFactory;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.publish.domain.publisher.PublishPathCompass;
import com.trs.components.common.publish.domain.publisher.PublishSyncGlobalTuner;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.tagparser.TagBeanInfo;
import com.trs.components.common.publish.domain.tagparser.TagItem;
import com.trs.components.common.publish.domain.tagparser.TagParseHelper;
import com.trs.components.common.publish.domain.tagparser.TagParserContentBase;
import com.trs.components.common.publish.parser.HTMLContentParseHelper;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.metadata.center.MetaViewData;
import com.trs.components.metadata.definition.ClassInfo;
import com.trs.components.metadata.definition.ClassInfos;
import com.trs.components.metadata.definition.IMetaDataDefCacheMgr;
import com.trs.components.metadata.definition.MetaView;
import com.trs.components.metadata.definition.MetaViewField;
import com.trs.components.metadata.publish.PublishContentViewFieldImpl;
import com.trs.components.wcm.content.persistent.Appendix;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.publish.tagparser.WCMAppendixGenerator;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.support.file.FileHelper;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.CMyUnzip;
import com.trs.infra.util.store.FileService;
import com.trs.infra.util.store.FileStore;
import com.trs.wcm.publish.ImgFileParserHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class WCMTagParserViewData
extends TagParserContentBase {
    private static Logger logger = Logger.getLogger(WCMTagParserViewData.class);
    private IMetaDataDefCacheMgr m_oDataDefCacheMgr = (IMetaDataDefCacheMgr)DreamFactory.createObjectById("IMetaDataDefCacheMgr");
    private static final int CHNL_DESC = 100;
    private static final int CHNL_NAME = 200;
    private static final int HOME_SITE = 201;
    private static final int HOME_SITENAME = 202;
    private static ArrayList FIELDS_DEFAULT_LIST_OF_METADATA = new ArrayList(4);

    public String[] parseSubItems(PublishTagContext _context) throws WCMException {
        TagItem oTagItem = _context.getTagItem();
        List tagChildren = oTagItem.getChildren();
        PublishTagContext tagContext = new PublishTagContext(_context, oTagItem);
        IPublishContent content = (IPublishContent)PublishElementFactory.makeElementFrom(this.m_host);
        content.setFolder(_context.getUpperFolder());
        tagContext.setUpperHost(content);
        return TagParseHelper.parseItems(tagChildren, tagContext);
    }

    @Override
    public String[] parse(PublishTagContext _context) throws WCMException {
        this.m_host = this.findHost(_context);
        if (this.m_host == null) {
            return null;
        }
        if (_context.getAttribute("ParseIFNotNull") == null) {
            TagItem oTagItem = _context.getTagItem();
            boolean bContainConditionItem = WCMTagParserViewData.containsTagItemChild(oTagItem);
            if (bContainConditionItem) {
                return this.parseSubItems(_context);
            }
            return this.parsePropety(_context);
        }
        String[] pResult = this.parsePropety(_context);
        if (!_context.getAttribute("ParseIFNotNull", false)) {
            return pResult;
        }
        if (pResult == null || pResult.length == 1 && CMyString.isEmpty(pResult[0])) {
            return null;
        }
        TagItem oTagItem = _context.getTagItem();
        List tagChildren = oTagItem.getChildren();
        return TagParseHelper.parseItems(tagChildren, _context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String[] parsePropety(PublishTagContext _context) throws WCMException {
        IPublishElement originalUpperHost = null;
        boolean bNeedReset = false;
        String[] result = null;
        try {
            MetaViewData viewData = (MetaViewData)this.m_host;
            String sFieldName = _context.getAttribute("Field");
            MetaViewField viewField = this.m_oDataDefCacheMgr.getMetaViewField(viewData.getMetaView().getId(), sFieldName);
            int nViewFieldType = -1;
            if (viewField != null) {
                nViewFieldType = viewField.getType();
            }
            if ((originalUpperHost = _context.getUpperHost()) instanceof PublishContentViewFieldImpl) {
                bNeedReset = true;
                this.resetUpperHost(_context, this.m_host);
            }
            if (viewField != null && !viewData.getProperties().containsKey(sFieldName.toUpperCase()) && viewData.getProperties().containsKey(viewField.getDBName().toUpperCase())) {
                sFieldName = viewField.getDBName();
            }
            switch (nViewFieldType) {
                case 19: {
                    result = this.generateBigFileAppendix(_context, sFieldName);
                    break;
                }
                case 8: {
                    result = this.generateAppendix(_context, sFieldName);
                    break;
                }
                case 12: 
                case 16: {
                    result = this.parseHtmlContent(viewData.getPropertyAsString(sFieldName), _context);
                    break;
                }
                case 10: {
                    result = this.makeClassInfo(_context, viewData, sFieldName);
                    break;
                }
                case 3: 
                case 4: {
                    result = this.parseText(_context, sFieldName);
                    break;
                }
                case 18: {
                    String sValue = viewData.getPropertyAsString(sFieldName);
                    if (sValue == null || (sValue = sValue.trim()).length() <= 0) {
                        String[] stringArray = null;
                        if (originalUpperHost == null) return stringArray;
                        if (!bNeedReset) return stringArray;
                        _context.setUpperHost(originalUpperHost);
                        return stringArray;
                    }
                    result = this.parseProperty(sValue, _context);
                    break;
                }
                default: {
                    result = super.parse(_context, sFieldName);
                }
            }
            if (originalUpperHost == null) return result;
            if (!bNeedReset) return result;
            _context.setUpperHost(originalUpperHost);
            return result;
        }
        catch (Throwable throwable) {
            if (originalUpperHost == null) throw throwable;
            if (!bNeedReset) throw throwable;
            _context.setUpperHost(originalUpperHost);
            throw throwable;
        }
    }

    private String[] parseText(PublishTagContext _context, String _sFieldName) throws WCMException {
        String sText = this.m_host.getPropertyAsString(_sFieldName);
        if (sText == null || !_context.getAttribute("WML", false)) {
            return super.parse(_context, _sFieldName);
        }
        return this.makeWmlContent(_context, sText);
    }

    private String[] makeWmlContent(PublishTagContext _context, String _sResult) throws WCMException {
        IPublishElement element = _context.getPageElement();
        if (!(element instanceof IPublishContent)) {
            return super.parse(_context);
        }
        int nMaxNum = _context.getAttribute("PAGENUM", 900);
        if (nMaxNum <= 0) {
            return super.parse(_context);
        }
        String sFileName = PublishPathCompass.makeDetailPageFileName((IPublishContent)element);
        String sFileExt = _context.getPageContext().getTemplate().getOutputFileExt();
        ArrayList<String> list = new ArrayList<String>(5);
        StringBuffer buff = new StringBuffer(1024);
        int nEnLen = 1;
        int nChLen = 3;
        int nCurrLen = 0;
        int nPageIndex = 0;
        int nGet = 0;
        String temp = null;
        char[] chars = _sResult.toCharArray();
        char ch2 = '\u0000';
        for (char ch2 : chars) {
            int n = nCurrLen = ch2 <= '\u007f' ? nEnLen : nChLen;
            if ((nGet += nCurrLen) > nMaxNum) {
                temp = TagParseHelper.formatTextIfNeeded(_context, buff.toString());
                buff.setLength(0);
                buff.append(temp);
                buff.append("<br />");
                buff.append(WCMTagParserViewData.makeCurrNavContent(sFileName, sFileExt, nPageIndex, true));
                list.add(buff.toString());
                buff.setLength(0);
                ++nPageIndex;
                nGet = nCurrLen;
            }
            buff.append(ch2);
        }
        int nImgCount = 0;
        try {
            temp = _context.getPageContext().getExtraAttribute("PAGVAR_WMLIMGCOUNT");
            nImgCount = Integer.parseInt(temp) - 1;
        }
        catch (Exception len) {
            // empty catch block
        }
        if (buff.length() > 0) {
            temp = TagParseHelper.formatTextIfNeeded(_context, buff.toString());
            buff.setLength(0);
            buff.append(temp);
            if (nPageIndex > 0 || nImgCount > nPageIndex) {
                buff.append("<br />");
                buff.append(WCMTagParserViewData.makeCurrNavContent(sFileName, sFileExt, nPageIndex, nImgCount > nPageIndex));
            }
            list.add(buff.toString());
            buff.setLength(0);
        }
        buff.setLength(0);
        nImgCount -= nPageIndex;
        while (--nImgCount >= 0) {
            buff.append("<br />");
            buff.append(WCMTagParserViewData.makeCurrNavContent(sFileName, sFileExt, ++nPageIndex, nImgCount > 0));
            list.add(buff.toString());
            buff.setLength(0);
        }
        String[] result = new String[list.size()];
        result = list.toArray(result);
        return result;
    }

    private static String makeCurrNavContent(String _sFileName, String _sFileExt, int _nIndex, boolean _bDisplayPre) {
        String sURL;
        StringBuffer sbNavContent = new StringBuffer();
        if (_nIndex > 0) {
            sURL = null;
            sURL = _nIndex == 1 ? _sFileName + "." + _sFileExt : _sFileName + "_" + (_nIndex - 1) + "." + _sFileExt;
            sbNavContent.append("<a href=\"" + sURL + "\">&lt;&lt;" + I18NMessage.get(WCMTagParserViewData.class, "WCMTagParserViewData.label1", "\u4e0a\u4e00\u9875") + "</a>");
            sbNavContent.append("&nbsp;&nbsp;");
        }
        if (_bDisplayPre) {
            sURL = _sFileName + "_" + (_nIndex + 1) + "." + _sFileExt;
            sbNavContent.append("<a href=\"" + sURL + "\">" + I18NMessage.get(WCMTagParserViewData.class, "WCMTagParserViewData.label2", "\u4e0b\u4e00\u9875") + "&gt;&gt;</a>");
        }
        return sbNavContent.toString();
    }

    private String[] makeClassInfo(PublishTagContext _context, MetaViewData _viewData, String _sFieldName) throws WCMException {
        ClassInfos classInfos = ClassInfos.findByIds(null, _viewData.getPropertyAsString(_sFieldName));
        if (classInfos.isEmpty()) {
            return null;
        }
        String sClassFieldName = _context.getAttribute("ClassField");
        if (CMyString.isEmpty(sClassFieldName)) {
            sClassFieldName = "CNAME";
        }
        boolean bFullPath = _context.getAttribute("FullPath", false);
        String sSeperator = _context.getAttribute("SEPERATOR");
        if (CMyString.isEmpty(sSeperator)) {
            sSeperator = "\\";
        }
        boolean bDisplayParentName = _context.getAttribute("DisplayParentName", false);
        StringBuffer sbClassPaths = new StringBuffer();
        int nSize = classInfos.size();
        for (int i = 0; i < nSize; ++i) {
            ClassInfo classInfo = (ClassInfo)classInfos.getAt(i);
            if (classInfo == null) continue;
            if (bFullPath) {
                String sClassInfoPath = classInfo.getPropertyAsString(sClassFieldName);
                ClassInfo parentClassInfo = ClassInfo.findById(classInfo.getParentId());
                while (parentClassInfo != null) {
                    sClassInfoPath = parentClassInfo.getPropertyAsString(sClassFieldName) + sSeperator + sClassInfoPath;
                    if ((parentClassInfo = ClassInfo.findById(parentClassInfo.getParentId())) != null && !parentClassInfo.isRoot()) continue;
                }
                sbClassPaths.append(sClassInfoPath);
            } else if (bDisplayParentName) {
                ClassInfo parentClassInfo = ClassInfo.findById(classInfo.getParentId());
                if (parentClassInfo != null && parentClassInfo.isRoot()) {
                    parentClassInfo = classInfo;
                }
                sbClassPaths.append(parentClassInfo == null ? classInfo.getPropertyAsString(sClassFieldName) : parentClassInfo.getPropertyAsString(sClassFieldName));
            } else {
                sbClassPaths.append(classInfo.getPropertyAsString(sClassFieldName));
            }
            sbClassPaths.append(";");
        }
        if (sbClassPaths.length() <= 0) {
            return null;
        }
        sbClassPaths.setLength(sbClassPaths.length() - 1);
        return new String[]{sbClassPaths.toString()};
    }

    @Override
    protected String[] parseHostNormalProperty(String _sName, PublishTagContext _context) throws WCMException {
        MetaViewData viewData = (MetaViewData)this.m_host;
        boolean bIsLabel = _context.getAttribute("isLabel", true);
        String sDelim = _context.getAttribute("Delim");
        Object oValue = _sName.charAt(0) == '#' ? this.m_host.getAttributeValue(_sName.substring(1)) : (!bIsLabel || this.m_host.getProperty(_sName) instanceof CMyDateTime ? this.m_host.getProperty(_sName) : viewData.getRealProperty(_sName, sDelim));
        if (oValue == null) {
            return null;
        }
        return this.parseProperty(oValue, _context);
    }

    @Override
    protected String[] parseHostSpecialProperty(int _nPropertyId, PublishTagContext _context) {
        if (this.m_host == null) {
            logger.error((Object)(_context.getTagItem() + I18NMessage.get(WCMTagParserViewData.class, "WCMTagParserViewData.label3", "\u89e3\u6790\u5931\u8d25\uff01\u76f8\u5173MetaViewData\u6ca1\u6709\u627e\u5230\uff01")));
            return null;
        }
        try {
            Channel channel = ((MetaViewData)this.m_host).getChannel();
            switch (_nPropertyId) {
                case 100: {
                    String sDesc = channel.getDesc();
                    if (sDesc == null || (sDesc = sDesc.trim()).length() <= 0) {
                        sDesc = channel.getName();
                    }
                    return this.parseProperty(sDesc, _context);
                }
                case 200: {
                    String sName = channel.getName();
                    return this.parseProperty(sName, _context);
                }
                case 201: 
                case 202: {
                    return this.parseHomeSite(channel, _context, _nPropertyId);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    protected void registerHostSpecialProperties() {
        this.registerHostSpecialProperty("CHNLDESC", 100);
        this.registerHostSpecialProperty("CHNLNAME", 200);
        this.registerHostSpecialProperty("HOMESITE", 201);
        this.registerHostSpecialProperty("HOMESITENAME", 202);
    }

    @Override
    public TagBeanInfo getBeanInfo() {
        return null;
    }

    @Override
    protected CMSObj findHost(PublishTagContext _context) throws WCMException {
        if (this.m_host != null) {
            return this.m_host;
        }
        Object oFormTaskObject = _context.getPageContext().getTaskContext().getCachObject("o_MetaViewData");
        if (oFormTaskObject != null) {
            return (MetaViewData)oFormTaskObject;
        }
        IPublishElement upperHost = _context.getUpperHost();
        CMSObj obj = upperHost.getSubstance();
        if (obj instanceof MetaViewData) {
            return obj;
        }
        if (obj instanceof Document) {
            MetaView view = this.getMetaViewCachedByTagContext(_context, (Document)obj);
            return this.getViewDataCachedByTagContext(_context, obj, view);
        }
        if (obj instanceof MetaViewField) {
            int nCount = 1;
            int nMaxCount = 100;
            for (PublishTagContext tempContext = _context.getParent(); tempContext != null; tempContext = tempContext.getParent()) {
                if (nCount > nMaxCount) {
                    logger.error((Object)(nCount + I18NMessage.get(WCMTagParserViewData.class, "WCMTagParserViewData.label4", "\u6b21\u90fd\u6ca1\u6709\u627e\u5230UppserHost\u662fViewDAta")));
                    break;
                }
                ++nCount;
                CMSObj tempObj = tempContext.getUpperHost().getSubstance();
                if (tempObj instanceof MetaViewData) {
                    return tempObj;
                }
                if (!(tempObj instanceof Document)) continue;
                MetaView view = this.getMetaViewCachedByTagContext(tempContext, (Document)tempObj);
                return this.getViewDataCachedByTagContext(tempContext, tempObj, view);
            }
            CMSObj pageObj = _context.getPageElement().getSubstance();
            MetaView view = this.getMetaViewCachedByTagContext(_context, (Document)pageObj);
            return this.getViewDataCachedByTagContext(_context, pageObj, view);
        }
        throw new WCMException(I18NMessage.get(WCMTagParserViewData.class, "WCMTagParserViewData.label5", "TRS_ViewData\u7f6e\u6807\u4e0d\u80fd\u5e94\u7528\u5230\u5f53\u524d\u573a\u666f\u4e0b\uff01[UpperHost=") + obj.getClassName(true) + "]");
    }

    private void resetUpperHost(PublishTagContext _context, CMSObj _obj) {
        IPublishElement _host = null;
        try {
            _host = PublishElementFactory.makeElementFrom(_obj);
            _context.setUpperHost(_host);
        }
        catch (WCMException e) {
            logger.error((Object)e.getMessage());
        }
    }

    private MetaView getMetaViewCachedByTagContext(PublishTagContext _oTagContext, Document _document) throws WCMException {
        MetaView view = MetaView.findById(_document.getKindId());
        if (view == null) {
            throw new WCMException(I18NMessage.get(WCMTagParserViewData.class, "WCMTagParserViewData.label6", "\u5f53\u524d\u6587\u6863\u5173\u8054\u7684\u89c6\u56fe\u4e0d\u5b58\u5728\uff01[DocId=") + _document.getId() + ",ViewId=" + _document.getKindId() + "]");
        }
        return view;
    }

    private MetaViewData getViewDataCachedByTagContext(PublishTagContext _oTagContext, CMSObj _host, MetaView _view) throws WCMException {
        String sKey;
        MetaViewData viewData;
        HashMap<String, MetaViewData> hExtraAttributes = _oTagContext.getExtraAttributes();
        if (hExtraAttributes == null) {
            hExtraAttributes = new HashMap<String, MetaViewData>(1);
            _oTagContext.setExtraAttributes(hExtraAttributes);
        }
        if ((viewData = (MetaViewData)hExtraAttributes.get(sKey = "Curr.ViewData." + _host.getId())) != null) {
            return viewData;
        }
        viewData = new MetaViewData(_view);
        String sSelectFields = this.getSelectFields(_view.getTrueTableName(), "TRS_VIEWDATA", _oTagContext);
        viewData.loadById(_host.getId(), sSelectFields);
        hExtraAttributes.put(sKey, viewData);
        return viewData;
    }

    private String[] generateBigFileAppendix(PublishTagContext _context, String _sFieldName) throws WCMException {
        String sRelativeFilePath;
        if (CMyString.isEmpty(_sFieldName)) {
            _sFieldName = _context.getAttribute("Field");
        }
        if (CMyString.isEmpty(sRelativeFilePath = this.m_host.getPropertyAsString(_sFieldName))) {
            return new String[]{""};
        }
        String sBFPath = ConfigServer.getServer().getInitProperty("BF");
        if (CMyString.isEmpty(sBFPath)) {
            throw new WCMException("\u6ca1\u6709\u5728TRSWCMApp.ini\u6587\u4ef6\u4e2d\u914d\u7f6e\u5927\u6587\u4ef6\u6839\u8def\u5f84BF");
        }
        FileService file = new FileService((sBFPath = CMyString.setStrEndWith(sBFPath, File.separatorChar)) + sRelativeFilePath);
        if (!file.exists()) {
            if (!_context.isPreview()) {
                _context.getPageContext().addErrorLog(9, "\u76f8\u5173\u9644\u4ef6[" + _sFieldName + "]\u4e0d\u5b58\u5728\uff01[AbsoluteFile=" + sBFPath + sRelativeFilePath + "]", this.m_tagItem.toString());
            }
            return new String[]{"NotExistFile"};
        }
        if (_context.getAttribute("ReturnFileSize", false)) {
            return new String[]{FileHelper.convertFileSize(file.length())};
        }
        return super.parse(_context);
    }

    private String[] generateAppendix(PublishTagContext _context, String _sFieldName) throws WCMException {
        boolean bPreview;
        String sFileName;
        if (CMyString.isEmpty(_sFieldName)) {
            _sFieldName = _context.getAttribute("Field");
        }
        if (CMyString.isEmpty(sFileName = this.m_host.getPropertyAsString(_sFieldName))) {
            return new String[]{""};
        }
        String[] pAppendixIds = sFileName.trim().split("[ ]*,[ ]*");
        Matcher matcher = Pattern.compile("^[+-]?[0-9]+$").matcher(pAppendixIds[0]);
        if (matcher.find()) {
            Appendix appendix = Appendix.findById(Integer.parseInt(pAppendixIds[0]));
            if (appendix == null) {
                return new String[]{""};
            }
            sFileName = appendix.getFile();
        } else {
            sFileName = CMyFile.extractFileName(sFileName);
            sFileName = sFileName.split(",")[0];
        }
        if (!FilesMan.isValidFile(sFileName, "P0") && !FilesMan.isValidFile(sFileName, "W0")) {
            _context.getPageContext().addErrorLog(9, I18NMessage.get(WCMTagParserViewData.class, "WCMTagParserViewData.label7", "\u76f8\u5173\u9644\u4ef6[") + sFileName + I18NMessage.get(WCMTagParserViewData.class, "WCMTagParserViewData.label8", "]\u4e0d\u662f\u6709\u6548\u7684WCM\u6587\u4ef6\uff01"), this.m_tagItem.toString());
            return new String[]{"NotValidFileName"};
        }
        String sAbsoluteFieldName = "";
        sAbsoluteFieldName = ConfigServer.getServer().getSysConfigValue("Image_Convert_Quality", "false").trim().equalsIgnoreCase("true") ? ImgFileParserHelper.makeAbsoluteFilePathAndConvert(sFileName, _context) : FileHelper.makeAbsoluteFilePathOfImage(sFileName, _context.getAttribute("InWidth", 0));
        sFileName = CMyFile.extractFileName(sAbsoluteFieldName);
        FileService file = new FileService(sAbsoluteFieldName);
        if (!file.exists()) {
            if (!_context.isPreview()) {
                _context.getPageContext().addErrorLog(9, I18NMessage.get(WCMTagParserViewData.class, "WCMTagParserViewData.label7", "\u76f8\u5173\u9644\u4ef6[") + sFileName + I18NMessage.get(WCMTagParserViewData.class, "WCMTagParserViewData.label9", "]\u4e0d\u5b58\u5728\uff01[AbsoluteFile=") + sAbsoluteFieldName + "]", this.m_tagItem.toString());
            }
            return new String[]{"NotExistFile"};
        }
        if (_context.getAttribute("ReturnFileSize", false)) {
            return new String[]{FileHelper.convertFileSize(file.length())};
        }
        if (_context.getAttribute("ReturnImageWidth", false)) {
            return new String[]{"" + FileHelper.getImageDimensions(sAbsoluteFieldName)[0]};
        }
        if (_context.getAttribute("ReturnImageHeight", false)) {
            return new String[]{"" + FileHelper.getImageDimensions(sAbsoluteFieldName)[1]};
        }
        if (_context.getAttribute("ReturnImageDimensions", false)) {
            String sPattern = _context.getAttribute("ImageDimensionsPattern");
            sPattern = CMyString.showEmpty(sPattern, "width='{width}' height='{height}'");
            int[] dimensions = FileHelper.getImageDimensions(sAbsoluteFieldName);
            String sResult = sPattern.replaceAll("(?is)\\{width\\}", String.valueOf(dimensions[0]));
            sResult = sResult.replaceAll("(?is)\\{height\\}", String.valueOf(dimensions[1]));
            return new String[]{sResult};
        }
        IPublishContent oApdOwner = (IPublishContent)_context.getUpperHost();
        PublishPathCompass compass = _context.getPathCompass();
        String sLocalPath = compass.getLocalPath(oApdOwner, bPreview = _context.isPreview());
        if (!CMyFile.fileExists(sLocalPath + sFileName)) {
            String sUnZipPath;
            PublishSyncGlobalTuner.insureLocalPathExists(sLocalPath);
            String sUnZipPathField = _context.getAttributeTrim("UnZipPathField");
            String sFileExt = CMyFile.extractFileExt(sFileName);
            if (!CMyString.isEmpty(sUnZipPathField) && "ZIP".equalsIgnoreCase(sFileExt) && !CMyString.isEmpty(sUnZipPath = this.m_host.getPropertyAsString(sUnZipPathField))) {
                try {
                    this.doUnZipAndDistribute(_context, sFileName, sUnZipPath);
                    return new String[]{sUnZipPath};
                }
                catch (Exception e) {
                    throw new WCMException("Fail to unzip [" + sAbsoluteFieldName + "]!", e);
                }
            }
            try {
                CMyFile.copyFile(sAbsoluteFieldName, sLocalPath + sFileName);
                if (!bPreview) {
                    _context.getFileDistributeShip().distributeFile(sAbsoluteFieldName, oApdOwner, null, true);
                }
            }
            catch (Exception e) {
                throw new WCMException(I18NMessage.get(WCMTagParserViewData.class, "WCMTagParserViewData.label10", "\u5206\u53d1\u6587\u4ef6\u5931\u8d25\uff01[UpperHost=") + _context.getUpperHost().getInfo() + "][FileName=" + sFileName + "]", e);
            }
        }
        String sResult = WCMAppendixGenerator.makeAppendixURL(_context, oApdOwner, sFileName);
        return new String[]{sResult};
    }

    private void doUnZipAndDistribute(PublishTagContext _context, String _sZipFileName, String _sUnZipPathName) throws Exception {
        FilesMan filesMan = FilesMan.getFilesMan();
        String sAbsoluteZipFilePath = filesMan.mapFilePath(_sZipFileName, 0);
        sAbsoluteZipFilePath = CMyString.setStrEndWith(sAbsoluteZipFilePath, File.separatorChar);
        String sNewPath = sAbsoluteZipFilePath + _sUnZipPathName + File.separatorChar;
        boolean bPreview = _context.isPreview();
        String sFolderLocalPath = _context.getPathCompass().getLocalPath(_context.getPageFolder(), bPreview);
        String sContentLocalPath = _context.getPathCompass().getLocalPath(_context.getUpperHost(), bPreview);
        if (new FileService(sContentLocalPath + _sZipFileName).exists()) {
            return;
        }
        String sUnzipPath = sAbsoluteZipFilePath + CMyFile.excludeFileExt(_sZipFileName) + File.separatorChar;
        CMyUnzip myUnzip = new CMyUnzip();
        myUnzip.addStrictFile(ConfigServer.getServer().getInitProperty("FILE_UPLOAD_ALLOW_SUFFIX") + ",shtml,shtm");
        myUnzip.setZipFile(sAbsoluteZipFilePath + _sZipFileName);
        myUnzip.unzip(sUnzipPath, true);
        FileService newFilePath = new FileService(sNewPath);
        if (newFilePath.exists()) {
            String sBackupPath = sNewPath.substring(0, sNewPath.length() - 1) + "_" + System.currentTimeMillis() + File.separatorChar;
            newFilePath.renameTo(new FileService(sBackupPath));
            newFilePath = new FileService(sNewPath);
        }
        FileService file = new FileService(sUnzipPath);
        FileStore oRenameFile = file;
        FileStore[] pSubFiles = file.listFiles();
        if (pSubFiles.length == 1 && pSubFiles[0].isDirectory()) {
            oRenameFile = pSubFiles[0];
        }
        if (!oRenameFile.renameTo(newFilePath)) {
            throw new Exception("Fail rename " + oRenameFile.getAbsolutePath() + " to " + sNewPath);
        }
        try {
            CMyFile.copyFileDir(sNewPath, sFolderLocalPath, true);
            if (!bPreview) {
                this.distributePath(_context, _context.getPageFolder(), sNewPath, _sUnZipPathName);
            }
            CMyFile.copyFile(sAbsoluteZipFilePath + _sZipFileName, sContentLocalPath + _sZipFileName, true);
        }
        catch (Exception e) {
            throw new WCMException(I18NMessage.get(WCMTagParserViewData.class, "WCMTagParserViewData.label10", "\u5206\u53d1\u6587\u4ef6\u5931\u8d25\uff01[UpperHost=") + _context.getUpperHost().getInfo() + "][FileName=" + _sZipFileName + "]", e);
        }
    }

    private void distributePath(PublishTagContext _context, IPublishElement _dstElement, String _sSrcFilePath, String _sSubPathName) throws WCMException {
        FileStore[] pFiles = new FileService(_sSrcFilePath).listFiles();
        for (int i = 0; i < pFiles.length; ++i) {
            FileStore oFile = pFiles[i];
            if (oFile.isFile()) {
                _context.getFileDistributeShip().distributeFile(oFile.getAbsolutePath(), _dstElement, _sSubPathName, false);
                continue;
            }
            String sSubPathName = _sSubPathName;
            sSubPathName = CMyString.isEmpty(sSubPathName) ? "" : sSubPathName + '/';
            sSubPathName = sSubPathName + oFile.getName();
            this.distributePath(_context, _dstElement, oFile.getAbsolutePath(), sSubPathName);
        }
    }

    private String[] parseHtmlContent(String _sHTMLContent, PublishTagContext _context) throws WCMException {
        if (CMyString.isEmpty(_sHTMLContent)) {
            return null;
        }
        if (_context.getAttribute("WML", false) && _context.getAttribute("PAGENUM", 0) > 0) {
            String sText = _sHTMLContent.replaceAll("<{1}[^>]{1,}>{1}", "");
            return this.parseText(_context, sText);
        }
        String sResult = null;
        try {
            String sIncludeTags;
            String sExcludeTags;
            sResult = new HTMLContentParseHelper().makeHTMLContentParsed(_context, _sHTMLContent);
            String sCleanTagsAttrs = _context.getAttribute("cleanattrs4tags");
            if (!CMyString.isEmpty(sCleanTagsAttrs)) {
                sResult = CMyString.cleanAttributes4Tags(sResult, sCleanTagsAttrs);
            }
            if (!CMyString.isEmpty(sExcludeTags = _context.getAttribute("excludetags"))) {
                sResult = CMyString.excludeTags(sResult, sExcludeTags);
            }
            if (!CMyString.isEmpty(sIncludeTags = _context.getAttribute("includetags"))) {
                sResult = CMyString.includeTags(sResult, sIncludeTags);
            }
            sResult = TagParseHelper.formatTextIfNeeded(_context, sResult);
            if (_context.getAttribute("NUM", 0) > 0) {
                sResult = TagParseHelper.truncateTextIfNeeded(_context, sResult);
            }
            if (_context.getPageElement() instanceof IPublishContent) {
                return TagParseHelper.separatePages(sResult);
            }
            return new String[]{sResult};
        }
        catch (Exception ex) {
            throw new WCMException(1100, I18NMessage.get(WCMTagParserViewData.class, "WCMTagParserViewData.label11", "\u89e3\u6790 ") + this.m_host + I18NMessage.get(WCMTagParserViewData.class, "WCMTagParserViewData.label12", " \u7684\u6b63\u6587\u5931\u8d25!"), ex);
        }
    }

    private static boolean containsTagItemChild(TagItem _currTagItem) {
        List m_children = _currTagItem.getChildren();
        if (m_children == null) {
            return false;
        }
        int nSize = m_children.size();
        for (int i = 0; i < nSize; ++i) {
            Object child = m_children.get(i);
            if (child == null || !(child instanceof TagItem)) continue;
            return true;
        }
        return false;
    }

    private String[] parseHomeSite(Channel channel, PublishTagContext _context, int _nPropId) throws WCMException {
        if (channel == null) {
            return null;
        }
        WebSite site = channel.getSite();
        if (site == null) {
            return null;
        }
        String sHomeName = _nPropId == 201 ? site.getDesc() : site.getName();
        try {
            String sResult = TagParseHelper.truncateTextIfNeeded(_context, sHomeName);
            sResult = TagParseHelper.formatTextIfNeeded(_context, sResult);
            if (_context.getAttribute("AUTOLINK", false)) {
                IPublishFolder folder = (IPublishFolder)PublishElementFactory.makeElementFrom(site);
                sResult = TagParseHelper.addAutoLink(folder.getRootDomain(), sResult, sHomeName, _context);
            }
            return new String[]{sResult};
        }
        catch (Exception ex) {
            throw new WCMException(I18NMessage.get(WCMTagParserViewData.class, "WCMTagParserViewData.label11", "\u89e3\u6790 ") + channel + I18NMessage.get(WCMTagParserViewData.class, "WCMTagParserViewData.label15", " \u7684\u6240\u5c5e\u7ad9\u70b9\u5931\u8d25!"), ex);
        }
    }

    private TagItem findObjectsTagItem(TagItem _currParentTagItem) {
        if (_currParentTagItem == null) {
            return null;
        }
        String sTagName = _currParentTagItem.getName().toUpperCase();
        if (sTagName.equals("TRS_RECORD") || sTagName.equals("TRS_EXISTSDATA") || sTagName.equals("TRS_NOTEXISTSDATA") || sTagName.equals("TRS_CONDITION")) {
            return this.findObjectsTagItem(_currParentTagItem.getParent());
        }
        return _currParentTagItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getSelectFields(String _sTableName, String _sElementTagName, PublishTagContext _tagContext) {
        if (_tagContext.getPageElement() instanceof IPublishContent) {
            return "*";
        }
        TagItem oObjectsTagItem = this.findObjectsTagItem(_tagContext.getTagItem().getParent());
        if (oObjectsTagItem == null) {
            return "*";
        }
        String sSelectAll = oObjectsTagItem.getAttribute("SelectAll");
        if ("true".equalsIgnoreCase(sSelectAll)) {
            return "*";
        }
        String sKey = (_sTableName + ".SELECT").toUpperCase();
        String sSelectFields = oObjectsTagItem.getExtraAttributeValue(sKey);
        if (sSelectFields == null) {
            TagItem tagItem = oObjectsTagItem;
            synchronized (tagItem) {
                sSelectFields = oObjectsTagItem.getExtraAttributeValue(sKey);
                if (sSelectFields == null) {
                    sSelectFields = this.makeSelectFields(_sTableName, _sElementTagName, oObjectsTagItem, _tagContext);
                    oObjectsTagItem.setExtraAttribute(sKey, sSelectFields);
                }
            }
        }
        return sSelectFields;
    }

    private String makeSelectFields(String _sTableName, String _sTagName, TagItem _oObjectsTagItem, PublishTagContext _tagContext) {
        ArrayList arDefaultFields = FIELDS_DEFAULT_LIST_OF_METADATA;
        String sSelectFields = (String)arDefaultFields.get(0);
        int nSize = arDefaultFields.size();
        for (int i = 1; i < nSize; ++i) {
            sSelectFields = sSelectFields + "," + arDefaultFields.get(i);
        }
        ArrayList listChildFields = TagParseHelper.makeSelectFields(_oObjectsTagItem, _sTagName);
        DBManager dbMgr = DBManager.getDBManager();
        int nSize2 = listChildFields.size();
        for (int i = 0; i < nSize2; ++i) {
            String sFieldName = (String)listChildFields.get(i);
            if (arDefaultFields.indexOf(sFieldName) >= 0) continue;
            try {
                if (dbMgr.getFieldInfo(_sTableName, sFieldName) == null) {
                    _tagContext.addWarning(_sTagName + I18NMessage.get(WCMTagParserViewData.class, "WCMTagParserViewData.label16", "\u7f6e\u6807\u6307\u5b9a\u7684Field[") + sFieldName + I18NMessage.get(WCMTagParserViewData.class, "WCMTagParserViewData.label17", "]\u5728") + _sTableName + I18NMessage.get(WCMTagParserViewData.class, "WCMTagParserViewData.label18", "\u8868\u4e2d\u4e0d\u5b58\u5728\uff01"));
                    continue;
                }
            }
            catch (WCMException ex) {
                ex.printStackTrace();
                try {
                    _tagContext.addWarning(I18NMessage.get(WCMTagParserViewData.class, "WCMTagParserViewData.label19", "\u83b7\u53d6\u6307\u5b9a\u7684Field[") + sFieldName + I18NMessage.get(WCMTagParserViewData.class, "WCMTagParserViewData.label20", "]\u4ece") + _sTableName + I18NMessage.get(WCMTagParserViewData.class, "WCMTagParserViewData.label21", "\u8868\u4e2d\u53d1\u751f\u5f02\u5e38\uff01") + CMyException.getStackTraceText(ex));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            sSelectFields = sSelectFields + "," + sFieldName;
        }
        return sSelectFields;
    }

    static {
        FIELDS_DEFAULT_LIST_OF_METADATA.add("MetaDataId");
        FIELDS_DEFAULT_LIST_OF_METADATA.add("ChannelId");
        FIELDS_DEFAULT_LIST_OF_METADATA.add("CRTIME");
    }
}

