/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.publish;

import com.trs.DreamFactory;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.tagparser.ITagParser;
import com.trs.components.common.publish.domain.tagparser.TagBeanAttrInfo;
import com.trs.components.common.publish.domain.tagparser.TagBeanInfo;
import com.trs.components.common.publish.domain.tagparser.TagItem;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.template.TemplateQuote;
import com.trs.components.metadata.center.MetaViewData;
import com.trs.components.metadata.publish.PublishContentViewDataImpl;
import com.trs.components.wcm.content.domain.AppendixMgr;
import com.trs.components.wcm.content.persistent.Appendix;
import com.trs.components.wcm.content.persistent.Appendixes;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.publish.element.PublishContentDocumentImpl;
import com.trs.components.wcm.publish.tagparser.WCMAppendixGenerator;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.NamesRegister;

public class WCMTagParserAppendix
implements ITagParser {
    private static NamesRegister s_oAppendixTypeRegister = new NamesRegister();
    private Document m_oDocument = null;
    private TagItem m_tagItem = null;
    private static TagBeanInfo s_TagBeanInfo;

    @Override
    public TagBeanInfo getBeanInfo() {
        if (s_TagBeanInfo == null) {
            TagBeanAttrInfo tbai = null;
            TagBeanInfo tbi = new TagBeanInfo();
            tbi.setName("TRS_APPENDIX");
            tbi.setDesc("TRS_APPENDIX");
            tbi.setType(TagBeanInfo.BodyType.IGNORE);
            tbai = new TagBeanAttrInfo();
            tbai.setName("MODE");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setEnumValue(new String[]{"PIC", "FILE", "LINK", "ALL"});
            tbai.setDefaultValue("FILE");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("INDEX");
            tbai.setType(TagBeanAttrInfo.Type.INTEGER);
            tbai.setDefaultValue("-1");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("AUTOLINK");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setEnumValue(new String[]{"true", "false"});
            tbai.setDefaultValue("true");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("TARGET");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setDefaultValue("_blank");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("EXTRA");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("BEGINHTML");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("ENDHTML");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("MEMO");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setEnumValue(new String[]{"true", "false"});
            tbai.setDefaultValue("true");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("BEGINMEMO");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("ENDMEMO");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("SEPERATOR");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("FIELD");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("UPLOAD");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("NAMEONLY");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setEnumValue(new String[]{"true", "false"});
            tbai.setDefaultValue("false");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("UPLOADONLY");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setEnumValue(new String[]{"true", "false"});
            tbai.setDefaultValue("false");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("WIDTH");
            tbai.setType(TagBeanAttrInfo.Type.INTEGER);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("HEIGHT");
            tbai.setType(TagBeanAttrInfo.Type.INTEGER);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("WHERE");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("RELATEDCOLUMN");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbi.addAttrInfo(tbai);
            s_TagBeanInfo = tbi;
        }
        return s_TagBeanInfo;
    }

    private AppendixMgr getAppMgr() {
        return (AppendixMgr)DreamFactory.createObjectById("AppendixMgr");
    }

    private int getAppendixType(PublishTagContext _context) {
        String sMode = CMyString.showNull(_context.getAttribute("MODE"), "FILE").toUpperCase();
        return s_oAppendixTypeRegister.lookup(sMode, 10);
    }

    @Override
    public void setTagItem(TagItem _item) {
        this.m_tagItem = _item;
    }

    public void clear() {
        if (this.m_tagItem != null) {
            this.m_tagItem = null;
        }
        if (this.m_oDocument != null) {
            this.m_oDocument = null;
        }
    }

    @Override
    public TemplateQuote[] analyzeQuotes(IPublishFolder _root) {
        return null;
    }

    private Document getDocument(PublishTagContext _context) throws WCMException {
        IPublishElement oElement = _context.getUpperHost();
        if (oElement instanceof PublishContentDocumentImpl) {
            return (Document)oElement.getSubstance();
        }
        if (oElement instanceof PublishContentViewDataImpl) {
            MetaViewData oViewData = (MetaViewData)oElement.getSubstance();
            return Document.findById(oViewData.getMetaDataId(), "DocId,DocVersion");
        }
        return null;
    }

    @Override
    public String[] parse(PublishTagContext _context) throws WCMException {
        this.m_oDocument = this.getDocument(_context);
        if (this.m_oDocument == null) {
            return null;
        }
        int nAppType = this.getAppendixType(_context);
        int nIndex = _context.getAttribute("INDEX", -1);
        int nReturnMode = 2;
        if (_context.getAttribute("UPLOADONLY", false)) {
            nReturnMode = 0;
        } else {
            int n = nReturnMode = _context.getAttribute("NAMEONLY", false) ? 1 : 2;
        }
        if (nIndex < 0) {
            String sResult = WCMAppendixGenerator.generateAppendixes(this.m_oDocument, nAppType, _context, nReturnMode);
            if (sResult == null) {
                return null;
            }
            return new String[]{sResult};
        }
        Appendixes aApps = this.getAllAppendixes(_context, nAppType);
        if (nIndex >= aApps.size()) {
            return null;
        }
        return new String[]{WCMAppendixGenerator.generateAppendix((Appendix)aApps.getAt(nIndex), (IPublishContent)_context.getUpperHost(), _context, nReturnMode)};
    }

    private Appendixes getAllAppendixes(PublishTagContext _context, int nAppType) throws WCMException {
        String sRelatedColumn;
        WCMFilter filter = null;
        String sWhere = _context.getAttribute("Where");
        if (sWhere != null && (sWhere = sWhere.trim()).length() > 0) {
            filter = new WCMFilter("", sWhere, "");
        }
        if (!CMyString.isEmpty(sRelatedColumn = _context.getAttribute("RELATEDCOLUMN"))) {
            sWhere = filter != null ? sWhere + " and " : "";
            sWhere = sWhere + " RelatedColumn='" + sRelatedColumn + "' ";
            filter = new WCMFilter("", sWhere, "");
        }
        return this.getAppMgr().getAppendixes(this.m_oDocument, nAppType, filter);
    }

    static {
        s_oAppendixTypeRegister.register("VIDEO", 50);
        s_oAppendixTypeRegister.register("LINK", 40);
        s_oAppendixTypeRegister.register("FILE", 10);
        s_oAppendixTypeRegister.register("PIC", 20);
        s_oAppendixTypeRegister.register("ALL", 60);
        s_TagBeanInfo = null;
    }
}

