/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.definition.excel;

import com.trs.DreamFactory;
import com.trs.cms.auth.persistent.User;
import com.trs.components.metadata.MetaDataConstants;
import com.trs.components.metadata.definition.IMetaDataDefMgr;
import com.trs.components.metadata.definition.MetaDBTable;
import com.trs.components.metadata.definition.MetaDataType;
import com.trs.components.metadata.definition.MetaView;
import com.trs.components.metadata.definition.MetaViewField;
import com.trs.components.metadata.definition.MetaViewFieldGroup;
import com.trs.components.metadata.definition.MetaViews;
import com.trs.components.metadata.definition.excel.FieldInfo;
import com.trs.components.metadata.definition.excel.FieldInfos;
import com.trs.components.metadata.definition.excel.IExcelForStructImporter;
import com.trs.components.metadata.definition.excel.PinyinHelperForDBFieldName;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.store.FileService;
import com.trs.infra.util.store.FileWrapper;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import jxl.Cell;
import jxl.CellType;
import jxl.Sheet;
import jxl.Workbook;
import org.apache.log4j.Logger;

public class ExcelForStructImporter
implements IExcelForStructImporter {
    private static final String PRE_TABLE_NAME = "HCN_";
    public static boolean CREATE_TABLE = true;
    public static boolean bRecordResult = false;
    public static boolean VALIDATE_DATA = false;
    private static StringBuffer sbDropSQL = new StringBuffer();
    private static Logger logger = Logger.getLogger(ExcelForStructImporter.class);
    public static FieldInfos DEFAULT_FIELDS = new FieldInfos();

    @Override
    public MetaViews createViewsFromExcel(String _sExcelFileNameForStructure) throws WCMException {
        return null;
    }

    @Override
    public MetaViews createViewsFromExcel(String _sExcelFileNameForStructure, int _nImportMode) throws WCMException {
        return null;
    }

    public static void analyerExcel(String _sExcelFile) throws Exception {
        logger.info((Object)("==========" + _sExcelFile + ".............========="));
        Workbook workbook = Workbook.getWorkbook((File)new FileWrapper(new FileService(_sExcelFile)));
        String sPreSheetName = "";
        int nSheetCount = workbook.getNumberOfSheets();
        for (int nSheetIndex = 1; nSheetIndex < nSheetCount; ++nSheetIndex) {
            Sheet oCurrSheet = workbook.getSheet(nSheetIndex);
            sPreSheetName = oCurrSheet.getName();
            logger.info((Object)("==========" + sPreSheetName + "========="));
            int nStartRowIndex = ExcelForStructImporter.caculateStartIndex(oCurrSheet);
            if (nStartRowIndex >= 0) {
                Cell[] pCell = oCurrSheet.getRow(nStartRowIndex - 1);
                int nDataTypeIndex = ExcelForStructImporter.caculateDataTypeCellIndex(pCell);
                if (nDataTypeIndex < 0) {
                    logger.error((Object)("\u3010" + oCurrSheet.getName() + I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label31", "\u3011\u627e\u4e0d\u5230\u5b9a\u4e49\u8f93\u5165\u9879\u683c\u5f0f\u7684\u5217\uff01\uff01\uff01\uff01\uff01")));
                } else {
                    int nRequireIndex = ExcelForStructImporter.caculateRequireCellIndex(pCell);
                    if (nRequireIndex < 0) {
                        logger.error((Object)("\u3010" + oCurrSheet.getName() + I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label32", "\u3011\u627e\u4e0d\u5230\u5b9a\u4e49\u5fc5\u586b\u9879\u7684\u5217\uff01\uff01\uff01\uff01\uff01")));
                    } else {
                        String sTableName;
                        int nPersonalIndex = ExcelForStructImporter.caculatePersonalCellIndex(pCell);
                        String sSheetName = oCurrSheet.getName();
                        int nPos = sSheetName.indexOf(I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label33", "\u8be6\u7ec6\u89c4\u683c"));
                        String sName = sSheetName;
                        if (nPos > 0) {
                            sName = sSheetName.substring(0, nPos);
                        }
                        if ((sTableName = PRE_TABLE_NAME + PinyinHelperForDBFieldName.convert(sName, "_")).length() > 57) {
                            logger.error((Object)("[" + sTableName + I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label34", "]\u957f\u5ea6\u8d85\u957f\uff01")));
                        }
                        String sCurrGroupName = "";
                        ArrayList<MetaViewField> arDBFields = null;
                        ArrayList<String> arFieldNames = null;
                        StringBuffer sbResult = new StringBuffer();
                        int nRowCount = oCurrSheet.getRows();
                        for (int nRowIndex = nStartRowIndex; nRowIndex < nRowCount; ++nRowIndex) {
                            MetaViewField field;
                            if (arFieldNames == null || arDBFields == null) {
                                arFieldNames = new ArrayList<String>(nRowCount);
                                arDBFields = new ArrayList<MetaViewField>(nRowCount);
                            }
                            if ((pCell = oCurrSheet.getRow(nRowIndex)) == null || pCell.length <= 2 || pCell[1].getType() == CellType.EMPTY) continue;
                            String sTemp = pCell[0].getContents().trim();
                            if (sTemp.length() > 0) {
                                sCurrGroupName = sTemp;
                            }
                            if ((field = ExcelForStructImporter.converToFieldFromRow(sCurrGroupName, pCell, nDataTypeIndex, nRequireIndex, nPersonalIndex)) == null) {
                                logger.error((Object)(I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label35", "\u89e3\u6790\u9519\u8bef[") + oCurrSheet.getName() + I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label36", "]\u7b2c[") + (nRowIndex + 1) + I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label37", "]\u884c")));
                                continue;
                            }
                            field.setProperty("GroupName", I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label38", "\u89c4\u683c\u53c2\u6570_") + sCurrGroupName, false);
                            String sFieldName = field.getName();
                            int nCount = 1;
                            while (arFieldNames.indexOf(sFieldName) >= 0) {
                                sFieldName = field.getName() + nCount;
                                ++nCount;
                            }
                            if (nCount > 1) {
                                field.setName(sFieldName);
                            }
                            arFieldNames.add(field.getName());
                            arDBFields.add(field);
                            logger.debug((Object)(sTableName + "." + sCurrGroupName + "." + field.getAnotherName() + ":[" + field.getName() + "]"));
                        }
                        if (sbResult.length() <= 0 || bRecordResult) {
                            // empty if block
                        }
                        if (arDBFields != null && !arDBFields.isEmpty() && CREATE_TABLE) {
                            ExcelForStructImporter.createTable(sName, sTableName, arDBFields);
                        }
                    }
                }
            }
            logger.info((Object)("==========" + sPreSheetName + " end!========="));
        }
        workbook.close();
        logger.info((Object)("==========" + _sExcelFile + " end !========="));
        CMyFile.writeFile("c:\\drop_table_from_excel.sql", sbDropSQL.toString());
    }

    private static boolean isSerialProduct(String _sName) {
        String[] pSerialName = new String[]{I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label39", "\u7a7a\u8c03"), I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label40", "\u7b14\u8bb0\u672c"), I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label28", "\u4e00\u4f53\u673a"), I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label29", "\u53f0\u5f0f\u673a"), I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label41", "\u71c3\u6c14\u7076"), I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label42", "\u5957\u7cfb")};
        for (int i = 0; i < pSerialName.length; ++i) {
            if (!pSerialName[i].equals(_sName)) continue;
            return true;
        }
        return false;
    }

    private static MetaDBTable createSerialTable(String _sTableAnotherName, String _sTableName, int _nProductViewId) throws WCMException {
        sbDropSQL.append("drop table WCMMetaTable" + _sTableName + ";");
        sbDropSQL.append("\n");
        IMetaDataDefMgr oMetaDataDefMgr = (IMetaDataDefMgr)DreamFactory.createObjectById("IMetaDataDefMgr");
        User currUser = User.findByName("admin");
        MetaDBTable currTable = MetaDBTable.createNewInstance();
        currTable.setAnotherName(_sTableAnotherName);
        currTable.setName(_sTableName);
        oMetaDataDefMgr.save(currUser, currTable);
        MetaView view = ExcelForStructImporter.createViewFrom(currTable);
        view.setProperty("TEMPLATEPATH", "template1");
        oMetaDataDefMgr.save(currUser, view);
        HashMap hGroupIds = new HashMap();
        int nSize = DEFAULT_FIELDS.getDataTypesCount();
        for (int i = 0; i < nSize; ++i) {
            FieldInfo fieldInfo = DEFAULT_FIELDS.getDataTypeAt(i);
            MetaViewField dbField = ExcelForStructImporter.createViewFieldFromDataType(DEFAULT_FIELDS.getDataTypeAt(i));
            if (I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label3", "\u4ea7\u54c1\u578b\u53f7").equals(dbField.getAnotherName())) {
                dbField.setAnotherName(I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label43", "\u7cfb\u5217\u578b\u53f7"));
            } else if (I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label1", "\u4ea7\u54c1\u540d\u79f0").equals(dbField.getAnotherName())) {
                dbField.setAnotherName(I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label44", "\u7cfb\u5217\u540d\u79f0"));
            }
            if (!fieldInfo.isForTableAnotherNames(_sTableAnotherName)) continue;
            ExcelForStructImporter.dowithGroupName(currUser, dbField, hGroupIds, view);
            try {
                oMetaDataDefMgr.save(currUser, view, dbField);
                continue;
            }
            catch (Exception e) {
                oMetaDataDefMgr.delete(currUser, currTable);
                logger.error((Object)(I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label45", "\u5904\u7406\u5b57\u6bb5\u51fa\u73b0\u5f02\u5e38\uff01[") + _sTableAnotherName + "." + _sTableName + "." + dbField.getAnotherName() + "." + dbField.getName() + "]"), (Throwable)e);
                break;
            }
        }
        MetaViewField dbField = MetaViewField.createNewInstance();
        dbField.setAnotherName(I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label46", "\u578b\u53f7\u5217\u8868"));
        dbField.setName("XINHAO");
        dbField.setDBType(12);
        dbField.setLength(120);
        dbField.setType(14);
        dbField.setProperty("GroupName", I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label46", "\u578b\u53f7\u5217\u8868"), false);
        dbField.setProperty("RELATIONVIEWID", _nProductViewId);
        ExcelForStructImporter.dowithGroupName(currUser, dbField, hGroupIds, view);
        try {
            oMetaDataDefMgr.save(currUser, view, dbField);
        }
        catch (Exception e) {
            oMetaDataDefMgr.delete(currUser, currTable);
            logger.error((Object)(I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label45", "\u5904\u7406\u5b57\u6bb5\u51fa\u73b0\u5f02\u5e38\uff01[") + _sTableAnotherName + "." + _sTableName + "." + dbField.getAnotherName() + "." + dbField.getName() + "]"), (Throwable)e);
        }
        return currTable;
    }

    private static MetaDBTable createTable(String _sTableAnotherName, String _sTableName, ArrayList _arDBFields) throws Exception {
        int i;
        sbDropSQL.append("drop table WCMMetaTable" + _sTableName + ";");
        sbDropSQL.append("\n");
        Properties oResult = new Properties();
        IMetaDataDefMgr oMetaDataDefMgr = (IMetaDataDefMgr)DreamFactory.createObjectById("IMetaDataDefMgr");
        User currUser = User.findByName("admin");
        boolean bSerialProduct = ExcelForStructImporter.isSerialProduct(_sTableAnotherName);
        MetaDBTable currTable = MetaDBTable.createNewInstance();
        currTable.setAnotherName(_sTableAnotherName);
        currTable.setName(_sTableName);
        oMetaDataDefMgr.save(currUser, currTable);
        MetaView view = ExcelForStructImporter.createViewFrom(currTable);
        view.setProperty("TEMPLATEPATH", "template1");
        oMetaDataDefMgr.save(currUser, view);
        HashMap hGroupIds = new HashMap();
        int nSize = _arDBFields.size();
        for (i = 0; i < nSize; ++i) {
            MetaViewField dbField = (MetaViewField)_arDBFields.get(i);
            String sAnotherName = dbField.getAnotherName();
            if (sAnotherName.equals(I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label47", "\u578b\u53f7")) || sAnotherName.equals(I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label3", "\u4ea7\u54c1\u578b\u53f7")) || sAnotherName.indexOf(I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label48", "\u9000\u5e02")) >= 0) continue;
            ExcelForStructImporter.dowithGroupName(currUser, dbField, hGroupIds, view);
            if (sAnotherName.equals(I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label49", "\u4e0a\u5e02\u65f6\u95f4"))) {
                MetaDataType dataType = MetaDataConstants.DATA_TYPES.getDataTypeById(11);
                dbField.setType(dataType.getDataType());
                dbField.setDBType(dataType.getSqlDataType());
                dbField.setLength(dataType.getMaxLength());
            }
            try {
                oMetaDataDefMgr.save(currUser, view, dbField);
            }
            catch (Exception e) {
                oMetaDataDefMgr.delete(currUser, currTable);
                logger.error((Object)(I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label45", "\u5904\u7406\u5b57\u6bb5\u51fa\u73b0\u5f02\u5e38\uff01[") + _sTableAnotherName + "." + _sTableName + "." + dbField.getAnotherName() + "." + dbField.getName() + "]"), (Throwable)e);
                break;
            }
            if (dbField.getType() != 9) continue;
            oResult.put(dbField.getName(), dbField.getAnotherName() + "," + dbField.getType());
        }
        nSize = DEFAULT_FIELDS.getDataTypesCount();
        for (i = 0; i < nSize; ++i) {
            FieldInfo fieldInfo = DEFAULT_FIELDS.getDataTypeAt(i);
            MetaViewField dbField = ExcelForStructImporter.createViewFieldFromDataType(fieldInfo);
            if (bSerialProduct && !fieldInfo.isInSerailMode() || !fieldInfo.isForTableAnotherNames(_sTableAnotherName)) continue;
            ExcelForStructImporter.dowithGroupName(currUser, dbField, hGroupIds, view);
            try {
                oMetaDataDefMgr.save(currUser, view, dbField);
            }
            catch (Exception e) {
                oMetaDataDefMgr.delete(currUser, currTable);
                logger.error((Object)(I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label45", "\u5904\u7406\u5b57\u6bb5\u51fa\u73b0\u5f02\u5e38\uff01[") + _sTableAnotherName + "." + _sTableName + "." + dbField.getAnotherName() + "." + dbField.getName() + "]"), (Throwable)e);
                break;
            }
            if (dbField.getType() != 9) continue;
            oResult.put(dbField.getName(), dbField.getAnotherName() + "," + dbField.getType());
        }
        if (bRecordResult) {
            oResult.store(new FileService("d:\\Haier\\" + _sTableAnotherName + "_WCMMetaTable" + _sTableName + ".txt").getOutputStream(), "");
        }
        if (bSerialProduct) {
            ExcelForStructImporter.createSerialTable(_sTableAnotherName + I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label50", "\u7cfb\u5217"), _sTableName + "_XL", view.getId());
        }
        return currTable;
    }

    private static void dowithGroupName(User currUser, MetaViewField dbField, HashMap hGroupIds, MetaView view) throws WCMException {
        String sCurrGroupName = dbField.getPropertyAsString("GroupName");
        dbField.removeProperty("GroupName");
        if (CMyString.isEmpty(sCurrGroupName)) {
            return;
        }
        Integer iGroupId = ExcelForStructImporter.doFindAndCreateGroup(currUser, view, hGroupIds, sCurrGroupName);
        dbField.setProperty("FIELDGROUPID", iGroupId.intValue());
    }

    private static Integer doFindAndCreateGroup(User _currUser, MetaView _currView, HashMap _hGroupIds, String _sCurrGroupName) throws WCMException {
        Integer iGroupId = (Integer)_hGroupIds.get(_sCurrGroupName);
        if (iGroupId == null) {
            iGroupId = ExcelForStructImporter.createFieldGroup(_currUser, _currView, _hGroupIds, _sCurrGroupName);
            _hGroupIds.put(_sCurrGroupName, iGroupId);
        }
        return iGroupId;
    }

    private static Integer createFieldGroup(User _currUser, MetaView _view, HashMap _hGroupIds, String _sCurrGroupName) throws WCMException {
        String[] pGroupName = _sCurrGroupName.split("_");
        int nParentId = 0;
        if (pGroupName.length == 2) {
            nParentId = ExcelForStructImporter.doFindAndCreateGroup(_currUser, _view, _hGroupIds, pGroupName[0]);
        }
        MetaViewFieldGroup group = MetaViewFieldGroup.createNewInstance();
        group.setMetaViewId(_view.getId());
        if (pGroupName.length > 0) {
            group.setGroupName(pGroupName[pGroupName.length - 1]);
        }
        group.setProperty("ParentId", nParentId);
        group.setOrder(-1);
        group.save(_currUser);
        return new Integer(group.getId());
    }

    private static MetaView createViewFrom(MetaDBTable currTable) throws WCMException {
        MetaView view = MetaView.createNewInstance();
        view.setMainTable(currTable);
        view.setDesc(currTable.getAnotherName());
        view.setName(currTable.getName());
        return view;
    }

    private static MetaViewField createViewFieldFromDataType(FieldInfo dataType) throws WCMException {
        String sRealViewName;
        MetaViewField dbField = MetaViewField.createNewInstance();
        dbField.setAnotherName(dataType.getDataTypeDesc());
        dbField.setName(dataType.getKey());
        dbField.setType(dataType.getDataType());
        dbField.setDBType(dataType.getSqlDataType());
        if (dataType.getMaxLength() > 0) {
            dbField.setLength(dataType.getMaxLength());
        }
        dbField.setNotNull(dataType.isNotNull());
        dbField.setHidden(dataType.isHidden());
        dbField.setInOutline(dataType.isInOutline());
        dbField.setTitleField(dataType.isTitle());
        dbField.setSearchField(dataType.isSearchField());
        String sGroupName = dataType.getGroupName();
        if (!CMyString.isEmpty(sGroupName)) {
            dbField.setProperty("GroupName", sGroupName, false);
        }
        if (dataType.getEnumValues() != null) {
            dbField.setEnmValue(dataType.getEnumValues());
        }
        if (!CMyString.isEmpty(sRealViewName = dataType.getRelViewName())) {
            WCMFilter filter = new WCMFilter("", "ViewDesc=?", "");
            filter.addSearchValues(sRealViewName);
            MetaViews views = MetaViews.openWCMObjs(null, filter);
            if (views.isEmpty()) {
                logger.error((Object)(I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label51", "\u6307\u5b9a\u7684\u89c6\u56fe\u3010") + sRealViewName + I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label52", "\u3011\u4e0d\u5b58\u5728\uff01\uff01\uff01")));
            } else {
                dbField.setProperty("RELATIONVIEWID", views.getIdAt(0));
            }
        }
        return dbField;
    }

    private static int caculateDataTypeCellIndex(Cell[] _pCell) {
        int nDataTypeIndex = 2;
        while (!_pCell[nDataTypeIndex].getContents().trim().equals(I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label53", "\u8f93\u5165\u9879\u683c\u5f0f")) && !_pCell[nDataTypeIndex].getContents().trim().equals(I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label54", "\u8f93\u5165\u65b9\u5f0f"))) {
            if (++nDataTypeIndex < _pCell.length) continue;
            return -1;
        }
        return nDataTypeIndex;
    }

    private static int caculateRequireCellIndex(Cell[] _pCell) {
        int nRequireIndex = 2;
        while (!_pCell[nRequireIndex].getContents().trim().startsWith(I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label55", "\u5fc5\u586b"))) {
            if (++nRequireIndex < _pCell.length) continue;
            return -1;
        }
        return nRequireIndex;
    }

    private static int caculatePersonalCellIndex(Cell[] _pCell) {
        int nIndex = 2;
        while (!_pCell[nIndex].getContents().trim().startsWith(I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label56", "\u4e2a\u6027"))) {
            if (++nIndex < _pCell.length) continue;
            return -1;
        }
        return nIndex;
    }

    /*
     * Unable to fully structure code
     */
    private static int caculateStartIndex(Sheet _oCurrSheet) {
        nStartRowIndex = 0;
        nStartCount = 0;
        block0: while (true) {
            if (++nStartCount > 40) {
                return -1;
            }
            if ((pCell = _oCurrSheet.getRow(nStartRowIndex++)) == null || pCell.length <= 3) continue;
            nNotEmptyCount = 0;
            do {
                if (pCell[nNotEmptyCount++].getType() != CellType.EMPTY) ** break;
                continue block0;
            } while (nNotEmptyCount < 3);
            break;
        }
        return nStartRowIndex;
    }

    private static MetaViewField converToFieldFromRow(String _sCurrGroupName, Cell[] _pCell, int _nDataTypeIndex, int _nRequireIndex, int _nPersonalIndex) throws Exception {
        MetaViewField dbField = new MetaViewField();
        if (!CMyString.isEmpty(_sCurrGroupName)) {
            dbField.setProperty("GroupName", _sCurrGroupName, false);
        }
        String sAnotherName = _pCell[1].getContents().trim();
        dbField.setAnotherName(sAnotherName);
        String sName = null;
        sName = sAnotherName.length() > 4 ? PinyinHelperForDBFieldName.getFirstLetter(sAnotherName, false) : PinyinHelperForDBFieldName.convert(sAnotherName);
        dbField.setName(sName);
        boolean bRequire = false;
        if (_pCell.length > _nRequireIndex) {
            bRequire = ExcelForStructImporter.isRequire(_pCell[_nRequireIndex].getContents().trim());
        }
        dbField.setNotNull(bRequire);
        String sTypeName = _pCell[_nDataTypeIndex].getContents().trim();
        if (sTypeName.startsWith(I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label57", "\u5355\u9009"))) {
            ExcelForStructImporter.dowithRadio(_pCell, dbField, _nDataTypeIndex, _nRequireIndex, _nPersonalIndex);
        } else if (sTypeName.startsWith(I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label58", "\u591a\u9009")) || sTypeName.equals(I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label59", "\u52fe\u9009"))) {
            ExcelForStructImporter.dowithCheckbox(_pCell, dbField, _nDataTypeIndex, _nRequireIndex, _nPersonalIndex);
        } else if (sTypeName.equals(I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label60", "\u8f93\u5165\u9879")) || sTypeName.equals(I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label61", "l\u8f93\u5165\u9879")) || sTypeName.startsWith(I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label62", "\u6587\u672c\u8f93\u5165"))) {
            ExcelForStructImporter.setDBType(dbField, 3);
        } else if (sTypeName.startsWith(I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label63", "\u4e0b\u62c9"))) {
            ExcelForStructImporter.dowithRadio(_pCell, dbField, _nDataTypeIndex, _nRequireIndex, _nPersonalIndex);
        } else if (sTypeName.equals(I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label64", "\u65e5\u671f\u63a7\u4ef6"))) {
            ExcelForStructImporter.setDBType(dbField, 11);
        } else if (sTypeName.equals(I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label65", "\u6570\u5b57\u8f93\u5165\u9879"))) {
            dbField.setType(1);
            dbField.setDBType(6);
            dbField.setScale(3);
        } else {
            logger.error((Object)(I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label66", "\u6ca1\u6709\u7a77\u4e3e\u51fa\u3010") + sAnotherName + I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label67", "\u3011\u7684\u53c2\u6570\u7c7b\u578b\u3010") + sTypeName + "\u3011\uff01\uff01\uff01\uff01\uff01"));
            return null;
        }
        return dbField;
    }

    private static int makeRealEnumValues(Cell[] _pCell, int _nEnumStartIndex, String[] _pEnumValues, String _sAnotherName) {
        int nRelEnumCount = 0;
        for (int nEnumIndex = _nEnumStartIndex; nEnumIndex < _pCell.length; ++nEnumIndex) {
            String sValue = _pCell[nEnumIndex].getContents().trim();
            if (sValue.length() == 0) {
                if (nEnumIndex != _nEnumStartIndex) break;
                continue;
            }
            sValue = sValue.replace('~', ' ');
            if (_sAnotherName.startsWith(I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label68", "\u6295\u653e")) && (I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label69", "\u666e\u6295").equals(sValue) || I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label70", "\u5168\u6295 ").equals(sValue) || I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label71", "\u5168\u9009").equals(sValue))) {
                logger.info((Object)(_sAnotherName + I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label72", " \u662f\u6295\u653e\u6e20\u9053\u53c2\u6570\uff0c\u5ffd\u7565\u4e86\u3010") + sValue + I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label73", "\u3011\u9009\u9879!")));
                continue;
            }
            _pEnumValues[nRelEnumCount++] = sValue;
        }
        if (nRelEnumCount != 1) {
            return nRelEnumCount;
        }
        String sValue = _pEnumValues[0];
        if (sValue.equals("/")) {
            return nRelEnumCount;
        }
        String[] pSepicalName = new String[]{I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label74", "\u989d\u5b9a\u7535\u538b/\u9891\u7387"), I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label75", "\u611f\u5149\u5143\u4ef6\u5c3a\u5bf8"), I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label76", "\u66dd\u5149\u8865\u507f")};
        char[] pDelim = new char[]{'\u3001', '/', ','};
        for (int i = 0; i < pDelim.length; ++i) {
            int nPos;
            char cDelim = pDelim[i];
            if (cDelim == '/') {
                boolean bSpecail = false;
                for (int nSpecialIndex = 0; nSpecialIndex < pSepicalName.length; ++nSpecialIndex) {
                    if (!_sAnotherName.equals(pSepicalName[nSpecialIndex])) continue;
                    bSpecail = true;
                    break;
                }
                if (bSpecail) {
                    logger.info((Object)(_sAnotherName + I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label77", " \u662f\u7279\u6b8a\u53c2\u6570\uff0c\u3010") + _pEnumValues[0] + I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label78", "\u3011\u5305\u542b\u4e86/\u503c\uff0c\u4e0d\u662f\u591a\u503c\u5206\u9694\u7b26!")));
                    continue;
                }
            }
            if ((nPos = sValue.indexOf(cDelim)) < 0) continue;
            logger.info((Object)("[" + sValue + I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label79", "]\u6709\u53ef\u80fd\u662f\u591a\u4e2a\u679a\u4e3e\u503c")));
            String[] pValues = CMyString.split(_pEnumValues[0], String.valueOf(cDelim));
            int nSrcStartPos = 0;
            String sFirstValue = pValues[0];
            if (_sAnotherName.startsWith(I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label68", "\u6295\u653e")) && (I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label69", "\u666e\u6295").equals(sFirstValue) || I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label70", "\u5168\u6295 ").equals(sFirstValue))) {
                logger.info((Object)(_sAnotherName + I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label72", " \u662f\u6295\u653e\u6e20\u9053\u53c2\u6570\uff0c\u5ffd\u7565\u4e86\u3010") + sValue + I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label73", "\u3011\u9009\u9879!")));
                nSrcStartPos = 1;
            }
            try {
                System.arraycopy(pValues, nSrcStartPos, _pEnumValues, 0, pValues.length - nSrcStartPos);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                logger.error((Object)("Src.length[" + pValues.length + "] _pEnumValues.lenght[" + _pEnumValues.length + "] [" + _pEnumValues[0] + "]"));
                throw e;
            }
            nRelEnumCount = pValues.length;
            return nRelEnumCount;
        }
        return nRelEnumCount;
    }

    private static boolean isRequire(String _sValue) {
        if (CMyString.isEmpty(_sValue) || _sValue.startsWith(I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label80", "\u9009\u586b")) || _sValue.startsWith(I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label81", "\u5426"))) {
            return false;
        }
        if (_sValue.equals("*") || _sValue.startsWith(I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label55", "\u5fc5\u586b")) || _sValue.startsWith(I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label82", "\u662f"))) {
            return true;
        }
        logger.error((Object)(I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label83", "\u5fc5\u586b\u9879\u7684\u503c[") + _sValue + I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label84", "]\u4e0d\u5728\u679a\u4e3e\u503c\u8303\u56f4\u4e4b\u5185")));
        return false;
    }

    private static boolean isValueOfTrueOrFalse(String _sValue) {
        return CMyString.isEmpty(_sValue) || _sValue.equals(I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label82", "\u662f")) || _sValue.equals("\u221a") || _sValue.equals(I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label85", "\u6709"));
    }

    private static void dowithRadio(Cell[] _pCell, MetaViewField _dbField, int _nDataTypeIndex, int _nRequireIndex, int _nPersonalIndex) throws Exception {
        boolean bValidate = VALIDATE_DATA;
        String sAnotherName = _dbField.getAnotherName();
        int nCellCount = _pCell.length;
        int nEnumStartIndex = 0;
        nEnumStartIndex = _nRequireIndex > _nDataTypeIndex ? _nRequireIndex + 1 : _nDataTypeIndex + 1;
        if (nEnumStartIndex <= _nPersonalIndex) {
            nEnumStartIndex = _nPersonalIndex + 1;
        }
        if (nEnumStartIndex >= nCellCount) {
            logger.error((Object)("\u3010" + sAnotherName + I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label86", "\u3011\u7684\u679a\u4e3e\u503c\u6ca1\u6709\uff0c\u4e0d\u77e5\u662f\u5426\u662f\u201c\u662f\u5426\u9009\u9879\u201d\u7c7b\u578b\uff01")));
            ExcelForStructImporter.setDBType(_dbField, 5);
            return;
        }
        String[] pEnumValues = new String[20];
        int nRelEnumCount = ExcelForStructImporter.makeRealEnumValues(_pCell, nEnumStartIndex, pEnumValues, sAnotherName);
        int nDataType = 6;
        switch (nRelEnumCount) {
            case 0: {
                nDataType = ExcelForStructImporter.dowithTrueOrFalseDataType(_dbField, pEnumValues);
                if (!bValidate) break;
                logger.error((Object)("\u3010" + sAnotherName + I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label87", "\u3011\u7684\u679a\u4e3e\u503c\u503c\u6ca1\u6709\uff0c\u4e0d\u77e5\u662f\u5426\u662f\u201c\u662f\u5426\u9009\u9879\u201d\u7c7b\u578b\uff01")));
                break;
            }
            case 1: {
                if (ExcelForStructImporter.isValueOfTrueOrFalse(pEnumValues[0]) || pEnumValues[0].equals("/")) {
                    nDataType = ExcelForStructImporter.dowithTrueOrFalseDataType(_dbField, pEnumValues);
                    break;
                }
                nDataType = 6;
                _dbField.setEnmValue(pEnumValues[0]);
                if (!bValidate) break;
                logger.error((Object)("\u3010" + sAnotherName + I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label88", "\u3011\u7684\u679a\u4e3e\u503c\u503c\u662f\u4e00\u4e2a\uff0c\u4f46\u4e0d\u662f\u662f\u5426\u9009\u9879\uff01\u3010") + pEnumValues[0] + "\u3011"));
                break;
            }
            case 2: {
                if (ExcelForStructImporter.isValueOfTrueOrFalse(pEnumValues[0])) {
                    nDataType = ExcelForStructImporter.dowithTrueOrFalseDataType(_dbField, pEnumValues);
                    break;
                }
                nDataType = 6;
                if (bValidate) {
                    logger.error((Object)("\u3010" + sAnotherName + I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label89", "\u3011\u7684\u679a\u4e3e\u503c\u503c\u662f\u4e24\u4e2a\uff0c\u4f46\u4e0d\u662f\u662f\u5426\u9009\u9879\uff01\u3010") + pEnumValues[0] + "\u3011"));
                }
                _dbField.setEnmValue(ExcelForStructImporter.makeEnumValuesForWCM(pEnumValues, nRelEnumCount));
                break;
            }
            default: {
                if (ExcelForStructImporter.isValueOfTrueOrFalse(pEnumValues[0])) {
                    nDataType = ExcelForStructImporter.dowithTrueOrFalseDataType(_dbField, pEnumValues);
                    if (!bValidate) break;
                    logger.error((Object)("\u3010" + sAnotherName + I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label90", "\u3011\u7684\u679a\u4e3e\u503c\u503c\u662f") + nRelEnumCount + I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label91", "\u4e2a\uff0c\u6709\u53ef\u80fd\u662f\u5426\u9009\u9879\uff01\u7b2c\u4e8c\u4e2a\u4e3a\u3010") + pEnumValues[1] + "\u3011"));
                    break;
                }
                nDataType = 6;
                _dbField.setEnmValue(ExcelForStructImporter.makeEnumValuesForWCM(pEnumValues, nRelEnumCount));
            }
        }
        ExcelForStructImporter.setDBType(_dbField, nDataType);
    }

    private static void dowithCheckbox(Cell[] _pCell, MetaViewField _dbField, int _nDataTypeIndex, int _nRequireIndex, int _nPersonalIndex) throws Exception {
        boolean bValidate = VALIDATE_DATA;
        String sAnotherName = _dbField.getAnotherName();
        int nCellCount = _pCell.length;
        int nEnumStartIndex = 0;
        nEnumStartIndex = _nRequireIndex > _nDataTypeIndex ? _nRequireIndex + 1 : _nDataTypeIndex + 1;
        if (nEnumStartIndex <= _nPersonalIndex) {
            nEnumStartIndex = _nPersonalIndex + 1;
        }
        if (nEnumStartIndex >= nCellCount) {
            logger.error((Object)("\u3010" + sAnotherName + I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label86", "\u3011\u7684\u679a\u4e3e\u503c\u6ca1\u6709\uff0c\u4e0d\u77e5\u662f\u5426\u662f\u201c\u662f\u5426\u9009\u9879\u201d\u7c7b\u578b\uff01")));
            ExcelForStructImporter.setDBType(_dbField, 5);
            return;
        }
        String[] pEnumValues = new String[20];
        int nRelEnumCount = ExcelForStructImporter.makeRealEnumValues(_pCell, nEnumStartIndex, pEnumValues, sAnotherName);
        int nDataType = 9;
        switch (nRelEnumCount) {
            case 0: {
                nDataType = ExcelForStructImporter.dowithTrueOrFalseDataType(_dbField, pEnumValues);
                if (!bValidate) break;
                logger.error((Object)("\u3010" + sAnotherName + I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label86", "\u3011\u7684\u679a\u4e3e\u503c\u6ca1\u6709\uff0c\u4e0d\u77e5\u662f\u5426\u662f\u201c\u662f\u5426\u9009\u9879\u201d\u7c7b\u578b\uff01")));
                break;
            }
            case 1: {
                if (ExcelForStructImporter.isValueOfTrueOrFalse(pEnumValues[0]) || pEnumValues[0].equals("/")) {
                    nDataType = ExcelForStructImporter.dowithTrueOrFalseDataType(_dbField, pEnumValues);
                    break;
                }
                nDataType = 9;
                _dbField.setEnmValue(pEnumValues[0]);
                if (!bValidate) break;
                logger.error((Object)("\u3010" + sAnotherName + I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label88", "\u3011\u7684\u679a\u4e3e\u503c\u503c\u662f\u4e00\u4e2a\uff0c\u4f46\u4e0d\u662f\u662f\u5426\u9009\u9879\uff01\u3010") + pEnumValues[0] + "\u3011"));
                break;
            }
            case 2: {
                if (ExcelForStructImporter.isValueOfTrueOrFalse(pEnumValues[0])) {
                    nDataType = ExcelForStructImporter.dowithTrueOrFalseDataType(_dbField, pEnumValues);
                    break;
                }
                nDataType = 9;
                if (bValidate) {
                    logger.error((Object)("\u3010" + sAnotherName + I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label89", "\u3011\u7684\u679a\u4e3e\u503c\u503c\u662f\u4e24\u4e2a\uff0c\u4f46\u4e0d\u662f\u662f\u5426\u9009\u9879\uff01\u3010") + pEnumValues[0] + "\u3011"));
                }
                _dbField.setEnmValue(ExcelForStructImporter.makeEnumValuesForWCM(pEnumValues, nRelEnumCount));
                break;
            }
            default: {
                if (ExcelForStructImporter.isValueOfTrueOrFalse(pEnumValues[0])) {
                    nDataType = ExcelForStructImporter.dowithTrueOrFalseDataType(_dbField, pEnumValues);
                    if (!bValidate) break;
                    logger.error((Object)("\u3010" + sAnotherName + I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label90", "\u3011\u7684\u679a\u4e3e\u503c\u503c\u662f") + nRelEnumCount + I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label91", "\u4e2a\uff0c\u6709\u53ef\u80fd\u662f\u5426\u9009\u9879\uff01\u7b2c\u4e8c\u4e2a\u4e3a\u3010") + pEnumValues[1] + "\u3011"));
                    break;
                }
                nDataType = 9;
                _dbField.setEnmValue(ExcelForStructImporter.makeEnumValuesForWCM(pEnumValues, nRelEnumCount));
            }
        }
        ExcelForStructImporter.setDBType(_dbField, nDataType);
    }

    private static void dowithSelect(Cell[] _pCell, MetaViewField _dbField, int _nDataTypeIndex, int _nRequireIndex, int _nPersonalIndex) throws Exception {
        boolean bValidate = VALIDATE_DATA;
        String sAnotherName = _dbField.getAnotherName();
        int nCellCount = _pCell.length;
        int nEnumStartIndex = 0;
        nEnumStartIndex = _nRequireIndex > _nDataTypeIndex ? _nRequireIndex + 1 : _nDataTypeIndex + 1;
        if (nEnumStartIndex <= _nPersonalIndex) {
            nEnumStartIndex = _nPersonalIndex + 1;
        }
        if (nEnumStartIndex >= nCellCount) {
            logger.error((Object)(I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label92", "\u4e0b\u62c9\u9879\u3010") + sAnotherName + I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label86", "\u3011\u7684\u679a\u4e3e\u503c\u6ca1\u6709\uff0c\u4e0d\u77e5\u662f\u5426\u662f\u201c\u662f\u5426\u9009\u9879\u201d\u7c7b\u578b\uff01")));
            ExcelForStructImporter.setDBType(_dbField, 5);
            return;
        }
        String[] pEnumValues = new String[20];
        int nRelEnumCount = ExcelForStructImporter.makeRealEnumValues(_pCell, nEnumStartIndex, pEnumValues, sAnotherName);
        int nDataType = 7;
        switch (nRelEnumCount) {
            case 0: {
                nDataType = ExcelForStructImporter.dowithTrueOrFalseDataType(_dbField, pEnumValues);
                if (!bValidate) break;
                logger.error((Object)(I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label92", "\u4e0b\u62c9\u9879\u3010") + sAnotherName + I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label86", "\u3011\u7684\u679a\u4e3e\u503c\u6ca1\u6709\uff0c\u4e0d\u77e5\u662f\u5426\u662f\u201c\u662f\u5426\u9009\u9879\u201d\u7c7b\u578b\uff01")));
                break;
            }
            case 1: {
                if (ExcelForStructImporter.isValueOfTrueOrFalse(pEnumValues[0]) || pEnumValues[0].equals("/")) {
                    nDataType = ExcelForStructImporter.dowithTrueOrFalseDataType(_dbField, pEnumValues);
                    break;
                }
                nDataType = 7;
                _dbField.setEnmValue(pEnumValues[0]);
                if (!bValidate) break;
                logger.error((Object)(I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label92", "\u4e0b\u62c9\u9879\u3010") + sAnotherName + I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label88", "\u3011\u7684\u679a\u4e3e\u503c\u503c\u662f\u4e00\u4e2a\uff0c\u4f46\u4e0d\u662f\u662f\u5426\u9009\u9879\uff01\u3010") + pEnumValues[0] + "\u3011"));
                break;
            }
            case 2: {
                if (ExcelForStructImporter.isValueOfTrueOrFalse(pEnumValues[0])) {
                    nDataType = ExcelForStructImporter.dowithTrueOrFalseDataType(_dbField, pEnumValues);
                    break;
                }
                nDataType = 7;
                if (bValidate) {
                    logger.error((Object)("\u3010" + sAnotherName + I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label89", "\u3011\u7684\u679a\u4e3e\u503c\u503c\u662f\u4e24\u4e2a\uff0c\u4f46\u4e0d\u662f\u662f\u5426\u9009\u9879\uff01\u3010") + pEnumValues[0] + "\u3011"));
                }
                _dbField.setEnmValue(ExcelForStructImporter.makeEnumValuesForWCM(pEnumValues, nRelEnumCount));
                break;
            }
            default: {
                if (ExcelForStructImporter.isValueOfTrueOrFalse(pEnumValues[0])) {
                    nDataType = ExcelForStructImporter.dowithTrueOrFalseDataType(_dbField, pEnumValues);
                    if (!bValidate) break;
                    logger.error((Object)("\u3010" + sAnotherName + I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label90", "\u3011\u7684\u679a\u4e3e\u503c\u503c\u662f") + nRelEnumCount + I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label91", "\u4e2a\uff0c\u6709\u53ef\u80fd\u662f\u5426\u9009\u9879\uff01\u7b2c\u4e8c\u4e2a\u4e3a\u3010") + pEnumValues[1] + "\u3011"));
                    break;
                }
                nDataType = 7;
                _dbField.setEnmValue(ExcelForStructImporter.makeEnumValuesForWCM(pEnumValues, nRelEnumCount));
            }
        }
        ExcelForStructImporter.setDBType(_dbField, nDataType);
    }

    private static int dowithTrueOrFalseDataType(MetaViewField _dbField, String[] _pEnumValues) throws WCMException {
        int nDataType = 6;
        _dbField.setDBType(4);
        if (_pEnumValues == null || _pEnumValues.length <= 0) {
            return nDataType;
        }
        String sGroupName = _dbField.getPropertyAsString("GroupName");
        if ("\u221a".equals(_pEnumValues[0]) && ExcelForStructImporter.isExistsPropGroup(sGroupName) || I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label85", "\u6709").equals(_pEnumValues[0])) {
            _dbField.setEnmValue(I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label93", "\u6709`1~\u65e0`0"));
            logger.info((Object)(_dbField.getAnotherName() + "." + _dbField.getName() + I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label94", " \u662f\u6709\u65e0\u7c7b\u578b")));
        } else {
            int i;
            _dbField.setEnmValue(I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label95", "\u662f`1~\u5426`0"));
            String sLastValue = null;
            for (i = _pEnumValues.length - 1; i >= 0 && (sLastValue = _pEnumValues[i]) == null; --i) {
            }
            logger.info((Object)(_dbField.getAnotherName() + "." + _dbField.getName() + I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label96", " \u662f[\u662f\u5426]\u7c7b\u578b\uff0c\u679a\u4e3e\u957f\u5ea6\u4e3a[") + (i + 1) + I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label97", "]\u6700\u540e\u4e00\u4e2a\u503c\u4e3a[") + sLastValue + "]"));
        }
        return nDataType;
    }

    private static boolean isExistsPropGroup(String _sGroupName) {
        String[] pGroupName = new String[]{I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label98", "\u4eba\u6027\u5316\u8bbe\u8ba1"), I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label99", "\u521b\u65b0\u79d1\u6280"), I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label100", "\u529f\u80fd\u53c2\u6570"), I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label101", "\u9886\u5148\u79d1\u6280"), I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label102", "\u5b89\u5168\u4fdd\u62a4")};
        for (int i = 0; i < pGroupName.length; ++i) {
            if (!pGroupName[i].equals(_sGroupName)) continue;
            return true;
        }
        return false;
    }

    private static void setDBType(MetaViewField _dbField, int _nDataTypeId) throws WCMException {
        HashMap hEnumValues;
        _dbField.setType(_nDataTypeId);
        if (_dbField.getDBType() == 4) {
            return;
        }
        MetaDataType dataType = MetaDataConstants.DATA_TYPES.getDataTypeById(_nDataTypeId);
        _dbField.setDBType(dataType.getSqlDataType());
        int nMaxLength = dataType.getMaxLength();
        if (!(_nDataTypeId == 5 || _nDataTypeId != 9 && _nDataTypeId != 6 && _nDataTypeId != 7 || (hEnumValues = _dbField.getEnmValueMap(true)) == null || hEnumValues.isEmpty())) {
            nMaxLength = 0;
            for (String sValue : hEnumValues.values()) {
                int nRealLength = (int)((double)CMyString.getBytesLength(sValue) * 1.6) + 5;
                if (_nDataTypeId == 9) {
                    nMaxLength += nRealLength;
                    continue;
                }
                if (nRealLength <= nMaxLength) continue;
                nMaxLength = nRealLength;
            }
        }
        _dbField.setLength(nMaxLength);
    }

    private static String makeEnumValuesForWCM(String[] _pEnumValues, int _nRelEnumCount) {
        StringBuffer sbEmValues = new StringBuffer(_nRelEnumCount * 12);
        sbEmValues.append(_pEnumValues[0]);
        for (int i = 1; i < _nRelEnumCount; ++i) {
            sbEmValues.append("~");
            sbEmValues.append(_pEnumValues[i]);
        }
        return sbEmValues.toString();
    }

    static {
        FieldInfo fieldInfo = DEFAULT_FIELDS.register(3, I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label1", "\u4ea7\u54c1\u540d\u79f0"), "PName", 12, 100, I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label2", "\u89c4\u683c\u53c2\u6570"), null);
        fieldInfo.setNotNull(true);
        fieldInfo.setTitle(true);
        fieldInfo.setInOutline(true);
        fieldInfo.setSearchField(true);
        fieldInfo = DEFAULT_FIELDS.register(3, I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label3", "\u4ea7\u54c1\u578b\u53f7"), "ModelNo", 12, 30, I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label2", "\u89c4\u683c\u53c2\u6570"), null);
        fieldInfo.setNotNull(true);
        fieldInfo.setInOutline(true);
        fieldInfo.setSearchField(true);
        fieldInfo = DEFAULT_FIELDS.register(12, I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label4", "\u4ea7\u54c1\u7279\u6027"), "Special", 2005, 0, I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label4", "\u4ea7\u54c1\u7279\u6027"), null);
        fieldInfo.setInSerailMode(false);
        DEFAULT_FIELDS.register(3, I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label5", "\u4ea7\u54c1\u7f16\u7801"), "PCode", 12, 30, I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label2", "\u89c4\u683c\u53c2\u6570"), null);
        DEFAULT_FIELDS.register(3, I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label6", "\u4ea7\u54c1\u6807\u7b7e"), "PKeywords", 12, 120, I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label2", "\u89c4\u683c\u53c2\u6570"), null);
        DEFAULT_FIELDS.register(5, I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label7", "\u662f\u5426\u9000\u5e02"), "PExpire", 4, 1, I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label8", "\u89c4\u683c\u53c2\u6570_\u5c5e\u6027"), null);
        DEFAULT_FIELDS.register(5, I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label9", "\u5373\u5c06\u4e0a\u5e02"), "PSale", 4, 1, I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label8", "\u89c4\u683c\u53c2\u6570_\u5c5e\u6027"), null);
        DEFAULT_FIELDS.register(11, I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label10", "\u5373\u5c06\u4e0a\u5e02\u6709\u6548\u671f"), "PSaleValid", 93, 0, I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label8", "\u89c4\u683c\u53c2\u6570_\u5c5e\u6027"), null);
        DEFAULT_FIELDS.register(5, I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label11", "\u6d3b\u52a8\u4e2d"), "PPromotion", 4, 1, I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label8", "\u89c4\u683c\u53c2\u6570_\u5c5e\u6027"), null);
        DEFAULT_FIELDS.register(11, I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label12", "\u6d3b\u52a8\u6709\u6548\u671f"), "PPromotionValid", 93, 0, I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label8", "\u89c4\u683c\u53c2\u6570_\u5c5e\u6027"), null);
        DEFAULT_FIELDS.register(3, I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label13", "\u6d3b\u52a8\u94fe\u63a5"), "PPromotionURL", 12, 200, I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label8", "\u89c4\u683c\u53c2\u6570_\u5c5e\u6027"), null);
        fieldInfo = DEFAULT_FIELDS.register(1, I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label14", "\u8bc4\u8bba\u6b21\u6570"), "CommentCount", 4, 0);
        fieldInfo.setHidden(true);
        fieldInfo.setInSerailMode(false);
        fieldInfo = DEFAULT_FIELDS.register(1, I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label15", "\u6d4f\u89c8\u6b21\u6570"), "ClickCount", 4, 0);
        fieldInfo.setHidden(true);
        fieldInfo.setInSerailMode(false);
        fieldInfo = DEFAULT_FIELDS.register(1, I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label16", "\u6536\u85cf\u6b21\u6570"), "FavCount", 4, 0);
        fieldInfo.setHidden(true);
        fieldInfo.setInSerailMode(false);
        fieldInfo = DEFAULT_FIELDS.register(1, I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label17", "\u88ab\u5206\u4eab\u6b21\u6570"), "ShareCount", 4, 0);
        fieldInfo.setHidden(true);
        fieldInfo.setInSerailMode(false);
        fieldInfo = DEFAULT_FIELDS.register(1, I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label18", "\u70b9\u51fb\u8d2d\u4e70\u6b21\u6570"), "WBuyCount", 4, 0);
        fieldInfo.setHidden(true);
        fieldInfo.setInSerailMode(false);
        DEFAULT_FIELDS.register(1, I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label19", "\u63a8\u8350\u5ea6"), "Suggest", 6, 0);
        fieldInfo.setHidden(true);
        fieldInfo.setInSerailMode(false);
        fieldInfo = DEFAULT_FIELDS.register(1, I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label20", "\u5916\u90e8\u6570\u636eID"), "HOutputId", 4, 0);
        fieldInfo.setInOutline(true);
        fieldInfo = DEFAULT_FIELDS.register(6, I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label21", "\u6982\u8ff0\u7248\u5f0f"), "OutlineViewMode", 4, 0, I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label22", "\u4ea7\u54c1\u6982\u8ff0"), I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label22", "\u4ea7\u54c1\u6982\u8ff0"));
        fieldInfo.setEnumValues(I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label23", "\u56fe\u6587`1~\u6587\u5b57+\u63cf\u8ff0`2~\u7eaf\u6587\u5b57`3"));
        fieldInfo.setInSerailMode(false);
        fieldInfo = DEFAULT_FIELDS.register(14, I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label22", "\u4ea7\u54c1\u6982\u8ff0"), "Outline", 12, 50, I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label22", "\u4ea7\u54c1\u6982\u8ff0"), I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label22", "\u4ea7\u54c1\u6982\u8ff0"));
        fieldInfo.setInSerailMode(false);
        fieldInfo = DEFAULT_FIELDS.register(14, I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label24", "\u8bf4\u660e\u4e66"), "Book", 12, 50, I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label24", "\u8bf4\u660e\u4e66"), I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label24", "\u8bf4\u660e\u4e66"));
        fieldInfo.setInSerailMode(false);
        fieldInfo = DEFAULT_FIELDS.register(14, I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label25", "\u5e38\u89c1\u95ee\u9898"), "FAQ", 12, 120, I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label25", "\u5e38\u89c1\u95ee\u9898"), I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label25", "\u5e38\u89c1\u95ee\u9898"));
        fieldInfo.setInSerailMode(false);
        fieldInfo = DEFAULT_FIELDS.register(14, I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label26", "\u9a71\u52a8\u4e0b\u8f7d"), "Driver", 12, 255, I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label26", "\u9a71\u52a8\u4e0b\u8f7d"), I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label26", "\u9a71\u52a8\u4e0b\u8f7d"));
        fieldInfo.setInSerailMode(false);
        fieldInfo.setForTableAnotherNames(new String[]{I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label27", "\u7b14\u8bb0\u672c\u7cfb\u5217"), I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label28", "\u4e00\u4f53\u673a"), I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label29", "\u53f0\u5f0f\u673a"), I18NMessage.get(ExcelForStructImporter.class, "ExcelForStructImporter.label30", "\u6570\u7801\u6444\u50cf\u673a")});
    }
}

