/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.definition;

import com.trs.cms.content.CMSObj;
import com.trs.components.common.publish.domain.publisher.PublishPathCompass;
import com.trs.components.common.publish.domain.publisher.PublishSyncGlobalTuner;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.tagparser.TagBeanAttrInfo;
import com.trs.components.common.publish.domain.tagparser.TagBeanInfo;
import com.trs.components.common.publish.domain.tagparser.TagParserFolderBase;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.metadata.publish.WCMTagParserViewData;
import com.trs.components.wcm.advisor.Advisor;
import com.trs.components.wcm.advisor.AdvisorXMLMaker;
import com.trs.components.wcm.advisor.Advisors;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.publish.tagparser.WCMTagParserHelper;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.store.FileService;
import java.util.List;

public class WCMTagParserWizard
extends TagParserFolderBase {
    private static final int XML = 100;
    private static TagBeanInfo s_TagBeanInfo = null;

    private String parseToXML(PublishTagContext _context) throws WCMException {
        int nChannelId = this.m_host.getId();
        String sAdvisorName = _context.getAttribute("name");
        WCMFilter filter = new WCMFilter("", "", "");
        String sWhere = "ChannelId=?";
        filter.addSearchValues(nChannelId);
        if (!CMyString.isEmpty(sAdvisorName)) {
            sWhere = sWhere + " AND ADVISORNAME=?";
            filter.addSearchValues(sAdvisorName);
        }
        filter.setWhere(sWhere);
        filter.setMaxRowNumber(1);
        Advisors advisors = Advisors.openWCMObjs(null, filter);
        if (advisors.isEmpty()) {
            return null;
        }
        Advisor advisor = (Advisor)advisors.getAt(0);
        AdvisorXMLMaker oAdvisorXMLMaker = new AdvisorXMLMaker();
        String sXML = oAdvisorXMLMaker.parseToXML(advisor);
        List lFileNames = oAdvisorXMLMaker.getRelateFiles();
        boolean bDisFile = _context.getAttribute("DisFile", false);
        for (String sFileName : lFileNames) {
            this.distributeFile(_context, sFileName, bDisFile);
        }
        return sXML;
    }

    @Override
    protected void registerHostSpecialProperties() {
        this.registerHostSpecialProperty("XML", 100);
    }

    @Override
    protected String[] parseHostSpecialProperty(int _nPropertyId, PublishTagContext _context) throws WCMException {
        switch (_nPropertyId) {
            case 100: {
                return new String[]{this.parseToXML(_context)};
            }
        }
        return null;
    }

    @Override
    protected CMSObj findHost(PublishTagContext _context) throws WCMException {
        boolean bMustBeChannel = true;
        BaseChannel oChannelOrSite = WCMTagParserHelper.findFolderHost(this.m_tagItem, _context, bMustBeChannel);
        if (bMustBeChannel || oChannelOrSite == null) {
            return oChannelOrSite;
        }
        return oChannelOrSite.getSite();
    }

    @Override
    public TagBeanInfo getBeanInfo() {
        if (s_TagBeanInfo == null) {
            TagBeanInfo tbi = new TagBeanInfo();
            tbi.setName("TRS_WIZARD");
            tbi.setDesc("\u4ea7\u54c1\u987e\u95eeXML\u4ea7\u751f\u5668");
            tbi.setType(TagBeanInfo.BodyType.IGNORE);
            TagBeanAttrInfo tbai = null;
            tbai = new TagBeanAttrInfo();
            tbai.setName("ID");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setDefaultValue("OWNER");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("CHILDINDEX");
            tbai.setType(TagBeanAttrInfo.Type.INTEGER);
            tbai.setDefaultValue("-1");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("NUM");
            tbai.setType(TagBeanAttrInfo.Type.INTEGER);
            tbai.setDefaultValue("0");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("FIELD");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setDefaultValue("XML");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("AUTOFORMAT");
            tbai.setEnumValue(new String[]{"true", "false"});
            tbai.setDefaultValue("false");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("AUTOFORMATTYPE");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setEnumValue(new String[]{"HTML", "HTMLValue", "JAVASCRIPT", "JS", "XML", "JSON"});
            tbai.setDefaultValue("HTML");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("TemplateName");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbi.addAttrInfo(tbai);
            s_TagBeanInfo = tbi;
        }
        return s_TagBeanInfo;
    }

    private void distributeFile(PublishTagContext _context, String _sFileName, boolean _bDisFile) throws WCMException {
        String sLocalPath;
        String sFileName = _sFileName;
        if (!FilesMan.isValidFile(sFileName, "P0") && !FilesMan.isValidFile(sFileName, "W0")) {
            _context.getPageContext().addErrorLog(9, I18NMessage.get(WCMTagParserViewData.class, "WCMTagParserViewData.label7", "\u76f8\u5173\u9644\u4ef6[") + sFileName + I18NMessage.get(WCMTagParserViewData.class, "WCMTagParserViewData.label8", "]\u4e0d\u662f\u6709\u6548\u7684WCM\u6587\u4ef6\uff01"), this.m_tagItem.toString());
            return;
        }
        String sAbsoluteFieldName = FilesMan.getFilesMan().mapFilePath(sFileName, 0) + sFileName;
        FileService file = new FileService(sAbsoluteFieldName);
        if (!file.exists()) {
            _context.getPageContext().addErrorLog(9, I18NMessage.get(WCMTagParserViewData.class, "WCMTagParserViewData.label7", "\u76f8\u5173\u9644\u4ef6[") + sFileName + I18NMessage.get(WCMTagParserViewData.class, "WCMTagParserViewData.label9", "]\u4e0d\u5b58\u5728\uff01[AbsoluteFile=") + sAbsoluteFieldName + "]", this.m_tagItem.toString());
            return;
        }
        IPublishFolder oApdOwner = (IPublishFolder)PublishElementFactory.makeElementFrom(this.m_host);
        PublishPathCompass compass = _context.getPathCompass();
        boolean bPreview = _context.isPreview();
        if (_bDisFile) {
            bPreview = false;
        }
        if (!CMyFile.fileExists((sLocalPath = compass.getLocalPath(oApdOwner, bPreview)) + sFileName)) {
            PublishSyncGlobalTuner.insureLocalPathExists(sLocalPath);
            try {
                CMyFile.copyFile(sAbsoluteFieldName, sLocalPath + sFileName);
                if (_bDisFile || !bPreview) {
                    _context.getFileDistributeShip().distributeFile(sAbsoluteFieldName, oApdOwner, null, true);
                }
            }
            catch (Exception e) {
                throw new WCMException(I18NMessage.get(WCMTagParserViewData.class, "WCMTagParserViewData.label10", "\u5206\u53d1\u6587\u4ef6\u5931\u8d25\uff01[UpperHost=") + _context.getUpperHost().getInfo() + "][FileName=" + sFileName + "]", e);
            }
        }
    }
}

