/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.definition;

import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.metadata.definition.MetaViewFieldGroups;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;

public class MetaViewFieldGroup
extends CMSObj {
    public static final int OBJ_TYPE = 2093442339;
    public static final String DB_TABLE_NAME = "XWCMMETAVIEWFIELDGROUP";
    public static final String DB_ID_NAME = "METAVIEWFIELDGROUPID";
    private static final int DIRECTION_MOVE_FORWARD = 1;
    private static final int DIRECTION_MOVE_BACK = -1;
    private static final int DIRECTION_MOVE_NO = 0;

    @Override
    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    @Override
    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    @Override
    public int getWCMType() {
        return 2093442339;
    }

    public String getGroupName() {
        return this.getPropertyAsString("GROUPNAME");
    }

    public boolean setGroupName(String _sGroupName) throws WCMException {
        return this.setProperty("GROUPNAME", _sGroupName);
    }

    public int getMetaViewId() {
        return this.getPropertyAsInt("METAVIEWID", 0);
    }

    public boolean setMetaViewId(int _nMetaViewId) throws WCMException {
        return this.setProperty("METAVIEWID", _nMetaViewId);
    }

    public int getParentId() {
        return this.getPropertyAsInt("PARENTID", 0);
    }

    public boolean setParentId(int _nParentId) throws WCMException {
        return this.setProperty("PARENTID", _nParentId);
    }

    public int getOrder() {
        return this.getPropertyAsInt("GROUPORDER", 0);
    }

    public boolean setOrder(int _nGoupOrder) throws WCMException {
        return this.setProperty("GROUPORDER", _nGoupOrder);
    }

    @Override
    public boolean isValid() throws WCMException {
        if (this.isAddMode()) {
            if (this.getProperty("GROUPNAME") == null) {
                throw new WCMException(1106, I18NMessage.get(MetaViewFieldGroup.class, "MetaViewFieldGroup.label1", "\u5c5e\u6027GroupName\u6ca1\u6709\u8bbe\u7f6e(MetaViewFieldGroup.isValid)"));
            }
            if (this.getProperty("METAVIEWID") == null) {
                throw new WCMException(1106, I18NMessage.get(MetaViewFieldGroup.class, "MetaViewFieldGroup.label2", "\u5c5e\u6027MetaViewId\u6ca1\u6709\u8bbe\u7f6e(MetaViewFieldGroup.isValid)"));
            }
        } else if (!this.isModified()) {
            throw new WCMException(1107, I18NMessage.get(MetaViewFieldGroup.class, "MetaViewFieldGroup.label3", "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539(MetaViewFieldGroup.isValid)"));
        }
        this.changeOrder();
        return true;
    }

    @Override
    public void insert(User _currUser) throws WCMException {
        if (this.isAddMode() && this.isModified()) {
            super.insert(_currUser);
        }
    }

    private void changeOrder() throws WCMException {
        int nMaxOrder;
        int nNewOrder;
        int nMoveBeginAt = 0;
        int nMoveEndAt = 0;
        int nMoveDirection = 0;
        if (this.isAddMode()) {
            nNewOrder = this.getOrder();
            nMaxOrder = this.getMaxOrder();
            if (nNewOrder == -1) {
                nNewOrder = nMaxOrder + 1;
                this.setOrder(nNewOrder);
                return;
            }
            nMoveDirection = 1;
            nMoveEndAt = nMaxOrder;
            nMoveBeginAt = nNewOrder;
        } else {
            if (!this.isChangeProperty("GROUPORDER")) {
                return;
            }
            nNewOrder = this.getNewPropertyAsInt("GROUPORDER", -1);
            if (nNewOrder == -1) {
                nMaxOrder = this.getMaxOrder();
                if (this.isChangeProperty("PARENTID")) {
                    nNewOrder = nMaxOrder + 1;
                } else if (nMaxOrder == this.getOrder()) {
                    nNewOrder = this.getOrder();
                } else {
                    nMoveDirection = -1;
                    nMoveEndAt = nMaxOrder;
                    nMoveBeginAt = this.getOrder() + 1;
                    nNewOrder = nMaxOrder;
                }
            } else if (nNewOrder > this.getOrder()) {
                nMoveDirection = -1;
                nMoveEndAt = --nNewOrder;
                nMoveBeginAt = this.getOrder() + 1;
            } else {
                nMoveDirection = 1;
                nMoveEndAt = this.getOrder() - 1;
                nMoveBeginAt = nNewOrder;
            }
        }
        String sRegionWhere = "GROUPORDER>=" + nMoveBeginAt + " AND GROUPORDER <= " + nMoveEndAt + " and METAVIEWID=" + this.getMetaViewId();
        String sMoveSql = "UPDATE XWCMMETAVIEWFIELDGROUP SET GROUPORDER = GROUPORDER+(" + nMoveDirection + ") WHERE " + sRegionWhere;
        DBManager.getDBManager().sqlExecuteUpdate(sMoveSql);
        this.setOrder(nNewOrder);
    }

    private int getMaxOrder() throws WCMException {
        String SQL_QUERY_MAX_ORDER = "select max(GROUPORDER) from XWCMMETAVIEWFIELDGROUP where METAVIEWID=?";
        return DBManager.getDBManager().sqlExecuteIntQuery("select max(GROUPORDER) from XWCMMETAVIEWFIELDGROUP where METAVIEWID=?", new int[]{this.getMetaViewId()});
    }

    public static final MetaViewFieldGroup findById(int _nId) throws WCMException {
        if (_nId <= 0) {
            return null;
        }
        return (MetaViewFieldGroup)BaseObj.findById(MetaViewFieldGroup.class, _nId);
    }

    public static final MetaViewFieldGroups findByName(int _nMetaViewId, String _sGroupName) throws WCMException {
        WCMFilter filter = new WCMFilter("", "METAVIEWID=? AND GROUPNAME =?", "");
        filter.addSearchValues(_nMetaViewId);
        filter.addSearchValues(_sGroupName);
        MetaViewFieldGroups fieldGroups = MetaViewFieldGroups.openWCMObjs(null, filter);
        return fieldGroups;
    }

    public static final MetaViewFieldGroup createNewInstance() throws WCMException {
        return (MetaViewFieldGroup)BaseObj.createNewInstance(MetaViewFieldGroup.class);
    }

    public static final MetaViewFieldGroup findByKey(Object _oKey) throws WCMException {
        return (MetaViewFieldGroup)BaseObj.findByKey(MetaViewFieldGroup.class, _oKey);
    }
}

