/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.definition;

import com.trs.DreamFactory;
import com.trs.cluster.IClusterMsgCenter;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.publish.domain.publisher.PublishPageContext;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.publisher.PublishTaskContext;
import com.trs.components.common.publish.domain.tagparser.TagDocument;
import com.trs.components.common.publish.domain.tagparser.TagDocumentReader;
import com.trs.components.common.publish.domain.tagparser.TagParseHelper;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.metadata.MetaDataConstants;
import com.trs.components.metadata.center.IMetaViewEmployerMgr;
import com.trs.components.metadata.definition.ClassInfo;
import com.trs.components.metadata.definition.ClassInfos;
import com.trs.components.metadata.definition.DefaultFieldsFactory;
import com.trs.components.metadata.definition.IDefaultFieldsCreator;
import com.trs.components.metadata.definition.IMetaDataDefCacheMgr;
import com.trs.components.metadata.definition.IMetaDataDefMgr;
import com.trs.components.metadata.definition.MetaDBField;
import com.trs.components.metadata.definition.MetaDBFields;
import com.trs.components.metadata.definition.MetaDBTable;
import com.trs.components.metadata.definition.MetaDBTables;
import com.trs.components.metadata.definition.MetaDataDefHelper;
import com.trs.components.metadata.definition.MetaDataType;
import com.trs.components.metadata.definition.MetaView;
import com.trs.components.metadata.definition.MetaViewField;
import com.trs.components.metadata.definition.MetaViewFields;
import com.trs.components.metadata.definition.MetaViews;
import com.trs.components.wcm.content.domain.DocumentMgr;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.config.Config;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.CharsetDetector;
import com.trs.infra.util.database.DBType;
import com.trs.infra.util.database.FieldInfo;
import com.trs.infra.util.database.TableInfo;
import com.trs.infra.util.store.FileService;
import com.trs.infra.util.store.FileStore;
import java.io.File;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import org.apache.log4j.Logger;

public class MetaDataDefMgr
implements IMetaDataDefMgr {
    private static final String SQL_SYN_VIEWDBFIELDNAME = "update XWCMVIEWFIELDINFO set DBFIELDNAME=? where DBFIELD=?";
    private static final String WHERE_QUERY_VIEWS_BY_OTHERTABLE = "ViewInfoId in(select XWCMVIEWOtherTables.ViewId from XWCMVIEWOtherTables where XWCMVIEWOtherTables.TableId=?)";
    private static Logger logger = Logger.getLogger(MetaDataDefMgr.class);
    private DBManager m_oDBMgr = DBManager.getDBManager();
    private IMetaDataDefCacheMgr m_oDataDefCacheMgr = (IMetaDataDefCacheMgr)DreamFactory.createObjectById("IMetaDataDefCacheMgr");
    private DocumentMgr m_oDocumentMgr = (DocumentMgr)DreamFactory.createObjectById("DocumentMgr");

    @Override
    public MetaDBTable save(User _currUser, MetaDBTable _oTableInfo) throws WCMException {
        WCMFilter filter;
        boolean bIsAddMode = _oTableInfo.isAddMode();
        boolean bChangeTableName = _oTableInfo.isChangeProperty("TABLENAME");
        String sRenameSQL = null;
        String sNewTableName = null;
        String sOldTableName = null;
        String sRenameIdFieldNameSQL = null;
        if (bIsAddMode) {
            sNewTableName = MetaDataConstants.makeTrueTableName(_oTableInfo.getName());
        } else if (bChangeTableName) {
            sOldTableName = MetaDataConstants.makeTrueTableName(_oTableInfo.getName());
            sNewTableName = MetaDataConstants.makeTrueTableName(_oTableInfo.getNewPropertyAsString("TABLENAME"));
            sRenameSQL = this.m_oDBMgr.getDBType().sqlRenameTable(sOldTableName, sNewTableName);
        }
        if (sNewTableName != null && !sNewTableName.equalsIgnoreCase(sOldTableName) && this.m_oDBMgr.getTableInfo(sNewTableName) != null) {
            throw new WCMException(I18NMessage.get(MetaDataDefMgr.class, "MetaDataDefMgr.label1", "\u6307\u5b9a\u7684\u8868\u540d[") + sNewTableName + I18NMessage.get(MetaDataDefMgr.class, "MetaDataDefMgr.label2", "]\u5df2\u7ecf\u5b58\u5728\uff01"));
        }
        _oTableInfo.save(_currUser);
        if (bIsAddMode) {
            this.createTableInDB(_currUser, _oTableInfo, sNewTableName);
        } else if (bChangeTableName) {
            this.m_oDBMgr.sqlExecuteUpdate(sRenameSQL);
            this.m_oDBMgr.reloadTableInfo(sNewTableName);
            sRenameIdFieldNameSQL = this.m_oDBMgr.getDBType().sqlRenameField(sNewTableName, sOldTableName + "ID", sNewTableName + "ID");
            if (sNewTableName != null && !sNewTableName.equalsIgnoreCase(sOldTableName)) {
                this.m_oDBMgr.sqlExecuteUpdate(sRenameIdFieldNameSQL);
            }
        }
        if (sNewTableName != null) {
            this.m_oDBMgr.reloadTableInfo(sNewTableName);
        }
        if (bChangeTableName) {
            this.m_oDBMgr.getTableInfos().removeTableInfo(sOldTableName);
        }
        MetaViews views = new MetaViews(_currUser, 1, 1);
        if (bChangeTableName) {
            filter = new WCMFilter("", "MainTableId=?", "");
            filter.addSearchValues(_oTableInfo.getId());
            views.addElements(MetaViews.openWCMObjs(null, filter));
            String[] pUpdateSQL = new String[]{"update XWCMDBFieldInfo set TableName=? where TableId=?", "update XWCMViewFieldInfo set TableName=? where TableId=?", "update XWCMViewInfo set ViewName=? where MainTableId=? and ViewName=MainTableName", "update XWCMViewInfo set MainTableName=? where MainTableId=?"};
            Object[] pParameters = new Object[]{_oTableInfo.getName(), _oTableInfo.getKey()};
            this.m_oDBMgr.sqlExecuteUpdate(pUpdateSQL, pParameters);
        }
        if (bChangeTableName) {
            filter = new WCMFilter("", WHERE_QUERY_VIEWS_BY_OTHERTABLE, "");
            filter.addSearchValues(_oTableInfo.getId());
            views.addElements(MetaViews.openWCMObjs(null, filter));
            int nSize = views.size();
            for (int i = 0; i < nSize; ++i) {
                MetaView view = (MetaView)views.getAt(i);
                if (view == null) continue;
                String sRelationTableName = "WCMMetaRelation" + view.getId();
                String sRenameRelationFieldSQL = this.m_oDBMgr.getDBType().sqlRenameField(sRelationTableName, sOldTableName + "ID", sNewTableName + "ID");
                try {
                    this.m_oDBMgr.sqlExecuteUpdate(sRenameRelationFieldSQL);
                    this.m_oDBMgr.reloadTableInfo(sRelationTableName);
                    continue;
                }
                catch (Exception e) {
                    logger.error((Object)(I18NMessage.get(MetaDataDefMgr.class, "MetaDataDefMgr.label3", "\u66f4\u65b0\u5173\u8054\u8868\u5b57\u6bb5\u5931\u8d25\uff01\n[SQL=") + sRenameRelationFieldSQL + "]\n" + e.getMessage()));
                }
            }
        }
        this.recreateViewRelations(_currUser, views);
        return _oTableInfo;
    }

    private void createTableInDB(User _currUser, MetaDBTable _oTableInfo, String _sTableName) throws WCMException {
        if (this.m_oDBMgr.getTableInfo(_sTableName) != null) {
            return;
        }
        String sCreateNewTableSQL = this.m_oDBMgr.getDBType().sqlCreateTableWithPrimary(_sTableName, _sTableName + "ID");
        this.m_oDBMgr.sqlExecuteUpdate(sCreateNewTableSQL);
        this.m_oDBMgr.reloadTableInfo(_sTableName);
        this.appendDefaultFields(_currUser, _oTableInfo);
        String sRandom = String.valueOf(System.currentTimeMillis());
        sRandom = sRandom.substring(sRandom.length() - 9);
        String sIndexName = "IX_" + _oTableInfo.getName() + "_" + sRandom;
        String sCreateIndexSQL = "create unique index " + sIndexName + " on " + _sTableName + "(MetaDataId)";
        this.m_oDBMgr.sqlExecuteUpdate(sCreateIndexSQL);
    }

    @Override
    public MetaDBField save(User _currUser, MetaDBTable _oOwnerTable, MetaDBField _oDBFieldInfo) throws WCMException {
        return this.save(_currUser, _oOwnerTable, _oDBFieldInfo, true);
    }

    private MetaDBField save(User _currUser, MetaDBTable _oOwnerTable, MetaDBField _oDBFieldInfo, boolean _bReloadTableCache) throws WCMException {
        int nOriginalLen = _oDBFieldInfo.getLength();
        int nOriginalScale = _oDBFieldInfo.getScale();
        boolean bIsAddMode = _oDBFieldInfo.isAddMode();
        boolean bChangePropertyOfContainNull = _oDBFieldInfo.isModifyColumnProperties(true);
        boolean bChangeProperty = _oDBFieldInfo.isModifyColumnProperties(false);
        boolean bChangeFieldName = false;
        String sTableName = MetaDataConstants.makeTrueTableName(_oOwnerTable.getName());
        String sRenameSQL = null;
        String sNewColumnName = null;
        if (bIsAddMode) {
            sNewColumnName = _oDBFieldInfo.getName();
        } else {
            sNewColumnName = _oDBFieldInfo.getNewPropertyAsString("FIELDNAME");
            boolean bl = bChangeFieldName = sNewColumnName != null && !_oDBFieldInfo.getName().equalsIgnoreCase(sNewColumnName);
            if (bChangeFieldName) {
                sRenameSQL = this.m_oDBMgr.getDBType().sqlRenameField(sTableName, _oDBFieldInfo.getName(), sNewColumnName);
            } else {
                sNewColumnName = null;
            }
            if (_oDBFieldInfo.isChangeProperty("DBTYPE")) {
                throw new WCMException(I18NMessage.get(MetaDataDefMgr.class, "MetaDataDefMgr.label4", "\u5b57\u6bb5\u7c7b\u578b\u53d8\u66f4\u7684\u64cd\u4f5c\u6bd4\u8f83\u590d\u6742\uff0c\u4e0d\u652f\u6301\uff01"));
            }
        }
        _oDBFieldInfo.setTableName(_oOwnerTable.getName());
        _oDBFieldInfo.setTableId(_oOwnerTable.getId());
        if (sNewColumnName != null) {
            MetaDataDefMgr.validateFieldNotExists(sTableName, sNewColumnName);
        }
        _oDBFieldInfo.isValid();
        if (bIsAddMode) {
            this.createFieldInDB(_currUser, _oDBFieldInfo, sTableName);
        } else if (bChangeFieldName) {
            try {
                this.alterFiledNameInDB(_oDBFieldInfo, sRenameSQL);
            }
            catch (WCMException e) {
                _oDBFieldInfo.cancelUpdate(_currUser);
                throw e;
            }
        }
        if (!bIsAddMode && bChangeProperty) {
            _oDBFieldInfo.setGetPropertyFromNew(true);
            FieldInfo fi = this.m_oDBMgr.getFieldInfo(sTableName, _oDBFieldInfo.getName());
            boolean zModified = false;
            zModified = fi != null && fi.getDataType().getType() == _oDBFieldInfo.getDBType() ? _oDBFieldInfo.getLength() != nOriginalLen || _oDBFieldInfo.getScale() != nOriginalScale : true;
            if (zModified) {
                try {
                    this.alterFieldInDB(_oDBFieldInfo, sTableName);
                }
                catch (WCMException e) {
                    _oDBFieldInfo.cancelUpdate(_currUser);
                    throw e;
                }
            }
            _oDBFieldInfo.setGetPropertyFromNew(false);
        }
        _oDBFieldInfo.save(_currUser);
        if (_bReloadTableCache && (bIsAddMode || bChangeFieldName || bChangePropertyOfContainNull)) {
            this.m_oDBMgr.reloadTableInfo(sTableName);
        }
        if (bChangeFieldName) {
            Object[] pParameters = new Object[]{sNewColumnName, _oDBFieldInfo.getKey()};
            this.m_oDBMgr.sqlExecuteUpdate(new String[]{SQL_SYN_VIEWDBFIELDNAME}, pParameters);
            this.createViewRelationsOfDBField(_currUser, _oDBFieldInfo);
        }
        return _oDBFieldInfo;
    }

    private static void validateFieldNotExists(String _sTableName, String _sNewColumnName) throws WCMException {
        if (DBManager.getDBManager().getFieldInfo(_sTableName, _sNewColumnName) != null) {
            throw new WCMException(I18NMessage.get(MetaDataDefMgr.class, "MetaDataDefMgr.label5", "\u6307\u5b9a\u7684\u5b57\u6bb5\u540d[") + _sNewColumnName + I18NMessage.get(MetaDataDefMgr.class, "MetaDataDefMgr.label6", "]\u5728\u8868[") + _sTableName + I18NMessage.get(MetaDataDefMgr.class, "MetaDataDefMgr.label7", "]\u4e2d\u5df2\u7ecf\u5b58\u5728\uff01"));
        }
    }

    private void alterFieldInDB(MetaDBField _oDBFieldInfo, String _sTableName) throws WCMException {
        try {
            int nLength = _oDBFieldInfo.getLength();
            if (_oDBFieldInfo.isStringField()) {
                nLength = MetaDataConstants.getExpandLength(nLength);
            }
            String sModifySQL = this.m_oDBMgr.getDBType().sqlModifyField(_sTableName, _oDBFieldInfo.getName(), _oDBFieldInfo.getSqlType(), nLength, !_oDBFieldInfo.isNotNull(), _oDBFieldInfo.getScale());
            this.m_oDBMgr.sqlExecuteUpdate(sModifySQL);
        }
        catch (WCMException e) {
            if (_oDBFieldInfo.isChangeProperty("DBLENGTH")) {
                String sErrorInfo = I18NMessage.get(MetaDataDefMgr.class, "MetaDataDefMgr.label29", "\u5b57\u6bb5[") + _oDBFieldInfo.getAnotherName() + I18NMessage.get(MetaDataDefMgr.class, "MetaDataDefMgr.label30", "]\u957f\u5ea6\u53d8\u66f4\u4e0d\u6210\u529f\uff0c") + I18NMessage.get(MetaDataDefMgr.class, "MetaDataDefMgr.label31", "\u53ef\u80fd\u67d0\u4e9b\u6570\u636e\u7684\u957f\u5ea6\u8d85\u8fc7\u4e86\u5f53\u524d\u65b0\u7684\u957f\u5ea6[") + _oDBFieldInfo.getLength() + I18NMessage.get(MetaDataDefMgr.class, "MetaDataDefMgr.label32", "]\u6216\u8005\u65b0\u7684\u957f\u5ea6\u8d85\u8fc7\u4e86\u6570\u636e\u5e93\u6700\u5927\u957f\u5ea6");
                throw new WCMException(2, sErrorInfo, e);
            }
            if (_oDBFieldInfo.isChangeProperty("DBTYPE")) {
                String sErrorInfo = I18NMessage.get(MetaDataDefMgr.class, "MetaDataDefMgr.label29", "\u5b57\u6bb5[") + _oDBFieldInfo.getAnotherName() + I18NMessage.get(MetaDataDefMgr.class, "MetaDataDefMgr.label33", "]\u7c7b\u578b\u53d8\u66f4\u4e0d\u6210\u529f\uff0c") + I18NMessage.get(MetaDataDefMgr.class, "MetaDataDefMgr.label34", "\u53ef\u80fd\u662f\u8001\u7684\u7c7b\u578b\u4e0d\u80fd\u8f6c\u6362\u6210\u65b0\u7684\u7c7b\u578b");
                throw new WCMException(2, sErrorInfo, e);
            }
            throw e;
        }
    }

    private void alterFiledNameInDB(MetaDBField _oDBFieldInfo, String _sRenameSQL) throws WCMException {
        try {
            this.m_oDBMgr.sqlExecuteUpdate(_sRenameSQL);
        }
        catch (Throwable e) {
            String sErrorInfo = I18NMessage.get(MetaDataDefMgr.class, "MetaDataDefMgr.label35", "\u4fee\u6539\u5b57\u6bb5[") + _oDBFieldInfo.getAnotherName() + I18NMessage.get(MetaDataDefMgr.class, "MetaDataDefMgr.label36", "]\u4e0d\u6210\u529f\uff0c") + I18NMessage.get(MetaDataDefMgr.class, "MetaDataDefMgr.label37", "\u53ef\u80fd\u662f\u6570\u636e\u5e93\u7684\u4fdd\u7559\u5b57\u6216\u8005\u6570\u636e\u5e93\u4e0d\u5141\u8bb8\u4fee\u6539\u5b57\u6bb5\u540d\uff01");
            throw new WCMException(2, sErrorInfo, e);
        }
    }

    private void createFieldInDB(User _currUser, MetaDBField _oDBFieldInfo, String _sTableName) throws WCMException {
        boolean bAddSuccess = false;
        int nLength = _oDBFieldInfo.getLength();
        if (_oDBFieldInfo.isStringField()) {
            nLength = MetaDataConstants.getExpandLength(nLength);
        }
        try {
            String sCreateSQL = this.m_oDBMgr.getDBType().sqlAddField(_sTableName, _oDBFieldInfo.getName(), _oDBFieldInfo.getSqlType(), nLength, !_oDBFieldInfo.isNotNull(), _oDBFieldInfo.getDefaultValue(), _oDBFieldInfo.getScale());
            this.m_oDBMgr.sqlExecuteUpdate(sCreateSQL);
            bAddSuccess = true;
        }
        catch (Throwable e) {
            String sErrorInfo = I18NMessage.get(MetaDataDefMgr.class, "MetaDataDefMgr.label38", "\u5b57\u6bb5\u540d[") + _oDBFieldInfo.getName() + I18NMessage.get(MetaDataDefMgr.class, "MetaDataDefMgr.label39", "]\u662f\u4fdd\u7559\u5b57\u3001\u4e0d\u552f\u4e00\u6216\u957f\u5ea6[") + _oDBFieldInfo.getLength() + I18NMessage.get(MetaDataDefMgr.class, "MetaDataDefMgr.label40", "]\u8fc7\u5927\uff01");
            throw new WCMException(2, sErrorInfo, e);
        }
        finally {
            if (!bAddSuccess) {
                _oDBFieldInfo.unlock();
            }
        }
    }

    @Override
    public MetaView save(User _currUser, MetaView _oViewInfo) throws WCMException {
        if (_oViewInfo.isAddMode()) {
            _oViewInfo.setName(_oViewInfo.getMainTableName());
        } else {
            if (!_oViewInfo.isModified(true)) {
                return _oViewInfo;
            }
            _oViewInfo.validCanEditAndLock(_currUser);
        }
        _oViewInfo.save(_currUser);
        return _oViewInfo;
    }

    @Override
    public MetaViewField save(User _currUser, MetaView _oOwnerView, MetaViewField _oViewFieldInfo) throws WCMException {
        this.resetTitleField(_oViewFieldInfo, _oOwnerView);
        this.resetURLField(_oViewFieldInfo, _oOwnerView);
        if (_oViewFieldInfo.isAddMode()) {
            _oViewFieldInfo.setView(_oOwnerView.getId());
            if (_oViewFieldInfo.getDBFieldId() == 0) {
                MetaDBField dbField = this.createDBFieldFromViewField(_currUser, _oOwnerView, _oViewFieldInfo);
                _oViewFieldInfo.inheritDBFieldInfo(dbField);
            } else {
                _oViewFieldInfo.inheritDBFieldInfo(_oViewFieldInfo.getDBField());
            }
            _oViewFieldInfo.setFromMainTable(_oOwnerView.getMainTableName().equalsIgnoreCase(_oViewFieldInfo.getTableName()));
        } else {
            MetaDBField oDBField;
            int nDBFieldId;
            _oViewFieldInfo.validCanEditAndLock(_currUser);
            if (_oViewFieldInfo.isChangeProperty("DBFIELD")) {
                int nNewDBFieldId = _oViewFieldInfo.getNewPropertyAsInt("DBFIELD", 0);
                MetaDBField oNewDBField = MetaDBField.findById(nNewDBFieldId);
                if (oNewDBField == null) {
                    throw new WCMException(I18NMessage.get(MetaDataDefMgr.class, "MetaDataDefMgr.label8", "\u65b0\u76f8\u5173\u7684\u7269\u7406\u5b57\u6bb5\u65e0\u6548\uff01[ID=") + nNewDBFieldId + "]");
                }
                _oViewFieldInfo.inheritDBFieldInfo(oNewDBField);
            } else if (_oViewFieldInfo.isChangeProperty("DBLENGTH")) {
                nDBFieldId = _oViewFieldInfo.getPropertyAsInt("DBFIELD", 0);
                oDBField = MetaDBField.findById(nDBFieldId);
                int nNewLength = _oViewFieldInfo.getNewPropertyAsInt("DBLENGTH", 0);
                if (oDBField.getLength() < nNewLength) {
                    oDBField.setLength(nNewLength);
                    this.save(_currUser, oDBField.getMetaDBTable(), oDBField);
                }
            }
            if (_oViewFieldInfo.isChangeProperty("DBSCALE")) {
                nDBFieldId = _oViewFieldInfo.getPropertyAsInt("DBFIELD", 0);
                oDBField = MetaDBField.findById(nDBFieldId);
                int nNewScale = _oViewFieldInfo.getNewPropertyAsInt("DBSCALE", 0);
                oDBField.setScale(nNewScale);
                this.save(_currUser, oDBField.getMetaDBTable(), oDBField);
            }
        }
        this.assertViewFieldNameNotSimilar(_oViewFieldInfo, "FIELDNAME");
        this.assertViewFieldNameNotSimilar(_oViewFieldInfo, "ANOTHERNAME");
        _oViewFieldInfo.save(_currUser);
        return _oViewFieldInfo;
    }

    private void assertViewFieldNameNotSimilar(MetaViewField _oViewFieldInfo, String _fieldName) throws WCMException {
        String sSrcFieldName = _fieldName;
        String sSrcFieldValue = null;
        sSrcFieldValue = _oViewFieldInfo.getFinalPropertyAsString(sSrcFieldName);
        if (CMyString.isEmpty(sSrcFieldValue)) {
            return;
        }
        String sNewValue = sSrcFieldValue;
        int nCount = 0;
        while (sNewValue != null) {
            WCMFilter filter = new WCMFilter("XWCMVIEWFIELDINFO", "ViewId=? and " + sSrcFieldName + "=? and " + "VIEWFIELDINFOID" + "<>?", "", "VIEWFIELDINFOID");
            filter.addSearchValues(_oViewFieldInfo.getViewId());
            filter.addSearchValues(sNewValue);
            filter.addSearchValues(_oViewFieldInfo.getId());
            if (DBManager.getDBManager().sqlExecuteIntQuery(filter) <= 0) break;
            sNewValue = sSrcFieldValue + ++nCount;
        }
        if (sNewValue != null && !sNewValue.equals(sSrcFieldValue)) {
            _oViewFieldInfo.setPropertyWithString(_fieldName, sNewValue);
        }
    }

    @Override
    public MetaViewField getMetaViewField(MetaView _oView, int _nDbFieldId) throws WCMException {
        WCMFilter filter = new WCMFilter(null, "viewId =? and dbField=?", null);
        filter.addSearchValues(_oView.getId());
        filter.addSearchValues(_nDbFieldId);
        MetaViewFields _oViewFieldInfos = MetaViewFields.openWCMObjs(null, filter);
        if (_oViewFieldInfos.size() > 0) {
            return (MetaViewField)_oViewFieldInfos.getAt(0);
        }
        return null;
    }

    public void resetTitleField(MetaViewField oMetaViewField) throws WCMException {
        int nViewId = oMetaViewField.getViewId();
        this.resetTitleField(oMetaViewField, MetaView.findById(nViewId));
    }

    private void resetTitleField(MetaViewField oMetaViewField, MetaView oView) throws WCMException {
        boolean bTitleField = false;
        if (oMetaViewField.isAddMode()) {
            bTitleField = oMetaViewField.getPropertyAsBoolean("TITLEFIELD", false);
        } else {
            boolean bl = bTitleField = oMetaViewField.getNewPropertyAsInt("TITLEFIELD", 0) != 0 && !oMetaViewField.isTitleField();
        }
        if (bTitleField) {
            this.clearTitleField(oView);
        }
    }

    public void clearTitleField(MetaView oView) throws WCMException {
        User loginUser = ContextHelper.getLoginUser();
        HashMap oMetaViewFields = this.m_oDataDefCacheMgr.getMetaViewFields(oView.getId());
        for (MetaViewField oMetaViewField : oMetaViewFields.values()) {
            if (!oMetaViewField.isTitleField()) continue;
            oMetaViewField.validCanEditAndLock(loginUser);
            oMetaViewField.setTitleField(false);
            oMetaViewField.save(loginUser);
            break;
        }
    }

    private void resetURLField(MetaViewField _oMetaViewField, MetaView _oView) throws WCMException {
        boolean bIsURLSField = false;
        if (!_oMetaViewField.isAddMode()) {
            boolean bl = bIsURLSField = _oMetaViewField.getNewPropertyAsInt("ISURLFIELD", 0) != 0 && !_oMetaViewField.getPropertyAsBoolean("ISURLFIELD", false);
        }
        if (bIsURLSField) {
            User loginUser = ContextHelper.getLoginUser();
            HashMap oMetaViewFields = this.m_oDataDefCacheMgr.getMetaViewFields(_oView.getId());
            for (MetaViewField oMetaViewField : oMetaViewFields.values()) {
                if (!oMetaViewField.getPropertyAsBoolean("ISURLFIELD", false)) continue;
                oMetaViewField.validCanEditAndLock(loginUser);
                oMetaViewField.setProperty("ISURLFIELD", false);
                oMetaViewField.save(loginUser);
                break;
            }
        }
    }

    @Override
    public String createDDLSQL(MetaDBTable _oTableInfo) throws WCMException {
        String sTableName = "WCMMetaTable" + _oTableInfo.getName();
        String sPrimaryFieldName = sTableName + "Id";
        DBType currType = this.m_oDBMgr.getDBType();
        StringBuffer sbSQL = new StringBuffer();
        sbSQL.append(currType.sqlCreateTable());
        sbSQL.append(" ");
        sbSQL.append(sTableName);
        sbSQL.append("\n");
        sbSQL.append("(\n");
        sbSQL.append("      ");
        sbSQL.append(sPrimaryFieldName);
        sbSQL.append(" ");
        sbSQL.append(currType.getTypeName(4));
        sbSQL.append(" Primary Key \n");
        sbSQL.append(")");
        return sbSQL.toString();
    }

    @Override
    public String createDDLSQL(MetaView _oViewInfo) throws WCMException {
        if (!_oViewInfo.isMultiTable()) {
            return null;
        }
        MetaViewFields fields = this.getViewFields(null, _oViewInfo, null);
        int nCount = 100 + (fields.size() + MetaDataConstants.DEFAULT_FIELDS.getDataTypesCount()) * 50;
        StringBuffer sbSQL = new StringBuffer(nCount);
        sbSQL.append("create View ");
        sbSQL.append(_oViewInfo.getName());
        sbSQL.append(" as\n");
        sbSQL.append(" select ");
        String sRelationTableName = "WCMMetaRelation" + _oViewInfo.getId();
        this.appendDefaultSelectFields(sbSQL, sRelationTableName);
        sbSQL.append("\n");
        int nSize = fields.size();
        for (int i = 0; i < nSize; ++i) {
            MetaViewField field = (MetaViewField)fields.getAt(i);
            if (field == null) continue;
            sbSQL.append(",");
            if (field.getName().equalsIgnoreCase(field.getDBName())) {
                sbSQL.append("WCMMetaTable");
                sbSQL.append(field.getTableName());
                sbSQL.append(".");
                sbSQL.append(field.getName());
                continue;
            }
            sbSQL.append("WCMMetaTable");
            sbSQL.append(field.getTableName());
            sbSQL.append(".");
            sbSQL.append(field.getDBName());
            sbSQL.append(" ");
            sbSQL.append(field.getName());
        }
        sbSQL.append("\n");
        sbSQL.append(" from ");
        sbSQL.append(sRelationTableName);
        sbSQL.append("\n");
        String sMainTableName = MetaDataConstants.makeTrueTableName(_oViewInfo.getMainTableName());
        this.appendLeftJoinWithRelationTable(sbSQL, sRelationTableName, sMainTableName);
        sbSQL.append("\n");
        MetaDBTables oOtherTables = _oViewInfo.getOtherTables(null, new WCMFilter("", "", "", "TableName"));
        int nSize2 = oOtherTables.size();
        for (int i = 0; i < nSize2; ++i) {
            MetaDBTable table = (MetaDBTable)oOtherTables.getAt(i);
            if (table == null) continue;
            String sCurrTableName = MetaDataConstants.makeTrueTableName(table.getName());
            this.appendLeftJoinWithRelationTable(sbSQL, sRelationTableName, sCurrTableName);
            sbSQL.append("\n");
        }
        return sbSQL.toString();
    }

    private void appendDefaultSelectFields(StringBuffer _sbSQL, String _sTableName) {
        for (int i = 0; i < MetaDataConstants.DEFAULT_FIELDS.getDataTypesCount(); ++i) {
            MetaDataType fieldType = MetaDataConstants.DEFAULT_FIELDS.getDataTypeAt(i);
            String sFieldName = fieldType.getKey();
            if (i > 0) {
                _sbSQL.append(",");
            }
            _sbSQL.append(_sTableName);
            _sbSQL.append(".");
            _sbSQL.append(sFieldName);
        }
    }

    private void appendLeftJoinWithRelationTable(StringBuffer _sbSQL, String _sRelationTableName, String _sTableName) {
        String sIdFieldName = _sTableName + "ID";
        _sbSQL.append(" left outer join ");
        _sbSQL.append(" ");
        _sbSQL.append(_sTableName);
        _sbSQL.append(" on ");
        _sbSQL.append(_sRelationTableName);
        _sbSQL.append(".");
        _sbSQL.append(sIdFieldName);
        _sbSQL.append("=");
        _sbSQL.append(_sTableName);
        _sbSQL.append(".");
        _sbSQL.append("MetaDataId");
    }

    @Override
    public void delete(User _currUser, MetaDBField _oDBFieldInfo) throws WCMException {
        String sFieldName;
        DBType dbType = this.m_oDBMgr.getDBType();
        String sTableName = MetaDataConstants.makeTrueTableName(_oDBFieldInfo.getTableName());
        if (this.m_oDBMgr.getFieldInfo(sTableName, sFieldName = _oDBFieldInfo.getName().trim().toUpperCase()) != null) {
            String sDropSQL = null;
            try {
                sDropSQL = dbType.sqlDropField(sTableName, sFieldName);
            }
            catch (Exception e) {
                throw new WCMException(I18NMessage.get(MetaDataDefMgr.class, "MetaDataDefMgr.label9", "\u751f\u6210\u5220\u9664\u5b57\u6bb5\u811a\u672c\u51fa\u9519\uff01"), e);
            }
            this.m_oDBMgr.sqlExecuteUpdate(sDropSQL);
            this.m_oDBMgr.getTableInfos().getTableInfo(sTableName).removeFieldInfo(sFieldName);
        }
        _oDBFieldInfo.delete(_currUser);
        WCMFilter filter = new WCMFilter("", "exists(select XWCMViewFieldInfo.ViewId from XWCMViewFieldInfo where XWCMViewFieldInfo.DBField=? and XWCMViewInfo.ViewInfoId=XWCMViewFieldInfo.ViewId)", "");
        filter.addSearchValues(_oDBFieldInfo.getId());
        MetaViews views = MetaViews.openWCMObjs(_currUser, filter);
        filter = new WCMFilter("", "DBField=?", "");
        filter.addSearchValues(_oDBFieldInfo.getId());
        MetaViewFields viewFields = MetaViewFields.openWCMObjs(_currUser, filter);
        viewFields.removeAll(true);
        this.recreateViewRelations(_currUser, views);
    }

    @Override
    public void delete(User _currUser, MetaDBTable _oTableInfo) throws WCMException {
        block22: {
            int i;
            int nSize;
            try {
                MetaViews oMetaViews = this.getViewsUsingTable(_oTableInfo);
                nSize = oMetaViews.size();
                for (i = 0; i < nSize; ++i) {
                    MetaView oMetaView = (MetaView)oMetaViews.getAt(i);
                    if (oMetaView == null) continue;
                    WCMFilter filter = new WCMFilter("", "", "");
                    filter.setWhere("docKind=" + oMetaView.getId());
                    Documents oDocuments = Documents.openWCMObjs(_currUser, filter);
                    int nInnerSize = oDocuments.size();
                    for (int j = 0; j < nInnerSize; ++j) {
                        Document oDocument = (Document)oDocuments.getAt(j);
                        if (oDocument == null) continue;
                        this.m_oDocumentMgr.delete(oDocument, null, true);
                    }
                }
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
            try {
                MetaDBFields oDBFields = this.getDFieldInfos(_currUser, _oTableInfo, null);
                nSize = oDBFields.size();
                for (i = 0; i < nSize; ++i) {
                    MetaDBField oDBField = (MetaDBField)oDBFields.getAt(i);
                    if (oDBField == null) continue;
                    try {
                        oDBField.delete(_currUser);
                        continue;
                    }
                    catch (Exception oInnerException) {
                        logger.error((Object)oInnerException);
                    }
                }
            }
            catch (Exception oOuterException) {
                logger.error((Object)oOuterException);
            }
            try {
                DBType dbType = this.m_oDBMgr.getDBType();
                String sTableName = MetaDataConstants.makeTrueTableName(_oTableInfo.getName());
                if (this.m_oDBMgr.getTableInfo(sTableName) == null) break block22;
                String sDropSQL = null;
                try {
                    sDropSQL = dbType.sqlDropTable(sTableName);
                }
                catch (Exception e) {
                    throw new WCMException(I18NMessage.get(MetaDataDefMgr.class, "MetaDataDefMgr.label10", "\u751f\u6210\u5220\u9664\u8868\u811a\u672c\u51fa\u9519\uff01"), e);
                }
                this.m_oDBMgr.sqlExecuteUpdate(sDropSQL);
                this.m_oDBMgr.getTableInfos().removeTableInfo(sTableName);
            }
            catch (Exception oOuterException) {
                logger.error((Object)oOuterException);
            }
        }
        try {
            _oTableInfo.delete(_currUser);
        }
        catch (Exception oOuterException) {
            logger.error((Object)oOuterException);
        }
        WCMFilter filter = new WCMFilter("", "MainTableName=?", "");
        filter.addSearchValues(_oTableInfo.getName());
        MetaViews views = MetaViews.openWCMObjs(_currUser, filter);
        int nSize = views.size();
        for (int i = 0; i < nSize; ++i) {
            MetaView view = (MetaView)views.getAt(i);
            if (view == null) continue;
            try {
                this.delete(_currUser, view);
                continue;
            }
            catch (Exception oInnerException) {
                logger.error((Object)oInnerException);
            }
        }
        filter = new WCMFilter("", "exists(select XWCMViewOtherTables.ViewId from XWCMViewOtherTables where XWCMViewOtherTables.TableId=? and XWCMViewInfo.ViewInfoId=XWCMViewOtherTables.ViewId)", "");
        filter.addSearchValues(_oTableInfo.getId());
        views = MetaViews.openWCMObjs(_currUser, filter);
        this.m_oDBMgr.sqlExecuteUpdate("delete from XWCMViewOtherTables where TableId=" + _oTableInfo.getId());
        String sWhere = "tableId=" + _oTableInfo.getId();
        int nSize2 = views.size();
        for (int i = 0; i < nSize2; ++i) {
            MetaView oView = (MetaView)views.getAt(i);
            if (oView == null) continue;
            MetaViewFields oMetaViewFields = this.getViewFields(_currUser, oView, new WCMFilter("", sWhere, ""));
            int nSize22 = oMetaViewFields.size();
            for (int j = 0; j < nSize22; ++j) {
                MetaViewField oMetaViewField = (MetaViewField)oMetaViewFields.getAt(j);
                if (oMetaViewField == null) continue;
                oMetaViewField.delete(_currUser);
            }
            MetaDBTables oMetaDBTables = oView.getOtherTables(_currUser, new WCMFilter("", "", "", "TableName"));
            if (!oMetaDBTables.isEmpty()) continue;
            try {
                DBManager.getDBManager().sqlExecuteUpdate("drop view " + oView.getName());
            }
            catch (Exception e) {
                System.err.println(I18NMessage.get(MetaDataDefMgr.class, "MetaDataDefMgr.label11", "\u589e\u52a0\u4e4b\u524d\u5220\u9664\u89c6\u56fe\u5931\u8d25\uff01SQL=drop view ") + oView.getName());
                System.err.println(e.getMessage());
            }
            oView.setName(oView.getMainTableName());
            oView.save();
        }
        this.recreateViewRelations(_currUser, views);
    }

    @Override
    public MetaDBFields getDFieldInfos(User _currUser, MetaDBTable _oDBTableInfo, WCMFilter _extraFilter) throws WCMException {
        WCMFilter filter = new WCMFilter("", "TABLEID=?", "");
        filter.addSearchValues(_oDBTableInfo.getId());
        filter.mergeWith(_extraFilter);
        return MetaDBFields.openWCMObjs(_currUser, filter);
    }

    @Override
    public String createViewRelations(User _currUser, MetaView _oView) throws WCMException {
        return this.createViewRelations(_currUser, _oView, true);
    }

    @Override
    public String createViewRelations(User _currUser, MetaView _oView, boolean generateApplication) throws WCMException {
        MetaDBTables tables = _oView.getOtherTables(_currUser, new WCMFilter("", "", "", "TableName"));
        this.createViewRelationTable(_oView, tables);
        if (!tables.isEmpty()) {
            String sViewName = "WCMMetaView" + _oView.getId();
            _oView.validCanEditAndLock(_currUser);
            _oView.setName(sViewName);
            _oView.save(_currUser);
            String sDDLSQL = this.createDDLSQL(_oView);
            if (!CMyString.isEmpty(sDDLSQL)) {
                try {
                    DBManager.getDBManager().sqlExecuteUpdate("drop view " + _oView.getName());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                DBManager.getDBManager().sqlExecuteUpdate(sDDLSQL);
                DBManager.getDBManager().reloadTableInfo(_oView.getName());
            }
        }
        if (generateApplication) {
            this.createViewApplication(_oView);
        }
        return null;
    }

    @Override
    public void createViewApplication0(MetaView _oView) throws WCMException {
        String sApplicationPath = MetaDataDefHelper.getViewApplicationRootPath();
        String sTemplatePath = sApplicationPath + "template" + File.separatorChar;
        this.createViewApplication(_oView, sTemplatePath, sApplicationPath);
        String sCustomTemplatePath = _oView.getTemplatePath();
        if (!CMyString.isEmpty(sCustomTemplatePath) && !"template".equalsIgnoreCase(sCustomTemplatePath)) {
            String sCustomTemplateFullPath = sApplicationPath + "customtemplates" + File.separatorChar + sCustomTemplatePath;
            this.createViewApplication(_oView, sCustomTemplateFullPath, sApplicationPath);
        }
        sTemplatePath = sApplicationPath + _oView.getId() + File.separatorChar + "template" + File.separatorChar;
        this.createViewApplication(_oView, sTemplatePath, sApplicationPath);
        CMyDateTime now = CMyDateTime.now();
        _oView.setAttribute(now.toTimestamp().toString().replace(" ", ""));
        _oView.save();
    }

    @Override
    public void createViewApplication(MetaView _oView) throws WCMException {
        this.createViewApplication0(_oView);
        IClusterMsgCenter clusterMsgCenter = (IClusterMsgCenter)DreamFactory.createObjectById("IClusterMsgCenter");
        String[] pParameters = new String[]{String.valueOf(_oView.getId())};
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"start to notify other cluster node create view application.");
            }
            clusterMsgCenter.send("META.CR", pParameters, true);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"end to notify other cluster node create view application.");
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Fail to notify other cluster node.", (Throwable)ex);
        }
    }

    private void createViewRelationTable(MetaView _oView, MetaDBTables _otherTables) throws WCMException {
        if (_otherTables == null || _otherTables.isEmpty()) {
            return;
        }
        boolean bNeedReloadCache = false;
        String sRelationTableName = "WCMMetaRelation" + _oView.getId();
        TableInfo tableInfo = this.m_oDBMgr.getTableInfo(sRelationTableName);
        if (tableInfo == null) {
            String sCreateNewTableSQL = this.m_oDBMgr.getDBType().sqlCreateTableWithPrimary(sRelationTableName, sRelationTableName + "ID");
            this.m_oDBMgr.sqlExecuteUpdate(sCreateNewTableSQL);
            String sMainTableIdName = MetaDataConstants.makeTrueTableName(_oView.getMainTableName()) + "ID";
            String sAppendMainTableId = this.m_oDBMgr.getDBType().sqlAddField(sRelationTableName, sMainTableIdName, 4, 0, false, "0", 0);
            this.m_oDBMgr.sqlExecuteUpdate(sAppendMainTableId);
            this.m_oDBMgr.reloadTableInfo(sRelationTableName);
        }
        int nSize = _otherTables.size();
        for (int i = 0; i < nSize; ++i) {
            MetaDBTable table = (MetaDBTable)_otherTables.getAt(i);
            String sCurrIdFieldName = MetaDataConstants.makeTrueTableName(table.getName()) + "ID";
            if (tableInfo != null && tableInfo.getFieldInfo(sCurrIdFieldName) != null) continue;
            String sCreateSQL = this.m_oDBMgr.getDBType().sqlAddField(sRelationTableName, sCurrIdFieldName, 4, 0, false, "0", 0);
            this.m_oDBMgr.sqlExecuteUpdate(sCreateSQL);
            bNeedReloadCache = true;
        }
        this.appendDefaultFields(sRelationTableName, null);
        if (bNeedReloadCache) {
            this.m_oDBMgr.reloadTableInfo(sRelationTableName);
        }
    }

    @Override
    public boolean createViewApplication(MetaView _oView, String _sTemplatePath, String _sApplicationPath) throws WCMException {
        FileService oViewSelfTemplatePath = new FileService(_sTemplatePath);
        if (!oViewSelfTemplatePath.exists()) {
            return false;
        }
        boolean bCreatedFile = false;
        FileStore[] subFiles = oViewSelfTemplatePath.listFiles();
        for (int i = 0; i < subFiles.length; ++i) {
            if (subFiles[i].isDirectory()) continue;
            bCreatedFile = true;
            String sTemplateContent = null;
            try {
                String sFilePath = subFiles[i].getAbsolutePath();
                String sFileEncoding = CharsetDetector.detect(sFilePath);
                sTemplateContent = CMyFile.readFile(sFilePath, sFileEncoding);
            }
            catch (Exception e) {
                throw new WCMException(I18NMessage.get(MetaDataDefMgr.class, "MetaDataDefMgr.label14", "\u8bfb\u53d6\u6587\u4ef6[") + subFiles[i].getAbsolutePath() + I18NMessage.get(MetaDataDefMgr.class, "MetaDataDefMgr.label15", "]\u51fa\u73b0\u5f02\u5e38\uff01"), e);
            }
            String sApplicationContent = null;
            try {
                TagDocument tagDoc = TagDocumentReader.read(sTemplateContent);
                if (tagDoc == null) {
                    throw new WCMException(I18NMessage.get(MetaDataDefMgr.class, "MetaDataDefMgr.label16", "\u89e3\u6790\u6a21\u677f\u6587\u4ef6[") + subFiles[i].getAbsolutePath() + I18NMessage.get(MetaDataDefMgr.class, "MetaDataDefMgr.label17", "]\u5931\u8d25\uff01"));
                }
                PublishTaskContext taskContext = new PublishTaskContext(null, null);
                IPublishElement pagePublishElement = PublishElementFactory.makeElementFrom(_oView);
                PublishPageContext oPageContext = new PublishPageContext(pagePublishElement, taskContext);
                PublishTagContext tagContext = new PublishTagContext(oPageContext);
                String[] results = TagParseHelper.parseItems(tagDoc.getItems(), tagContext);
                sApplicationContent = results[0];
            }
            catch (Exception e) {
                throw new WCMException(I18NMessage.get(MetaDataDefMgr.class, "MetaDataDefMgr.label16", "\u89e3\u6790\u6a21\u677f\u6587\u4ef6[") + subFiles[i].getAbsolutePath() + I18NMessage.get(MetaDataDefMgr.class, "MetaDataDefMgr.label15", "]\u51fa\u73b0\u5f02\u5e38\uff01"), e);
            }
            String sResourceFileEncoding = "utf-8";
            String sJspFileEncoding = ConfigServer.getServer().getSysConfigValue("METADATA_JSP_FILEENCODING", "GB2312");
            String sFileName = subFiles[i].getName();
            String sEncoding = sResourceFileEncoding;
            if (sFileName.endsWith(".jsp")) {
                sEncoding = sJspFileEncoding;
            }
            try {
                CMyFile.writeFile(_sApplicationPath + _oView.getId() + File.separatorChar + sFileName, sApplicationContent, sEncoding);
                String openDataPath = "OPENDATA_GENERATEPATH";
                Config config = ConfigServer.getServer().getSysConfig(openDataPath);
                if (config == null) continue;
                CMyFile.writeFile(config.getValue() + _oView.getId() + File.separatorChar + sFileName, sApplicationContent, sEncoding);
                continue;
            }
            catch (Exception e) {
                throw new WCMException(I18NMessage.get(MetaDataDefMgr.class, "MetaDataDefMgr.label18", "\u5199\u6587\u4ef6[") + _sApplicationPath + subFiles[i].getName() + I18NMessage.get(MetaDataDefMgr.class, "MetaDataDefMgr.label15", "]\u51fa\u73b0\u5f02\u5e38\uff01"), e);
            }
        }
        return bCreatedFile;
    }

    @Override
    public MetaViewFields getViewFields(User _currUser, MetaView _oView, WCMFilter _extraFilter) throws WCMException {
        WCMFilter filter = new WCMFilter("", "ViewId=?", "");
        filter.addSearchValues(_oView.getId());
        filter.setOrder("FIELDORDER desc");
        filter.mergeWith(_extraFilter);
        return MetaViewFields.openWCMObjs(_currUser, filter);
    }

    @Override
    public void appendDefaultFields(User _currUser, MetaDBTable _oTable) throws WCMException {
        String sTableName = MetaDataConstants.makeTrueTableName(_oTable.getName());
        this.appendDefaultFields(sTableName, _oTable);
    }

    private void appendDefaultFields(String _sTableName, MetaDBTable _oOwnerTable) throws WCMException {
        TableInfo tableInfo = this.m_oDBMgr.getTableInfo(_sTableName);
        if (tableInfo == null) {
            logger.info((Object)(I18NMessage.get(MetaDataDefMgr.class, "MetaDataDefMgr.label19", "\u6307\u5b9a\u7684\u8868[") + _sTableName + I18NMessage.get(MetaDataDefMgr.class, "MetaDataDefMgr.label20", "]\u4e0d\u5b58\u5728\uff01")));
            return;
        }
        boolean bCreateNewField = false;
        for (int i = 0; i < MetaDataConstants.DEFAULT_FIELDS.getDataTypesCount(); ++i) {
            MetaDataType fieldType = MetaDataConstants.DEFAULT_FIELDS.getDataTypeAt(i);
            String sFieldName = fieldType.getKey();
            if (tableInfo.getFieldInfo(sFieldName) != null) {
                logger.info((Object)(I18NMessage.get(MetaDataDefMgr.class, "MetaDataDefMgr.label19", "\u6307\u5b9a\u7684\u8868[") + _sTableName + I18NMessage.get(MetaDataDefMgr.class, "MetaDataDefMgr.label21", "]\u7684\u5b57\u6bb5[") + sFieldName + I18NMessage.get(MetaDataDefMgr.class, "MetaDataDefMgr.label2", "]\u5df2\u7ecf\u5b58\u5728\uff01")));
                continue;
            }
            bCreateNewField = true;
            String sCreateSQL = this.m_oDBMgr.getDBType().sqlAddField(_sTableName, sFieldName, fieldType.getSqlDataType(), fieldType.getMaxLength(), true, null, 0);
            this.m_oDBMgr.sqlExecuteUpdate(sCreateSQL);
        }
        this.createDefaultFieldsByPreTableName(_sTableName, _oOwnerTable);
        if (bCreateNewField) {
            this.m_oDBMgr.reloadTableInfo(_sTableName);
        }
    }

    private void createDefaultFieldsByPreTableName(String _sTableName, MetaDBTable _oOwnerTable) throws WCMException {
        if (_oOwnerTable == null) {
            return;
        }
        List<IDefaultFieldsCreator> arDefaultFieldsCreators = DefaultFieldsFactory.createDefaultFieldsCreator(_sTableName);
        int nSize = arDefaultFieldsCreators.size();
        for (int i = 0; i < nSize; ++i) {
            IDefaultFieldsCreator oCreator = arDefaultFieldsCreators.get(i);
            List<MetaDBField> arFields = oCreator.toDefaultFields();
            int nFieldSize = arFields.size();
            for (int nFieldIndex = 0; nFieldIndex < nFieldSize; ++nFieldIndex) {
                MetaDBField field = arFields.get(nFieldIndex);
                this.save(ContextHelper.getLoginUser(), _oOwnerTable, field, false);
            }
        }
    }

    private MetaDBField createDBFieldFromViewField(User _currUser, MetaView _ownerView, MetaViewField _oViewField) throws WCMException {
        String sDBFieldName = _oViewField.getName();
        if (this.m_oDBMgr.getFieldInfo(MetaDataConstants.makeTrueTableName(_ownerView.getMainTableName()), sDBFieldName) != null) {
            String sWhere = "TableName=? and FieldName=?";
            WCMFilter filter = new WCMFilter("", sWhere, "");
            filter.addSearchValues(_ownerView.getMainTableName());
            filter.addSearchValues(sDBFieldName);
            MetaDBFields dbFields = MetaDBFields.openWCMObjs(_currUser, filter);
            if (dbFields.isEmpty()) {
                throw new WCMException(I18NMessage.get(MetaDataDefMgr.class, "MetaDataDefMgr.label22", "\u6570\u636e\u6709\u8bef\uff0c\u5b57\u6bb5[") + sDBFieldName + I18NMessage.get(MetaDataDefMgr.class, "MetaDataDefMgr.label23", "]\u5728\u6570\u636e\u8868[") + _ownerView.getMainTableName() + I18NMessage.get(MetaDataDefMgr.class, "MetaDataDefMgr.label24", "]\u7ed3\u6784\u4e2d\u6ca1\u6709\u63cf\u8ff0"));
            }
            return (MetaDBField)dbFields.getAt(0);
        }
        MetaDBField oDBField = MetaDBField.createNewInstance();
        TableInfo tableInfo = DBManager.getDBManager().getTableInfo("XWCMDBFIELDINFO");
        Hashtable<String, Object> hViewField = _oViewField.getProperties();
        Enumeration<String> enKeys = hViewField.keys();
        while (enKeys.hasMoreElements()) {
            String sPropName = enKeys.nextElement();
            if (tableInfo.getFieldInfo(sPropName) == null) continue;
            oDBField.setProperty(sPropName, hViewField.get(sPropName));
        }
        oDBField.setTableId(_ownerView.getMainTableId());
        oDBField.setTableName(_ownerView.getMainTableName());
        oDBField.setName(_oViewField.getName());
        oDBField.setAnotherName(_oViewField.getAnotherName());
        return this.save(_currUser, _ownerView.getMainTable(), oDBField);
    }

    private MetaViewField createViewFieldFromDBField(User _currUser, MetaView _oOwnerView, MetaDBField _oDBField) throws WCMException {
        String SQL_QUERY_VIEWFIELD_BY_DBFIELD = "select VIEWFIELDINFOID from XWCMVIEWFIELDINFO where ViewId=? and DBFIELD=?";
        int nViewFieldId = this.m_oDBMgr.sqlExecuteIntQuery("select VIEWFIELDINFOID from XWCMVIEWFIELDINFO where ViewId=? and DBFIELD=?", new int[]{_oOwnerView.getId(), _oDBField.getId()});
        if (nViewFieldId > 0) {
            return null;
        }
        MetaViewField oViewField = MetaViewField.createNewInstance();
        TableInfo tableInfo = DBManager.getDBManager().getTableInfo("XWCMVIEWFIELDINFO");
        Hashtable<String, Object> hDBFieldProperties = _oDBField.getProperties();
        Enumeration<String> enKeys = hDBFieldProperties.keys();
        while (enKeys.hasMoreElements()) {
            String sPropName = enKeys.nextElement();
            if (tableInfo.getFieldInfo(sPropName) == null) continue;
            oViewField.setProperty(sPropName, hDBFieldProperties.get(sPropName));
        }
        oViewField.setView(_oOwnerView.getId());
        oViewField.setDBField(_oDBField.getId());
        oViewField.setDBName(_oDBField.getName());
        oViewField.save(_currUser);
        return oViewField;
    }

    @Override
    public void setViewFields(User _currUser, MetaView _oOwnerView, MetaDBFields _dbFields) throws WCMException {
        if (_dbFields.isEmpty()) {
            String sDeleteSQL = "delete from XWCMVIEWFIELDINFO where ViewId=" + _oOwnerView.getId();
            this.m_oDBMgr.sqlExecuteUpdate(sDeleteSQL);
        } else {
            int nSize = _dbFields.size();
            for (int i = 0; i < nSize; ++i) {
                MetaDBField dbField = (MetaDBField)_dbFields.getAt(i);
                if (dbField == null) continue;
                this.createViewFieldFromDBField(_currUser, _oOwnerView, dbField);
            }
            String sDeleteSQL = "delete from XWCMVIEWFIELDINFO where ViewId=" + _oOwnerView.getId() + " and DBFIELD not in(" + _dbFields.getIdListAsString() + ")";
            this.m_oDBMgr.sqlExecuteUpdate(sDeleteSQL);
        }
        this.m_oDataDefCacheMgr.reloadViewCache(_oOwnerView.getId());
    }

    @Override
    public void delete(User _currUser, MetaViewField _oViewField) throws WCMException {
        _oViewField.delete(_currUser);
    }

    @Override
    public void delete(User _currUser, MetaView _oView) throws WCMException {
        if (_oView.isMultiTable()) {
            try {
                String sDropViewSQL = "drop view WCMMetaView" + _oView.getId();
                this.m_oDBMgr.sqlExecuteUpdate(sDropViewSQL);
            }
            catch (Exception e) {
                logger.error((Object)I18NMessage.get(MetaDataDefMgr.class, "MetaDataDefMgr.label25", "\u5220\u9664\u591a\u8868\u89c6\u56fe\u7684\u5173\u8054\u89c6\u56fe\u5931\u8d25\uff01"), (Throwable)e);
            }
            try {
                String sRelationTableName = "WCMMetaRelation" + _oView.getId();
                String sDropTableSQL = "drop table " + sRelationTableName;
                this.m_oDBMgr.sqlExecuteUpdate(sDropTableSQL);
            }
            catch (Exception e) {
                logger.error((Object)I18NMessage.get(MetaDataDefMgr.class, "MetaDataDefMgr.label26", "\u5220\u9664\u591a\u8868\u89c6\u56fe\u7684\u5173\u8054\u8868\u5931\u8d25\uff01"), (Throwable)e);
            }
        }
        CMyFile.deleteDir(MetaDataDefHelper.getViewApplicationRootPath() + _oView.getId());
        String sDeleteFieldsSQL = "delete from XWCMVIEWFIELDINFO where ViewId=" + _oView.getId();
        this.m_oDBMgr.sqlExecuteUpdate(sDeleteFieldsSQL);
        _oView.delete(_currUser);
        IMetaViewEmployerMgr employerMgr = (IMetaViewEmployerMgr)DreamFactory.createObjectById("IMetaViewEmployerMgr");
        employerMgr.clearEmployer(_currUser, _oView);
    }

    @Override
    public MetaViews getViewsUsingTable(MetaDBTable _oTable) throws WCMException {
        String sWhere = "MainTableId=? or ViewInfoId in(select XWCMViewOtherTables.ViewId from XWCMViewOtherTables where XWCMViewOtherTables.TableId=?)";
        WCMFilter filter = new WCMFilter("", sWhere, "");
        filter.addSearchValues(_oTable.getId());
        filter.addSearchValues(_oTable.getId());
        return MetaViews.openWCMObjs(null, filter);
    }

    @Override
    public MetaViews getViewsContainsTable(MetaDBTable _oTable) throws WCMException {
        String sWhere = "ViewInfoId in(select XWCMViewOtherTables.ViewId from XWCMViewOtherTables where XWCMViewOtherTables.TableId=?)";
        WCMFilter filter = new WCMFilter("", sWhere, "");
        filter.addSearchValues(_oTable.getId());
        return MetaViews.openWCMObjs(null, filter);
    }

    private void createViewRelationsOfDBField(User _currUser, MetaDBField _oDBFieldInfo) throws WCMException {
        MetaViews views = this.getViewsUsingField(_currUser, _oDBFieldInfo);
        this.recreateViewRelations(_currUser, views);
    }

    private void recreateViewRelations(User _currUser, MetaViews _views) throws WCMException {
        int nSize = _views.size();
        for (int i = 0; i < nSize; ++i) {
            MetaView view = (MetaView)_views.getAt(i);
            this.m_oDataDefCacheMgr.reloadViewCache(view.getId());
            try {
                this.createViewRelations(_currUser, view);
                continue;
            }
            catch (Throwable e) {
                logger.error((Object)(I18NMessage.get(MetaDataDefMgr.class, "MetaDataDefMgr.label27", "\u4ea7\u751f\u89c6\u56fe[Name=") + view.getDesc() + "][Id=" + view.getId() + I18NMessage.get(MetaDataDefMgr.class, "MetaDataDefMgr.label28", "]\u7684\u76f8\u5173\u5185\u5bb9\u5931\u8d25\uff01")), e);
            }
        }
    }

    @Override
    public MetaViews getViewsUsingField(User _currUser, MetaDBField _oDBFieldInfo) throws WCMException {
        String sWhere = "exists(select XWCMVIEWFIELDINFO.ViewId from XWCMVIEWFIELDINFO where XWCMVIEWFIELDINFO.DBField=? and XWCMVIEWFIELDINFO.ViewId=XWCMVIEWINFO.VIEWINFOID)";
        WCMFilter filter = new WCMFilter("", sWhere, "");
        filter.addSearchValues(_oDBFieldInfo.getId());
        return MetaViews.openWCMObjs(_currUser, filter);
    }

    @Override
    public void recreateAll(User _currUser, MetaDBTables _oMetaDBTables) throws WCMException {
        int nSize = _oMetaDBTables.size();
        for (int i = 0; i < nSize; ++i) {
            MetaDBTable dbMetaDBTable = (MetaDBTable)_oMetaDBTables.getAt(i);
            if (dbMetaDBTable == null) continue;
            String sTableName = MetaDataConstants.makeTrueTableName(dbMetaDBTable.getName());
            this.createTableInDB(_currUser, dbMetaDBTable, sTableName);
            MetaDBFields fields = this.getDFieldInfos(_currUser, dbMetaDBTable, null);
            int nFieldSize = fields.size();
            for (int j = 0; j < nFieldSize; ++j) {
                MetaDBField dbField = (MetaDBField)fields.getAt(j);
                if (dbField == null) continue;
                this.createFieldInDB(_currUser, dbField, sTableName);
            }
            this.m_oDBMgr.reloadTableInfo(sTableName);
            MetaViews views = this.getViewsUsingTable(dbMetaDBTable);
            int nViewSize = views.size();
            for (int j = 0; j < nViewSize; ++j) {
                MetaView view = (MetaView)views.getAt(j);
                if (view == null) continue;
                this.createViewRelations(_currUser, view, true);
            }
        }
    }

    @Override
    public ClassInfos getClassInfosUsingMetaView(User _currUser, MetaView oMetaView) throws WCMException {
        StringBuffer sbWhere = new StringBuffer(200);
        sbWhere.append("exists(select 1 from XWCMViewFieldInfo");
        sbWhere.append(" where fieldType=");
        sbWhere.append(10);
        if (oMetaView != null) {
            sbWhere.append(" and ViewId=").append(oMetaView.getId());
        } else {
            sbWhere.append(" and exists(select 1 from XWCMViewInfo");
            sbWhere.append(" where ViewInfoId=XWCMViewFieldInfo.ViewId)");
        }
        sbWhere.append(" and ClassId = XWCMCLASSINFO.ClassInfoId)");
        WCMFilter filter = new WCMFilter();
        filter.setWhere(sbWhere.toString());
        return ClassInfos.openWCMObjs(_currUser, filter);
    }

    @Override
    public MetaViews getMetaViewsUsingClassInfo(User _currUser, ClassInfo oClassInfo) throws WCMException {
        StringBuffer sbWhere = new StringBuffer(200);
        sbWhere.append("exists(select 1 from XWCMViewFieldInfo");
        sbWhere.append(" where fieldType=");
        sbWhere.append(10);
        if (oClassInfo != null) {
            sbWhere.append(" and ClassId=").append(oClassInfo.getId());
        } else {
            sbWhere.append(" and exists(select 1 from XWCMClassInfo");
            sbWhere.append(" where ClassInfoId=XWCMViewFieldInfo.ClassId)");
        }
        sbWhere.append(" and viewId = XWCMVIEWINFO.viewInfoId)");
        WCMFilter filter = new WCMFilter();
        filter.setWhere(sbWhere.toString());
        return MetaViews.openWCMObjs(_currUser, filter);
    }

    @Override
    public MetaView createViewFromDBTable(MetaDBTable _dbTable) throws WCMException {
        User loginUser = ContextHelper.getLoginUser();
        MetaView view = MetaView.createNewInstance();
        view.setMainTable(_dbTable);
        view.setDesc(CMyString.isEmpty(_dbTable.getAnotherName()) ? "\u7f51\u7ad9\u6570\u636e02" : _dbTable.getAnotherName());
        this.save(loginUser, view);
        MetaDBFields dbFields = this.getDFieldInfos(null, _dbTable, null);
        int nSize = dbFields.size();
        for (int i = 0; i < nSize; ++i) {
            MetaDBField dbField = (MetaDBField)dbFields.getAt(i);
            if (dbField == null) continue;
            MetaViewField viewField = MetaViewField.createNewInstance();
            viewField.setView(view.getId());
            viewField.inheritDBFieldInfo(dbField);
            viewField.save(loginUser);
        }
        this.createViewApplication(view);
        return view;
    }
}

