/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.center;

import com.trs.DreamFactory;
import com.trs.cms.content.HTMLContent;
import com.trs.components.metadata.center.MetaViewData;
import com.trs.components.metadata.definition.ClassInfo;
import com.trs.components.metadata.definition.ClassInfos;
import com.trs.components.metadata.definition.IMetaDataDefCacheMgr;
import com.trs.components.metadata.definition.MetaView;
import com.trs.components.metadata.definition.MetaViewField;
import com.trs.components.metadata.definition.MetaViewFields;
import com.trs.components.wcm.content.domain.AppendixMgr;
import com.trs.components.wcm.content.domain.RelationMgr;
import com.trs.components.wcm.content.persistent.Appendix;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.Relation;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.database.TableInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.log4j.Logger;

public class MetaDataCenterHelper {
    private static Logger logger = Logger.getLogger(MetaDataCenterHelper.class);
    static IMetaDataDefCacheMgr m_oDataDefCacheMgr = (IMetaDataDefCacheMgr)DreamFactory.createObjectById("IMetaDataDefCacheMgr");
    static AppendixMgr appendixMgr = (AppendixMgr)DreamFactory.createObjectById("AppendixMgr");
    static RelationMgr relationMgr = (RelationMgr)DreamFactory.createObjectById("RelationMgr");
    public static int MAX_IN_NUM = 999;
    public static int nCountClassInfoId = 1;
    private static final String TYPE = "type";
    private static final String CONTENT = "content";
    private static final String VALUE = "value";

    public static WCMFilter makeFilterWithClassInfos(String sClassInfoIds, boolean _bContainsChildren) throws WCMException {
        if (sClassInfoIds == null || (sClassInfoIds = sClassInfoIds.trim()).length() == 0) {
            return null;
        }
        ClassInfos classInfos = ClassInfos.findByIds(null, sClassInfoIds);
        WCMFilter filter = new WCMFilter("WCMChnlDoc", "", "");
        StringBuffer sbQueryWithClassIdWhere = new StringBuffer();
        sbQueryWithClassIdWhere.append("exists(select 1 from XWCMClassInfoView c where c.ClassInfoId in(");
        boolean bOnlyLeaf = "true".equalsIgnoreCase(ConfigServer.getServer().getSysConfigValue("CLASS_DOCUMENTS_ONLY_LEAF", "true"));
        MetaDataCenterHelper.makeClassInfoWhere(classInfos, sbQueryWithClassIdWhere, filter, bOnlyLeaf, _bContainsChildren);
        nCountClassInfoId = 1;
        if (filter.getSearchValues() != null && filter.getSearchValues().size() > 0) {
            sbQueryWithClassIdWhere.setLength(sbQueryWithClassIdWhere.length() - 1);
        }
        sbQueryWithClassIdWhere.append(") and c.MetaDataId=WCMChnlDoc.DocId)");
        filter.setWhere(sbQueryWithClassIdWhere.toString());
        return filter;
    }

    private static void makeClassInfoWhere(ClassInfos _currClassInfos, StringBuffer _sbQueryWithClassIdWhere, WCMFilter _filter, boolean _bOnlyLeaf, boolean _bContainsChildren) throws WCMException {
        if (_currClassInfos == null || _currClassInfos.isEmpty()) {
            return;
        }
        int nSize = _currClassInfos.size();
        for (int i = 0; i < nSize; ++i) {
            ClassInfo classInfo = (ClassInfo)_currClassInfos.getAt(i);
            if (classInfo == null) continue;
            ClassInfos children = classInfo.getChildren();
            if (!_bOnlyLeaf || children == null || children.isEmpty()) {
                if (nCountClassInfoId < MAX_IN_NUM) {
                    _sbQueryWithClassIdWhere.append("?,");
                    ++nCountClassInfoId;
                } else {
                    nCountClassInfoId = 1;
                    _sbQueryWithClassIdWhere.setLength(_sbQueryWithClassIdWhere.length() - 1);
                    _sbQueryWithClassIdWhere.append(") or c.ClassInfoId in(?,");
                }
                _filter.addSearchValues(classInfo.getId());
            }
            if (!_bContainsChildren) continue;
            MetaDataCenterHelper.makeClassInfoWhere(children, _sbQueryWithClassIdWhere, _filter, _bOnlyLeaf, _bContainsChildren);
        }
    }

    public static void renderFields(MetaViewData _oViewData) throws WCMException {
        HashMap hFields = m_oDataDefCacheMgr.getMetaViewFields(_oViewData.getMetaView().getId());
        Iterator iter = hFields.values().iterator();
        Document document = _oViewData.getDocument();
        block11: while (iter.hasNext()) {
            MetaViewField field = (MetaViewField)iter.next();
            if (field == null || !field.isFromMainTable()) continue;
            switch (field.getType()) {
                case 12: 
                case 16: {
                    String sFieldName = field.getName();
                    String sFieldValue = _oViewData.getFinalPropertyAsString(sFieldName);
                    if (CMyString.isEmpty(sFieldValue)) break;
                    sFieldValue = HTMLContent.saveHtmlContent(sFieldValue);
                    _oViewData.setProperty(sFieldName, sFieldValue);
                    break;
                }
                case 8: {
                    String sFieldName = field.getName();
                    if (!MetaDataCenterHelper.checkValid(_oViewData, sFieldName)) break;
                    MetaDataCenterHelper.handleAppendix(document, _oViewData, sFieldName, 70);
                    break;
                }
                case 32: {
                    String sFieldName = field.getName();
                    if (!MetaDataCenterHelper.checkValid(_oViewData, sFieldName)) break;
                    MetaDataCenterHelper.handleAppendix(document, _oViewData, sFieldName, 80);
                    break;
                }
                case 33: {
                    String sFieldName = field.getName();
                    if (!MetaDataCenterHelper.checkValid(_oViewData, sFieldName)) break;
                    MetaDataCenterHelper.handleAppendix(document, _oViewData, sFieldName, 90);
                    break;
                }
                case 31: {
                    ArrayList relationList;
                    String sFieldName = field.getName();
                    if (!MetaDataCenterHelper.checkValid(_oViewData, sFieldName) || (relationList = _oViewData.getMetaDataId() != 0 ? (ArrayList)_oViewData.getNewProperty(sFieldName) : (ArrayList)_oViewData.getProperty(sFieldName)) == null) break;
                    relationMgr.saveRelations(_oViewData.getDocument(), relationList);
                    StringBuffer stringBuffer = new StringBuffer();
                    for (int i = 0; i < relationList.size(); ++i) {
                        Relation relation = (Relation)relationList.get(i);
                        stringBuffer.append(relation.getId());
                        stringBuffer.append(",");
                    }
                    if (stringBuffer.length() > 0) {
                        _oViewData.setProperty(sFieldName, stringBuffer.substring(0, stringBuffer.length() - 1));
                        break;
                    }
                    _oViewData.setProperty(sFieldName, "");
                    break;
                }
                case 42: {
                    String sFieldName = field.getName();
                    String normalPics = _oViewData.getMetaDataId() != 0 ? (String)_oViewData.getNewProperty(sFieldName) : (String)_oViewData.getProperty(sFieldName);
                    if (CMyString.isEmpty(normalPics)) break;
                    String[] normalPicArr = CMyString.split(normalPics, ",");
                    ArrayList<String> nFileNameArr = new ArrayList<String>();
                    for (String normalPic : normalPicArr) {
                        String nFileName;
                        FilesMan filesMan = FilesMan.getFilesMan();
                        String string = nFileName = filesMan.fileExists(normalPic) ? normalPic : "";
                        if (filesMan.fileExists(normalPic) && !"W0".equals(filesMan.getFileFlag(normalPic))) {
                            nFileName = filesMan.copyWCMFile(normalPic, "W0");
                        }
                        if (CMyString.isEmpty(nFileName)) continue;
                        nFileNameArr.add(nFileName);
                    }
                    String newFileName = MetaDataCenterHelper.arrToString(nFileNameArr);
                    _oViewData.setProperty(sFieldName, newFileName);
                    break;
                }
                case 15: {
                    String sFieldName = field.getName();
                    String sValue = "";
                    sValue = _oViewData.isAddMode() ? (String)_oViewData.getProperty(sFieldName) : (String)_oViewData.getNewProperty(sFieldName);
                    try {
                        ArrayList arrayList = (ArrayList)MetaDataCenterHelper.jsonStringToList(sValue);
                        for (int i = 0; i < arrayList.size(); ++i) {
                            HashMap tempList = (HashMap)arrayList.get(i);
                            if (tempList.get(TYPE).equals(CONTENT)) {
                                field.setEnmValue(tempList.get(VALUE).toString());
                            }
                            if (!tempList.get(TYPE).equals(VALUE)) continue;
                            _oViewData.setProperty(sFieldName, tempList.get(VALUE).toString());
                        }
                        continue block11;
                    }
                    catch (Exception e) {
                        logger.error((Object)"\u5904\u7406\u53ef\u8f93\u5165\u4e0b\u62c9\u5217\u8868\u51fa\u9519\uff01");
                        break;
                    }
                }
            }
        }
    }

    private static List<Map<String, String>> jsonStringToList(String sValue) throws Exception {
        JSONArray arry = JSONArray.fromObject((Object)sValue);
        ArrayList<Map<String, String>> rsList = new ArrayList<Map<String, String>>();
        for (int i = 0; i < arry.size(); ++i) {
            JSONObject jsonObject = arry.getJSONObject(i);
            HashMap<String, String> map = new HashMap<String, String>();
            Iterator iter = jsonObject.keys();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                String value = jsonObject.get(key).toString();
                map.put(key, value);
            }
            rsList.add(map);
        }
        return rsList;
    }

    private static void handleAppendix(Document document, MetaViewData viewData, String sFieldName, int type) throws WCMException {
        ArrayList appendixList;
        String oldAppendixIds = "";
        if (viewData.getMetaDataId() != 0) {
            appendixList = (ArrayList)viewData.getNewProperty(sFieldName);
            oldAppendixIds = (String)viewData.getProperty(sFieldName);
        } else {
            appendixList = (ArrayList)viewData.getProperty(sFieldName);
        }
        if (appendixList == null || appendixList.isEmpty()) {
            appendixMgr.removeAppendices(document, oldAppendixIds);
            viewData.setProperty(sFieldName, "");
            return;
        }
        ArrayList<Integer> finalIds = new ArrayList<Integer>();
        if (CMyString.isEmpty(oldAppendixIds)) {
            for (Appendix appendix : appendixList) {
                appendixMgr.saveAppendix(document, appendix, type);
                finalIds.add(appendix.getId());
            }
            viewData.setProperty(sFieldName, CMyString.getIdListAsString(finalIds, ','));
            return;
        }
        ArrayList<Integer> appendixIdsToStay = new ArrayList<Integer>();
        for (Appendix appendix : appendixList) {
            if (appendix.getId() == 0) {
                appendixMgr.saveAppendix(document, appendix, type);
                finalIds.add(appendix.getId());
                continue;
            }
            appendixMgr.saveAppendix(document, appendix, type);
            appendixIdsToStay.add(appendix.getId());
        }
        for (String oldAppendixIdStr : oldAppendixIds.split(",")) {
            int oldAppendixId = Integer.parseInt(oldAppendixIdStr);
            if (!appendixIdsToStay.contains(oldAppendixId)) {
                appendixMgr.deleteAppendixFromDocument(document, Appendix.findById(oldAppendixId));
                continue;
            }
            finalIds.add(oldAppendixId);
        }
        viewData.setProperty(sFieldName, CMyString.getIdListAsString(finalIds, ','));
    }

    private static String arrToString(List<String> nFileNameArr) {
        StringBuilder stringBuilder = new StringBuilder("");
        for (String newFileName : nFileNameArr) {
            if (CMyString.isEmpty(newFileName)) continue;
            stringBuilder.append(newFileName);
            stringBuilder.append(",");
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        return stringBuilder.toString();
    }

    private static boolean checkValid(MetaViewData viewData, String fieldName) {
        boolean propertyIsList;
        boolean result = false;
        boolean isAddMode = viewData.getMetaDataId() == 0;
        Object newProperty = viewData.getNewProperty(fieldName);
        boolean newPropertyIsList = newProperty != null && newProperty instanceof List;
        Object property = viewData.getProperty(fieldName);
        boolean bl = propertyIsList = property != null && property instanceof List;
        if (isAddMode && propertyIsList || !isAddMode && newPropertyIsList) {
            result = true;
        }
        return result;
    }

    public static void rendHtmlFields(MetaViewData _oViewData) throws WCMException {
        HashMap hFields = m_oDataDefCacheMgr.getMetaViewFields(_oViewData.getMetaView().getId());
        for (MetaViewField field : hFields.values()) {
            String sFieldName;
            String sFieldValue;
            if (field == null || !field.isFromMainTable() || field.getType() != 12 && field.getType() != 16 && field.getDBType() != 2005 || CMyString.isEmpty(sFieldValue = _oViewData.getFinalPropertyAsString(sFieldName = field.getName()))) continue;
            sFieldValue = HTMLContent.saveHtmlContent(sFieldValue);
            _oViewData.setProperty(sFieldName, sFieldValue);
        }
    }

    public static String makeSelectFieldsForQuery(MetaView _view) throws WCMException {
        String[] pDefaultSelectFields;
        String sTrueTableName = _view.getTrueTableName();
        DBManager dbMgr = DBManager.getDBManager();
        TableInfo tableInfo = dbMgr.getTableInfo(sTrueTableName);
        StringBuffer sbSelectFields = new StringBuffer();
        sbSelectFields.append("MetaDataId");
        for (String sDefaultField : pDefaultSelectFields = new String[]{"DocType", "DocTitle", "DocRelTime", "AttachPic", "AttachVideo", "AttachAudio", "ThumbFiles", "OriginMetaDataId"}) {
            if (tableInfo.getFieldInfo(sDefaultField) == null) continue;
            sbSelectFields.append(',');
            sbSelectFields.append(sDefaultField);
        }
        HashMap hFields = m_oDataDefCacheMgr.getMetaViewFields(_view.getId());
        for (MetaViewField field : hFields.values()) {
            if (field == null || !field.isInOutline()) continue;
            sbSelectFields.append(',');
            sbSelectFields.append(field.getName());
        }
        return sbSelectFields.toString();
    }

    public static MetaViewFields makeSearchFields(MetaView _view) throws WCMException {
        MetaViewFields oViewFields = new MetaViewFields(null);
        HashMap hFields = m_oDataDefCacheMgr.getMetaViewFields(_view.getId());
        for (MetaViewField field : hFields.values()) {
            if (field == null || !field.isSearchField()) continue;
            oViewFields.addElement(field);
        }
        return oViewFields;
    }
}

