/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.infoview.helper;

import com.trs.components.infoview.persistent.InfoView;
import com.trs.components.wcm.resource.Status;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyString;
import com.trs.webframework.context.MethodContext;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;

public class InfoViewQueryHelper {
    private static final String DEFAULT_TIMERANGE_FIELD = "CRTIME";
    protected static Logger logger = Logger.getLogger(InfoViewQueryHelper.class);
    private static final String FIELD_OPERATIONMARK = "FLOWOPERATIONMARK";
    private static HashMap m_oSystemFieldMap = null;
    private static DocumentFactory m_oDocFactory = null;
    private static String[] m_aDefaultOutlineFields = new String[]{"FLOWOPERATIONMARK", "_DOCID", "DOCTITLE", "CRTIME", "DOCSTATUS", "ARCHIVESERIAL", "POSTUSER", "POSITIONCODE", "POSTUSER", "DOCPUBTIME", "DOCPUBURL"};

    private static DocumentFactory getDocumentFactory() {
        if (m_oDocFactory == null) {
            m_oDocFactory = new DocumentFactory();
        }
        return m_oDocFactory;
    }

    private static HashMap getSystemFieldMap() {
        if (m_oSystemFieldMap == null) {
            m_oSystemFieldMap = new HashMap();
            m_oSystemFieldMap.put("_EDIT", I18NMessage.get(InfoViewQueryHelper.class, "InfoViewQueryHelper.label1", "\u7f16\u8f91"));
            m_oSystemFieldMap.put("_PREVIEW", I18NMessage.get(InfoViewQueryHelper.class, "InfoViewQueryHelper.label2", "\u9884\u89c8"));
            m_oSystemFieldMap.put("_DOCSTATUS", I18NMessage.get(InfoViewQueryHelper.class, "InfoViewQueryHelper.label3", "\u6587\u6863\u72b6\u6001"));
            m_oSystemFieldMap.put("_DOCID", I18NMessage.get(InfoViewQueryHelper.class, "InfoViewQueryHelper.label4", "\u6587\u6863\u7f16\u53f7"));
            m_oSystemFieldMap.put("INFOVIEWID", I18NMessage.get(InfoViewQueryHelper.class, "InfoViewQueryHelper.label5", "\u8868\u5355\u7f16\u53f7"));
            m_oSystemFieldMap.put("DOCTITLE", I18NMessage.get(InfoViewQueryHelper.class, "InfoViewQueryHelper.label6", "\u6587\u6863\u6807\u9898"));
            m_oSystemFieldMap.put(DEFAULT_TIMERANGE_FIELD, I18NMessage.get(InfoViewQueryHelper.class, "InfoViewQueryHelper.label7", "\u521b\u5efa\u65f6\u95f4"));
            m_oSystemFieldMap.put("CRUSER", I18NMessage.get(InfoViewQueryHelper.class, "InfoViewQueryHelper.label8", "\u53d1\u7a3f\u4eba"));
            m_oSystemFieldMap.put("POSTUSER", I18NMessage.get(InfoViewQueryHelper.class, "InfoViewQueryHelper.label9", "\u53d1\u7a3f\u4eba(\u5916\u7f51)"));
            m_oSystemFieldMap.put("ARCHIVESERIAL", I18NMessage.get(InfoViewQueryHelper.class, "InfoViewQueryHelper.label10", "\u5b58\u6863\u7f16\u53f7"));
            m_oSystemFieldMap.put("POSITIONCODE", I18NMessage.get(InfoViewQueryHelper.class, "InfoViewQueryHelper.label11", "\u67e5\u8be2\u7f16\u53f7"));
            m_oSystemFieldMap.put(FIELD_OPERATIONMARK, I18NMessage.get(InfoViewQueryHelper.class, "InfoViewQueryHelper.label12", "\u72b6\u6001"));
            m_oSystemFieldMap.put("DOCPUBTIME", I18NMessage.get(InfoViewQueryHelper.class, "InfoViewQueryHelper.label13", "\u53d1\u5e03\u65f6\u95f4"));
            m_oSystemFieldMap.put("DOCPUBURL", I18NMessage.get(InfoViewQueryHelper.class, "InfoViewQueryHelper.label14", "\u53d1\u5e03\u5730\u5740"));
        }
        return m_oSystemFieldMap;
    }

    public static String[] getFieldDisplay(String[] sFieldName) {
        String[] sFieldDisp = new String[sFieldName.length];
        for (int i = 0; i < sFieldName.length; ++i) {
            String name = sFieldName[i];
            int index = name.lastIndexOf(58);
            if (index > 0) {
                sFieldDisp[i] = name.substring(index + 1);
                continue;
            }
            String disp = (String)InfoViewQueryHelper.getSystemFieldMap().get(name);
            if (disp == null) {
                disp = name;
            }
            sFieldDisp[i] = disp;
        }
        return sFieldDisp;
    }

    private static boolean getBooleanValue(String _sAttrVal, boolean _bDefaultValue) {
        String sValue = _sAttrVal;
        if (CMyString.isEmpty(sValue)) {
            return _bDefaultValue;
        }
        if ("true".equals(sValue = sValue.trim().toLowerCase())) {
            return true;
        }
        if ("false".equals(sValue)) {
            return false;
        }
        try {
            int nValue = Integer.parseInt(sValue);
            nValue = _bDefaultValue ? 1 : 0;
            return nValue != 0;
        }
        catch (NumberFormatException e) {
            return _bDefaultValue;
        }
    }

    public static int getDocumentStatus(String sLuceneId) throws WCMException {
        int id = Integer.parseInt(sLuceneId);
        return DBManager.getDBManager().sqlExecuteIntQuery("select DocStatus from WCMChnlDoc where DocId=? and Modal=1", new int[]{id});
    }

    public static String getStatusName(int status) throws WCMException {
        Status docStatus;
        if (status < 0) {
            status = -status;
        }
        if ((docStatus = Status.findById(status)) == null) {
            return I18NMessage.get(InfoViewQueryHelper.class, "InfoViewQueryHelper.label15", "\u672a\u77e5");
        }
        return docStatus.getDisp();
    }

    private static String[] getFieldNames(MethodContext _context) throws WCMException {
        int nInfoviewId = _context.getValue("InfoviewId", 0);
        InfoView infoview = InfoView.findById(nInfoviewId);
        String sSelectedFields = _context.getValue("SelectFields");
        if (CMyString.isEmpty(sSelectedFields) && infoview != null) {
            sSelectedFields = infoview.getOutlineFields();
        }
        sSelectedFields = CMyString.showNull(sSelectedFields);
        String[] aFieldNames = null;
        aFieldNames = CMyString.isEmpty(sSelectedFields) ? m_aDefaultOutlineFields : sSelectedFields.split(",");
        return aFieldNames;
    }

    static Element createDataItem(String[] _aFieldNames, HashMap _hsValues) {
        DocumentFactory oDocFactory = InfoViewQueryHelper.getDocumentFactory();
        Element oItemElement = oDocFactory.createElement("dataitem");
        for (int i = 0; i < _aFieldNames.length; ++i) {
            String sFieldName = _aFieldNames[i];
            Element oElement = oDocFactory.createElement(sFieldName);
            oItemElement.add(oElement);
            String sFieldValue = (String)_hsValues.get(sFieldName);
            if (sFieldValue == null) {
                sFieldValue = "";
            }
            oElement.add(oDocFactory.createCDATA(sFieldValue));
        }
        if (_hsValues.get("DOCEDITURL") != null) {
            Element oElement = oDocFactory.createElement("DOCEDITURL");
            oItemElement.add(oElement);
            oElement.add(oDocFactory.createCDATA((String)_hsValues.get("DOCEDITURL")));
        }
        return oItemElement;
    }

    static Document createDataSetDocument() {
        DocumentFactory oDocFactory = InfoViewQueryHelper.getDocumentFactory();
        Document oDocument = oDocFactory.createDocument("utf-8");
        Element oRootElement = oDocFactory.createElement("dataset");
        oDocument.setRootElement(oRootElement);
        return oDocument;
    }

    private static Element createHeaderItem(String _sFieldName, String _sFieldDisplay) {
        DocumentFactory oDocFactory = InfoViewQueryHelper.getDocumentFactory();
        Element oElement = oDocFactory.createElement("field");
        oElement.add(oDocFactory.createAttribute(oElement, "name", _sFieldName));
        oElement.add(oDocFactory.createAttribute(oElement, "desc", _sFieldDisplay));
        return oElement;
    }

    static Element createDataHeader(String[] _aFieldNames, String[] _aFieldDisplays) {
        DocumentFactory oDocFactory = InfoViewQueryHelper.getDocumentFactory();
        Element oHeadElement = oDocFactory.createElement("dataheader");
        for (int i = 0; i < _aFieldNames.length; ++i) {
            oHeadElement.add(InfoViewQueryHelper.createHeaderItem(_aFieldNames[i], _aFieldDisplays[i]));
        }
        return oHeadElement;
    }

    public static void testCase1() {
        Document oDocument = InfoViewQueryHelper.createDataSetDocument();
        Element oRootElement = oDocument.getRootElement();
        String[] aFields = new String[]{"field1", "field2", "field3"};
        String[] aFieldDisplays = new String[]{I18NMessage.get(InfoViewQueryHelper.class, "InfoViewQueryHelper.label16", "\u59d3\u540d"), I18NMessage.get(InfoViewQueryHelper.class, "InfoViewQueryHelper.label17", "\u5e74\u9f84"), I18NMessage.get(InfoViewQueryHelper.class, "InfoViewQueryHelper.label18", "\u6027\u522b")};
        Element oHeaderElement = InfoViewQueryHelper.createDataHeader(aFields, aFieldDisplays);
        oRootElement.add(oHeaderElement);
        HashMap<String, String> hsValues = new HashMap<String, String>();
        Element oDataItemElement = null;
        hsValues.put("field1", "gronlet1");
        hsValues.put("field2", "24");
        hsValues.put("field3", "1");
        oDataItemElement = InfoViewQueryHelper.createDataItem(aFields, hsValues);
        oRootElement.add(oDataItemElement);
        hsValues.clear();
        hsValues.put("field1", "gronlet2");
        hsValues.put("field2", "25");
        oDataItemElement = InfoViewQueryHelper.createDataItem(aFields, hsValues);
        oRootElement.add(oDataItemElement);
        hsValues.clear();
        hsValues.put("field1", "gronlet3");
        hsValues.put("field3", "1");
        oDataItemElement = InfoViewQueryHelper.createDataItem(aFields, hsValues);
        oRootElement.add(oDataItemElement);
        hsValues.clear();
        hsValues.put("field1", "gronlet4");
        hsValues.put("field2", "27");
        hsValues.put("field3", "1");
        oDataItemElement = InfoViewQueryHelper.createDataItem(aFields, hsValues);
        oRootElement.add(oDataItemElement);
        System.out.println(oDocument.asXML());
        oDocument.clearContent();
    }

    public static void main(String[] args) {
        InfoViewQueryHelper.testCase1();
    }
}

