/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.infoview.extract.manifest;

import com.trs.components.infoview.extract.manifest.MenuArea;
import com.trs.components.infoview.extract.manifest.MenuButton;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.dom4j.Document;
import org.dom4j.Element;

public class View {
    private String m_sName;
    private String m_sCaption;
    private String m_sTransform;
    private String m_sXSLPrefix;
    private MenuArea m_oContextMenuArea;
    private HashMap m_oContextMenuMap;
    private HashMap m_oBind2EditIDMap;
    private String m_sViewWidth;
    private boolean m_zDefaultView;
    private String m_sNewTransform;
    private Document m_oDOM4JDocument;
    private int m_iTRSObjectID;

    View build(Element element) {
        this.m_sName = element.attributeValue("name");
        this.m_sCaption = element.attributeValue("caption");
        this.m_sTransform = element.element("mainpane").attributeValue("transform");
        Element elEditing = element.element("editing");
        if (elEditing == null) {
            return this;
        }
        this.m_oBind2EditIDMap = new HashMap();
        Iterator itrXMLToEdit = elEditing.elementIterator("xmlToEdit");
        while (itrXMLToEdit.hasNext()) {
            int index;
            Element elXMLToEdit = (Element)itrXMLToEdit.next();
            String name = elXMLToEdit.attributeValue("name");
            String item = elXMLToEdit.attributeValue("item");
            if (item.charAt(0) == '/' && (index = item.indexOf(47, 1)) > 0) {
                item = item.substring(index + 1);
            }
            this.m_oBind2EditIDMap.put(item, name);
        }
        Iterator itrMenuArea = element.elementIterator("menuArea");
        while (itrMenuArea.hasNext()) {
            MenuArea menuarea = new MenuArea();
            menuarea.build((Element)itrMenuArea.next());
            this.addMenuArea(menuarea);
        }
        return this;
    }

    public String getCaption() {
        return this.m_sCaption;
    }

    public void setCaption(String caption) {
        this.m_sCaption = caption;
    }

    public String getName() {
        return this.m_sName;
    }

    public void setName(String name) {
        this.m_sName = name;
    }

    public String getTransform() {
        return this.m_sTransform;
    }

    public void setTransform(String transform) {
        this.m_sTransform = transform;
    }

    public void addMenuArea(MenuArea menuarea) {
        if (menuarea == null) {
            return;
        }
        if ("msoStructuralEditingContextMenu".equals(menuarea.getName())) {
            this.m_oContextMenuArea = menuarea;
            this.initContextMenuMap(menuarea);
        }
    }

    private void initContextMenuMap(MenuArea menuarea) {
        ArrayList list = menuarea.getButton();
        if (list == null || list.size() <= 0) {
            return;
        }
        if (this.m_oContextMenuMap == null) {
            this.m_oContextMenuMap = new HashMap();
        }
        MenuButton button = null;
        ArrayList<MenuButton> subList = null;
        for (int i = list.size() - 1; i >= 0; --i) {
            button = (MenuButton)list.get(i);
            subList = (ArrayList<MenuButton>)this.m_oContextMenuMap.get(button.getXMLToEdit());
            if (subList == null) {
                subList = new ArrayList<MenuButton>();
                this.m_oContextMenuMap.put(button.getXMLToEdit(), subList);
            }
            subList.add(button);
        }
    }

    public ArrayList getContextMenuForBinding(String sBinding) {
        if (sBinding == null || this.m_oBind2EditIDMap == null) {
            return null;
        }
        String sXMLToEdit = (String)this.m_oBind2EditIDMap.get(sBinding);
        if (sXMLToEdit == null) {
            return null;
        }
        return this.getContextMenuForXMLToEdit(sXMLToEdit);
    }

    public ArrayList getContextMenuForXMLToEdit(String sXMLToEdit) {
        if (sXMLToEdit == null || this.m_oContextMenuMap == null) {
            return null;
        }
        return (ArrayList)this.m_oContextMenuMap.get(sXMLToEdit);
    }

    public MenuArea getContextMenuArea() {
        return this.m_oContextMenuArea;
    }

    public void setContextMenuArea(MenuArea contextMenuArea) {
        this.m_oContextMenuArea = contextMenuArea;
    }

    public HashMap getContextMenuMap() {
        return this.m_oContextMenuMap;
    }

    public void setContextMenuMap(HashMap contextMenuMap) {
        this.m_oContextMenuMap = contextMenuMap;
    }

    public String getViewWidth() {
        return this.m_sViewWidth;
    }

    public void setViewWidth(String viewWidth) {
        this.m_sViewWidth = viewWidth;
    }

    public boolean isDefaultView() {
        return this.m_zDefaultView;
    }

    public void setDefaultView(boolean defaultView) {
        this.m_zDefaultView = defaultView;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(128);
        sb.append("View::name=").append(this.m_sName);
        sb.append(",caption=").append(this.m_sCaption);
        sb.append(",transform=").append(this.m_sTransform);
        return sb.toString();
    }

    public String getNewTransform() {
        if (this.m_sNewTransform == null) {
            this.m_sNewTransform = System.currentTimeMillis() + this.m_sTransform;
        }
        return this.m_sNewTransform;
    }

    public void setNewTransform(String newTransform) {
        this.m_sNewTransform = newTransform;
    }

    public Document getDOM4JDocument() {
        return this.m_oDOM4JDocument;
    }

    public void setDOM4JDocument(Document document) {
        this.m_oDOM4JDocument = document;
    }

    public int getViewID() {
        return this.m_iTRSObjectID;
    }

    public void setTRSObjectID(int id) {
        this.m_iTRSObjectID = id;
    }

    public String getXSLPrefix() {
        return this.m_sXSLPrefix;
    }

    public void setXSLPrefix(String _prefix) {
        this.m_sXSLPrefix = _prefix;
    }
}

