/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.infoview.extract.manifest;

import com.trs.components.infoview.extract.manifest.FileProperty;
import java.util.HashMap;
import java.util.Iterator;
import org.dom4j.Element;

public class PackageFile {
    private String m_sName;
    private HashMap m_oFileProperties;

    PackageFile build(Element element) {
        this.m_sName = element.attributeValue("name");
        Element elFPS = element.element("fileProperties");
        if (elFPS == null) {
            return this;
        }
        Iterator itr = elFPS.elementIterator("property");
        while (itr.hasNext()) {
            Element elProperty = (Element)itr.next();
            FileProperty property = new FileProperty();
            property.setName(elProperty.attributeValue("name"));
            property.setType(elProperty.attributeValue("type"));
            property.setValue(elProperty.attributeValue("value"));
            this.addFileProperty(property);
        }
        return this;
    }

    public String getName() {
        return this.m_sName;
    }

    public void setName(String name) {
        this.m_sName = name;
    }

    private void addFileProperty(FileProperty property) {
        if (property == null) {
            return;
        }
        if (this.m_oFileProperties == null) {
            this.m_oFileProperties = new HashMap();
        }
        this.m_oFileProperties.put(property.getName(), property);
    }

    public FileProperty getFileProperty(String key) {
        if (key == null || this.m_oFileProperties == null) {
            return null;
        }
        return (FileProperty)this.m_oFileProperties.get(key);
    }

    public HashMap getFileProperties() {
        return this.m_oFileProperties;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(512);
        sb.append("PackageFile::name=").append(this.m_sName);
        sb.append(",Properties=").append(this.m_oFileProperties);
        return sb.toString();
    }
}

