/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.infoview.extract;

import com.trs.components.infoview.InfoViewConfig;
import com.trs.components.infoview.InfoViewHelper;
import com.trs.components.infoview.extract.DataType;
import com.trs.components.infoview.extract.DataTypeBuilder;
import com.trs.components.infoview.extract.XSLTViewBuilder;
import com.trs.components.infoview.extract.manifest.Manifest;
import com.trs.components.infoview.extract.manifest.View;
import com.trs.infra.util.store.FileService;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class InfoPathFileData {
    private String m_sDiretory;
    private HashMap m_oMapFiles;
    private Manifest m_oManifest;
    private ArrayList m_oGroupList;
    private ArrayList m_oTypeList;
    private ArrayList m_oViewList;
    private HashMap m_oViewMaps;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String getFileContent(String file) throws IOException {
        InputStream fis = null;
        try {
            int length;
            char[] buff = new char[2048];
            fis = new FileService(file).getInputStream();
            InputStreamReader isr = new InputStreamReader(fis, "utf-8");
            BufferedReader reader = new BufferedReader(isr);
            StringBuffer sbContent = new StringBuffer(4096);
            while ((length = reader.read(buff)) != -1) {
                sbContent.append(buff, 0, length);
            }
            reader.close();
            fis = null;
            String string = sbContent.toString();
            return string;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public void build(String diretory, HashMap mapFiles, InfoViewConfig ivConfig) throws Exception {
        if (diretory == null) {
            throw new NullPointerException("sDiretory is null");
        }
        if (mapFiles == null) {
            throw new NullPointerException("mapFiles is null");
        }
        if (!diretory.endsWith(File.separator)) {
            diretory = diretory + File.separator;
        }
        this.m_sDiretory = diretory;
        this.m_oMapFiles = mapFiles;
        this.m_oManifest = new Manifest();
        this.m_oManifest.build(this.buildDocument("manifest.xsf"));
        DataTypeBuilder datatypeBuilder = new DataTypeBuilder();
        Document schemaes = this.buildDocument(this.getSchemaFile());
        datatypeBuilder.build(schemaes);
        DataType rootType = datatypeBuilder.getSchema(this.getSchemaRootElement());
        this.m_oGroupList = new ArrayList();
        this.m_oTypeList = new ArrayList();
        this.m_oViewList = new ArrayList();
        this.m_oViewMaps = this.m_oManifest.getAllViews();
        List lViewList = this.m_oManifest.getAllViewsInOrder();
        for (View view : lViewList) {
            Document document = this.buildDocument(view.getTransform());
            view.setDOM4JDocument(document);
            this.m_oViewList.add(view);
            XSLTViewBuilder xsltviewBuilder = new XSLTViewBuilder();
            xsltviewBuilder.init(ivConfig, this.m_oManifest, this.m_oGroupList, rootType, this.m_oTypeList);
            xsltviewBuilder.build(view);
        }
    }

    public void reform(int _iInfoViewId) throws Exception {
        for (View view : this.m_oViewList) {
            this.reformImageSource(view, _iInfoViewId);
            String filename = this.m_sDiretory + view.getNewTransform();
            Document document = view.getDOM4JDocument();
            InfoViewHelper.writeDOM4JDocument(document, filename);
        }
    }

    public void reformTemplateXml() throws Exception {
        Document oTemplateDoc = this.buildDocument("template.xml");
        ArrayList lstFields = this.getFieldList();
        HashMap<String, String> hsValidXPaths = new HashMap<String, String>();
        String sTmpXPath = null;
        for (DataType dataType : lstFields) {
            sTmpXPath = dataType.getBindName();
            if (sTmpXPath == null) continue;
            hsValidXPaths.put(sTmpXPath, "");
        }
        Element oRoot = oTemplateDoc.getRootElement();
        Iterator iterRoot = oRoot.elementIterator();
        while (iterRoot.hasNext()) {
            Element oChildElement = (Element)iterRoot.next();
            this.doTemplateXmlElement(oChildElement, "", hsValidXPaths);
        }
        String filename = this.m_sDiretory + "template.xml";
        InfoViewHelper.writeDOM4JDocument(oTemplateDoc, filename);
    }

    private boolean doTemplateXmlElement(Element _oElement, String _sParentPath, HashMap _hsXPaths) {
        Iterator iterEle = _oElement.elementIterator();
        boolean bValid = false;
        String sName = _oElement.getName();
        if (_oElement.getNamespacePrefix() != null && _oElement.getNamespacePrefix().length() != 0) {
            sName = _oElement.getNamespacePrefix() + ":" + _oElement.getName();
        }
        String sMyPath = _sParentPath + sName;
        while (iterEle.hasNext()) {
            Element oChildElement = (Element)iterEle.next();
            bValid = bValid || this.doTemplateXmlElement(oChildElement, sMyPath + "/", _hsXPaths);
        }
        if (bValid) {
            return true;
        }
        boolean bl = bValid = _hsXPaths.get(sMyPath) != null;
        if (!bValid) {
            _oElement.addAttribute("trs_field_unuse", "1");
        }
        return bValid;
    }

    private void reformImageSource(View view, int _iInfoViewId) throws Exception {
        List list;
        String filename;
        StringBuffer sb = new StringBuffer(128);
        sb.append("infoview_get_image.jsp?InfoViewId=");
        sb.append(_iInfoViewId).append("&src=");
        String sPrefix = sb.toString();
        Attribute attr2 = null;
        Document document = view.getDOM4JDocument();
        attr2 = (Attribute)document.selectSingleNode("//body/@background");
        if (attr2 != null && this.m_oMapFiles.get(filename = attr2.getValue()) != null) {
            attr2.setValue(sPrefix + filename);
            attr2.getParent().addAttribute("old_src", filename);
        }
        if ((list = document.selectNodes("//img/@src")) != null) {
            for (Attribute attr2 : list) {
                String filename2;
                Element elImage = attr2.getParent();
                if (elImage.attribute("CtrlId") != null || this.m_oMapFiles.get(filename2 = attr2.getValue()) == null) continue;
                attr2.setValue(sPrefix + filename2);
                elImage.addAttribute("old_src", filename2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document buildDocument(String sFileName) throws Exception {
        Exception _ex_ = null;
        Document document = null;
        InputStreamReader reader = null;
        String sFilePath = this.getFilePath(sFileName);
        try {
            InputStream fis = new FileService(sFilePath).getInputStream();
            reader = new InputStreamReader(fis, "utf-8");
            SAXReader saxReader = new SAXReader();
            document = saxReader.read((Reader)reader);
        }
        catch (Exception e) {
            _ex_ = e;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
        }
        if (_ex_ != null) {
            throw _ex_;
        }
        return document;
    }

    private String getFilePath(String sFileName) {
        return (String)this.m_oMapFiles.get(sFileName);
    }

    public String getAllFileList() {
        StringBuffer sb = new StringBuffer(this.m_oMapFiles.size() * 15);
        for (Object s : this.m_oMapFiles.keySet()) {
            if (sb.length() > 0) {
                sb.append(":");
            }
            sb.append(s);
        }
        return new String(sb.toString());
    }

    public String getSchemaFile() {
        return this.m_oManifest.getRootSchema().getXSDFile();
    }

    public String getSchemaRootElement() {
        return this.m_oManifest.getRootSchema().getRootElement();
    }

    public String getSchemaURI() {
        return this.m_oManifest.getRootSchema().getXSDURI();
    }

    public String getTemplateFile() {
        return this.m_oManifest.getFileNewTemplate();
    }

    public ArrayList getViewList() {
        return this.m_oViewList;
    }

    public ArrayList getGroupList() {
        return this.m_oGroupList;
    }

    public ArrayList getFieldList() {
        return this.m_oTypeList;
    }

    public HashMap getViewMaps() {
        return this.m_oViewMaps;
    }
}

