/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.infoview;

import com.trs.cms.auth.persistent.User;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyString;
import java.util.ArrayList;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;

class PatternAnalyzer {
    private String m_sPattern;
    private Document m_oDocument;
    private User m_oUser;
    private String m_sInfogateUserName;

    public final Document getDocument() {
        return this.m_oDocument;
    }

    public final void setDocument(Document document) {
        this.m_oDocument = document;
    }

    public final User getCurrentUser() {
        return this.m_oUser;
    }

    public final void setCurrentUser(User currentUser) {
        this.m_oUser = currentUser;
    }

    public final void setInfogateUserName(String infogateUserName) {
        this.m_sInfogateUserName = infogateUserName;
    }

    public final String getInfogateUserName() {
        return this.m_sInfogateUserName;
    }

    public final String getPattern() {
        return this.m_sPattern;
    }

    public final void setPattern(String pattern) {
        this.m_sPattern = pattern;
    }

    public PatternAnalyzer(String pattern) {
        this.m_sPattern = pattern;
    }

    public String getAnalyzedResult() {
        if (CMyString.isEmpty(this.m_sPattern)) {
            return null;
        }
        StringBuffer buff = new StringBuffer(64);
        PatternPart[] parts = this.analyzePattern();
        PatternPart part = null;
        Node tempNode = null;
        for (int i = 0; i < parts.length; ++i) {
            Element elNode;
            String sFieldNamValue;
            part = parts[i];
            if (part.isconstant) {
                buff.append(part.name);
                continue;
            }
            if (part.name.indexOf("::") == 0) {
                buff.append(this.getSysVariableValue(part.name));
                continue;
            }
            tempNode = this.m_oDocument.selectSingleNode("//" + part.name);
            if (tempNode == null) continue;
            String sValue = tempNode.getStringValue();
            if (tempNode instanceof Element && !CMyString.isEmpty(sFieldNamValue = (elNode = (Element)tempNode).attributeValue("FileName"))) {
                sValue = sFieldNamValue;
            }
            if (CMyString.isEmpty(sValue)) {
                buff.append(' ').append(part.name);
                buff.append(" not set ");
                continue;
            }
            buff.append(sValue);
        }
        return buff.toString();
    }

    private PatternPart[] analyzePattern() {
        ArrayList<PatternPart> results = new ArrayList<PatternPart>();
        char[] srcbuff = this.m_sPattern.toCharArray();
        StringBuffer sb = new StringBuffer(16);
        char temp = '\u0000';
        int nFlag = 0;
        for (int i = 0; i < srcbuff.length; ++i) {
            PatternPart t;
            temp = srcbuff[i];
            if (temp == '$' && i + 1 < srcbuff.length && srcbuff[i + 1] == '{') {
                if (nFlag == 0 && sb.length() > 0) {
                    t = new PatternPart(sb.toString(), true);
                    results.add(t);
                    sb.setLength(0);
                }
                ++i;
                ++nFlag;
                continue;
            }
            if (temp == '}' && nFlag > 0) {
                --nFlag;
                t = new PatternPart(sb.toString(), false);
                results.add(t);
                sb.setLength(0);
                continue;
            }
            sb.append(temp);
        }
        if (sb.length() > 0) {
            results.add(new PatternPart(sb.toString(), true));
        }
        PatternPart[] parts = new PatternPart[results.size()];
        return results.toArray(parts);
    }

    private String getSysVariableValue(String variable) {
        String var = variable.substring(2, variable.length());
        String value = "";
        if ("user".equalsIgnoreCase(var)) {
            value = this.getInfogateUserName();
            if (CMyString.isEmpty(value) && CMyString.isEmpty(value = this.getCurrentUser().getTrueName())) {
                value = this.getCurrentUser().getName();
            }
        } else {
            String format = "yyyyMMdd";
            if (var.indexOf(",") != -1) {
                format = var.substring(var.indexOf(",") + 1, var.length());
            }
            if (CMyString.isEmpty(value = CMyDateTime.now().toString(format))) {
                value = CMyDateTime.now().toString("yyyyMMdd");
            }
        }
        return value;
    }

    public static void main(String[] args) {
    }

    private class PatternPart {
        public String name;
        public boolean isconstant;

        public PatternPart(String name, boolean isconstant) {
            this.name = name;
            this.isconstant = isconstant;
        }
    }
}

