/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.widget.tagparser;

import com.trs.DreamFactory;
import com.trs.components.common.publish.domain.publisher.PublishPathCompass;
import com.trs.components.common.publish.domain.publisher.PublishSyncGlobalTuner;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.tagparser.BaseTagParser;
import com.trs.components.common.publish.domain.tagparser.TagBeanAttrInfo;
import com.trs.components.common.publish.domain.tagparser.TagBeanInfo;
import com.trs.components.common.publish.domain.tagparser.TagItem;
import com.trs.components.common.publish.domain.tagparser.TagParseHelper;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.widget.IPageStyleMgr;
import com.trs.components.common.publish.widget.PageStyle;
import com.trs.components.common.publish.widget.PageStyles;
import com.trs.components.common.publish.widget.StylePathHelper;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.html.HtmlUtil;
import com.trs.infra.util.store.FileService;
import java.io.File;

public class WCMTagParserPageStyle
extends BaseTagParser {
    private IPageStyleMgr m_oPageStyleMgr = (IPageStyleMgr)DreamFactory.createObjectById("IPageStyleMgr");
    private static TagBeanInfo s_TagBeanInfo = null;
    private String m_sCssFilePath4EditMode = "/template/style/";
    private String m_sPageStyleRootPathRange = "images/style/";

    @Override
    public TagBeanInfo getBeanInfo() {
        if (s_TagBeanInfo == null) {
            TagBeanAttrInfo tbai = null;
            TBI tbi = new TBI();
            tbi.setName("TRS_PageStyle");
            tbi.setDesc("TRS_PageStyle");
            tbi.setType(TagBeanInfo.BodyType.IGNORE);
            tbai = new TagBeanAttrInfo();
            tbai.setName("ID");
            tbai.setType(TagBeanAttrInfo.Type.INTEGER);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("NAME");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("URLISABS");
            tbai.setEnumValue(new String[]{"true", "false"});
            tbai.setDefaultValue("false");
            tbi.addAttrInfo(tbai);
            s_TagBeanInfo = tbi;
        }
        return s_TagBeanInfo;
    }

    @Override
    public String[] parse(PublishTagContext _context) throws WCMException {
        String sLinkUrlComposite;
        String sLinkUrl;
        int nStyleId = _context.getAttribute("ID", 0);
        String sStyleName = _context.getAttribute("NAME");
        PageStyle oPageStyle = null;
        if (nStyleId > 0) {
            oPageStyle = PageStyle.findById(nStyleId);
        }
        if (oPageStyle == null && !CMyString.isEmpty(sStyleName)) {
            oPageStyle = PageStyle.findByName(sStyleName);
        }
        if (oPageStyle == null) {
            return null;
        }
        sStyleName = oPageStyle.getStyleName();
        if (CMyString.isEmpty(sStyleName)) {
            return null;
        }
        IPublishElement publishElement = _context.getPageElement();
        if (publishElement == null) {
            return null;
        }
        this.distributeStyles(_context);
        boolean bUrlIsAbs = "TRUE".equalsIgnoreCase(_context.getAttribute("URLISABS"));
        PublishPathCompass compass = _context.getPathCompass();
        if (bUrlIsAbs) {
            boolean bPreview = _context.isPreview();
            if (bPreview) {
                sLinkUrl = compass.getPreviewHttpPath(_context.getRoot()) + this.m_sPageStyleRootPathRange + "style_css" + "/" + sStyleName + ".css";
                sLinkUrlComposite = compass.getPreviewHttpPath(_context.getRoot()) + this.m_sPageStyleRootPathRange + "style_css" + "/" + sStyleName + "_composite.css";
            } else {
                sLinkUrl = compass.getAbsoluteHttpPath(_context.getRoot()) + this.m_sPageStyleRootPathRange + "style_css" + "/" + sStyleName + ".css";
                sLinkUrlComposite = compass.getAbsoluteHttpPath(_context.getRoot()) + this.m_sPageStyleRootPathRange + "style_css" + "/" + sStyleName + "_composite.css";
            }
        } else if (TagParseHelper.isVisualParseMode(_context)) {
            sLinkUrl = this.m_sCssFilePath4EditMode + "style_css" + "/" + sStyleName + ".css";
            sLinkUrlComposite = this.m_sCssFilePath4EditMode + "style_css" + "/" + sStyleName + "_composite.css";
        } else {
            sLinkUrl = HtmlUtil.calRelativePath(compass.getAbsoluteHttpPath(_context.getRoot()), compass.getAbsoluteHttpPath(publishElement));
            sLinkUrlComposite = sLinkUrl + this.m_sPageStyleRootPathRange + "style_css" + "/" + sStyleName + "_composite.css";
            sLinkUrl = sLinkUrl + this.m_sPageStyleRootPathRange + "style_css" + "/" + sStyleName + ".css";
        }
        StringBuffer buffer = new StringBuffer();
        long lCSSVersion = oPageStyle.getCssVersion();
        buffer.append(this.appendCssLinkHtml(sLinkUrlComposite + "?RanDom=" + lCSSVersion, oPageStyle.getId(), true));
        buffer.append(this.appendCssLinkHtml(sLinkUrl + "?RanDom=" + lCSSVersion, oPageStyle.getId(), false));
        return new String[]{buffer.toString()};
    }

    private String appendCssLinkHtml(String _pageStylePath, int _pageStyleId, boolean _isComposite) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<link href=\"" + _pageStylePath + "\"");
        if (_isComposite) {
            buffer.append(" id=\"pagestylecss_composite\"");
        } else {
            buffer.append(" id=\"pagestylecss\"");
        }
        buffer.append(" pagestyleid=\"").append(_pageStyleId).append("\"");
        buffer.append(" rel=\"stylesheet\" ");
        buffer.append(" type=\"text/css\" />");
        return buffer.toString();
    }

    private void distributeStyles(PublishTagContext context) throws WCMException {
        boolean bNeedCopySystem = false;
        PageStyles oPageStyles = this.m_oPageStyleMgr.query(null);
        int nSize = oPageStyles.size();
        for (int i = 0; i < nSize; ++i) {
            PageStyle oPageStyle = (PageStyle)oPageStyles.getAt(i);
            if (oPageStyle == null || !this.distributeStyle(context, oPageStyle)) continue;
            bNeedCopySystem = true;
        }
        if (bNeedCopySystem) {
            this.copyPictureResource(context, "default");
        }
    }

    private boolean distributeStyle(PublishTagContext context, PageStyle oPageStyle) throws WCMException {
        String sStyleName = oPageStyle.getStyleName();
        if (CMyString.isEmpty(sStyleName)) {
            return false;
        }
        String sSrcPageStyleCssPath = StylePathHelper.getStyleCssDir();
        String sSrcPageStyleCssFileAbsPath = sSrcPageStyleCssPath + sStyleName + ".css";
        String sSrcPageStyleCompsiteCssFileAbsPath = sSrcPageStyleCssPath + sStyleName + "_composite.css";
        PublishPathCompass compass = context.getPathCompass();
        String sSiteRootPath = compass.getLocalPath(context.getRoot(), context.isPreview());
        sSiteRootPath = CMyString.setStrEndWith(sSiteRootPath, File.separatorChar);
        String sPageStyleRootPath = sSiteRootPath + this.m_sPageStyleRootPathRange.replace('/', File.separatorChar);
        String sDestPageStyleCssPath = sPageStyleRootPath + "style_css";
        String sDestPageStyleCssFileAbsPath = sDestPageStyleCssPath + File.separatorChar + sStyleName + ".css";
        String sDestPageStyleCompositeCssFileAbsPath = sDestPageStyleCssPath + File.separatorChar + sStyleName + "_composite.css";
        if (!this.isNeedCopy(sSrcPageStyleCssFileAbsPath, sDestPageStyleCssFileAbsPath) && !this.isNeedCopy(sSrcPageStyleCompsiteCssFileAbsPath, sDestPageStyleCompositeCssFileAbsPath)) {
            return false;
        }
        PublishSyncGlobalTuner.insureLocalPathExists(sDestPageStyleCssPath);
        try {
            CMyFile.copyFile(sSrcPageStyleCssFileAbsPath, sDestPageStyleCssFileAbsPath);
            CMyFile.copyFile(sSrcPageStyleCompsiteCssFileAbsPath, sDestPageStyleCompositeCssFileAbsPath);
        }
        catch (CMyException e) {
            e.printStackTrace();
        }
        if (!context.isPreview()) {
            context.getFileDistributeShip().distributeFile(sSrcPageStyleCssFileAbsPath, context.getRoot(), this.m_sPageStyleRootPathRange + "style_css", false);
            context.getFileDistributeShip().distributeFile(sSrcPageStyleCompsiteCssFileAbsPath, context.getRoot(), this.m_sPageStyleRootPathRange + "style_css", false);
        }
        this.copyPictureResource(context, sStyleName);
        return true;
    }

    private void copyPictureResource(PublishTagContext context, String sStyleName) throws WCMException {
        PublishPathCompass compass = context.getPathCompass();
        String sSiteRootPath = compass.getLocalPath(context.getRoot(), context.isPreview());
        sSiteRootPath = CMyString.setStrEndWith(sSiteRootPath, File.separatorChar);
        String sPageStyleRootPath = sSiteRootPath + this.m_sPageStyleRootPathRange.replace('/', File.separatorChar);
        String sSrcPageStyleCommonPath = StylePathHelper.getStyleCommonDir() + sStyleName;
        String sDestPageStyleCommonPath = sPageStyleRootPath + "style_common";
        try {
            CMyFile.copyFileDir(sSrcPageStyleCommonPath, sDestPageStyleCommonPath, true);
        }
        catch (CMyException e) {
            e.printStackTrace();
        }
        if (!context.isPreview()) {
            context.getFileDistributeShip().distributeFileDir(sSrcPageStyleCommonPath, context.getRoot(), this.m_sPageStyleRootPathRange + "style_common" + "/" + sStyleName, true);
        }
    }

    private boolean isNeedCopy(String _sSrcFileAbsPath, String _sDestFileAbsPath) throws WCMException {
        if (!CMyFile.fileExists(_sSrcFileAbsPath)) {
            return false;
        }
        if (!CMyFile.fileExists(_sDestFileAbsPath)) {
            return true;
        }
        FileService srcFile = new FileService(_sSrcFileAbsPath);
        FileService destFile = new FileService(_sDestFileAbsPath);
        return srcFile.lastModified() > destFile.lastModified();
    }

    private class TBI
    extends TagBeanInfo {
        @Override
        public void checkSemantic(IPublishFolder _folder, TagItem _tagItem, StringBuffer _sbResult) {
        }
    }
}

