/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.widget;

import com.trs.DreamFactory;
import com.trs.ajaxservice.WCMAJAXServiceHelper;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.publish.widget.IWidgetParameterMgr;
import com.trs.components.common.publish.widget.IWidgetParameterServiceProvider;
import com.trs.components.common.publish.widget.SpecialAuthServer;
import com.trs.components.common.publish.widget.Widget;
import com.trs.components.common.publish.widget.WidgetParameter;
import com.trs.components.common.publish.widget.WidgetParameters;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyString;
import com.trs.webframework.context.MethodContext;

public class WidgetParameterServiceProvider
implements IWidgetParameterServiceProvider {
    private IWidgetParameterMgr m_oIWidgetParameterMgr = (IWidgetParameterMgr)DreamFactory.createObjectById("IWidgetParameterMgr");

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    @Override
    public void delete(MethodContext _context) throws Exception {
        String sWigetParameterIds;
        User loginUser = this.getLoginUser();
        WidgetParameters oWidgetParameters = WidgetParameters.findByIds(loginUser, sWigetParameterIds = _context.getObjectIds());
        if (oWidgetParameters == null || oWidgetParameters.size() == 0) {
            throw new WCMException(200006, "\u6ca1\u6709\u8981\u5220\u9664\u7684\u8d44\u6e90\u53d8\u91cf.");
        }
        int nSize = oWidgetParameters.size();
        for (int i = 0; i < nSize; ++i) {
            WidgetParameter currWidgetParameter = (WidgetParameter)oWidgetParameters.getAt(i);
            if (currWidgetParameter == null) continue;
            boolean bHasRight = SpecialAuthServer.hasRight(loginUser, currWidgetParameter, 23);
            if (!bHasRight) {
                throw new WCMException("\u60a8\u6ca1\u6709\u6743\u9650\u5220\u9664\u8d44\u6e90\u53d8\u91cf[" + currWidgetParameter.getWidgetParamDesc() + "]\u3002");
            }
            this.m_oIWidgetParameterMgr.delete(loginUser, currWidgetParameter);
        }
    }

    @Override
    public Object query(MethodContext _context) throws Exception {
        User loginUser = this.getLoginUser();
        int nWidgetId = _context.getValue("WidgetId", 0);
        if (nWidgetId <= 0) {
            return WidgetParameters.createNewInstance(loginUser);
        }
        WCMFilter oFilter = new WCMFilter(_context.getQueryFilter());
        WidgetParameters oWidgetParameters = this.m_oIWidgetParameterMgr.query(loginUser, oFilter);
        for (int i = oWidgetParameters.size() - 1; i >= 0; --i) {
            boolean bHasRight;
            WidgetParameter oWidgetParameter = (WidgetParameter)oWidgetParameters.getAt(i);
            if (oWidgetParameter == null || (bHasRight = SpecialAuthServer.hasRight(loginUser, oWidgetParameter, 24))) continue;
            oWidgetParameters.remove(oWidgetParameter, false);
        }
        return oWidgetParameters;
    }

    @Override
    public int save(MethodContext _context) throws Exception {
        User loginUser = this.getLoginUser();
        int nWidgetParameterId = _context.getObjectId();
        WidgetParameter oWidgetParameter = null;
        if (nWidgetParameterId > 0) {
            oWidgetParameter = WidgetParameter.findById(nWidgetParameterId);
        } else {
            oWidgetParameter = new WidgetParameter();
            int nWidgetId = _context.getValue("WidgetId", 0);
            oWidgetParameter.setWidgetId(nWidgetId);
        }
        int nRightIndex = nWidgetParameterId > 0 ? 22 : 21;
        boolean bHasRight = SpecialAuthServer.hasRight(loginUser, oWidgetParameter, nRightIndex);
        if (!bHasRight) {
            throw new WCMException("\u60a8\u6ca1\u6709\u6743\u9650" + (nWidgetParameterId > 0 ? "\u4fee\u6539\u8d44\u6e90\u53d8\u91cf[" + oWidgetParameter.getWidgetParamDesc() + "]\u3002" : "\u65b0\u5efa\u8d44\u6e90\u53d8\u91cf\uff01"));
        }
        String[] pLogicFields = new String[]{"WidgetParameterId", "WidgetId"};
        oWidgetParameter = (WidgetParameter)WCMAJAXServiceHelper.setWCMObjectProperties(loginUser, _context, oWidgetParameter, pLogicFields);
        this.m_oIWidgetParameterMgr.saveWidgetParameter(loginUser, oWidgetParameter);
        return oWidgetParameter.getId();
    }

    @Override
    public boolean existsSimilarName(MethodContext context) throws Exception {
        WCMFilter existFilter = new WCMFilter("XWCMWIDGETPARAMETER", "WIDGETID=? AND WIDGETPARAMNAME=? and WIDGETPARAMETERID<>?", "", "WIDGETPARAMETERID");
        String sParameterName = CMyString.showNull(context.getValue("widgetParamName"));
        existFilter.addSearchValues(context.getValue("widgetId"));
        existFilter.addSearchValues(sParameterName.toUpperCase());
        existFilter.addSearchValues(context.getObjectId());
        return DBManager.getDBManager().sqlExecuteIntQuery(existFilter) > 0;
    }

    @Override
    public Object findById(MethodContext context) throws Throwable {
        return null;
    }

    @Override
    public Object findByIds(MethodContext context) throws Throwable {
        return null;
    }

    @Override
    public void changeOrder(MethodContext context) throws Exception {
        Widget srcWidget;
        int srcObjectId = context.getValue("srcObjectId", 0);
        WidgetParameter srcObject = WidgetParameter.findById(srcObjectId);
        if (srcObject == null) {
            throw new WCMException("\u6ca1\u6709\u627e\u5230\u8d44\u6e90[id=" + srcObjectId + "]\u7684\u8d44\u6e90\u53d8\u91cf");
        }
        User loginUser = this.getLoginUser();
        if (!SpecialAuthServer.hasRight(loginUser, srcWidget = Widget.findById(srcObject.getWidgetId()), 22)) {
            throw new WCMException("\u60a8\u6ca1\u6709\u6743\u9650\u4fee\u6539\u8d44\u6e90\u53d8\u91cf[" + srcObject.getWidgetParamDesc() + "]");
        }
        int dstObjectId = context.getValue("dstObjectId", 0);
        WidgetParameter dstObject = null;
        if (dstObjectId > 0) {
            dstObject = WidgetParameter.findById(dstObjectId);
        }
        int nNewOrder = dstObject == null ? -1 : dstObject.getOrder();
        srcObject.setOrder(nNewOrder);
        this.m_oIWidgetParameterMgr.saveWidgetParameter(loginUser, srcObject);
    }
}

