/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.widget;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.publish.widget.IWidgetMgr;
import com.trs.components.common.publish.widget.IWidgetParameterMgr;
import com.trs.components.common.publish.widget.Widget;
import com.trs.components.common.publish.widget.WidgetConstants;
import com.trs.components.common.publish.widget.WidgetParameter;
import com.trs.components.common.publish.widget.WidgetParameters;
import com.trs.components.common.publish.widget.WidgetPathHelper;
import com.trs.components.common.publish.widget.WidgetXmlConverter;
import com.trs.components.common.publish.widget.Widgets;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.XmlObject;
import com.trs.infra.persistent.XmlToObjConverter;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.CMyUnZipFile;
import com.trs.infra.util.CMyZip;
import com.trs.infra.util.Reports;
import com.trs.infra.util.store.FileService;
import java.io.File;
import java.util.ArrayList;

public class WidgetMgr
implements IWidgetMgr {
    private Reports m_importReports;
    private static WidgetXmlConverter m_WidgetXmlConverter = null;
    private XmlToObjConverter m_converter = null;
    private IWidgetParameterMgr m_oIWidgetParameterMgr = null;
    private static final String Tag_WidgetParameters = "XWCMWIDGETPARAMETERS";
    private ThreadLocal m_oThreadLocal4ExistSimilarWidget = new ThreadLocal();

    public WidgetMgr() {
        m_WidgetXmlConverter = new WidgetXmlConverter();
        this.m_converter = new XmlToObjConverter(1);
        this.m_oIWidgetParameterMgr = (IWidgetParameterMgr)DreamFactory.createObjectById("IWidgetParameterMgr");
        this.registerConverter();
    }

    private void registerConverter() {
        this.m_converter.registPersistentObj("XWCMWIDGET", Widget.class);
        this.m_converter.registPersistentObj("XWCMWIDGETPARAMETER", WidgetParameter.class);
        this.m_converter.registPersistentObj(Tag_WidgetParameters, WidgetParameters.class);
    }

    @Override
    public boolean delete(User _oCurrUser, Widget _oCurrWidget) throws Exception {
        WidgetParameters oWidgetParameters = this.m_oIWidgetParameterMgr.query(_oCurrWidget);
        int nSize = oWidgetParameters.size();
        for (int i = 0; i < nSize; ++i) {
            WidgetParameter oWidgetParameter = (WidgetParameter)oWidgetParameters.getAt(i);
            if (oWidgetParameter == null) continue;
            this.m_oIWidgetParameterMgr.delete(_oCurrUser, oWidgetParameter);
        }
        return _oCurrWidget.delete(_oCurrUser) == 1;
    }

    @Override
    public Widgets query(User _oCurrUser, WCMFilter _oFilter) throws Exception {
        Widgets oWidgets = Widgets.openWCMObjs(_oCurrUser, _oFilter);
        return oWidgets;
    }

    @Override
    public Widget saveWidget(User _oCurrUser, Widget _oCurrWidget) throws Exception {
        String sNewPic;
        String sWidgetName;
        if (_oCurrWidget == null) {
            throw new WCMException(200006, "\u65e0\u6548\u7684Widget\u5bf9\u8c61\uff0c\u65e0\u6cd5\u4fdd\u5b58.");
        }
        boolean bAddMode = _oCurrWidget.isAddMode();
        String string = sWidgetName = _oCurrWidget.isAddMode() ? _oCurrWidget.getPropertyAsString("WNAME") : _oCurrWidget.getNewPropertyAsString("WNAME");
        if (this.existSimilarWidget(_oCurrWidget)) {
            throw new WCMException(1008, "\u5df2\u7ecf\u5b58\u5728\u540d\u79f0\u4e3a[" + sWidgetName + "]\u7684\u8d44\u6e90.");
        }
        if (bAddMode) {
            String sPicFileName = _oCurrWidget.getWidgetpic();
            if (!CMyString.isEmpty(sPicFileName)) {
                _oCurrWidget.setWidgetpic(this.copyFileToWebpic(sPicFileName));
            }
        } else if (_oCurrWidget.isChangeProperty("WIDGETPIC") && !CMyString.isEmpty(sNewPic = _oCurrWidget.getNewPropertyAsString("WIDGETPIC"))) {
            _oCurrWidget.setWidgetpic(this.copyFileToWebpic(sNewPic));
        }
        _oCurrWidget.save(_oCurrUser);
        this.saveInherentParam(_oCurrUser, _oCurrWidget, bAddMode);
        return _oCurrWidget;
    }

    private void saveInherentParam(User _oCurrUser, Widget _oCurrWidget, boolean isAddMode) throws WCMException {
        if (_oCurrWidget == null) {
            throw new WCMException(200006, "\u65e0\u6548\u7684Widget\u5bf9\u8c61\uff0c\u65e0\u6cd5\u4fdd\u5b58.");
        }
        for (int i = 0; i < WidgetConstants.FIEXED_PARAMETERS.length; ++i) {
            String sDBParamName;
            String sDefaultValue;
            WidgetParameter oWidgetParameter;
            String sParamName = WidgetConstants.FIEXED_PARAMETERS[i][0];
            if (isAddMode) {
                oWidgetParameter = new WidgetParameter();
                oWidgetParameter.setWidgetId(_oCurrWidget.getId());
                oWidgetParameter.setWidgetParamName(sParamName);
                oWidgetParameter.setWidgetParamDesc(WidgetConstants.FIEXED_PARAMETERS[i][1]);
                oWidgetParameter.setWidgetParamType(Integer.parseInt(WidgetConstants.FIEXED_PARAMETERS[i][2]));
                oWidgetParameter.setNotnull(Integer.parseInt(WidgetConstants.FIEXED_PARAMETERS[i][3]));
            } else {
                oWidgetParameter = this.m_oIWidgetParameterMgr.findParameterByName(_oCurrWidget, sParamName);
            }
            if (oWidgetParameter == null) {
                oWidgetParameter = new WidgetParameter();
                oWidgetParameter.setWidgetId(_oCurrWidget.getId());
                oWidgetParameter.setWidgetParamName(sParamName);
                oWidgetParameter.setWidgetParamDesc(WidgetConstants.FIEXED_PARAMETERS[i][1]);
                oWidgetParameter.setWidgetParamType(Integer.parseInt(WidgetConstants.FIEXED_PARAMETERS[i][2]));
                oWidgetParameter.setNotnull(Integer.parseInt(WidgetConstants.FIEXED_PARAMETERS[i][3]));
            }
            if (CMyString.isEmpty(sDefaultValue = WidgetConstants.FIEXED_PARAMETERS[i][4]) && !CMyString.isEmpty(sDBParamName = WidgetConstants.FIEXED_PARAMETERS[i][5])) {
                sDefaultValue = _oCurrWidget.getPropertyAsString(sDBParamName);
            }
            oWidgetParameter.setDefaultValue(CMyString.showNull(sDefaultValue));
            this.m_oIWidgetParameterMgr.saveWidgetParameter(_oCurrUser, oWidgetParameter);
        }
    }

    public boolean existSimilarWidget(Widget _oCurrWidget) throws WCMException {
        Widgets oWidgets;
        boolean bAddMode = _oCurrWidget.isAddMode();
        String sWidgetName = null;
        sWidgetName = bAddMode ? _oCurrWidget.getPropertyAsString("WNAME") : _oCurrWidget.getNewPropertyAsString("WNAME");
        if (CMyString.isEmpty(sWidgetName)) {
            return false;
        }
        String sWhere = "WNAME=?";
        if (!bAddMode) {
            sWhere = sWhere + " AND WIDGETID<>?";
        }
        WCMFilter oFilter = new WCMFilter("XWCMWIDGET", sWhere, "", "WIDGETID");
        int nWidgetId = _oCurrWidget.getId();
        oFilter.addSearchValues(sWidgetName);
        if (!bAddMode) {
            oFilter.addSearchValues(nWidgetId);
        }
        return (oWidgets = Widgets.openWCMObjs(ContextHelper.getLoginUser(), oFilter)).size() > 0;
    }

    private String copyFileToWebpic(String _sFileName) throws WCMException {
        FilesMan filesMan = FilesMan.getFilesMan();
        String sFileFlag = filesMan.getFileFlag(_sFileName);
        String sNewFileName = _sFileName;
        if (sFileFlag != "W0") {
            sNewFileName = filesMan.copyWCMFile(_sFileName, "W0");
        }
        return sNewFileName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String export(Widgets _oWidgets) throws WCMException {
        FilesMan aFilesMan = FilesMan.getFilesMan();
        String sPathName = aFilesMan.getNextFilePathName("ST", "zip");
        CMyZip oCMyZip = new CMyZip();
        String sXmlFile = null;
        try {
            oCMyZip.setEncoding("utf-8");
            oCMyZip.setZipFileName(sPathName);
            sXmlFile = aFilesMan.getNextFileName("ST", "xml", null, true);
            m_WidgetXmlConverter.toXMLFile(_oWidgets, sXmlFile);
            oCMyZip.addToZip(sXmlFile, false);
            int nSize = _oWidgets.size();
            for (int i = 0; i < nSize; ++i) {
                String sWidgetThumbs;
                Widget currWidget = (Widget)_oWidgets.getAt(i);
                if (currWidget == null || CMyString.isEmpty(sWidgetThumbs = CMyString.showNull(currWidget.getWidgetpic()))) continue;
                String sFullFileName = this.getFullName(sWidgetThumbs);
                oCMyZip.addToZip(sFullFileName, false);
                String sIdentityName = currWidget.getIdentityFlag(currWidget.getWname());
                String sRelateJsPath = WidgetPathHelper.getPath();
                String sFullName = sRelateJsPath + sIdentityName + ".js";
                if (!CMyFile.fileExists(sFullName)) continue;
                oCMyZip.addToZip(sFullName, false);
            }
            oCMyZip.done();
        }
        catch (CMyException ex) {
            try {
                aFilesMan.deleteFile(sPathName);
                throw new WCMException(1100, "\u5bfc\u51fa\u8d44\u6e90\u65f6\uff0c\u538b\u7f29\u6587\u4ef6\u5931\u8d25.", ex);
            }
            catch (Throwable throwable) {
                try {
                    CMyFile.deleteFile(sXmlFile);
                    throw throwable;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
        }
        try {
            CMyFile.deleteFile(sXmlFile);
            return CMyFile.extractFileName(sPathName);
        }
        catch (Exception e) {
            e.printStackTrace();
            return CMyFile.extractFileName(sPathName);
        }
    }

    @Override
    public Reports importWidgets(String _sFile, int _nImportMode) throws WCMException {
        this.m_importReports = new Reports("");
        if (CMyString.isEmpty(_sFile)) {
            throw new WCMException(10, "\u6587\u4ef6\u4e3a\u7a7a.");
        }
        String sFullFile = this.getFullName(_sFile);
        String sUnZipPath = CMyFile.extractFilePath(sFullFile) + "unzip" + System.currentTimeMillis();
        sUnZipPath = CMyString.setStrEndWith(sUnZipPath, File.separatorChar);
        CMyUnZipFile uzf = new CMyUnZipFile(sFullFile, sUnZipPath);
        uzf.addFileExtFilters("xml");
        try {
            uzf.doUnZipAnd();
        }
        catch (CMyException e) {
            throw new WCMException(200, "\u89e3\u538b\u7f29\u6587\u4ef6\u5931\u8d25.", e);
        }
        ArrayList xmlFiles = uzf.getFilteredFiles();
        if (xmlFiles == null) {
            throw new WCMException(10, "\u5bfc\u5165\u7684zip\u5305\u4e2d\u6ca1\u6709\u6709\u6548\u7684\u63cf\u8ff0\u8d44\u6e90\u4fe1\u606f\u7684xml\u6587\u4ef6.");
        }
        String xmlFile = null;
        for (int i = 0; i < xmlFiles.size(); ++i) {
            xmlFile = (String)xmlFiles.get(i);
            XmlObject[] xmlObjects = this.convertXmlFile(xmlFile);
            this.importWidgets(xmlObjects, sUnZipPath, _nImportMode);
        }
        this.m_importReports.setTitle("\u4eceZip\u6587\u4ef6\u4e2d\u5bfc\u5165\u8d44\u6e90");
        CMyFile.deleteDir(sUnZipPath);
        return this.m_importReports;
    }

    private void importWidgets(XmlObject[] _xmlObjects, String sUnZipPath, int _nImportMode) throws WCMException {
        int[] resultIds = new int[_xmlObjects.length];
        for (int i = 0; i < _xmlObjects.length; ++i) {
            Widget result = this.importWidgetInfo(_xmlObjects[i], sUnZipPath, _nImportMode);
            if (result == null) continue;
            resultIds[i] = result.getId();
        }
        this.m_importReports.setResultIds(resultIds);
    }

    private Widget importWidgetInfo(XmlObject _xmlObject, String sUnZipPath, int _nImportMode) throws WCMException {
        if (_xmlObject == null) {
            throw new WCMException(20, "\u65e0\u6548\u7684\u8d44\u6e90\u63cf\u8ff0xml\u6587\u4ef6.");
        }
        BaseObj currObj = _xmlObject.getCurrentObj();
        Widget oWidget = null;
        try {
            oWidget = (Widget)currObj;
            String sWidgetName = oWidget.getWname();
            oWidget.setNextId();
            this.m_oThreadLocal4ExistSimilarWidget.set(Boolean.FALSE);
            if (this.existSimilarWidget(oWidget)) {
                this.m_oThreadLocal4ExistSimilarWidget.set(Boolean.TRUE);
                if (_nImportMode == 1) {
                    this.WidgetThumbsHandler(oWidget, sUnZipPath);
                    this.WidgetOwnerJsHandler(oWidget, sUnZipPath);
                    Widget oldWidget = this.findWidgetByName(ContextHelper.getLoginUser(), sWidgetName);
                    int nOldWidgetId = oldWidget.getId();
                    oldWidget.setNewProperties(oWidget.getAllProperty());
                    oldWidget.setProperty("WIDGETID", nOldWidgetId);
                    oldWidget.setProperty("CrUser", ContextHelper.getLoginUser().getName());
                    oldWidget.setProperty("CrTime", CMyDateTime.now());
                    oldWidget.save(ContextHelper.getLoginUser());
                    this.importWidgetParameters(oldWidget, _xmlObject, _nImportMode);
                    this.m_importReports.addSucessedReport("\u5bfc\u5165\u8d44\u6e90[" + oldWidget.getWname() + "]\u6210\u529f.");
                    return oldWidget;
                }
                if (_nImportMode == 3) {
                    this.changeWidgetName(oWidget, sUnZipPath);
                } else if (_nImportMode == 2) {
                    WCMException e = new WCMException("\u5df2\u5b58\u5728\u540d\u79f0\u4e3a[" + sWidgetName + "]\u7684\u8d44\u6e90,\u5ffd\u7565\u8be5\u5bfc\u5165");
                    this.m_importReports.addFailedReport("\u5df2\u7ecf\u5b58\u5728\u540c\u540d\u7684\u8d44\u6e90\uff0c\u60a8\u9009\u62e9\u4e86\u5ffd\u7565\u5904\u7406\uff0c\u6240\u4ee5\u5ffd\u7565\u8be5\u8d44\u6e90[" + sWidgetName + "]\u7684\u5bfc\u5165", e);
                    return null;
                }
            }
            this.WidgetThumbsHandler(oWidget, sUnZipPath);
            this.WidgetOwnerJsHandler(oWidget, sUnZipPath);
        }
        catch (Exception ex) {
            this.m_importReports.addFailedReport("\u5bfc\u5165\u8d44\u6e90\u5931\u8d25.", ex);
            return null;
        }
        try {
            oWidget.setCrUser(ContextHelper.getLoginUser());
            oWidget.setProperty("CrTime", CMyDateTime.now());
            this.saveWidget(ContextHelper.getLoginUser(), oWidget);
        }
        catch (Exception ex) {
            this.m_importReports.addFailedReport("\u5bfc\u5165\u8d44\u6e90[" + oWidget.getWname() + "]\u5931\u8d25.", ex);
            return null;
        }
        try {
            this.importWidgetParameters(oWidget, _xmlObject, _nImportMode);
        }
        catch (Exception ex) {
            this.m_importReports.addFailedReport("\u5bfc\u5165\u8d44\u6e90[" + oWidget.getWname() + "]\u5931\u8d25.", ex);
            return null;
        }
        this.m_importReports.addSucessedReport("\u5bfc\u5165\u8d44\u6e90[" + oWidget.getWname() + "]\u6210\u529f.");
        return oWidget;
    }

    private void WidgetOwnerJsHandler(Widget widget, String unZipPath) throws WCMException {
        try {
            String sIdentityName = widget.getIdentityFlag(widget.getWname());
            String sRelateJsPath = WidgetPathHelper.getPath();
            String sUnZipFileName = unZipPath + sIdentityName + ".js";
            String sRealFullName = sRelateJsPath + sIdentityName + ".js";
            if (CMyFile.fileExists(sUnZipFileName)) {
                CMyFile.copyFile(sUnZipFileName, sRealFullName);
            }
        }
        catch (Exception ex) {
            this.m_importReports.addFailedReport("\u62f7\u8d1d\u8d44\u6e90\u7684\u9644\u52a0\u5904\u7406Js\u65f6\u5931\u8d25.", ex);
        }
    }

    private void WidgetThumbsHandler(Widget oWidget, String sUnZipPath) throws WCMException {
        String sWidgetThumbs = CMyString.showNull(oWidget.getWidgetpic());
        FilesMan aFilesMan = FilesMan.getFilesMan();
        if (!CMyString.isEmpty(sWidgetThumbs)) {
            String sUnzipFullName = sUnZipPath + sWidgetThumbs;
            String sFullFileName = this.getFullName(sWidgetThumbs);
            String sExt = CMyFile.extractFileExt(sFullFileName);
            try {
                if (CMyFile.fileExists(sFullFileName)) {
                    String sNewFileName = aFilesMan.getNextFilePathName("W0", sExt);
                    CMyFile.copyFile(sUnzipFullName, sNewFileName);
                    oWidget.setWidgetpic(CMyFile.extractFileName(sNewFileName));
                } else {
                    CMyFile.copyFile(sUnzipFullName, sFullFileName);
                }
            }
            catch (Exception ex) {
                this.m_importReports.addFailedReport("\u62f7\u8d1d\u8d44\u6e90\u7684\u7f29\u7565\u56fe\u5931\u8d25.", ex);
            }
        }
    }

    private void importWidgetParameters(Widget _oWidget, XmlObject _xmlObject, int _nImportMode) throws WCMException {
        XmlObject[] widgetParameterObjs = _xmlObject.getChild(Tag_WidgetParameters);
        for (int i = 0; i < widgetParameterObjs.length; ++i) {
            this.importWidgetParameterInfo(_oWidget, widgetParameterObjs[i], _nImportMode);
        }
    }

    private void importWidgetParameterInfo(Widget _oWidget, XmlObject _xmlObject, int _nImportMode) throws WCMException {
        BaseObj currObj = _xmlObject.getCurrentObj();
        int nWidgetId = _oWidget.getId();
        WidgetParameter currWidgetParameter = (WidgetParameter)currObj;
        if (currWidgetParameter == null) {
            throw new WCMException(20, "\u65e0\u6548\u7684\u8d44\u6e90\u53d8\u91cf\u5bf9\u8c61.");
        }
        String sDefalutValue = currWidgetParameter.getDefaultValue();
        String sParameterName = currWidgetParameter.getWidgetParamName();
        boolean bIsHeadDisplay = WidgetConstants.FIEXED_PARAMETERS[2][0].equalsIgnoreCase(sParameterName);
        if (bIsHeadDisplay) {
            currWidgetParameter = this.findWidgetParamByName(nWidgetId, sParameterName);
            if (currWidgetParameter != null) {
                boolean bExistSimilar;
                boolean bl = bExistSimilar = this.m_oThreadLocal4ExistSimilarWidget.get() == Boolean.TRUE;
                if (_nImportMode != 1 || !bExistSimilar) {
                    currWidgetParameter.setDefaultValue(sDefalutValue);
                }
            }
        } else {
            currWidgetParameter.setNextId();
            if (this.m_oIWidgetParameterMgr.existWidgetParameter(_oWidget, currWidgetParameter)) {
                if (_nImportMode == 1) {
                    WidgetParameter oldWidgetParameter = this.findWidgetParamByName(nWidgetId, sParameterName);
                    if (oldWidgetParameter != null) {
                        String sOldDefaultValue = oldWidgetParameter.getDefaultValue();
                        int nOldWidgetParamType = oldWidgetParameter.getWidgetParamType();
                        boolean bSameType = nOldWidgetParamType == currWidgetParameter.getWidgetParamType();
                        int nOldWidgetParameterId = oldWidgetParameter.getId();
                        oldWidgetParameter.setNewProperties(currWidgetParameter.getAllProperty());
                        if (bSameType) {
                            oldWidgetParameter.setPropertyWithString("DEFAULTVALUE", sOldDefaultValue);
                        }
                        oldWidgetParameter.setProperty("WIDGETPARAMETERID", nOldWidgetParameterId);
                        oldWidgetParameter.setWidgetId(nWidgetId);
                        oldWidgetParameter.save();
                    }
                    return;
                }
                if (_nImportMode == 3) {
                    this.changeNameIfNescessary(_oWidget, currWidgetParameter);
                } else if (_nImportMode == 2) {
                    WCMException e = new WCMException("\u5df2\u5b58\u5728\u540d\u79f0\u4e3a[" + sParameterName + "]\u7684\u8d44\u6e90\u53d8\u91cf,\u5ffd\u7565\u8be5\u5bfc\u5165");
                    this.m_importReports.addFailedReport("\u5df2\u7ecf\u5b58\u5728\u540c\u540d\u7684\u8d44\u6e90\u53d8\u91cf\uff0c\u60a8\u9009\u62e9\u4e86\u5ffd\u7565\u5904\u7406\uff0c\u6240\u4ee5\u5ffd\u7565\u8be5\u8d44\u6e90\u53d8\u91cf[" + sParameterName + "]\u7684\u5bfc\u5165", e);
                    return;
                }
            }
            currWidgetParameter.setWidgetId(nWidgetId);
        }
        try {
            this.m_oIWidgetParameterMgr.saveWidgetParameter(ContextHelper.getLoginUser(), currWidgetParameter);
        }
        catch (Exception ex) {
            this.m_importReports.addWarnedReport("\u5bfc\u5165\u8d44\u6e90\u53d8\u91cf[" + currWidgetParameter.getWidgetParamName() + "]\u5931\u8d25.", ex);
        }
    }

    private WidgetParameter findWidgetParamByName(int _nWidgetId, String _sParamName) throws WCMException {
        String sWhere = "WIDGETID =? and WIDGETPARAMNAME=?";
        WCMFilter filter = new WCMFilter("XWCMWIDGETPARAMETER", sWhere, "", "");
        filter.addSearchValues(_nWidgetId);
        filter.addSearchValues(_sParamName);
        WidgetParameters currWidgetParameters = WidgetParameters.openWCMObjs(null, filter);
        return (WidgetParameter)(currWidgetParameters.size() > 0 ? currWidgetParameters.getAt(0) : null);
    }

    private void changeNameIfNescessary(Widget _oCurrWidget, WidgetParameter _oCurrWidgetParameter) throws WCMException {
        boolean bSimName = this.m_oIWidgetParameterMgr.existWidgetParameter(_oCurrWidget, _oCurrWidgetParameter);
        if (!bSimName) {
            return;
        }
        int nCount = 0;
        while (bSimName) {
            String sNewWidgetParameterName = _oCurrWidgetParameter.getWidgetParamName();
            sNewWidgetParameterName = sNewWidgetParameterName + nCount;
            _oCurrWidgetParameter.setWidgetParamName(sNewWidgetParameterName);
            ++nCount;
            bSimName = this.m_oIWidgetParameterMgr.existWidgetParameter(_oCurrWidget, _oCurrWidgetParameter);
        }
    }

    private void changeWidgetName(Widget _oCurrWidget, String _sUnZipPath) throws WCMException {
        int nCount = 1;
        boolean bSimName = this.existSimilarWidget(_oCurrWidget);
        String sNewWidgetName = _oCurrWidget.getWname();
        while (bSimName) {
            String sIdentityName = _oCurrWidget.getIdentityFlag(_oCurrWidget.getWname());
            String sOldFullName = _sUnZipPath + sIdentityName + ".js";
            sNewWidgetName = sNewWidgetName + "_" + _oCurrWidget.getId();
            _oCurrWidget.setPropertyWithString("Wname", sNewWidgetName);
            String sNewFullName = _sUnZipPath + _oCurrWidget.getIdentityFlag(sNewWidgetName) + ".js";
            FileService oldFile = new FileService(sOldFullName);
            if (oldFile.exists()) {
                FileService newFile = new FileService(sNewFullName);
                oldFile.renameTo(newFile);
            }
            ++nCount;
            bSimName = this.existSimilarWidget(_oCurrWidget);
            if (!bSimName) continue;
            this.changeWidgetName(_oCurrWidget, _sUnZipPath);
        }
    }

    private XmlObject[] convertXmlFile(String _sXmlFile) throws WCMException {
        try {
            XmlObject[] xmlObjects = this.m_converter.convertXml(_sXmlFile, null, null);
            return xmlObjects;
        }
        catch (Throwable t) {
            throw new WCMException(150, "\u8f6c\u6362XML\u6587\u4ef6\u5931\u8d25!\u4e0d\u662f\u4e00\u4e2a\u6709\u6548\u7684\u8d44\u6e90\u63cf\u8ff0xml\u6587\u4ef6", t);
        }
    }

    private String getFullName(String _sFile) throws WCMException {
        FilesMan filesMan = FilesMan.getFilesMan();
        if (!CMyFile.fileExists(_sFile)) {
            String sPath = filesMan.mapFilePath(_sFile, 0);
            _sFile = sPath + _sFile;
        }
        return _sFile;
    }

    @Override
    public Widget findWidgetByName(User _oCurrUser, String sWidgetName) throws WCMException {
        WCMFilter filter = new WCMFilter(null, "WNAME=?", "WIDGETID desc");
        filter.addSearchValues(sWidgetName);
        Widgets oWidgets = Widgets.openWCMObjs(_oCurrUser, filter);
        return oWidgets.size() > 0 ? (Widget)oWidgets.getAt(0) : null;
    }
}

