/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.widget;

import com.trs.DreamFactory;
import com.trs.cms.auth.domain.RoleMgr;
import com.trs.cms.auth.persistent.Group;
import com.trs.cms.auth.persistent.Groups;
import com.trs.cms.auth.persistent.RightValue;
import com.trs.cms.auth.persistent.Role;
import com.trs.cms.auth.persistent.RoleUserCacheMgr;
import com.trs.cms.auth.persistent.Roles;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.publish.widget.ContentStyle;
import com.trs.components.common.publish.widget.Layout;
import com.trs.components.common.publish.widget.Master;
import com.trs.components.common.publish.widget.PageStyle;
import com.trs.components.common.publish.widget.ResourceStyle;
import com.trs.components.common.publish.widget.Widget;
import com.trs.components.special.Special;
import com.trs.infra.common.WCMException;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class SpecialAuthServer {
    private static Logger logger;
    private static final int[] SPECIAL_INDEX_RANGE;
    public static final int SPECIAL_ADD = 1;
    public static final int SPECIAL_EDIT = 2;
    public static final int SPECIAL_DELETE = 3;
    public static final int SPECIAL_BROWSE = 4;
    public static final int SPECIAL_PUBLISH = 5;
    private static final int[] STYLE_INDEX_RANGE;
    public static final int STYLE_ADD = 11;
    public static final int STYLE_EDIT = 12;
    public static final int STYLE_DELETE = 13;
    public static final int STYLE_BROWSE = 14;
    private static final int[] WIDGET_INDEX_RANGE;
    public static final int WIDGET_ADD = 21;
    public static final int WIDGET_EDIT = 22;
    public static final int WIDGET_DELETE = 23;
    public static final int WIDGET_BROWSE = 24;
    private static final int[] EVERYONE_HAS_RIGHTINDEX;
    private static final String SPECIAL_ROLE = "\u4e13\u9898\u7ef4\u62a4\u4eba\u5458";
    private static final String SPECIAL_ROLE_FOR_SAME_GROUP = "\u540c\u7ec4\u7ec7\u4e0b\u4e13\u9898\u7ef4\u62a4\u4eba\u5458";
    private static final String STYLE_ROLE = "\u98ce\u683c\u7ef4\u62a4\u4eba\u5458";
    private static final String STYLE_ROLE_FOR_SAME_GROUP = "\u540c\u7ec4\u7ec7\u4e0b\u98ce\u683c\u7ef4\u62a4\u4eba\u5458";
    private static final String WIDGET_ROLE = "\u8d44\u6e90\u7ef4\u62a4\u4eba\u5458";
    private static final String WIDGET_ROLE_FOR_SAME_GROUP = "\u540c\u7ec4\u7ec7\u4e0b\u8d44\u6e90\u7ef4\u62a4\u4eba\u5458";
    private static Map objRoleMapping;
    private static Map objRoleMappingForSameGroup;
    private static Map objRightValueMapping;
    private static final RightValue EVERYONE_HAS_RIGHT_VALUE;
    private static final RightValue SPECIAL_RIGHT_VALUE;
    private static final RightValue WIDGET_RIGHT_VALUE;
    private static final RightValue STYLE_RIGHT_VALUE;

    public static boolean hasRight(CMSObj operator, CMSObj obj, int nRightIndex) throws WCMException {
        User oUser = (User)operator;
        if (oUser.isAdministrator()) {
            return true;
        }
        if (oUser.getName().equalsIgnoreCase(obj.getCrUserName())) {
            return true;
        }
        for (int i = 0; i < EVERYONE_HAS_RIGHTINDEX.length; ++i) {
            if (EVERYONE_HAS_RIGHTINDEX[i] != nRightIndex) continue;
            return true;
        }
        Role oRole = (Role)objRoleMapping.get(obj.getClass());
        if (oRole == null) {
            return true;
        }
        RoleUserCacheMgr roleUserCacheMgr = (RoleUserCacheMgr)DreamFactory.createObjectById("RoleUserCacheMgr");
        Roles oRoles = roleUserCacheMgr.getRoles(oUser, null);
        if (oRoles.indexOf(oRole.getId()) >= 0) {
            return true;
        }
        Role oRoleForSameGroup = (Role)objRoleMappingForSameGroup.get(obj.getClass());
        if (oRoleForSameGroup == null) {
            return false;
        }
        if (oRoles.indexOf(oRoleForSameGroup.getId()) < 0) {
            return false;
        }
        if (obj.isAddMode()) {
            return true;
        }
        return SpecialAuthServer.isInSameParentGroup(oUser, obj.getCrUser());
    }

    private static boolean isInSameParentGroup(User _oOperator, User _oCrUser) throws WCMException {
        Groups groupsOfCrUser = Groups.createNewInstance(null);
        if (_oCrUser != null) {
            groupsOfCrUser = _oCrUser.getGroups();
        }
        if (groupsOfCrUser == null || groupsOfCrUser.size() == 0) {
            return false;
        }
        Groups groupsOfOperator = _oOperator.getGroups();
        if (groupsOfOperator == null || groupsOfOperator.size() == 0) {
            return false;
        }
        int nSize = groupsOfCrUser.size();
        for (int i = 0; i < nSize; ++i) {
            Group group = (Group)groupsOfCrUser.getAt(i);
            if (group == null) continue;
            for (Group parent = group; parent != null; parent = parent.getParent()) {
                if (groupsOfOperator.indexOf(parent.getId()) < 0) continue;
                return true;
            }
        }
        return false;
    }

    public static RightValue getRightValue(CMSObj operator, CMSObj obj) throws WCMException {
        return SpecialAuthServer.getRightValue(operator, obj.getClass());
    }

    public static RightValue getRightValue(CMSObj operator, Class clazz) throws WCMException {
        User oUser = (User)operator;
        if (oUser.isAdministrator()) {
            return RightValue.getAdministratorRightValue();
        }
        Role oRole = (Role)objRoleMapping.get(clazz);
        if (oRole == null) {
            return RightValue.getAdministratorRightValue();
        }
        RoleUserCacheMgr roleUserCacheMgr = (RoleUserCacheMgr)DreamFactory.createObjectById("RoleUserCacheMgr");
        Roles oRoles = roleUserCacheMgr.getRoles(oUser, null);
        RightValue rightValue = (RightValue)objRightValueMapping.get(clazz);
        if (rightValue == null) {
            rightValue = EVERYONE_HAS_RIGHT_VALUE;
        }
        if (oRoles.indexOf(oRole.getId()) >= 0) {
            return rightValue;
        }
        Role oRoleForSameGroup = (Role)objRoleMappingForSameGroup.get(clazz);
        if (oRoleForSameGroup != null && oRoles.indexOf(oRoleForSameGroup.getId()) >= 0) {
            return rightValue;
        }
        return EVERYONE_HAS_RIGHT_VALUE;
    }

    static {
        int i;
        logger = Logger.getLogger(SpecialAuthServer.class);
        SPECIAL_INDEX_RANGE = new int[]{1, 10};
        STYLE_INDEX_RANGE = new int[]{11, 20};
        WIDGET_INDEX_RANGE = new int[]{21, 30};
        EVERYONE_HAS_RIGHTINDEX = new int[]{4, 14, 24};
        objRoleMapping = new HashMap();
        objRoleMappingForSameGroup = new HashMap();
        try {
            RoleMgr oRoleMgr = (RoleMgr)DreamFactory.createObjectById("RoleMgr");
            Role oSpecialRole = oRoleMgr.findRoleByName(SPECIAL_ROLE);
            objRoleMapping.put(Special.class, oSpecialRole);
            Role oSpecialRoleInSameGroup = oRoleMgr.findRoleByName(SPECIAL_ROLE_FOR_SAME_GROUP);
            objRoleMappingForSameGroup.put(Special.class, oSpecialRoleInSameGroup);
            Role oStyleRole = oRoleMgr.findRoleByName(STYLE_ROLE);
            objRoleMapping.put(PageStyle.class, oStyleRole);
            objRoleMapping.put(ContentStyle.class, oStyleRole);
            objRoleMapping.put(ResourceStyle.class, oStyleRole);
            Role oStyleRoleInSameGroup = oRoleMgr.findRoleByName(STYLE_ROLE_FOR_SAME_GROUP);
            objRoleMappingForSameGroup.put(PageStyle.class, oStyleRoleInSameGroup);
            objRoleMappingForSameGroup.put(ContentStyle.class, oStyleRoleInSameGroup);
            objRoleMappingForSameGroup.put(ResourceStyle.class, oStyleRoleInSameGroup);
            Role oWidgetRole = oRoleMgr.findRoleByName(WIDGET_ROLE);
            objRoleMapping.put(Widget.class, oWidgetRole);
            objRoleMapping.put(Master.class, oWidgetRole);
            objRoleMapping.put(Layout.class, oWidgetRole);
            Role oWidgetRoleInSameGroup = oRoleMgr.findRoleByName(WIDGET_ROLE_FOR_SAME_GROUP);
            objRoleMappingForSameGroup.put(Widget.class, oWidgetRoleInSameGroup);
            objRoleMappingForSameGroup.put(Master.class, oWidgetRoleInSameGroup);
            objRoleMappingForSameGroup.put(Layout.class, oWidgetRoleInSameGroup);
        }
        catch (Exception e) {
            logger.error((Object)"\u521d\u59cb\u5316\u4e13\u9898\u76f8\u5173\u6743\u9650\u5bf9\u8c61\u65f6\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
        }
        objRightValueMapping = new HashMap();
        EVERYONE_HAS_RIGHT_VALUE = new RightValue();
        for (i = 0; i < EVERYONE_HAS_RIGHTINDEX.length; ++i) {
            EVERYONE_HAS_RIGHT_VALUE.setBit(EVERYONE_HAS_RIGHTINDEX[i], true);
        }
        SPECIAL_RIGHT_VALUE = new RightValue(EVERYONE_HAS_RIGHT_VALUE);
        for (i = SPECIAL_INDEX_RANGE[0]; i <= SPECIAL_INDEX_RANGE[1]; ++i) {
            SPECIAL_RIGHT_VALUE.setBit(i, true);
        }
        objRightValueMapping.put(Special.class, SPECIAL_RIGHT_VALUE);
        WIDGET_RIGHT_VALUE = new RightValue(EVERYONE_HAS_RIGHT_VALUE);
        for (i = WIDGET_INDEX_RANGE[0]; i <= WIDGET_INDEX_RANGE[1]; ++i) {
            WIDGET_RIGHT_VALUE.setBit(i, true);
        }
        objRightValueMapping.put(Widget.class, WIDGET_RIGHT_VALUE);
        objRightValueMapping.put(Master.class, WIDGET_RIGHT_VALUE);
        objRightValueMapping.put(Layout.class, WIDGET_RIGHT_VALUE);
        STYLE_RIGHT_VALUE = new RightValue(EVERYONE_HAS_RIGHT_VALUE);
        for (i = STYLE_INDEX_RANGE[0]; i <= STYLE_INDEX_RANGE[1]; ++i) {
            STYLE_RIGHT_VALUE.setBit(i, true);
        }
        objRightValueMapping.put(PageStyle.class, STYLE_RIGHT_VALUE);
        objRightValueMapping.put(ContentStyle.class, STYLE_RIGHT_VALUE);
        objRightValueMapping.put(ResourceStyle.class, STYLE_RIGHT_VALUE);
    }
}

