/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.persistent.template;

import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.BizError;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.util.CMyString;

public class TagBean
extends CMSObj {
    public static final int OBJ_TYPE = 951;
    public static final String DB_TABLE_NAME = "WCMTAGBEANS";
    public static final String DB_ID_NAME = "TAGBEANID";

    @Override
    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    @Override
    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    @Override
    public int getWCMType() {
        return 951;
    }

    public String getTagName() {
        return (String)this.getProperty("TAGNAME");
    }

    public boolean setTagName(String _sName) throws WCMException {
        if (_sName == null || (_sName = _sName.trim()).length() == 0) {
            throw new WCMException(10, "Tag name required!");
        }
        return this.setProperty("TAGNAME", _sName.toUpperCase());
    }

    public String getTagDesc() {
        return (String)this.getProperty("TAGDESC");
    }

    public boolean setTagDesc(String _sDesc) throws WCMException {
        return this.setProperty("TAGDESC", _sDesc);
    }

    public String getTagBean() {
        return (String)this.getProperty("TAGBEAN");
    }

    public boolean setTagBean(String _sBean) throws WCMException {
        return this.setProperty("TAGBEAN", _sBean);
    }

    public boolean isEnabled() {
        return this.getPropertyAsBoolean("ENABLED", true);
    }

    public boolean setEnabled(boolean _bEnabled) throws WCMException {
        return this.setProperty("ENABLED", _bEnabled);
    }

    @Override
    public boolean isValid() throws WCMException {
        String sBean;
        String sName = null;
        if (this.isAddMode()) {
            sName = (String)this.getProperty("TAGNAME");
            if (sName == null) {
                throw new WCMException(1106, I18NMessage.get(TagBean.class, "TagBean.label1", "\u5c5e\u6027TagName\u6ca1\u6709\u8bbe\u7f6e"));
            }
            sBean = (String)this.getProperty("TAGBEAN");
            if (sBean == null || sBean.length() == 0) {
                throw new WCMException(1106, I18NMessage.get(TagBean.class, "TagBean.label2", "\u5c5e\u6027TagBean\u6ca1\u6709\u8bbe\u7f6e\u6216\u4e3a\u7a7a\uff01"));
            }
        } else {
            if (!this.isModified()) {
                throw new WCMException(1107, I18NMessage.get(TagBean.class, "TagBean.label3", "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539"));
            }
            sName = (String)this.getNewProperty("TAGNAME");
            sBean = (String)this.getNewProperty("TAGBEAN");
        }
        if (sName != null) {
            String strCondition = "(TagName='" + CMyString.filterForSQL(sName) + "')";
            if (!this.isAddMode()) {
                strCondition = strCondition + " AND (" + this.getIdFieldName() + "<>" + this.getId() + ")";
            }
            if (this.checkExists(strCondition)) {
                throw new BizError(I18NMessage.get(TagBean.class, "TagBean.label4", "\u7f6e\u6807\u540d\u79f0[") + sName + I18NMessage.get(TagBean.class, "TagBean.label5", "]\u5df2\u7ecf\u5b58\u5728"));
            }
        }
        if (sBean != null) {
            try {
                Class.forName(sBean);
            }
            catch (Exception ex) {
                throw new WCMException(13, "Bean class [" + sBean + "] is not found!", ex);
            }
        }
        return true;
    }

    @Override
    public void insert(User _currUser) throws WCMException {
        if (this.isAddMode() && this.isModified()) {
            if (this.getProperty("ENABLED") == null) {
                this.setEnabled(true);
            }
            super.insert(_currUser);
        }
    }

    public static final TagBean findById(int _nId) throws WCMException {
        if (_nId <= 0) {
            return null;
        }
        return (TagBean)BaseObj.findById(TagBean.class, _nId);
    }

    public static final TagBean createNewInstance() throws WCMException {
        return (TagBean)BaseObj.createNewInstance(TagBean.class);
    }

    public static final TagBean findByKey(Object _oKey) throws WCMException {
        return (TagBean)BaseObj.findByKey(TagBean.class, _oKey);
    }
}

