/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.persistent.publisher;

import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.publisher.FolderPublishConfigCacheMgr;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.util.CMyString;

public class FolderPublishConfig
extends CMSObj {
    public static final int OBJ_TYPE = 956;
    public static final String DB_TABLE_NAME = "WCMFOLDERPUBLISHCONFIG";
    public static final String DB_ID_NAME = "FOLDERPUBLISHCONFIGID";
    private static FolderPublishConfigCacheMgr s_oCacheMgr = new FolderPublishConfigCacheMgr();

    @Override
    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    @Override
    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    @Override
    public int getWCMType() {
        return 956;
    }

    public int getFolderType() {
        return this.getPropertyAsInt("FOLDERTYPE", 0);
    }

    public int getFolderId() {
        return this.getPropertyAsInt("FOLDERID", 0);
    }

    public boolean setFolder(int _nType, int _nId) throws WCMException {
        return this.setProperty("FOLDERTYPE", _nType) && this.setProperty("FOLDERID", _nId);
    }

    public boolean setFolder(IPublishFolder _folder) throws WCMException {
        if (_folder == null) {
            throw new WCMException(10, "Valid publish folder required!");
        }
        return this.setFolder(_folder.getType(), _folder.getId());
    }

    public String getOutlineFileName() {
        return this.getPropertyAsString("OUTLINEFILE");
    }

    public boolean setOutlineFileName(String _sOutlineFileName) throws WCMException {
        return this.setProperty("OUTLINEFILE", _sOutlineFileName);
    }

    public String getDetailFileExt() {
        return this.getPropertyAsString("DETAILFILEEXT");
    }

    public boolean setDetailFileExt(String _sDetailFileExt) throws WCMException {
        return this.setProperty("DETAILFILEEXT", _sDetailFileExt);
    }

    public String getDataPath() {
        String sTempDataPath = this.getPropertyAsString("DATAPATH");
        if (sTempDataPath == null || (sTempDataPath = sTempDataPath.trim()).length() <= 0) {
            sTempDataPath = Integer.toString(this.getFolderId());
        }
        return sTempDataPath;
    }

    public boolean setDataPath(String _sDataPath) throws WCMException {
        return this.setProperty("DATAPATH", _sDataPath);
    }

    public String getRootDomain() {
        return this.getPropertyAsString("ROOTDOMAIN");
    }

    public boolean setRootDomain(String _sRootMain) throws WCMException {
        return this.setProperty("ROOTDOMAIN", _sRootMain);
    }

    public int getSiteLanguage() {
        return this.getPropertyAsInt("SITELANGUAGE", 0);
    }

    public boolean setSiteLanguage(int _nSiteLanguage) throws WCMException {
        return this.setProperty("SITELANGUAGE", _nSiteLanguage);
    }

    public String getPageEncoding() {
        String encoding = this.getPropertyAsString("PAGEENCODING");
        if (CMyString.isEmpty(encoding)) {
            encoding = "GBK";
        }
        return encoding;
    }

    public boolean setPageEncoding(String _sPageEncoding) throws WCMException {
        return this.setProperty("PAGEENCODING", _sPageEncoding);
    }

    @Override
    public boolean isValid() throws WCMException {
        if (this.isAddMode()) {
            if (this.getProperty("FOLDERTYPE") == null) {
                throw new WCMException(1106, I18NMessage.get(FolderPublishConfig.class, "FolderPublishConfig.label1", "\u5c5e\u6027FolderType\u6ca1\u6709\u8bbe\u7f6e"));
            }
            if (this.getProperty("FOLDERID") == null) {
                throw new WCMException(1106, I18NMessage.get(FolderPublishConfig.class, "FolderPublishConfig.label2", "\u5c5e\u6027FolderId\u6ca1\u6709\u8bbe\u7f6e"));
            }
            if (this.getProperty("DATAPATH") == null) {
                throw new WCMException(1106, I18NMessage.get(FolderPublishConfig.class, "FolderPublishConfig.label3", "\u5c5e\u6027DataPath\u6ca1\u6709\u8bbe\u7f6e"));
            }
        } else if (!this.isModified()) {
            throw new WCMException(1107, I18NMessage.get(FolderPublishConfig.class, "FolderPublishConfig.label4", "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539"));
        }
        return true;
    }

    @Override
    public void insert(User _currUser) throws WCMException {
        if (this.isAddMode() && this.isModified()) {
            super.insert(_currUser);
        }
    }

    @Override
    public int delete(User _currUser) throws WCMException {
        int nResult = super.delete(_currUser);
        s_oCacheMgr.notifyOnRemoveConfig(this);
        return nResult;
    }

    public static final FolderPublishConfig findById(int _nId) throws WCMException {
        if (_nId <= 0) {
            return null;
        }
        return (FolderPublishConfig)BaseObj.findById(FolderPublishConfig.class, _nId);
    }

    public static final FolderPublishConfig findOf(int _nFolderType, int _nFolderId) throws WCMException {
        return s_oCacheMgr.findConfig(_nFolderType, _nFolderId);
    }

    public static final FolderPublishConfig findOf(IPublishFolder _folder) throws WCMException {
        return s_oCacheMgr.findConfig(_folder.getType(), _folder.getId());
    }

    public static final FolderPublishConfig createNewInstance() throws WCMException {
        return (FolderPublishConfig)BaseObj.createNewInstance(FolderPublishConfig.class);
    }

    public static final FolderPublishConfig findByKey(Object _oKey) throws WCMException {
        return (FolderPublishConfig)BaseObj.findByKey(FolderPublishConfig.class, _oKey);
    }
}

