/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.domain.template;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.publish.persistent.element.IPublishElements;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.components.common.publish.persistent.template.TemplateQuote;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.DebugTimer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class TemplateQuoteMgr0310 {
    private static final Logger logger = Logger.getLogger((String)TemplateQuoteMgr0310.class.getName());
    private static final long MAX_USE_TIME = 400L;

    public void save(TemplateQuote _quote) throws WCMException {
        if (_quote == null) {
            throw new WCMException(10, "Valid quote required!");
        }
        _quote.save(ContextHelper.getLoginUser());
    }

    public void save(List _quotes) throws WCMException {
        if (_quotes == null || _quotes.isEmpty()) {
            return;
        }
        try {
            User currUser = ContextHelper.getLoginUser();
            for (int i = 0; i < _quotes.size(); ++i) {
                TemplateQuote aQuote = (TemplateQuote)_quotes.get(i);
                if (aQuote == null) continue;
                aQuote.save(currUser);
            }
        }
        catch (Exception ex) {
            throw new WCMException(1100, "Failed to save the template quotes list!", ex);
        }
    }

    int clearQuotesOfTemplate(Template _template) throws WCMException {
        if (_template == null) {
            throw new WCMException(1100, "Valid template required!");
        }
        return this.clearQuotesOfTemplate(_template.getId());
    }

    int clearQuotesOfTemplate(int _nTemplateId) throws WCMException {
        String SQL = "DELETE FROM WCMTEMPLATEQUOTE WHERE TEMPLATEID=?";
        Connection oConn = null;
        PreparedStatement oPreStmt = null;
        DBManager dbManager = DBManager.getDBManager();
        try {
            oConn = dbManager.getConnection();
            oPreStmt = oConn.prepareStatement("DELETE FROM WCMTEMPLATEQUOTE WHERE TEMPLATEID=?");
            oPreStmt.setInt(1, _nTemplateId);
            int n = oPreStmt.executeUpdate();
            return n;
        }
        catch (Exception ex) {
            throw new WCMException(1100, "Failed to clear template quotes record!", ex);
        }
        finally {
            if (oPreStmt != null) {
                try {
                    oPreStmt.close();
                }
                catch (Exception ex) {
                    logger.error((Object)"Failed to close prepared statement", (Throwable)ex);
                }
            }
            if (oConn != null) {
                dbManager.freeConnection(oConn);
            }
        }
    }

    public int clearQuotesOfFolder(IPublishFolder _folder) throws WCMException {
        if (_folder == null) {
            throw new WCMException(10, "Valid publish folder required!");
        }
        return this.clearQuotesOfFolder(_folder.getType(), _folder.getId());
    }

    public int clearQuotesOfFolder(int _nFolderType, int _nFolderId) throws WCMException {
        String SQL = "DELETE FROM WCMTEMPLATEQUOTE WHERE QUOTEDFOLDERID=? AND QUOTEDFOLDERTYPE=?";
        Connection oConn = null;
        PreparedStatement oPreStmt = null;
        DBManager dbManager = DBManager.getDBManager();
        try {
            oConn = dbManager.getConnection();
            oPreStmt = oConn.prepareStatement("DELETE FROM WCMTEMPLATEQUOTE WHERE QUOTEDFOLDERID=? AND QUOTEDFOLDERTYPE=?");
            oPreStmt.setInt(1, _nFolderId);
            oPreStmt.setInt(2, _nFolderType);
            int n = oPreStmt.executeUpdate();
            return n;
        }
        catch (Exception ex) {
            throw new WCMException(1100, "Failed to clear template quotes record!", ex);
        }
        finally {
            if (oPreStmt != null) {
                try {
                    oPreStmt.close();
                }
                catch (Exception ex) {
                    logger.error((Object)"Failed to close prepared statement", (Throwable)ex);
                }
            }
            if (oConn != null) {
                dbManager.freeConnection(oConn);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List getFoldersWhoseOutlineQuotesContentsOf(IPublishFolder _quotedFolder) throws WCMException {
        ArrayList<IPublishFolder> arrayList;
        Statement oPreStmt;
        Connection oConn;
        DBManager dbManager;
        block30: {
            if (_quotedFolder == null) {
                throw new WCMException(10, "Quoted folder required!");
            }
            if (_quotedFolder.isRoot()) {
                return null;
            }
            String QUOTED_FOLDER_CONDITION = "(QUOTEDFOLDERID=? AND FAMILYINDEX=? AND QUOTEDFOLDERTYPE=?)";
            String SQL_QUOTE_DIRECTLY = "SELECT DISTINCT EMPLOYERTYPE, EMPLOYERID FROM V_TEMPLATEEMPLOY employ, WCMTEMPLATEQUOTE quote WHERE quote.TEMPLATEID=employ.TEMPLATEID AND employ.TEMPLATETYPE=? AND QUOTETYPE=? AND ((QUOTEDFOLDERID=? AND FAMILYINDEX=? AND QUOTEDFOLDERTYPE=?) OR (QUOTEDFOLDERID=? AND FAMILYINDEX=? AND QUOTEDFOLDERTYPE=?))";
            String SQL_QUOTE_BYFAMILY = "SELECT 1 FROM WCMTEMPLATEEMPLOY employ WHERE employ.EMPLOYERTYPE=? AND employ.EMPLOYERID=? AND EXISTS(SELECT quote.TEMPLATEID FROM WCMTEMPLATEQUOTE quote WHERE quote.TEMPLATEID=employ.TEMPLATEID AND QUOTETYPE=? AND (QUOTEDFOLDERID=? AND FAMILYINDEX=? AND QUOTEDFOLDERTYPE=?))";
            DebugTimer timer = new DebugTimer();
            dbManager = null;
            oConn = null;
            oPreStmt = null;
            ResultSet rsData = null;
            try {
                IPublishElements children;
                IPublishFolder aFolder;
                int nSiblingIndex = _quotedFolder.getSiblingIndex();
                IPublishFolder parent = _quotedFolder.getParent();
                if (parent == null) {
                    throw new Exception("Parent of quoted folder (" + _quotedFolder.getInfo() + ") not found!");
                }
                dbManager = DBManager.getDBManager();
                oConn = dbManager.getConnection();
                oPreStmt = oConn.prepareStatement("SELECT DISTINCT EMPLOYERTYPE, EMPLOYERID FROM V_TEMPLATEEMPLOY employ, WCMTEMPLATEQUOTE quote WHERE quote.TEMPLATEID=employ.TEMPLATEID AND employ.TEMPLATETYPE=? AND QUOTETYPE=? AND ((QUOTEDFOLDERID=? AND FAMILYINDEX=? AND QUOTEDFOLDERTYPE=?) OR (QUOTEDFOLDERID=? AND FAMILYINDEX=? AND QUOTEDFOLDERTYPE=?))");
                oPreStmt.setInt(1, 1);
                oPreStmt.setInt(2, 1);
                oPreStmt.setInt(3, _quotedFolder.getId());
                oPreStmt.setInt(4, -1);
                oPreStmt.setInt(5, _quotedFolder.getType());
                oPreStmt.setInt(6, parent.getId());
                oPreStmt.setInt(7, nSiblingIndex);
                oPreStmt.setInt(8, parent.getType());
                timer.start();
                rsData = oPreStmt.executeQuery();
                timer.stop();
                if (logger.isDebugEnabled() && timer.getTime() > 400L) {
                    logger.debug((Object)("execute[SELECT DISTINCT EMPLOYERTYPE, EMPLOYERID FROM V_TEMPLATEEMPLOY employ, WCMTEMPLATEQUOTE quote WHERE quote.TEMPLATEID=employ.TEMPLATEID AND employ.TEMPLATETYPE=? AND QUOTETYPE=? AND ((QUOTEDFOLDERID=? AND FAMILYINDEX=? AND QUOTEDFOLDERTYPE=?) OR (QUOTEDFOLDERID=? AND FAMILYINDEX=? AND QUOTEDFOLDERTYPE=?))] use [" + timer.getTime() + "]ms"));
                    logger.debug((Object)("parameters:[1] [1] [" + _quotedFolder.getId() + "] [" + -1 + "] [" + _quotedFolder.getType() + "] [" + parent.getId() + "] [" + nSiblingIndex + "][" + parent.getType() + "]"));
                }
                ArrayList<IPublishFolder> quotersList = new ArrayList<IPublishFolder>();
                while (rsData.next()) {
                    int nFolderId;
                    int nFolderType = rsData.getInt(1);
                    aFolder = (IPublishFolder)PublishElementFactory.lookupElement(nFolderType, nFolderId = rsData.getInt(2));
                    if (aFolder == null) continue;
                    quotersList.add(aFolder);
                }
                rsData.close();
                rsData = null;
                oPreStmt.close();
                oPreStmt = null;
                if (quotersList.indexOf(parent) < 0) {
                    oPreStmt = oConn.prepareStatement("SELECT 1 FROM WCMTEMPLATEEMPLOY employ WHERE employ.EMPLOYERTYPE=? AND employ.EMPLOYERID=? AND EXISTS(SELECT quote.TEMPLATEID FROM WCMTEMPLATEQUOTE quote WHERE quote.TEMPLATEID=employ.TEMPLATEID AND QUOTETYPE=? AND (QUOTEDFOLDERID=? AND FAMILYINDEX=? AND QUOTEDFOLDERTYPE=?))");
                    oPreStmt.setMaxRows(1);
                    oPreStmt.setInt(1, parent.getType());
                    oPreStmt.setInt(2, parent.getId());
                    oPreStmt.setInt(3, 1);
                    oPreStmt.setInt(4, 0);
                    oPreStmt.setInt(5, 0);
                    oPreStmt.setInt(6, nSiblingIndex);
                    timer.start();
                    rsData = oPreStmt.executeQuery();
                    timer.stop();
                    if (logger.isDebugEnabled() && timer.getTime() > 400L) {
                        logger.debug((Object)("execute[SELECT 1 FROM WCMTEMPLATEEMPLOY employ WHERE employ.EMPLOYERTYPE=? AND employ.EMPLOYERID=? AND EXISTS(SELECT quote.TEMPLATEID FROM WCMTEMPLATEQUOTE quote WHERE quote.TEMPLATEID=employ.TEMPLATEID AND QUOTETYPE=? AND (QUOTEDFOLDERID=? AND FAMILYINDEX=? AND QUOTEDFOLDERTYPE=?))] use [" + timer.getTime() + "]ms"));
                        logger.debug((Object)("parameters:[" + parent.getType() + "] [" + parent.getId() + "] [" + 1 + "] [0] [0] [" + nSiblingIndex + "]"));
                    }
                    if (rsData.next()) {
                        quotersList.add(parent);
                    }
                    rsData.close();
                }
                if ((children = _quotedFolder.getChildren()) != null && !children.isEmpty()) {
                    for (int i = 0; i < children.size(); ++i) {
                        aFolder = (IPublishFolder)children.get(i);
                        if (aFolder == null || quotersList.indexOf(aFolder) >= 0) continue;
                        if (oPreStmt == null) {
                            oPreStmt = oConn.prepareStatement("SELECT 1 FROM WCMTEMPLATEEMPLOY employ WHERE employ.EMPLOYERTYPE=? AND employ.EMPLOYERID=? AND EXISTS(SELECT quote.TEMPLATEID FROM WCMTEMPLATEQUOTE quote WHERE quote.TEMPLATEID=employ.TEMPLATEID AND QUOTETYPE=? AND (QUOTEDFOLDERID=? AND FAMILYINDEX=? AND QUOTEDFOLDERTYPE=?))");
                            oPreStmt.setMaxRows(1);
                            oPreStmt.setInt(3, 1);
                            oPreStmt.setInt(4, 0);
                            oPreStmt.setInt(5, 0);
                            oPreStmt.setInt(6, -2);
                        }
                        oPreStmt.setInt(1, aFolder.getId());
                        oPreStmt.setInt(2, aFolder.getType());
                        timer.start();
                        rsData = oPreStmt.executeQuery();
                        timer.stop();
                        if (logger.isDebugEnabled() && timer.getTime() > 400L) {
                            logger.debug((Object)("execute[SELECT 1 FROM WCMTEMPLATEEMPLOY employ WHERE employ.EMPLOYERTYPE=? AND employ.EMPLOYERID=? AND EXISTS(SELECT quote.TEMPLATEID FROM WCMTEMPLATEQUOTE quote WHERE quote.TEMPLATEID=employ.TEMPLATEID AND QUOTETYPE=? AND (QUOTEDFOLDERID=? AND FAMILYINDEX=? AND QUOTEDFOLDERTYPE=?))] use [" + timer.getTime() + "]ms"));
                            logger.debug((Object)("parameters:[" + aFolder.getId() + "] [" + aFolder.getType() + "] [" + 1 + "] [0] [0] [" + -2 + "]"));
                        }
                        if (rsData.next()) {
                            quotersList.add(aFolder);
                        }
                        rsData.close();
                    }
                }
                arrayList = quotersList;
                if (rsData == null) break block30;
            }
            catch (Exception ex) {
                try {
                    throw new WCMException(1100, "Failed to query and fetch the folders quoting the specified folder!", ex);
                }
                catch (Throwable throwable) {
                    if (rsData != null) {
                        try {
                            rsData.close();
                        }
                        catch (Exception ex2) {
                            logger.error((Object)"Failed to close result!", (Throwable)ex2);
                        }
                    }
                    if (oPreStmt != null) {
                        try {
                            oPreStmt.close();
                        }
                        catch (Exception ex3) {
                            logger.error((Object)"Failed to close prepared statement!", (Throwable)ex3);
                        }
                    }
                    if (oConn != null) {
                        dbManager.freeConnection(oConn);
                    }
                    throw throwable;
                }
            }
            try {
                rsData.close();
            }
            catch (Exception ex) {
                logger.error((Object)"Failed to close result!", (Throwable)ex);
            }
        }
        if (oPreStmt != null) {
            try {
                oPreStmt.close();
            }
            catch (Exception ex) {
                logger.error((Object)"Failed to close prepared statement!", (Throwable)ex);
            }
        }
        if (oConn != null) {
            dbManager.freeConnection(oConn);
        }
        return arrayList;
    }
}

