/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.domain.template;

import com.trs.DreamFactory;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.template.TemplateArgument;
import com.trs.components.common.publish.persistent.template.TemplateArguments;
import com.trs.infra.I18NMessage;
import com.trs.infra.cache.Cache;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.support.cache.ICacheMgr;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class TemplateArgumentCacheMgr
implements ICacheMgr {
    private static Logger s_logger = Logger.getLogger(TemplateArgumentCacheMgr.class);
    public static long LRU_CACHE_EXPIRES = 3600000L;
    private static Cache cache = (Cache)DreamFactory.createObjectById("lruCache");
    public static int MAX_CACHE_SIZE = 512;

    @Override
    public boolean init() throws WCMException {
        cache.setMaxSize(MAX_CACHE_SIZE);
        return true;
    }

    @Override
    public boolean reinit() throws WCMException {
        return false;
    }

    @Override
    public void clear() {
    }

    public String getArgument(IPublishElement _employer, String _name) throws WCMException {
        return this.getArgument(_employer.getType(), _employer.getId(), _name);
    }

    public String getArgument(int _type, int _id, String _name) throws WCMException {
        HashMap map = this.getArguments(_type, _id);
        if (map != null) {
            return (String)map.get(_name);
        }
        return null;
    }

    public HashMap getArguments(IPublishElement _employer) throws WCMException {
        return this.getArguments(_employer.getType(), _employer.getId());
    }

    public HashMap getArguments(int _type, int _id) throws WCMException {
        HashMap map = this.getFromCache(_type, _id);
        if (map != null) {
            return map;
        }
        return this.loadFromDB(_type, _id);
    }

    private HashMap getFromCache(int _type, int _id) {
        return (HashMap)cache.get(this.getKey(_type, _id));
    }

    private synchronized HashMap loadFromDB(int _type, int _id) throws WCMException {
        HashMap map = this.getFromCache(_type, _id);
        if (map != null) {
            return map;
        }
        StringBuffer sbWhere = new StringBuffer(256);
        sbWhere.append("EMPLOYERTYPE=").append(_type);
        sbWhere.append(" and EMPLOYERID=").append(_id);
        WCMFilter filter = new WCMFilter("", sbWhere.toString(), "");
        TemplateArguments tas = TemplateArguments.createNewInstance(User.getSystem());
        tas.open(filter);
        map = tas.toHashMapForCache();
        String cacheKey = this.getKey(_type, _id);
        cache.set(cacheKey, map);
        cache.pexpire(cacheKey, LRU_CACHE_EXPIRES);
        return map;
    }

    private String getKey() {
        return this.getClass().getName();
    }

    private String getKey(int _type, int _id) {
        return this.getKey() + "." + _type + "." + _id;
    }

    @Override
    public void notifyOnAddObj(BaseObj _oObjAdded) throws WCMException {
        if (!(_oObjAdded instanceof TemplateArgument)) {
            s_logger.error((Object)this.getListenerTypeErrorMsg(_oObjAdded, I18NMessage.get(TemplateArgumentCacheMgr.class, "TemplateArgumentCacheMgr.label1", "\u65b0\u589e")));
            return;
        }
        TemplateArgument ta = (TemplateArgument)_oObjAdded;
        HashMap map = this.getArguments(ta.getEmployerType(), ta.getEmployerId());
        if (map != null) {
            map.put(ta.getCacheKey(), ta.getArgumentValue());
        }
        cache.set(this.getKey(ta.getEmployerType(), ta.getEmployerId()), map);
    }

    @Override
    public void notifyOnDelObj(BaseObj _oObjDeleted, int _nEventType) throws WCMException {
        if (!(_oObjDeleted instanceof TemplateArgument)) {
            s_logger.error((Object)this.getListenerTypeErrorMsg(_oObjDeleted, I18NMessage.get(TemplateArgumentCacheMgr.class, "TemplateArgumentCacheMgr.label2", "\u5220\u9664")));
            return;
        }
        TemplateArgument ta = (TemplateArgument)_oObjDeleted;
        HashMap map = this.getArguments(ta.getEmployerType(), ta.getEmployerId());
        if (map != null) {
            map.remove(ta.getCacheKey());
        }
        cache.set(this.getKey(ta.getEmployerType(), ta.getEmployerId()), map);
    }

    @Override
    public void notifyOnModifyObj(BaseObj _oObjModified, int _nEventType) throws WCMException {
        if (!(_oObjModified instanceof TemplateArgument)) {
            s_logger.error((Object)this.getListenerTypeErrorMsg(_oObjModified, I18NMessage.get(TemplateArgumentCacheMgr.class, "TemplateArgumentCacheMgr.label3", "\u4fee\u6539")));
            return;
        }
        TemplateArgument ta = (TemplateArgument)_oObjModified;
        HashMap map = this.getArguments(ta.getEmployerType(), ta.getEmployerId());
        if (map != null) {
            map.put(ta.getCacheKey(), ta.getNewProperty("ARGUMENTVALUE"));
        }
        cache.set(this.getKey(ta.getEmployerType(), ta.getEmployerId()), map);
    }

    private String getListenerTypeErrorMsg(Object obj, String msg) {
        StringBuffer sb = new StringBuffer(512);
        sb.append("Listener[");
        sb.append(this.getClass());
        sb.append(I18NMessage.get(TemplateArgumentCacheMgr.class, "TemplateArgumentCacheMgr.label4", "]\u4e0d\u80fd\u76d1\u542c\u5bf9\u8c61["));
        sb.append(obj.getClass());
        sb.append(I18NMessage.get(TemplateArgumentCacheMgr.class, "TemplateArgumentCacheMgr.label5", "]\u7684"));
        sb.append(msg);
        sb.append('\uff01');
        return sb.toString();
    }

    private class Key {
        private int m_iType;
        private int m_iId;

        private Key(int type, int id) {
            this.m_iType = type;
            this.m_iId = id;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Key) {
                if (obj == this) {
                    return true;
                }
                Key key = (Key)obj;
                if (key.m_iType == this.m_iType && key.m_iId == this.m_iId) {
                    return true;
                }
            }
            return false;
        }

        public int hashCode() {
            return this.m_iId;
        }
    }
}

