/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.domain.tagparser;

import com.trs.DreamFactory;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.tagparser.ITagParser;
import com.trs.components.common.publish.domain.tagparser.TagBeanAttrInfo;
import com.trs.components.common.publish.domain.tagparser.TagBeanInfo;
import com.trs.components.common.publish.domain.tagparser.TagItem;
import com.trs.components.common.publish.domain.template.TemplateCacheMgr;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.components.common.publish.persistent.template.TemplateQuote;
import com.trs.infra.common.WCMException;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyString;

public class TagParserTemplate
implements ITagParser {
    private static final String FIELD_OUTNAME = "OUTNAME";
    private static TagBeanInfo s_TagBeanInfo;

    public void clear() {
    }

    @Override
    public TagBeanInfo getBeanInfo() {
        if (s_TagBeanInfo == null) {
            TagBeanInfo tbi = new TagBeanInfo();
            tbi.setName("TRS_XTEMPLATE");
            tbi.setDesc("\u6a21\u677f\u5c5e\u6027\u7f6e\u6807");
            tbi.setType(TagBeanInfo.BodyType.IGNORE);
            TagBeanAttrInfo tbai = new TagBeanAttrInfo();
            tbai.setName("TEMPNAME");
            tbai.setDesc("\u6a21\u677f\u540d\u79f0");
            tbai.setRequired(true);
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("FIELD");
            tbai.setDesc("\u83b7\u53d6\u6a21\u677f\u5c5e\u6027");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbi.addAttrInfo(tbai);
            s_TagBeanInfo = tbi;
        }
        return s_TagBeanInfo;
    }

    @Override
    public void setTagItem(TagItem _item) {
    }

    @Override
    public TemplateQuote[] analyzeQuotes(IPublishFolder _root) throws WCMException {
        return null;
    }

    @Override
    public String[] parse(PublishTagContext _context) throws WCMException {
        String tempname = _context.getAttribute("TEMPNAME");
        if (CMyString.isEmpty(tempname)) {
            return null;
        }
        IPublishFolder root = _context.getPageFolder().getRoot();
        TemplateCacheMgr mgr = (TemplateCacheMgr)DreamFactory.createObjectById("TemplateCacheMgr");
        Template template = mgr.lookupByName(root, tempname);
        if (template == null) {
            return null;
        }
        String field = _context.getAttribute("FIELD");
        String value = null;
        boolean bOnlyTemplateName = "true".equalsIgnoreCase(_context.getAttribute("OnlyTemplateName"));
        if (CMyString.isEmpty(field) || FIELD_OUTNAME.equals(field)) {
            value = template.getOutputFileName();
            if (!bOnlyTemplateName && !"true".equals(ConfigServer.getServer().getSysConfigValue("NAME_BY_TEMPLATE_FILE", "false"))) {
                value = value + "_" + template.getId();
            }
            value = value + "." + template.getOutputFileExt();
        } else {
            value = template.getPropertyAsString(field);
            if (value == null) {
                value = "";
            }
        }
        return new String[]{value};
    }
}

