/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.bookmark;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.Groups;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.auth.persistent.Users;
import com.trs.cms.content.CMSBaseObjs;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.bookmark.BookMark;
import com.trs.components.common.bookmark.BookMarks;
import com.trs.components.common.bookmark.MarkKind;
import com.trs.components.common.bookmark.MarkKinds;
import com.trs.components.common.bookmark.MarkShare;
import com.trs.components.common.bookmark.MarkShares;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyString;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class BookMarkMgr {
    private static final int ALL_BOOKMARKS = -1;
    private static Logger m_oLogger = Logger.getLogger((String)BookMarkMgr.class.getName());

    public void moveBookMark(BookMark _aBookMark, MarkKind _newParent) throws WCMException {
        this.assertNotNull(_aBookMark);
        this.assertNotNull(_newParent);
        _aBookMark.canEdit(this.getLoginUser());
        _aBookMark.setKind(_newParent);
        _aBookMark.update(this.getLoginUser());
    }

    public void moveMarkKind(MarkKind _markKind, MarkKind _newParent) throws WCMException {
        this.assertNotNull(_markKind);
        this.assertNotNull(_newParent);
        _markKind.canEdit(this.getLoginUser());
        _markKind.setParent(_newParent.getId());
        _markKind.update(this.getLoginUser());
    }

    public MarkShares getShareMarks(WCMFilter _filter) throws WCMException {
        User currUser = this.getLoginUser();
        WCMFilter aFilter = new WCMFilter("", "ViewerId=" + currUser.getId(), "", "ShareId");
        aFilter.mergeWith(_filter);
        return MarkShares.openWCMObjs(currUser, aFilter);
    }

    public BookMarks getSharedBookMarks(User _aUser, WCMFilter _filter) throws WCMException {
        this.assertNotNull(_aUser);
        StringBuffer sbWhere = new StringBuffer();
        sbWhere.append("EXISTS(");
        sbWhere.append(" SELECT OBJID FROM ");
        sbWhere.append("WCMMARKSHARE");
        sbWhere.append(" MarkShare ");
        sbWhere.append(" WHERE(");
        sbWhere.append(" (VIEWERID=");
        sbWhere.append(_aUser.getId());
        sbWhere.append(" AND VIEWERTYPE=");
        sbWhere.append(204);
        sbWhere.append(" AND OBJTYPE=");
        sbWhere.append(303);
        sbWhere.append(" )");
        sbWhere.append(" OR ");
        sbWhere.append(" (VIEWERTYPE=");
        sbWhere.append(201);
        sbWhere.append(" AND OBJTYPE=");
        sbWhere.append(303);
        sbWhere.append(" AND EXISTS(");
        sbWhere.append(" SELECT ");
        sbWhere.append("GROUPID");
        sbWhere.append(" FROM ");
        sbWhere.append("WCMGRPUSER");
        sbWhere.append(" GrpUser ");
        sbWhere.append(" WHERE ");
        sbWhere.append("USERID");
        sbWhere.append("=");
        sbWhere.append(_aUser.getId());
        sbWhere.append(" AND MarkShare.VIEWERID=GrpUser.");
        sbWhere.append("GROUPID");
        sbWhere.append(" )");
        sbWhere.append(" )");
        sbWhere.append(" )");
        sbWhere.append(" AND MarkShare.ObjId=");
        sbWhere.append("WCMBOOKMARK");
        sbWhere.append('.');
        sbWhere.append("MARKID");
        sbWhere.append(" )");
        WCMFilter aFilter = new WCMFilter("", sbWhere.toString(), "");
        aFilter.mergeWith(_filter);
        return BookMarks.openWCMObjs(_aUser, aFilter);
    }

    public MarkKinds getSharedMarkKinds(User _aUser, WCMFilter _filter) throws WCMException {
        this.assertNotNull(_aUser);
        StringBuffer sbWhere = new StringBuffer();
        sbWhere.append("EXISTS(");
        sbWhere.append(" SELECT OBJID FROM ");
        sbWhere.append("WCMMARKSHARE");
        sbWhere.append(" MarkShare ");
        sbWhere.append(" WHERE(");
        sbWhere.append(" (VIEWERID=");
        sbWhere.append(_aUser.getId());
        sbWhere.append(" AND VIEWERTYPE=");
        sbWhere.append(204);
        sbWhere.append(" AND OBJTYPE=");
        sbWhere.append(307);
        sbWhere.append(" )");
        sbWhere.append(" OR ");
        sbWhere.append(" (VIEWERTYPE=");
        sbWhere.append(201);
        sbWhere.append(" AND OBJTYPE=");
        sbWhere.append(307);
        sbWhere.append(" AND EXISTS(");
        sbWhere.append(" SELECT ");
        sbWhere.append("GROUPID");
        sbWhere.append(" FROM ");
        sbWhere.append("WCMGRPUSER");
        sbWhere.append(" GrpUser ");
        sbWhere.append(" WHERE ");
        sbWhere.append("USERID");
        sbWhere.append("=");
        sbWhere.append(_aUser.getId());
        sbWhere.append(" AND MarkShare.VIEWERID=GrpUser.");
        sbWhere.append("GROUPID");
        sbWhere.append(" )");
        sbWhere.append(" )");
        sbWhere.append(" )");
        sbWhere.append(" AND MarkShare.ObjId=");
        sbWhere.append("KINDID");
        sbWhere.append(" )");
        WCMFilter aFilter = new WCMFilter("", sbWhere.toString(), "");
        aFilter.mergeWith(_filter);
        return MarkKinds.openWCMObjs(_aUser, aFilter);
    }

    public BookMarks getBookMarks(int _nMarkKindId, WCMFilter _filter) throws WCMException {
        User currUser = this.getLoginUser();
        String sWhere = "CrUser='" + CMyString.filterForSQL(currUser.getName()) + "' ";
        if (_nMarkKindId != -1) {
            sWhere = sWhere + " AND MKind=" + _nMarkKindId;
        }
        WCMFilter aFilter = new WCMFilter("", sWhere, "MarkId ASC");
        aFilter.mergeWith(_filter);
        return BookMarks.openWCMObjs(currUser, aFilter);
    }

    public BookMarks getBookMarks(MarkKind _markKind, WCMFilter _filter) throws WCMException {
        if (_markKind == null) {
            int nRootKindId = 0;
            return this.getBookMarks(nRootKindId, _filter);
        }
        return this.getBookMarks(_markKind.getId(), _filter);
    }

    public BookMarks getBookMarks(WCMFilter _filter) throws WCMException {
        return this.getBookMarks(-1, _filter);
    }

    public MarkKinds getMarkKinds(WCMFilter _filter) throws WCMException {
        User currUser = this.getLoginUser();
        WCMFilter aFilter = new WCMFilter("", "CrUser='" + CMyString.filterForSQL(currUser.getName()) + "' AND ParentId=0", "KindId ASC");
        aFilter.mergeWith(_filter);
        return MarkKinds.openWCMObjs(currUser, aFilter);
    }

    public MarkKinds getChildren(MarkKind _parentMarkKind, WCMFilter _filter) throws WCMException {
        int nParentId = 0;
        if (_parentMarkKind != null) {
            nParentId = _parentMarkKind.getId();
        }
        WCMFilter aFilter = new WCMFilter("", "ParentId=" + nParentId + " AND CrUser='" + CMyString.filterForSQL(this.getLoginUser().getName()) + "'", "KindId");
        aFilter.mergeWith(_filter);
        return MarkKinds.openWCMObjs(this.getLoginUser(), aFilter);
    }

    public boolean deleteMarkKind(MarkKind _aMarkKind) throws WCMException {
        this.assertNotNull(_aMarkKind);
        this.deleteChildren(_aMarkKind);
        String[] sSqlArgs = new String[]{"DELETE FROM WCMMarkShare WHERE ObjType=307 AND ObjId=" + _aMarkKind.getId(), "DELETE FROM WCMBookMark WHERE MKind=" + _aMarkKind.getId()};
        this.getDBManager().sqlExecuteUpdate(sSqlArgs);
        return _aMarkKind.delete(this.getLoginUser()) == 1;
    }

    private void deleteChildren(MarkKind _parent) throws WCMException {
        MarkKinds childern = this.getChildren(_parent, null);
        for (int i = 0; i < childern.size(); ++i) {
            MarkKind child = (MarkKind)childern.getAt(i);
            if (child == null) continue;
            this.deleteMarkKind(child);
        }
    }

    public boolean deleteBookMark(BookMark _aBookMark) throws WCMException {
        this.assertNotNull(_aBookMark);
        String sSql = "DELETE FROM WCMMarkShare WHERE ObjType=303 AND ObjId=" + _aBookMark.getId();
        this.getDBManager().sqlExecuteUpdate(sSql);
        return _aBookMark.delete(ContextHelper.getLoginUser()) == 1;
    }

    private void shareMark(int _nViewerType, String _sViewerIds, int _nMarkType, int _nMarkId) throws WCMException {
        if (_sViewerIds == null || _sViewerIds.length() == 0) {
            this.cancelShares(_nMarkType, _nMarkId);
        }
        WCMFilter aFilter = new WCMFilter("", "ObjType=" + _nMarkType + " AND ObjId=" + _nMarkId + " AND ViewerType=" + _nViewerType, "");
        MarkShares aMarkShares = MarkShares.openWCMObjs(ContextHelper.getLoginUser(), aFilter);
        if (!aMarkShares.isEmpty()) {
            aMarkShares.removeAll();
        }
        MarkShare aMarkShare = null;
        int nViewerId = 0;
        StringTokenizer stValue = new StringTokenizer(_sViewerIds, ",");
        while (stValue.hasMoreElements()) {
            try {
                nViewerId = Integer.parseInt((String)stValue.nextElement());
            }
            catch (NumberFormatException nfe) {
                m_oLogger.error((Object)"failed to parse the id sequence!", (Throwable)nfe);
                throw new WCMException(10, I18NMessage.get(BookMarkMgr.class, "BookMarkMgr.label1", "\u65e0\u6548\u7684\u5171\u4eab\u8005id"), nfe);
            }
            aMarkShare = (MarkShare)aMarkShares.addNew();
            aMarkShare.setObjId(_nMarkId);
            aMarkShare.setObjType(_nMarkType);
            aMarkShare.setViewerId(nViewerId);
            aMarkShare.setViewerType(_nViewerType);
            aMarkShare.setCrUser(ContextHelper.getLoginUser());
            aMarkShares.update();
            aMarkShares.clear();
        }
    }

    public Groups getSharedGroups(int _nTypeId, CMSObj _currObj) throws WCMException {
        if (_currObj == null) {
            throw new WCMException(10, I18NMessage.get(BookMarkMgr.class, "BookMarkMgr.label2", "\u4f20\u5165\u65e0\u6548\u7684\u5bf9\u8c61[null]\uff0c\u65e0\u6cd5\u5b8c\u6210\u53d6\u6d88\u5171\u4eab\u64cd\u4f5c\uff01"));
        }
        return this.getSharedGroups(_nTypeId, _currObj.getId());
    }

    public Users getSharedUsers(int _nTypeId, CMSObj _currObj) throws WCMException {
        if (_currObj == null) {
            throw new WCMException(10, I18NMessage.get(BookMarkMgr.class, "BookMarkMgr.label2", "\u4f20\u5165\u65e0\u6548\u7684\u5bf9\u8c61[null]\uff0c\u65e0\u6cd5\u5b8c\u6210\u53d6\u6d88\u5171\u4eab\u64cd\u4f5c\uff01"));
        }
        return this.getSharedUsers(_nTypeId, _currObj.getId());
    }

    private Users getSharedUsers(int _nMarkType, int _nMarkId) throws WCMException {
        String sWhere = "USERID IN (SELECT ViewerId FROM WCMMARKSHARE WHERE ObjType=" + _nMarkType + " AND ObjId=" + _nMarkId + " AND ViewerType=" + 204 + ")";
        WCMFilter aFilter = new WCMFilter("", sWhere, "");
        return Users.openWCMObjs(ContextHelper.getLoginUser(), aFilter);
    }

    private Groups getSharedGroups(int _nMarkType, int _nMarkId) throws WCMException {
        String sWhere = "GROUPID IN (SELECT ViewerId FROM WCMMARKSHARE WHERE ObjType=" + _nMarkType + " AND ObjId=" + _nMarkId + " AND ViewerType=" + 201 + ")";
        WCMFilter aFilter = new WCMFilter("", sWhere, "");
        return Groups.openWCMObjs(ContextHelper.getLoginUser(), aFilter);
    }

    private boolean isValidViewer(int _nViewerType, String _sViewerIds) throws WCMException {
        if (_sViewerIds == null) {
            return false;
        }
        switch (_nViewerType) {
            case 204: {
                Users shareUsers = Users.findByIds(this.getLoginUser(), _sViewerIds);
                return shareUsers != null && !shareUsers.isEmpty();
            }
            case 201: {
                Groups shareGroups = Groups.findByIds(this.getLoginUser(), _sViewerIds);
                return shareGroups != null && !shareGroups.isEmpty();
            }
            case 203: {
                return true;
            }
        }
        return false;
    }

    protected DBManager getDBManager() throws WCMException {
        DBManager currDBManager = DBManager.getDBManager();
        if (currDBManager == null || !currDBManager.isStarted()) {
            throw new WCMException(10, I18NMessage.get(BookMarkMgr.class, "BookMarkMgr.label3", "DBManaer\u914d\u7f6e\u4e0d\u6b63\u786e\uff01"));
        }
        if (!currDBManager.isStarted()) {
            throw new WCMException(10, I18NMessage.get(BookMarkMgr.class, "BookMarkMgr.label4", "DBManaer\u6ca1\u6709\u542f\u52a8\uff01"));
        }
        return currDBManager;
    }

    public BookMark saveBookMark(BookMark _bookMark) throws WCMException {
        this.assertNotNull(_bookMark);
        _bookMark.save(ContextHelper.getLoginUser());
        return _bookMark;
    }

    public MarkKind saveMarkKind(MarkKind _markKind) throws WCMException {
        this.assertNotNull(_markKind);
        _markKind.save(ContextHelper.getLoginUser());
        return _markKind;
    }

    public void cancelShares(int _nObjType, CMSBaseObjs _currObjs) throws WCMException {
        if (_currObjs == null || _currObjs.isEmpty()) {
            throw new WCMException(10, I18NMessage.get(BookMarkMgr.class, "BookMarkMgr.label2", "\u4f20\u5165\u65e0\u6548\u7684\u5bf9\u8c61[null]\uff0c\u65e0\u6cd5\u5b8c\u6210\u53d6\u6d88\u5171\u4eab\u64cd\u4f5c\uff01"));
        }
        for (int i = 0; i < _currObjs.size(); ++i) {
            this.cancelShares(_nObjType, _currObjs.getAt(i).getId());
        }
    }

    public void shareTo(int _nObjType, CMSBaseObjs _currObjs, int _nViewerType, String _sViewerIds) throws WCMException {
        if (_sViewerIds == null || _sViewerIds.trim().length() <= 0) {
            return;
        }
        if (_currObjs == null || _currObjs.isEmpty()) {
            throw new WCMException(10, I18NMessage.get(BookMarkMgr.class, "BookMarkMgr.label2", "\u4f20\u5165\u65e0\u6548\u7684\u5bf9\u8c61[null]\uff0c\u65e0\u6cd5\u5b8c\u6210\u53d6\u6d88\u5171\u4eab\u64cd\u4f5c\uff01"));
        }
        if (!this.isValidViewer(_nViewerType, _sViewerIds)) {
            throw new WCMException(10, I18NMessage.get(BookMarkMgr.class, "BookMarkMgr.label5", "\u65e0\u6548\u7684\u5171\u4eab\u8005!"));
        }
        for (int i = 0; i < _currObjs.size(); ++i) {
            this.shareMark(_nViewerType, _sViewerIds, _nObjType, _currObjs.getAt(i).getId());
        }
    }

    private void cancelShares(int _markType, int _markId) throws WCMException {
        WCMFilter aFilter = new WCMFilter("", "ObjId=" + _markId + " AND ObjType=" + _markType, "");
        MarkShares markShares = MarkShares.openWCMObjs(this.getLoginUser(), aFilter);
        markShares.removeAll();
    }

    private void assertNotNull(BaseObj _baseObj) throws WCMException {
        if (_baseObj == null) {
            throw new WCMException(10, I18NMessage.get(BookMarkMgr.class, "BookMarkMgr.label6", "\u65e0\u6548\u7684\u5bf9\u8c61[null],\u65e0\u6cd5\u5b8c\u6210\u64cd\u4f5c!"));
        }
    }

    private User getLoginUser() throws WCMException {
        User user = ContextHelper.getLoginUser();
        if (user == null) {
            throw new WCMException(1001, I18NMessage.get(BookMarkMgr.class, "BookMarkMgr.label7", "\u7528\u6237\u672a\u767b\u5f55\u6216\u767b\u5f55\u8d85\u65f6!"));
        }
        return user;
    }
}

