/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.address;

import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;

public class Contact
extends CMSObj {
    public static final int OBJ_TYPE = 304;
    public static final String DB_TABLE_NAME = "WCMCONTACT";
    public static final String DB_ID_NAME = "CONTACTID";

    @Override
    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    @Override
    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    @Override
    public int getWCMType() {
        return 304;
    }

    public String getUserName() {
        return (String)this.getProperty("USERNAME");
    }

    public boolean setUserName(String _userName) throws WCMException {
        return this.setProperty("USERNAME", _userName);
    }

    public String getNickName() {
        return (String)this.getProperty("NICKNAME");
    }

    public boolean setNickName(String _nickName) throws WCMException {
        return this.setProperty("NICKNAME", _nickName);
    }

    public String getDesc() {
        return (String)this.getProperty("CDESC");
    }

    public boolean setDesc(String _desc) throws WCMException {
        return this.setProperty("CDESC", _desc);
    }

    public String getEmail() {
        return (String)this.getProperty("EMAIL");
    }

    public boolean setEmail(String _email) throws WCMException {
        return this.setProperty("EMAIL", _email);
    }

    @Override
    public String getAttribute() {
        return (String)this.getProperty("ATTRIBUTE");
    }

    @Override
    public boolean setAttribute(String _attribute) throws WCMException {
        return this.setProperty("ATTRIBUTE", _attribute);
    }

    public String getMobile() {
        return (String)this.getProperty("MOBILE");
    }

    public boolean setMobile(String _mobile) throws WCMException {
        return this.setProperty("MOBILE", _mobile);
    }

    public String getTel() {
        return (String)this.getProperty("TEL");
    }

    public boolean setTel(String _tel) throws WCMException {
        return this.setProperty("TEL", _tel);
    }

    public String getAddress() {
        return (String)this.getProperty("ADDRESS");
    }

    public boolean setAddress(String _address) throws WCMException {
        return this.setProperty("ADDRESS", _address);
    }

    @Override
    public boolean isValid() throws WCMException {
        String sUserName = null;
        if (this.isAddMode()) {
            sUserName = (String)this.getAllProperty().get("USERNAME");
            if (sUserName == null) {
                throw new WCMException(1106, I18NMessage.get(Contact.class, "Contact.label1", "\u5c5e\u6027UserName\u6ca1\u6709\u8bbe\u7f6e(Contact.isValid)"));
            }
        } else if (!this.isModified()) {
            throw new WCMException(1107, I18NMessage.get(Contact.class, "Contact.label2", "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539(Contact.isValid)"));
        }
        return true;
    }

    @Override
    public void insert(User _currUser) throws WCMException {
        if (this.isAddMode() && this.getAllProperty() != null) {
            this.setCrTime();
            super.insert(_currUser);
        }
    }

    public boolean isSystemUser() {
        return User.findByName(this.getUserName()) != null;
    }

    public String getSystemUserId() {
        if (!this.isSystemUser()) {
            throw new UnsupportedOperationException("not a system user");
        }
        int nUserId = User.findByName(this.getUserName()).getId();
        return String.valueOf(nUserId);
    }

    public static final Contact findById(int _nId) throws WCMException {
        if (_nId <= 0) {
            return null;
        }
        return (Contact)BaseObj.findById(Contact.class, _nId);
    }

    public static final Contact createNewInstance() throws WCMException {
        return (Contact)BaseObj.createNewInstance(Contact.class);
    }

    public static final Contact findByKey(Object _oKey) throws WCMException {
        return (Contact)BaseObj.findByKey(Contact.class, _oKey);
    }
}

