/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.comment.publish.tagparser;

import com.trs.DreamFactory;
import com.trs.components.comment.domain.NewsComment;
import com.trs.components.comment.publish.helper.CommentParserEntity;
import com.trs.components.comment.publish.helper.CommentParserUtil;
import com.trs.components.common.conjection.persistent.EntryConfig;
import com.trs.components.common.conjection.service.IComponentEntryConfigService;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.tagparser.ITagParser;
import com.trs.components.common.publish.domain.tagparser.TagBeanAttrInfo;
import com.trs.components.common.publish.domain.tagparser.TagBeanInfo;
import com.trs.components.common.publish.domain.tagparser.TagItem;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.template.TemplateQuote;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyString;
import org.apache.log4j.Logger;

public class XWCMTagParserComment
implements ITagParser {
    private static Logger s_logger = Logger.getLogger(XWCMTagParserComment.class);
    private TagItem m_tagItem = null;
    private String m_sCurrPageEncoding = "utf-8";
    private static TagBeanInfo s_TagBeanInfo = null;

    @Override
    public TagBeanInfo getBeanInfo() {
        if (s_TagBeanInfo == null) {
            TagBeanAttrInfo tbai = null;
            TagBeanInfo tbi = new TagBeanInfo();
            tbi.setName("TRS_COMMENT");
            tbi.setDesc("TRS_COMMENT");
            tbi.setType(TagBeanInfo.BodyType.IGNORE);
            tbai = new TagBeanAttrInfo();
            tbai.setName("COUNTER");
            tbai.setType(TagBeanAttrInfo.Type.INTEGER);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("CONTENTTYPE");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("IPDISPLAYSTYLE");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("TOPRANGE");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("DISPLAYCOMMENT");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("TOPICID");
            tbai.setType(TagBeanAttrInfo.Type.INTEGER);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("TOPICTITLE");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("ENCODING");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("FIELD");
            tbai.setDesc("\u83b7\u53d6\u7279\u6b8a\u7684\u51e0\u4e2a\u5177\u4f53\u503c");
            tbai.setRequired(false);
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setEnumValue(new String[]{"APPURL", "VERIFYCODEIMG", "SIGNDATA"});
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("APPURL");
            tbai.setDesc("\u6307\u5b9aAPPURL");
            tbai.setRequired(false);
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbi.addAttrInfo(tbai);
            s_TagBeanInfo = tbi;
        }
        return s_TagBeanInfo;
    }

    @Override
    public void setTagItem(TagItem _item) {
        this.m_tagItem = _item;
    }

    public void clear() {
        if (this.m_tagItem != null) {
            this.m_tagItem = null;
        }
    }

    @Override
    public TemplateQuote[] analyzeQuotes(IPublishFolder _root) {
        return null;
    }

    @Override
    public String[] parse(PublishTagContext _context) throws WCMException {
        String field;
        IPublishElement element = _context.getUpperHost();
        if (element == null) {
            return null;
        }
        if (!(element.getSubstance() instanceof Document)) {
            throw new WCMException(I18NMessage.get(XWCMTagParserComment.class, "XWCMTagParserComment.label1", "\u5f53\u524d\u7684\u5bf9\u8c61[") + element + I18NMessage.get(XWCMTagParserComment.class, "XWCMTagParserComment.label2", "]\u4e0d\u662f\u6587\u6863\u5bf9\u8c61\uff01"));
        }
        String result = _context.getAttribute("APPURL");
        if (CMyString.isEmpty(result)) {
            result = ConfigServer.getServer().getSysConfigValue("COMMENT_APPURL", "");
        }
        if (CMyString.isEmpty(result)) {
            IComponentEntryConfigService configSrv = (IComponentEntryConfigService)DreamFactory.createObjectById("IComponentEntryConfigService");
            EntryConfig currConfig = configSrv.getTypedEntryConfig(4);
            result = currConfig.getLinkPath();
        }
        if (CMyString.isEmpty(result)) {
            result = _context.getPathCompass().getRootDomain(_context.getRoot());
        }
        if (!CMyString.isEmpty(field = _context.getAttribute("FIELD"))) {
            return this.parseField(result, field, element);
        }
        Document doc = (Document)element.getSubstance();
        try {
            result = CMyString.setStrEndWith(result, '/');
            if (element.getEncoding() != null) {
                this.m_sCurrPageEncoding = element.getEncoding();
            }
            result = result + this.parseComment(doc, this.m_tagItem);
        }
        catch (Exception ex) {
            throw new WCMException("Failed to parse the  coment of document[" + doc.getId() + "]!", ex);
        }
        return new String[]{result};
    }

    private String[] parseField(String result, String field, IPublishElement _element) throws WCMException {
        String[] r = new String[1];
        String sField = field.toUpperCase();
        if ("APPURL".equals(sField)) {
            r[0] = result;
        } else if ("VERIFYCODEIMG".equals(sField)) {
            if (result.charAt(result.length() - 1) != '/') {
                result = result + '/';
            }
            r[0] = result = result + "cn/randCodeGen.jsp";
        } else if ("SIGNDATA".equals(sField)) {
            Document doc = (Document)_element.getSubstance();
            NewsComment newsComment = this.makeNewsComment(doc, this.m_tagItem);
            try {
                r[0] = newsComment.getDataWithSign();
            }
            catch (Exception e) {
                throw new WCMException("\u83b7\u53d6\u7b7e\u540d\u6570\u636e\u51fa\u73b0\u5f02\u5e38", e);
            }
        }
        return r;
    }

    private String parseComment(Document doc, TagItem _oTagItem) throws WCMException {
        String sCommentURL = null;
        try {
            NewsComment aComment = this.makeNewsComment(doc, _oTagItem);
            String sData = aComment.getDataWithSign();
            sCommentURL = "comment?newsid=" + doc.getId() + "&encoding=" + this.m_sCurrPageEncoding + "&data=" + sData;
            String sDisplayComment = _oTagItem.getAttribute("DISPLAYCOMMENT");
            if (sDisplayComment != null) {
                String sAppendParam = this.getIfDisplayCommentParam(sDisplayComment);
                sCommentURL = sCommentURL + sAppendParam;
            }
        }
        catch (Exception ex) {
            throw new WCMException("Failed to parse the comment tag!", ex);
        }
        return sCommentURL;
    }

    private NewsComment makeNewsComment(Document doc, TagItem _oTagItem) throws WCMException {
        NewsComment aComment = new NewsComment();
        aComment.setLimit(1);
        CommentParserEntity entity = CommentParserUtil.getCommentParserEntity(doc, _oTagItem);
        if (s_logger.isDebugEnabled()) {
            s_logger.info((Object)("Entity is : " + entity.toString()));
        }
        aComment.setNewsId(entity.getId());
        aComment.setNewsTitle(entity.getTitle());
        aComment.setTopicId(entity.getTopicId());
        aComment.setTopicTitle(entity.getTopicTitle());
        aComment.setSiteId(entity.getSiteId());
        aComment.setChannelId(entity.getChannelId());
        int nPostCounter = _oTagItem.getIntAttribute("COUNTER", 0);
        if (nPostCounter != 0) {
            String sAdditionalData = this.getAdditionalData(_oTagItem, nPostCounter);
            aComment.setAdditionalData(sAdditionalData);
        }
        return aComment;
    }

    private String getIfDisplayCommentParam(String sDisplayComment) throws WCMException {
        if (!(sDisplayComment = sDisplayComment.toLowerCase()).equals("false") && !sDisplayComment.equals("true")) {
            throw new WCMException("invalid attribute value '" + sDisplayComment + "' for DISPLAYCOMMENT of <TRS_COMMENT>!");
        }
        String sAppendParam = sDisplayComment.equals("false") ? "&displaycomment=0" : "";
        return sAppendParam;
    }

    private String getAdditionalData(TagItem _oTagItem, int nPostCounter) throws WCMException {
        String sContentType = _oTagItem.getAttribute("CONTENTTYPE");
        String sTopRange = _oTagItem.getAttribute("TOPRANGE");
        int nIPDisplayStyle = _oTagItem.getIntAttribute("IPDISPLAYSTYLE", 1);
        if (sContentType == null) {
            sContentType = "JS";
        } else if (!NewsComment.isValidContentType(sContentType)) {
            throw new WCMException("invalid attribute value '" + sContentType + "' for CONTENTTYPE of <TRS_COMMENT>!");
        }
        if (sTopRange == null) {
            sTopRange = "TIME";
        } else if (!NewsComment.isValidTopRange(sTopRange)) {
            throw new WCMException("invalid attribute value '" + sTopRange + "' for TOPRANGE of <TRS_COMMENT>!");
        }
        String sContentEncoding = _oTagItem.getAttribute("ENCODING");
        if (CMyString.isEmpty(sContentEncoding)) {
            sContentEncoding = this.m_sCurrPageEncoding;
        }
        String sAdditionalData = nPostCounter + ";" + sContentType + ";" + sTopRange + ";" + nIPDisplayStyle + ";" + sContentEncoding;
        return sAdditionalData;
    }
}

