/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.comment.domain;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.comment.persistent.DocumentTopic;
import com.trs.components.comment.persistent.DocumentTopics;
import com.trs.components.comment.persistent.TopicedDocRelation;
import com.trs.components.comment.persistent.TopicedDocRelations;
import com.trs.components.wcm.content.domain.DocumentMgr;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyString;

public class DocumentTopicRelationMgr {
    public DocumentTopicRelationMgr() {
        new DocumentMgr();
    }

    protected User getCurrentUser() {
        return ContextHelper.getLoginUser();
    }

    public void saveDocTopicRelation(int _nTopicId, int _nDocChannelId, int[] _arRelatedDocIds) throws CMyException {
        String sWhere = "TOPICID = " + _nTopicId;
        if (_nDocChannelId != -1) {
            sWhere = sWhere + " AND DOCCHANNELID=" + _nDocChannelId;
        }
        try {
            int i;
            TopicedDocRelations relations = TopicedDocRelations.openWCMObjs(this.getCurrentUser(), new WCMFilter("", sWhere, ""));
            if (relations.size() != 0) {
                for (i = 0; i < relations.size(); ++i) {
                    TopicedDocRelation relation = (TopicedDocRelation)relations.getAt(i);
                    relation.delete(this.getCurrentUser());
                }
            }
            if (_arRelatedDocIds == null) {
                return;
            }
            for (i = 0; i < _arRelatedDocIds.length; ++i) {
                int nDocId = _arRelatedDocIds[i];
                TopicedDocRelation relation = TopicedDocRelation.createNewInstance();
                relation.setDocumentId(nDocId);
                relation.setTopicId(_nTopicId);
                relation.setDocChannelId(_nDocChannelId);
                relation.save(this.getCurrentUser());
            }
        }
        catch (Exception ex) {
            throw new CMyException(I18NMessage.get(DocumentTopicRelationMgr.class, "DocumentTopicRelationMgr.label1", "\u67e5\u627e\u76f8\u5e94[ID=") + _nTopicId + I18NMessage.get(DocumentTopicRelationMgr.class, "DocumentTopicRelationMgr.label2", "]\u4e3b\u9898\u5bf9\u6587\u6863\u7684\u5173\u8054\u7684\u5931\u8d25\uff01"), ex);
        }
    }

    public DocumentTopic getDocumentTopic(int _nTopicId) {
        try {
            return DocumentTopic.findById(_nTopicId);
        }
        catch (Exception ex) {
            throw new RuntimeException("Error ocuured when seeking the certain topic with [ID=" + _nTopicId + "]", ex);
        }
    }

    public DocumentTopic getDocumentTopic(int _DocId, int _ChnlId) throws WCMException {
        if (_DocId == 0 || _ChnlId == 0) {
            return null;
        }
        StringBuffer bufWhere = new StringBuffer(" EXISTS(");
        bufWhere.append(" SELECT * FROM  XWCMTOPICEDDOCRELATION");
        bufWhere.append(" WHERE DOCUMENTID=" + _DocId);
        bufWhere.append(" AND DOCCHANNELID=" + _ChnlId);
        bufWhere.append(" AND TOPICID=M_TOPIC.DOCUMENTTOPICID");
        bufWhere.append(")");
        DocumentTopics topics = DocumentTopics.openWCMObjs(this.getCurrentUser(), new WCMFilter("XWCMDOCUMENTTOPIC M_TOPIC", bufWhere.toString(), null));
        bufWhere.setLength(0);
        if (topics.size() == 0) {
            return null;
        }
        return (DocumentTopic)topics.getAt(0);
    }

    public String getRelatedDocIds(int _nTopicId, int _nDocChannelId) throws CMyException {
        String sWhere = "TOPICID = " + _nTopicId;
        if (_nDocChannelId != -1) {
            sWhere = sWhere + " AND DOCCHANNELID=" + _nDocChannelId;
        }
        String sMsgIfFailed = I18NMessage.get(DocumentTopicRelationMgr.class, "DocumentTopicRelationMgr.label1", "\u67e5\u627e\u76f8\u5e94[ID=") + _nTopicId + I18NMessage.get(DocumentTopicRelationMgr.class, "DocumentTopicRelationMgr.label3", "]\u4e3b\u9898\u5bf9\u6587\u6863\u7684\u5173\u8054\u5931\u8d25\uff01");
        return this.getFilteredDcoIds(sWhere, sMsgIfFailed);
    }

    public String getRelatedDocIds(int _nTopicId) throws CMyException {
        return this.getRelatedDocIds(_nTopicId, -1);
    }

    public boolean isInRelatedTopic(int _nDocId, int _nDocChannelId) throws CMyException {
        String sMsgIfFailed;
        if (_nDocId == 0 || _nDocChannelId == 0) {
            return false;
        }
        String sWhere = "DOCUMENTID = " + _nDocId + " AND DOCCHANNELID=" + _nDocChannelId;
        return null != this.getFilteredDcoIds(sWhere, sMsgIfFailed = I18NMessage.get(DocumentTopicRelationMgr.class, "DocumentTopicRelationMgr.label1", "\u67e5\u627e\u76f8\u5e94[ID=") + _nDocId + I18NMessage.get(DocumentTopicRelationMgr.class, "DocumentTopicRelationMgr.label3", "]\u4e3b\u9898\u5bf9\u6587\u6863\u7684\u5173\u8054\u5931\u8d25\uff01"));
    }

    public boolean isInRelatedTopic(String _sRelatedDocIds, int _nDocId) throws WCMException {
        if (CMyString.isEmpty(_sRelatedDocIds)) {
            throw new WCMException("The given doc ids is dimmy!");
        }
        String[] arDocIds = _sRelatedDocIds.split(",");
        for (int i = 0; i < arDocIds.length; ++i) {
            String sBoxedDocId = arDocIds[i];
            if (sBoxedDocId.compareToIgnoreCase(String.valueOf(_nDocId)) != 0) continue;
            return true;
        }
        return false;
    }

    public String getNoneRelatedDocIds(int _nTopicId, int _nDocChannelId) throws CMyException {
        String sWhere = "TOPICID <> " + _nTopicId;
        if (_nDocChannelId != -1) {
            sWhere = sWhere + " AND DOCCHANNELID=" + _nDocChannelId;
        }
        String sMsgIfFailed = I18NMessage.get(DocumentTopicRelationMgr.class, "DocumentTopicRelationMgr.label1", "\u67e5\u627e\u76f8\u5e94[ID=") + _nTopicId + I18NMessage.get(DocumentTopicRelationMgr.class, "DocumentTopicRelationMgr.label4", "]\u4e3b\u9898\u5bf9\u6587\u6863\u7684\u975e\u5173\u8054\u5931\u8d25\uff01");
        return this.getFilteredDcoIds(sWhere, sMsgIfFailed);
    }

    private String getFilteredDcoIds(String sWhere, String sMsgIfFailed) throws CMyException {
        try {
            TopicedDocRelations relations = TopicedDocRelations.openWCMObjs(this.getCurrentUser(), new WCMFilter("", sWhere, ""));
            if (relations.size() == 0) {
                return null;
            }
            Object[] arTopicIds = new String[relations.size()];
            for (int i = 0; i < arTopicIds.length; ++i) {
                arTopicIds[i] = relations.getAt(i).getPropertyAsInt("DOCUMENTID", 0) + "";
            }
            return CMyString.join(arTopicIds, ",");
        }
        catch (Exception ex) {
            throw new CMyException(sMsgIfFailed, ex);
        }
    }

    public void deleteTopicDocRelation(int documentTopicId, int delDocumentId) throws WCMException {
        String sWhere = "TOPICID=" + documentTopicId + " AND DOCUMENTID=" + delDocumentId;
        TopicedDocRelations relations = TopicedDocRelations.openWCMObjs(this.getCurrentUser(), new WCMFilter("", sWhere, ""));
        if (relations.size() == 0 || relations.getAt(0) == null) {
            throw new WCMException("cannot find the related document with [ID=" + delDocumentId + ", TopicId=" + documentTopicId + "]");
        }
        relations.getAt(0).delete();
    }

    public void deleteTopicDocRelation(int documentTopicId) throws WCMException {
        String sWhere = "TOPICID=" + documentTopicId;
        TopicedDocRelations relations = TopicedDocRelations.openWCMObjs(this.getCurrentUser(), new WCMFilter("", sWhere, ""));
        if (relations.size() == 0 || relations.getAt(0) == null) {
            throw new WCMException("cannot find the related document with [TopicId=" + documentTopicId + "]");
        }
        relations.getAt(0).delete();
    }
}

