/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.process.xml;

import com.trs.DreamFactory;
import com.trs.cms.auth.persistent.Group;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSBaseObjs;
import com.trs.cms.content.CMSObj;
import com.trs.cms.process.definition.Flow;
import com.trs.cms.process.definition.FlowAction;
import com.trs.cms.process.definition.FlowActions;
import com.trs.cms.process.definition.FlowCondition;
import com.trs.cms.process.definition.FlowConditions;
import com.trs.cms.process.definition.FlowNode;
import com.trs.cms.process.definition.FlowNodeBranch;
import com.trs.cms.process.definition.FlowNodeBranchs;
import com.trs.cms.process.definition.FlowNodeField;
import com.trs.cms.process.definition.FlowNodeFields;
import com.trs.cms.process.definition.FlowNodes;
import com.trs.cms.process.definition.FlowOptMarkEnumParser;
import com.trs.cms.process.definition.FlowRule;
import com.trs.cms.process.definition.FlowRules;
import com.trs.cms.process.definition.IFlowRuleCacheServer;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.XmlObject;
import com.trs.infra.persistent.XmlToObjConverterByDOM4j;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.Reports;
import com.trs.infra.util.database.DBType;
import org.apache.log4j.Logger;

public class FlowImporter {
    private static Logger s_logger = Logger.getLogger(FlowImporter.class);
    private IFlowRuleCacheServer m_oRuleCacheServer = (IFlowRuleCacheServer)DreamFactory.createObjectById("IFlowRuleCacheServer");
    private XmlToObjConverterByDOM4j m_converter;
    private Reports m_reports;
    private static final String PROPERTY_CRTIME = "CRTIME";
    private static final String PROPERTY_CRUSER = "CRUSER";
    private static final char CHAR_S = 'S';
    private static final String TAG_NODES = "WCMFLOWNODES";
    private static final String TAG_BRANCHS = "WCMFLOWBRANCHS";
    private static final String TAG_NODE_FIELDS = "XWCMFLOWNODEFIELDS";
    private static final String TAG_RULES = "XWCMFLOWRULES";
    private static final String TAG_CONDITIONS = "XWCMFLOWCONDITIONS";
    private static final String TAG_ACTIONS = "XWCMFLOWACTIONS";
    private static final String TAG_USERS = "WCMUSERS";
    private static final String TAG_GROUPS = "WCMGROUPS";
    private boolean m_bUpdateMode = false;
    private User m_oLoginUser = null;
    public int m_nCurrFlowId = 0;
    private boolean m_bImportWithFlowNodeFields = false;
    private boolean m_bImportWithOptMarkEnum = false;
    private boolean m_bImportWithInfoviewId = false;
    private CMSObj m_oOwner = null;

    public FlowImporter(int _nImportType) {
        this.m_converter = new XmlToObjConverterByDOM4j(_nImportType);
        this.m_bUpdateMode = 1 != _nImportType;
        this.registerConverter();
    }

    public FlowImporter(User _loginUser, int _nImportType) {
        this.m_oLoginUser = _loginUser;
        this.m_converter = new XmlToObjConverterByDOM4j(_nImportType);
        this.m_bUpdateMode = 1 != _nImportType;
        this.registerConverter();
    }

    public Reports importFromFile(String _sXmlFile, String _sXslFile) throws WCMException {
        this.assertNotEmptyString(_sXmlFile);
        this.assertUnSupportFile(_sXmlFile);
        String sFullXmlFile = this.getFullName(_sXmlFile);
        if (_sXslFile != null) {
            _sXslFile = this.getFullName(_sXslFile);
        }
        XmlObject[] flowXmlObjs = this.m_converter.convertXml(sFullXmlFile, _sXslFile, null);
        this.m_reports = new Reports(I18NMessage.get(FlowImporter.class, "FlowImporter.label1", "\u5bfc\u5165\u5de5\u4f5c\u6d41"));
        int[] arIds = new int[flowXmlObjs.length];
        for (int i = 0; i < flowXmlObjs.length; ++i) {
            this.importFlowInfo(flowXmlObjs[i]);
            arIds[i] = this.m_nCurrFlowId;
        }
        this.m_reports.setResultIds(arIds);
        return this.m_reports;
    }

    public Reports importFromXMLContent(String _sXmlContent) throws WCMException {
        XmlObject[] flowXmlObjs = this.m_converter.convertXml(_sXmlContent, null);
        this.m_reports = new Reports(I18NMessage.get(FlowImporter.class, "FlowImporter.label1", "\u5bfc\u5165"));
        int[] arIds = new int[flowXmlObjs.length];
        for (int i = 0; i < flowXmlObjs.length; ++i) {
            this.importFlowInfo(flowXmlObjs[i]);
            arIds[i] = this.m_nCurrFlowId;
        }
        this.m_reports.setResultIds(arIds);
        return this.m_reports;
    }

    public Reports importFromXMLObj(XmlObject _sXmlObj) throws WCMException {
        this.m_reports = new Reports(I18NMessage.get(FlowImporter.class, "FlowImporter.label1", "\u5bfc\u5165"));
        this.importFlowInfo(_sXmlObj);
        return this.m_reports;
    }

    private void assertNotEmptyString(String _str) throws WCMException {
        if (_str == null || _str.trim().length() == 0) {
            throw new WCMException(10, I18NMessage.get(FlowImporter.class, "FlowImporter.label2", "\u65e0\u6548\u7684\u6587\u4ef6\u540d!"));
        }
    }

    private void assertUnSupportFile(String _sXmlFile) throws WCMException {
        String sExt = CMyFile.extractFileExt(_sXmlFile);
        if (!"xml".equalsIgnoreCase(sExt)) {
            throw new WCMException(1200, I18NMessage.get(FlowImporter.class, "FlowImporter.label3", "\u53ea\u652f\u6301\u4eceXML\u6587\u4ef6\u4e2d\u5bfc\u5165\u5de5\u4f5c\u6d41\u7684\u914d\u7f6e!"));
        }
    }

    private String getFullName(String _sFile) throws WCMException {
        FilesMan filesMan = FilesMan.getFilesMan();
        if (!CMyFile.fileExists(_sFile)) {
            String sPath = filesMan.mapFilePath(_sFile, 0);
            _sFile = sPath + _sFile;
        }
        return _sFile;
    }

    private void importFlowInfo(XmlObject _flowXmlObj) {
        Flow flow = null;
        try {
            flow = (Flow)_flowXmlObj.getCurrentObj();
            if (flow == null) {
                s_logger.error((Object)"failed to parse the flow object!");
                this.m_reports.addFailedReport(I18NMessage.get(FlowImporter.class, "FlowImporter.label4", "\u5bfc\u5165\u5de5\u4f5c\u6d41[\u65e0\u6cd5\u89e3\u6790\u7684XML\u8282\u70b9]\u5931\u8d25\uff01"), new WCMException(I18NMessage.get(FlowImporter.class, "FlowImporter.label5", "\u65e0\u6cd5\u8bc6\u522b\u7684\u5bf9\u8c61\u5c5e\u6027\uff01-->") + _flowXmlObj));
                return;
            }
            this.removePropertyIfNecessary(flow);
            boolean bIsFlowAddMode = flow.isAddMode();
            if (!bIsFlowAddMode) {
                flow.validCanEditAndLock(this.m_oLoginUser);
            } else {
                if (this.m_oOwner != null) {
                    flow.setOwner(this.m_oOwner.getWCMType(), this.m_oOwner.getId());
                }
                if (!this.m_bImportWithInfoviewId) {
                    flow.getProperties().remove("INFOVIEWID");
                }
            }
            this.changeFlowNameIfNescessary(flow);
            if (!bIsFlowAddMode && this.isImportWithOptMarkEnum()) {
                flow = this.fillFLowOptMarkEnum(flow);
            }
            flow.save(this.m_oLoginUser);
            XmlObject[] nodesFlowRules = _flowXmlObj.getChild(TAG_RULES);
            this.importRules(nodesFlowRules, flow);
            XmlObject[] nodes = _flowXmlObj.getChild(TAG_NODES);
            this.importNodes(nodes, flow.getId());
            this.m_reports.addSucessedReport(I18NMessage.get(FlowImporter.class, "FlowImporter.label6", "\u5bfc\u5165[") + flow + I18NMessage.get(FlowImporter.class, "FlowImporter.label7", "]\u6210\u529f!"));
            this.m_nCurrFlowId = flow.getId();
            if (bIsFlowAddMode && this.isImportWithOptMarkEnum()) {
                flow = this.fillFLowOptMarkEnum(flow);
                flow.save();
            }
        }
        catch (Throwable t) {
            s_logger.error((Object)"failed to save the flow object!", t);
            this.m_reports.addFailedReport(I18NMessage.get(FlowImporter.class, "FlowImporter.label9", "\u5bfc\u5165[") + flow + I18NMessage.get(FlowImporter.class, "FlowImporter.label8", "]\u5931\u8d25!"), t);
        }
    }

    private Flow fillFLowOptMarkEnum(Flow _flow) throws WCMException {
        String sOptMarkEnum = FlowOptMarkEnumParser.getFlowOptMarkEnum(_flow);
        if (!CMyString.isEmpty(sOptMarkEnum)) {
            _flow.setProperty("OperationMarkEnum", sOptMarkEnum);
        }
        return _flow;
    }

    private void changeFlowNameIfNescessary(Flow _flow) throws Throwable {
        String sName = _flow.getName();
        if (_flow.isChangeProperty("FLOWNAME")) {
            sName = _flow.getNewPropertyAsString("FLOWNAME");
        }
        int nOwnerType = _flow.getOwnerType();
        int nOwnerId = _flow.getOwnerId();
        String sNewName = sName.trim();
        int count = 0;
        while (this.exists(sNewName, nOwnerType, nOwnerId, _flow.getId())) {
            sNewName = sName + "_" + count;
            ++count;
        }
        _flow.setName(sNewName);
    }

    private boolean exists(String _sName, int _nOwnerType, int _nOwnerId, int _nFlowId) throws Throwable {
        WCMFilter filter = new WCMFilter("WCMFlow", "FlowName=? and OwnerType=? and OwnerId=? and FlowId<>?", "", "FlowId");
        filter.addSearchValues(_sName);
        filter.addSearchValues(_nOwnerType);
        filter.addSearchValues(_nOwnerId);
        filter.addSearchValues(_nFlowId);
        return DBManager.getDBManager().sqlExecuteIntQuery(filter) > 0;
    }

    private void importNodes(XmlObject[] _nodes, int _nFlowId) throws Throwable {
        int i;
        int[] nNodeIds = new int[_nodes.length];
        for (i = 0; i < _nodes.length; ++i) {
            nNodeIds[i] = _nodes[i].getCurrentObj().getId();
        }
        this.clearUnUsedNodeWhenUpdate(_nFlowId, nNodeIds);
        for (i = 0; i < _nodes.length; ++i) {
            this.importNodeInfo(_nodes[i], _nFlowId);
        }
    }

    private FlowNode importNodeInfo(XmlObject _node, int _nFlowId) throws Throwable {
        FlowNode flowNode = (FlowNode)_node.getCurrentObj();
        if (flowNode.isAddMode()) {
            flowNode.setFlow(_nFlowId);
        } else {
            flowNode.validCanEditAndLock(this.m_oLoginUser);
        }
        this.removePropertyIfNecessary(flowNode);
        flowNode.save(this.m_oLoginUser);
        this.clearNodeOperInfos(flowNode.getId());
        this.importOperUsers(_node.getChild(TAG_USERS), flowNode.getId());
        this.importOperGroups(_node.getChild(TAG_GROUPS), flowNode.getId());
        this.importBranchs(_node.getChild(TAG_BRANCHS), flowNode.getId());
        this.importRules(_node.getChild(TAG_RULES), flowNode);
        if (this.isImportWithFlowNodeFields()) {
            this.importNodeFields(_node.getChild(TAG_NODE_FIELDS), flowNode);
        }
        this.m_oRuleCacheServer.reloadRuleCache(flowNode);
        return flowNode;
    }

    private void clearNodeOperInfos(int _nNodeId) throws Throwable {
        String sql = "DELETE FROM WCMFLOWNODEOPER WHERE NodeId=" + _nNodeId;
        DBManager.getDBManager().sqlExecuteUpdate(sql);
    }

    private void importOperUsers(XmlObject[] _users, int _nFlowNodeId) throws Throwable {
        for (int i = 0; i < _users.length; ++i) {
            User user = (User)_users[i].getCurrentObj();
            if (user.getPropertyAsString("UserName") != null) {
                String sUserName = user.getPropertyAsString("UserName");
                if ((user = User.findByName(sUserName)) == null || user.isDeleted() || user.getStatus() != 30) continue;
                this.importOperInfo(_nFlowNodeId, user.getId(), 204);
                continue;
            }
            this.importOperInfo(_nFlowNodeId, user.getPropertyAsInt("USERID", 0), 204);
        }
    }

    private void importOperGroups(XmlObject[] _groups, int _nFlowNodeId) throws Throwable {
        for (int i = 0; i < _groups.length; ++i) {
            Group group = (Group)_groups[i].getCurrentObj();
            this.importOperInfo(_nFlowNodeId, group.getPropertyAsInt("GROUPID", 0), 201);
        }
    }

    private void importOperInfo(int _nNodeId, int _nOperId, int _nOperType) throws Throwable {
        DBManager dbMgr = DBManager.getDBManager();
        DBType dbType = dbMgr.getDBType();
        StringBuffer sql = new StringBuffer("INSERT INTO WCMFLOWNODEOPER");
        sql.append('(');
        sql.append("NODEID");
        sql.append(',');
        sql.append("OPERTYPE");
        sql.append(',');
        sql.append("OPERID");
        sql.append(',');
        sql.append(PROPERTY_CRUSER);
        sql.append(',');
        sql.append(PROPERTY_CRTIME);
        sql.append(')');
        sql.append(" VALUES(");
        sql.append(_nNodeId);
        sql.append(',');
        sql.append(_nOperType);
        sql.append(',');
        sql.append(_nOperId);
        sql.append(',');
        sql.append('\'');
        sql.append(CMyString.filterForSQL(this.getLoginUser().getName()));
        sql.append('\'');
        sql.append(',');
        sql.append(dbType.sqlGetSysDate());
        sql.append(')');
        dbMgr.sqlExecuteUpdate(sql.toString());
    }

    private void clearUnUsedNodeWhenUpdate(int _nFlowId, int[] _nUsedNodeIds) throws Throwable {
        if (!this.m_bUpdateMode) {
            return;
        }
        WCMFilter aFilter = new WCMFilter("WCMFLOWNODE", "FlowId=" + _nFlowId, "");
        this.clearUnUsedDataWhenUpdate(FlowNodes.class, aFilter, _nUsedNodeIds);
    }

    private void importBranchs(XmlObject[] _branchs, int _nFlowNodeId) throws Throwable {
        int[] branchIds = new int[_branchs.length];
        for (int i = 0; i < _branchs.length; ++i) {
            FlowNodeBranch branch = this.importBranchInfo(_branchs[i], _nFlowNodeId);
            if (branch == null) continue;
            branchIds[i] = branch.getId();
        }
        this.clearUnUsedBranchsWhenUpdate(_nFlowNodeId, branchIds);
    }

    private FlowNodeBranch importBranchInfo(XmlObject _branch, int _nFlowNodeId) throws Throwable {
        FlowNodeBranch flowNodeBranch = (FlowNodeBranch)_branch.getCurrentObj();
        if (flowNodeBranch.isAddMode()) {
            flowNodeBranch.setNode(_nFlowNodeId);
        } else {
            flowNodeBranch.validCanEditAndLock(this.m_oLoginUser);
        }
        this.removePropertyIfNecessary(flowNodeBranch);
        flowNodeBranch.canEdit(this.getLoginUser());
        flowNodeBranch.save(this.m_oLoginUser);
        this.importRules(_branch.getChild(TAG_RULES), flowNodeBranch);
        return flowNodeBranch;
    }

    private void clearUnUsedBranchsWhenUpdate(int _nNodeId, int[] _nUsedBranchIds) throws Throwable {
        if (!this.m_bUpdateMode) {
            return;
        }
        WCMFilter aFilter = new WCMFilter("WCMFLOWBRANCH", "NodeId=" + _nNodeId, "");
        this.clearUnUsedDataWhenUpdate(FlowNodeBranchs.class, aFilter, _nUsedBranchIds);
    }

    private void clearUnUsedDataWhenUpdate(Class _clazz, WCMFilter _filter, int[] _nUsedIds) throws Throwable {
        User user = this.getLoginUser();
        CMSBaseObjs allDatas = CMSBaseObjs.openWCMObjs(user, _clazz, _filter);
        CMSBaseObjs usedDatas = this.getUsedDatas(_clazz, _nUsedIds);
        if (usedDatas != null) {
            allDatas.minusWith(usedDatas);
        }
        allDatas.removeAll(true);
    }

    private CMSBaseObjs getUsedDatas(Class _clazz, int[] _nUsedIds) throws Throwable {
        String sUsedIds = ",";
        for (int i = 0; i < _nUsedIds.length; ++i) {
            int nId = _nUsedIds[i];
            if (nId == 0) continue;
            sUsedIds = sUsedIds + nId + ",";
        }
        if (sUsedIds.length() > 2) {
            sUsedIds = sUsedIds.substring(1, sUsedIds.length());
            return CMSBaseObjs.findWCMObjsByIds(this.getLoginUser(), _clazz, sUsedIds);
        }
        return null;
    }

    private void registerConverter() {
        this.m_converter.registPersistentObj("WCMFLOW", Flow.class);
        this.m_converter.registPersistentObj("WCMFLOWNODE", FlowNode.class);
        this.m_converter.registPersistentObj("WCMUSER", User.class);
        this.m_converter.registPersistentObj("WCMGROUP", Group.class);
        this.m_converter.registPersistentObj("WCMFLOWBRANCH", FlowNodeBranch.class);
        this.m_converter.registPersistentObj("XWCMFLOWRULE", FlowRule.class);
        this.m_converter.registPersistentObj("XWCMFLOWCONDITION", FlowCondition.class);
        this.m_converter.registPersistentObj("XWCMFLOWACTION", FlowAction.class);
        this.m_converter.registPersistentObj("XWCMFLOWNODEFIELD", FlowNodeField.class);
    }

    private void removePropertyIfNecessary(BaseObj _object) {
        if (_object.isAddMode()) {
            _object.removeProperty(PROPERTY_CRTIME);
            _object.removeProperty(PROPERTY_CRUSER);
        }
    }

    private User getLoginUser() {
        return this.m_oLoginUser;
    }

    private void importRules(XmlObject[] _xmlFlowRules, CMSObj _host) throws Throwable {
        int[] pRuleIds = new int[_xmlFlowRules.length];
        int nOrder = pRuleIds.length;
        int i = 0;
        while (i < _xmlFlowRules.length) {
            FlowRule rule = this.importRule(_xmlFlowRules[i], _host, nOrder);
            if (rule != null) {
                pRuleIds[i] = rule.getId();
            }
            ++i;
            --nOrder;
        }
        this.clearUnUsedRulesWhenUpdate(pRuleIds, _host);
    }

    private FlowRule importRule(XmlObject _xmlFlowRule, CMSObj _host, int _nOrder) throws Throwable {
        FlowRule flowRule = (FlowRule)_xmlFlowRule.getCurrentObj();
        if (flowRule.isAddMode()) {
            flowRule.setHostType(_host.getWCMType());
            flowRule.setHostId(_host.getId());
        } else {
            flowRule.validCanEditAndLock(this.m_oLoginUser);
        }
        flowRule.setOrder(_nOrder);
        this.removePropertyIfNecessary(flowRule);
        flowRule.save(this.m_oLoginUser);
        this.importConditions(_xmlFlowRule.getChild(TAG_CONDITIONS), flowRule);
        this.importActions(_xmlFlowRule.getChild(TAG_ACTIONS), flowRule);
        return flowRule;
    }

    private void clearUnUsedRulesWhenUpdate(int[] _pUsingRuleIds, CMSObj _host) throws Throwable {
        if (!this.m_bUpdateMode) {
            return;
        }
        WCMFilter aFilter = new WCMFilter("XWCMFLOWRULE", "HostType=? and HostId=?", "");
        aFilter.addSearchValues(_host.getWCMType());
        aFilter.addSearchValues(_host.getId());
        this.clearUnUsedDataWhenUpdate(FlowRules.class, aFilter, _pUsingRuleIds);
    }

    private void importConditions(XmlObject[] _xmlFlowConditions, FlowRule _rule) throws Throwable {
        int[] pConditionIds = new int[_xmlFlowConditions.length];
        int nOrder = pConditionIds.length;
        int i = 0;
        while (i < _xmlFlowConditions.length) {
            FlowCondition condition = this.importCondition(_xmlFlowConditions[i], _rule, nOrder);
            if (condition != null) {
                pConditionIds[i] = condition.getId();
            }
            ++i;
            --nOrder;
        }
        this.clearUnUsedConditionsWhenUpdate(pConditionIds, _rule);
    }

    private FlowCondition importCondition(XmlObject _xmlFlowCondition, FlowRule _rule, int _nOrder) throws Throwable {
        FlowCondition flowCondition = (FlowCondition)_xmlFlowCondition.getCurrentObj();
        if (flowCondition.isAddMode()) {
            flowCondition.setRuleId(_rule.getId());
        } else {
            flowCondition.validCanEditAndLock(this.m_oLoginUser);
        }
        flowCondition.setOrder(_nOrder);
        this.removePropertyIfNecessary(flowCondition);
        flowCondition.save(this.m_oLoginUser);
        return flowCondition;
    }

    private void clearUnUsedConditionsWhenUpdate(int[] _pUsingConditionIds, CMSObj _host) throws Throwable {
        if (!this.m_bUpdateMode) {
            return;
        }
        WCMFilter aFilter = new WCMFilter("XWCMFLOWCONDITION", "RuleId=?", "");
        aFilter.addSearchValues(_host.getId());
        this.clearUnUsedDataWhenUpdate(FlowConditions.class, aFilter, _pUsingConditionIds);
    }

    private void importActions(XmlObject[] _xmlFlowActions, FlowRule _rule) throws Throwable {
        int[] pActionIds = new int[_xmlFlowActions.length];
        int nOrder = pActionIds.length;
        int i = 0;
        while (i < _xmlFlowActions.length) {
            FlowAction action = this.importAction(_xmlFlowActions[i], _rule, nOrder);
            if (action != null) {
                pActionIds[i] = action.getId();
            }
            ++i;
            --nOrder;
        }
        this.clearUnUsedActionsWhenUpdate(pActionIds, _rule);
    }

    private FlowAction importAction(XmlObject _xmlFlowAction, FlowRule _rule, int _nOrder) throws Throwable {
        FlowAction flowAction = (FlowAction)_xmlFlowAction.getCurrentObj();
        if (flowAction.isAddMode()) {
            flowAction.setRuleId(_rule.getId());
        } else {
            flowAction.validCanEditAndLock(this.m_oLoginUser);
        }
        flowAction.setOrder(_nOrder);
        this.removePropertyIfNecessary(flowAction);
        flowAction.save(this.m_oLoginUser);
        return flowAction;
    }

    private void clearUnUsedActionsWhenUpdate(int[] _pUsingActionIds, CMSObj _host) throws Throwable {
        if (!this.m_bUpdateMode) {
            return;
        }
        WCMFilter aFilter = new WCMFilter("XWCMFLOWACTION", "RuleId=?", "");
        aFilter.addSearchValues(_host.getId());
        this.clearUnUsedDataWhenUpdate(FlowActions.class, aFilter, _pUsingActionIds);
    }

    private void importNodeFields(XmlObject[] _xmlFlowNodeFields, FlowNode _node) throws Throwable {
        int[] pNodeFieldIds = new int[_xmlFlowNodeFields.length];
        int nOrder = pNodeFieldIds.length;
        int i = 0;
        while (i < _xmlFlowNodeFields.length) {
            FlowNodeField field = this.importNodeField(_xmlFlowNodeFields[i], _node);
            if (field != null) {
                pNodeFieldIds[i] = field.getId();
            }
            ++i;
            --nOrder;
        }
        this.clearUnUsedNodeFieldsWhenUpdate(pNodeFieldIds, _node);
    }

    private FlowNodeField importNodeField(XmlObject _xmlFlowNodeField, FlowNode _node) throws Throwable {
        FlowNodeField flowNodeField = (FlowNodeField)_xmlFlowNodeField.getCurrentObj();
        if (flowNodeField.isAddMode()) {
            flowNodeField.setFlowId(_node.getFlowId());
            flowNodeField.setNodeId(_node.getId());
        } else {
            flowNodeField.validCanEditAndLock(this.m_oLoginUser);
        }
        this.removePropertyIfNecessary(flowNodeField);
        flowNodeField.save(this.m_oLoginUser);
        return flowNodeField;
    }

    private void clearUnUsedNodeFieldsWhenUpdate(int[] _pUsingNodeFieldIds, FlowNode _node) throws Throwable {
        if (!this.m_bUpdateMode) {
            return;
        }
        WCMFilter aFilter = new WCMFilter("XWCMFLOWNODEFIELD", "NodeId=?", "");
        aFilter.setPageSize(500);
        aFilter.addSearchValues(_node.getId());
        this.clearUnUsedDataWhenUpdate(FlowNodeFields.class, aFilter, _pUsingNodeFieldIds);
    }

    public CMSObj getOwner() {
        return this.m_oOwner;
    }

    public void setOwner(CMSObj owner) {
        this.m_oOwner = owner;
    }

    public boolean isImportWithFlowNodeFields() {
        return this.m_bImportWithFlowNodeFields;
    }

    public void setImportWithFlowNodeFields(boolean importWithFlowNodeFields) {
        this.m_bImportWithFlowNodeFields = importWithFlowNodeFields;
    }

    public boolean isImportWithOptMarkEnum() {
        return this.m_bImportWithOptMarkEnum;
    }

    public void setImportWithOptMarkEnum(boolean importWithOptMarkEnum) {
        this.m_bImportWithOptMarkEnum = importWithOptMarkEnum;
    }

    public void setImportWithInfoviewId(boolean _val) {
        this.m_bImportWithInfoviewId = _val;
    }

    public boolean isImportWithInfoviewId() {
        return this.m_bImportWithInfoviewId;
    }
}

