/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.process.engine;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.process.IFlowContent;
import com.trs.cms.process.IFlowServer;
import com.trs.cms.process.definition.FlowNode;
import com.trs.cms.process.engine.FlowContext;
import com.trs.cms.process.engine.FlowDoc;
import com.trs.cms.process.engine.FlowDocs;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.listener.IObjectLCListenerOnDel;
import org.apache.log4j.Logger;

public class FlowNodeLCListenerForForceEnd
implements IObjectLCListenerOnDel {
    private static Logger s_logger = Logger.getLogger(FlowNodeLCListenerForForceEnd.class);
    private IFlowServer m_oFlowServer = null;

    @Override
    public void notifyOnDelObj(BaseObj _oObjDeleted, int _nEventType) throws WCMException {
        if (!(_oObjDeleted instanceof FlowNode)) {
            s_logger.error((Object)("Listener[" + this.getClass() + I18NMessage.get(FlowNodeLCListenerForForceEnd.class, "FlowNodeLCListenerForForceEnd.label1", "]\u4e0d\u80fd\u76d1\u542c\u5bf9\u8c61[") + _oObjDeleted.getClass() + I18NMessage.get(FlowNodeLCListenerForForceEnd.class, "FlowNodeLCListenerForForceEnd.label2", "]\u7684\u4fee\u6539\uff01")));
            return;
        }
        FlowNode flowNode = (FlowNode)_oObjDeleted;
        WCMFilter aFilter = new WCMFilter("", "NODEID=? and Worked=0 and ParentId=0", "", "ObjType, ObjId");
        aFilter.addSearchValues(flowNode.getId());
        FlowDocs flowDocs = FlowDocs.openWCMObjs(User.getSystem(), aFilter);
        if (flowDocs == null || flowDocs.size() <= 0) {
            return;
        }
        User loginUser = ContextHelper.getLoginUser();
        for (int i = 0; i < flowDocs.size(); ++i) {
            try {
                IFlowContent content;
                FlowDoc flowDoc = (FlowDoc)flowDocs.getAt(i);
                if (flowDoc == null || (content = flowDoc.getFlowContent()) == null) continue;
                FlowContext context = new FlowContext();
                context.setFlowContent(content);
                context.setPostUser(loginUser);
                context.setCurrUser(loginUser);
                this.getFlowServer().forceEnd(context);
                continue;
            }
            catch (Throwable e) {
                s_logger.error((Object)I18NMessage.get(FlowNodeLCListenerForForceEnd.class, "FlowNodeLCListenerForForceEnd.label3", "\u5f3a\u5236\u7ed3\u675f\u6d41\u8f6c\u53d1\u751f\u5f02\u5e38"), e);
            }
        }
    }

    private IFlowServer getFlowServer() {
        if (this.m_oFlowServer == null) {
            this.m_oFlowServer = (IFlowServer)DreamFactory.createObjectById("IFlowServer");
        }
        return this.m_oFlowServer;
    }
}

