/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.process.definition;

import com.trs.DreamFactory;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.process.IFlowCacheMgr;
import com.trs.cms.process.definition.FlowNode;
import com.trs.cms.process.definition.FlowNodes;
import com.trs.infra.cache.Cache;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.support.cache.ICacheMgr;

public class FlowCacheMgr
implements ICacheMgr,
IFlowCacheMgr {
    private static Cache cache = (Cache)DreamFactory.createObjectById("cache");

    private String getKey() {
        return FlowCacheMgr.class.getName();
    }

    @Override
    public boolean init() throws WCMException {
        this.initFlowNodeNameCache();
        return true;
    }

    @Override
    public boolean reinit() throws WCMException {
        this.clear();
        return this.init();
    }

    @Override
    public void clear() {
        this.clearFlowNodeNameCache();
    }

    @Override
    public void notifyOnAddObj(BaseObj _oObjAdded) throws WCMException {
        if (_oObjAdded instanceof FlowNode) {
            FlowNode currNode = (FlowNode)_oObjAdded;
            this.putFlowNodeName(currNode);
        }
    }

    @Override
    public void notifyOnDelObj(BaseObj _oObjDeleted, int _nEventType) throws WCMException {
        if (_oObjDeleted instanceof FlowNode) {
            FlowNode currNode = (FlowNode)_oObjDeleted;
            this.removeFlowNodeName(currNode);
        }
    }

    @Override
    public void notifyOnModifyObj(BaseObj _oObjModified, int _nEventType) throws WCMException {
        if (_oObjModified instanceof FlowNode) {
            FlowNode currNode = (FlowNode)_oObjModified;
            if (_oObjModified.isChangeProperty("NODENAME")) {
                cache.clear(this.makeFlowNodeNameKey(currNode.getFlowId(), currNode.getPropertyAsString("NODENAME")));
                cache.set(this.makeFlowNodeNameKey(currNode.getFlowId(), currNode.getNewPropertyAsString("NODENAME")), currNode.getKey());
            } else {
                this.putFlowNodeName(currNode);
            }
        }
    }

    private synchronized void clearFlowNodeNameCache() {
        if (!cache.exists(this.getKey()).booleanValue()) {
            return;
        }
        cache.clear(this.getKey());
    }

    private synchronized void initFlowNodeNameCache() throws WCMException {
        if (cache.exists(this.getKey()).booleanValue()) {
            return;
        }
        cache.set(this.getKey(), "true");
        FlowNodes aFlowNodes = FlowNodes.openWCMObjs(User.getSystem(), null);
        for (int i = 0; i < aFlowNodes.size(); ++i) {
            FlowNode aFlowNode = (FlowNode)aFlowNodes.getAt(i);
            if (aFlowNode == null) continue;
            this.putFlowNodeName(aFlowNode);
        }
    }

    private void putFlowNodeName(FlowNode _currFlowNode) {
        cache.set(this.makeFlowNodeNameKey(_currFlowNode), _currFlowNode.getKey());
    }

    private void removeFlowNodeName(FlowNode _currFlowNode) throws WCMException {
        cache.clear(this.makeFlowNodeNameKey(_currFlowNode));
    }

    private String makeFlowNodeNameKey(FlowNode _currFlowNode) {
        return this.makeFlowNodeNameKey(_currFlowNode.getFlowId(), _currFlowNode.getName());
    }

    private String makeFlowNodeNameKey(int _nFlowId, String _sNodeName) {
        return this.getKey() + "." + _nFlowId + "." + _sNodeName;
    }

    @Override
    public FlowNode findFlowNodeByName(int _nFlowId, String _sNodeName) throws WCMException {
        Integer cacheKey = (Integer)cache.get(this.makeFlowNodeNameKey(_nFlowId, _sNodeName));
        FlowNode flowNode = FlowNode.findById(cacheKey);
        return flowNode;
    }
}

