/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.process;

import com.trs.cms.process.IFilterForFlowContent;
import com.trs.cms.process.IFlowContent;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.WCMDiscoveryFactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class FilterForFlowContentFactory {
    private static Logger logger = Logger.getLogger(FilterForFlowContentFactory.class);
    private static FilterForFlowContentFactory filterForFlowContentFactory = null;
    private List<IFilterForFlowContent> filterForFlowContentList = null;

    private FilterForFlowContentFactory() {
    }

    public boolean doFilter(Map valueMap, IFlowContent content) throws WCMException {
        if (this.filterForFlowContentList == null) {
            this.init();
        }
        if (valueMap == null) {
            return true;
        }
        for (int i = 0; i < this.filterForFlowContentList.size(); ++i) {
            IFilterForFlowContent filterForFlowContent = this.filterForFlowContentList.get(i);
            for (Map.Entry entry : valueMap.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                if (!filterForFlowContent.needFilter(key) || filterForFlowContent.doFilter(value, content)) continue;
                return false;
            }
        }
        return true;
    }

    private void init() {
        if (this.filterForFlowContentList == null) {
            this.filterForFlowContentList = new ArrayList<IFilterForFlowContent>();
        }
        Iterator iterator = WCMDiscoveryFactory.getDiscovery().getImplementors("com.trs.cms.process.IFilterForFlowContent");
        while (iterator != null && iterator.hasNext()) {
            String sClazz = (String)iterator.next();
            try {
                IFilterForFlowContent channelInerit = (IFilterForFlowContent)Class.forName(sClazz).newInstance();
                this.filterForFlowContentList.add(channelInerit);
            }
            catch (Exception e) {
                logger.error((Object)I18NMessage.get(FilterForFlowContentFactory.class, "FilterForFlowContentFactory", "\u52a0\u8f7d\u7c7b\u5931\u8d25\uff01"), (Throwable)e);
            }
        }
    }

    public static synchronized FilterForFlowContentFactory newInstance() {
        if (filterForFlowContentFactory == null) {
            filterForFlowContentFactory = new FilterForFlowContentFactory();
        }
        return filterForFlowContentFactory;
    }

    public List<IFilterForFlowContent> getFilterForFlowContentList() {
        if (this.filterForFlowContentList == null) {
            this.init();
        }
        return this.filterForFlowContentList;
    }
}

