/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.content;

import com.trs.cms.auth.persistent.User;
import com.trs.infra.common.WCMException;
import com.trs.infra.support.config.ConfigServer;
import java.util.Date;

public class Locker {
    private User lockUser = null;
    private int lockTimeOut = 0;
    private boolean locked = false;
    private Date expiredTime = null;
    public static int DEF_LOCKTIMEOUT = 1200;

    public Locker() {
    }

    Locker(User lockUser) {
        this.lockUser = lockUser;
        this.locked = true;
    }

    Locker(User lockUser, Date _expiredTime) {
        this.lockUser = lockUser;
        this.locked = true;
        this.expiredTime = _expiredTime;
    }

    public User getLockUser() {
        return this.lockUser;
    }

    public int getLockTimeOut() {
        return this.lockTimeOut;
    }

    public boolean lockUserIs(User _user) {
        if (!this.locked) {
            return false;
        }
        if (this.lockUser == null) {
            return true;
        }
        return this.lockUser.equals(_user);
    }

    public synchronized boolean isLocked() {
        if (this.locked && this.isTimeOut()) {
            this.unlock();
        }
        return this.locked;
    }

    public boolean isTimeOut() {
        return this.isTimeOut(new Date());
    }

    public boolean isTimeOut(Date _dNow) {
        if (!this.locked) {
            return true;
        }
        if (this.lockTimeOut == 0) {
            return false;
        }
        return this.expiredTime.before(_dNow);
    }

    public synchronized boolean lock(User _lockUser) {
        return this.lock(_lockUser, DEF_LOCKTIMEOUT);
    }

    public synchronized boolean lock(User _lockUser, int _lockTimeOut) {
        if (_lockTimeOut < 0) {
            return false;
        }
        if (this.locked) {
            return this.lockUser.equals(_lockUser);
        }
        this.locked = true;
        this.lockUser = _lockUser;
        this.lockTimeOut = _lockTimeOut;
        if (_lockTimeOut > 0) {
            Date dNow = null;
            dNow = this.expiredTime == null ? (this.expiredTime = new Date()) : new Date();
            this.expiredTime.setTime(dNow.getTime() + (long)(this.lockTimeOut * 1000));
        }
        return true;
    }

    public synchronized boolean unlock() {
        if (!this.locked) {
            return true;
        }
        this.locked = false;
        this.lockUser = null;
        this.lockTimeOut = 0;
        return true;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer(64);
        buff.append("locker:");
        buff.append(this.locked);
        buff.append(",user=");
        buff.append(this.lockUser);
        return buff.toString();
    }

    static {
        try {
            DEF_LOCKTIMEOUT = Integer.valueOf(ConfigServer.getServer().getSysConfigValue("DEF_LOCKTIMEOUT", "20")) * 60;
        }
        catch (WCMException e) {
            e.printStackTrace();
        }
    }
}

