/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.auth.persistent;

import com.trs.DreamFactory;
import com.trs.cms.auth.domain.IRightMgr;
import com.trs.cms.auth.persistent.Group;
import com.trs.cms.auth.persistent.Groups;
import com.trs.cms.auth.persistent.RightValue;
import com.trs.cms.auth.persistent.Role;
import com.trs.cms.auth.persistent.Roles;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.auth.persistent.Users;
import com.trs.cms.content.CMSObj;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;

public class Right
extends CMSObj {
    public static final int OBJ_TYPE = 202;
    public static final String DB_TABLE_NAME = "WCMRIGHT";
    public static final String DB_ID_NAME = "RIGHTID";
    public static final int OPRTYPE_USER = 204;
    public static final int OPRTYPE_ROLE = 203;
    public static final int OPRTYPE_GROUP = 201;
    private static IRightMgr s_oRightMgr = (IRightMgr)DreamFactory.createObjectById("IRightMgr");

    @Override
    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    @Override
    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    @Override
    public int getWCMType() {
        return 202;
    }

    public int getObjType() {
        return this.getPropertyAsInt("OBJTYPE", 0);
    }

    public boolean setObjType(int _objType) throws WCMException {
        if (_objType < 0) {
            throw new WCMException(1104, I18NMessage.get(Right.class, "Right.label1", "ObjType\u503c\u65e0\u6548(Right.setObjType)"));
        }
        return this.setProperty("OBJTYPE", _objType);
    }

    public int getObjId() {
        return this.getPropertyAsInt("OBJID", 0);
    }

    public boolean setObjId(int _objId) throws WCMException {
        if (_objId < 0) {
            throw new WCMException(1104, I18NMessage.get(Right.class, "Right.label2", "ObjId\u503c\u65e0\u6548(Right.setObjId)"));
        }
        return this.setProperty("OBJID", _objId);
    }

    public boolean setObject(CMSObj _obj) throws WCMException {
        if (_obj == null || !_obj.isValidInstance()) {
            throw new WCMException(10, I18NMessage.get(Right.class, "Right.label3", "\u65e0\u6548\u7684\u64cd\u4f5c\u5bf9\u8c61(Right.setObject)"));
        }
        if (!this.setObjType(_obj.getWCMType())) {
            return false;
        }
        return this.setObjId(_obj.getId());
    }

    public boolean setObject(int _nObjectType, int _nObjectId) throws WCMException {
        return this.setObjType(_nObjectType) && this.setObjId(_nObjectId);
    }

    public int getOperatorType() {
        return this.getPropertyAsInt("OPRTYPE", 0);
    }

    public boolean setOperatorType(int _operatorType) throws WCMException {
        if (_operatorType != 203 && _operatorType != 204 && _operatorType != 201) {
            throw new WCMException(10, I18NMessage.get(Right.class, "Right.label4", "\u65e0\u6548\u7684\u8bbf\u95ee\u8005\u7c7b\u578b\uff08Right.setOperatorType\uff09"));
        }
        return this.setProperty("OPRTYPE", _operatorType);
    }

    public int getOperatorId() {
        return this.getPropertyAsInt("OPRID", 0);
    }

    public boolean setOperatorId(int _operatorId) throws WCMException {
        if (_operatorId <= 0) {
            throw new WCMException(10, I18NMessage.get(Right.class, "Right.label5", "\u65e0\u6548\u7684\u8bbf\u95ee\u8005ID"));
        }
        return this.setProperty("OPRID", _operatorId);
    }

    public CMSObj getOperator() throws WCMException {
        int nOperatorId = this.getOperatorId();
        switch (this.getOperatorType()) {
            case 204: {
                return User.findById(nOperatorId);
            }
            case 203: {
                return Role.findById(nOperatorId);
            }
            case 201: {
                return Group.findById(nOperatorId);
            }
        }
        return null;
    }

    public boolean setOperator(CMSObj _operator) throws WCMException {
        if (_operator == null || !_operator.isValidInstance()) {
            throw new WCMException(10, I18NMessage.get(Right.class, "Right.label6", "\u64cd\u4f5c\u8005\u5bf9\u8c61\u4e3a\u7a7a(Right.setOperator)"));
        }
        if (!this.setOperatorType(_operator.getWCMType())) {
            return false;
        }
        return this.setOperatorId(_operator.getId());
    }

    public boolean setOperator(int _nOperType, int _nOperId) throws WCMException {
        return this.setOperatorType(_nOperType) && this.setOperatorId(_nOperId);
    }

    public long getValueAsLong() {
        return this.getPropertyAsLong("RIGHTVALUE", 0L);
    }

    public long getValueAsInt() {
        return this.getValueAsLong();
    }

    public RightValue getValue() {
        return new RightValue(this.getValueAsLong());
    }

    public boolean setValue(RightValue _rightValue) throws WCMException {
        if (_rightValue == null) {
            throw new WCMException(10, I18NMessage.get(Right.class, "Right.label7", "\u6743\u9650\u503c\u65e0\u6548(Right.setValue)"));
        }
        return this.setValue(_rightValue.getValue());
    }

    public boolean setValue(long _lValue) throws WCMException {
        if (_lValue < 0L) {
            throw new WCMException(10, I18NMessage.get(Right.class, "Right.label8", "\u6743\u9650\u503c\u65e0\u6548[\u5fc5\u987b>=0](Right.setValue)"));
        }
        return this.setProperty("RIGHTVALUE", _lValue);
    }

    @Override
    public boolean isValid() throws WCMException {
        if (this.isAddMode()) {
            Number iObjType = (Number)this.getAllProperty().get("OBJTYPE");
            Number iObjId = (Number)this.getAllProperty().get("OBJID");
            Number iOprType = (Number)this.getAllProperty().get("OPRTYPE");
            Number iOprId = (Number)this.getAllProperty().get("OPRID");
            if (iObjType == null) {
                throw new WCMException(1106, I18NMessage.get(Right.class, "Right.label9", "\u5c5e\u6027ObjType\u6ca1\u6709\u8bbe\u7f6e(Right.isValid)"));
            }
            if (iObjId == null) {
                throw new WCMException(1106, I18NMessage.get(Right.class, "Right.label10", "\u5c5e\u6027ObjId\u6ca1\u6709\u8bbe\u7f6e(Right.isValid)"));
            }
            if (iOprType == null) {
                throw new WCMException(1106, I18NMessage.get(Right.class, "Right.label11", "\u5c5e\u6027OperType\u6ca1\u6709\u8bbe\u7f6e(Right.isValid)"));
            }
            if (iOprId == null) {
                throw new WCMException(1106, I18NMessage.get(Right.class, "Right.label11", "\u5c5e\u6027OperType\u6ca1\u6709\u8bbe\u7f6e(Right.isValid)"));
            }
            if (this.getAllProperty().get("RIGHTVALUE") == null) {
                throw new WCMException(1106, I18NMessage.get(Right.class, "Right.label12", "\u6743\u9650\u503c\u6ca1\u6709\u8bbe\u7f6e(Right.isValid)"));
            }
            String strCondition = " (ObjType=" + iObjType + ") and (ObjId=" + iObjId + ") and (OprType=" + iOprType + ") and (OprId=" + iOprId + ") ";
            if (!this.isAddMode()) {
                strCondition = strCondition + " and (" + this.getIdFieldName() + "<>" + this.getId() + ")";
            }
            if (this.checkExists(strCondition)) {
                throw new WCMException(1108, I18NMessage.get(Right.class, "Right.label13", "\u6743\u9650\u5bf9\u8c61\u5df2\u7ecf\u5b58\u5728\uff08Right.isValid\uff09"));
            }
        } else if (!this.isModified()) {
            throw new WCMException(1107, I18NMessage.get(Right.class, "Right.label14", "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539(Right.isValid)"));
        }
        return true;
    }

    public static Users getUsersWithRight(User _currUser, int _objType, int _objId, boolean _blHasRight) throws WCMException {
        WCMFilter filter = null;
        filter = _blHasRight ? new WCMFilter("wcmRight", "ObjType=" + _objType + " and ObjId=" + _objId + " and OprType=" + 204, "", "OprId as UserId") : new WCMFilter("wcmUser", "not exists(select RightId from wcmRight where (OprType=204) and (OprId=WCMUser.UserId) and (ObjType=" + _objType + ") and (ObjId=" + _objId + "))", "");
        Users aUsers = new Users(_currUser);
        try {
            aUsers.open(filter);
            return aUsers;
        }
        catch (WCMException ex) {
            throw new WCMException(1100, I18NMessage.get(Right.class, "Right.label15", "\u83b7\u53d6\u5bf9\u8c61\u4e0a\u6307\u5b9a/\u6ca1\u6709\u6307\u5b9a\u6743\u9650\u7684\u7528\u6237\u96c6\u5408\u65f6\u51fa\u9519(Right.getUsers)"), ex);
        }
    }

    public static Roles getRolesWithRight(User _currUser, int _objType, int _objId, boolean _blHasRight) throws WCMException {
        WCMFilter filter = null;
        filter = _blHasRight ? new WCMFilter("wcmRight", "ObjType=" + _objType + " and ObjId=" + _objId + " and OprType=" + 203, "", "OprId as RoleId") : new WCMFilter("wcmRole", "not exists(select RightId from wcmRight where (OprType=203) and (OprId=WCMRole.RoleId) and (ObjType=" + _objType + ") and (ObjId=" + _objId + "))", "");
        Roles aRoles = new Roles(_currUser);
        try {
            aRoles.open(filter);
            return aRoles;
        }
        catch (WCMException ex) {
            throw new WCMException(1100, I18NMessage.get(Right.class, "Right.label16", "\u83b7\u53d6\u5bf9\u8c61\u4e0a\u6307\u5b9a/\u6ca1\u6709\u6307\u5b9a\u6743\u9650\u7684\u89d2\u8272\u96c6\u5408\u65f6\u51fa\u9519(Right.getRolesWithRight)"), ex);
        }
    }

    public static Groups getGroupsWithRight(User _currUser, int _objType, int _objId, boolean _blHasRight) throws WCMException {
        WCMFilter filter = null;
        filter = _blHasRight ? new WCMFilter("wcmRight", "ObjType=" + _objType + " and ObjId=" + _objId + " and OprType=" + 201, "", "OprId as GROUPID") : new WCMFilter("wcmGroup", "not exists(select RightId from wcmRight where (OprType=201) and (OprId=wcmGroup.GroupId) and (ObjType=" + _objType + ") and (ObjId=" + _objId + "))", "");
        Groups aGroups = new Groups(_currUser);
        try {
            aGroups.open(filter);
            return aGroups;
        }
        catch (WCMException ex) {
            throw new WCMException(1100, I18NMessage.get(Right.class, "Right.label17", "\u83b7\u53d6\u5bf9\u8c61\u4e0a\u6307\u5b9a/\u6ca1\u6709\u6307\u5b9a\u6743\u9650\u7684\u7528\u6237\u7ec4\u96c6\u5408\u65f6\u51fa\u9519(Right.getGroupsWithRight)"), ex);
        }
    }

    public static final Right findBy(int _nObjType, int _nObjId, int _nOprType, int _nOprId) throws WCMException {
        return s_oRightMgr.getRight(_nObjType, _nObjId, _nOprType, _nOprId);
    }

    public static final Right findById(int _nId) throws WCMException {
        if (_nId <= 0) {
            return null;
        }
        return (Right)BaseObj.findById(Right.class, _nId);
    }

    public static final Right createNewInstance() throws WCMException {
        return (Right)BaseObj.createNewInstance(Right.class);
    }

    public static final Right findByKey(Object _oKey) throws WCMException {
        return (Right)BaseObj.findByKey(Right.class, _oKey);
    }

    @Override
    public String toString() {
        if (this.IS_ENGVERSION) {
            return "Value=" + this.getValueAsInt();
        }
        return "Value=" + this.getValueAsInt() + I18NMessage.get(Right.class, "Right.label18", "[\u6743\u9650\u503c-") + this.getId() + "]";
    }
}

