/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.auth.persistent;

import com.trs.DreamFactory;
import com.trs.cms.auth.persistent.GroupAdminsCacheMgr;
import com.trs.cms.auth.persistent.Groups;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.auth.persistent.Users;
import com.trs.cms.content.CMSObj;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.BizError;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyDateTime;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Hashtable;

public class Group
extends CMSObj
implements Serializable {
    private static final long serialVersionUID = -2265204905756007169L;
    public static final int OBJ_TYPE = 201;
    public static final String DB_TABLE_NAME = "WCMGROUP";
    public static final String DB_ID_NAME = "GROUPID";
    private Hashtable hAdministrator = null;
    private static final int DIRECTION_MOVE_FORWARD = 1;
    private static final int DIRECTION_MOVE_BACK = -1;
    private static final int DIRECTION_MOVE_NO = 0;
    public static final int POSITION_BEFORE = 1;
    public static final int POSITION_AFTER = 0;

    @Override
    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    @Override
    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    @Override
    public int getWCMType() {
        return 201;
    }

    public int getParentId() {
        return this.getPropertyAsInt("PARENTID", 0);
    }

    public Group getParent() throws WCMException {
        return Group.findById(this.getParentId());
    }

    public boolean setParent(int _parentId) throws WCMException {
        return this.setProperty("PARENTID", _parentId);
    }

    public boolean setParent(Group _parent) throws WCMException {
        if (_parent != null && !_parent.isValidInstance()) {
            throw new WCMException(10, I18NMessage.get(Group.class, "Group.label1", "\u65e0\u6548\u7684\u7236\u7ec4\u5bf9\u8c61(Group.setParent)"));
        }
        return this.setParent(_parent == null ? 0 : _parent.getId());
    }

    public String getName() {
        return (String)this.getProperty("GNAME");
    }

    public boolean setName(String _name) throws WCMException {
        return this.setProperty("GNAME", _name);
    }

    public String getDesc() {
        return (String)this.getProperty("GDESC");
    }

    public boolean setDesc(String _desc) throws WCMException {
        return this.setProperty("GDESC", _desc);
    }

    public String getEmail() {
        return (String)this.getProperty("EMAIL");
    }

    public boolean setEmail(String _email) throws WCMException {
        return this.setProperty("EMAIL", _email);
    }

    public int getGroupOrder() {
        return this.getPropertyAsInt("GroupOrder", 0);
    }

    public boolean setGroupOrder(int _nOrder) throws WCMException {
        return this.setProperty("GroupOrder", _nOrder);
    }

    @Override
    public boolean isValid() throws WCMException {
        String sName = null;
        if (this.isAddMode()) {
            sName = (String)this.getAllProperty().get("GNAME");
            if (sName == null) {
                throw new BizError(I18NMessage.get(Group.class, "Group.label2", "\u5c5e\u6027Name\u6ca1\u6709\u8bbe\u7f6e"));
            }
            int nParentId = this.getParentId();
            if (nParentId != 0 && Group.findById(nParentId) == null) {
                throw new BizError(I18NMessage.get(Group.class, "Group.label3", "\u6307\u5b9a\u7684ParentId\u65e0\u6548"));
            }
        } else {
            if (!this.isModified()) {
                throw new BizError(I18NMessage.get(Group.class, "Group.label4", "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539"));
            }
            sName = (String)this.getNewProperty("GNAME");
        }
        if (sName != null) {
            WCMFilter filter = new WCMFilter();
            filter.setFrom(DB_TABLE_NAME);
            StringBuilder where = new StringBuilder("ParentId = ? and GName = ? ");
            filter.addSearchValues(this.getParentId());
            filter.addSearchValues(sName);
            if (!this.isAddMode()) {
                where.append("and " + this.getIdFieldName() + " <> ?");
                filter.addSearchValues(this.getId());
            }
            filter.setWhere(where.toString());
            if (DBManager.getDBManager().sqlExecuteCountQuery(filter) > 0) {
                throw new BizError("\u7ec4\u7ec7\u540d\u79f0[" + sName + "]\u5df2\u7ecf\u5b58\u5728");
            }
        }
        this.changeOrder();
        return true;
    }

    public Users getUsers(User _currUser) throws WCMException {
        return this.getUsers(_currUser, null);
    }

    public Users getUsers(User _currUser, String _sOrder) throws WCMException {
        WCMFilter filter = null;
        Users aUsers = new Users(_currUser);
        filter = _sOrder == null || _sOrder.trim().length() == 0 ? new WCMFilter("wcmGrpUser", "GroupId=" + this.getId(), "", "UserId") : new WCMFilter("wcmUser, wcmGrpUser", "(wcmGrpUser.GroupId=" + this.getId() + ") and (wcmUser.UserId=wcmGrpUser.UserId) ", _sOrder, "wcmUser.USERID");
        try {
            aUsers.open(filter);
            return aUsers;
        }
        catch (WCMException ex) {
            throw new WCMException(1100, I18NMessage.get(Group.class, "Group.label6", "\u53d6\u7ec4\u4e2d\u7528\u6237\u96c6\u5408\u65f6\u51fa\u9519(Group.getUsers)"), ex);
        }
    }

    public Groups getChildren(User _currUser) throws WCMException {
        return this.getChildren(_currUser, "");
    }

    public Groups getChildrenByOrder(User _currUser) throws WCMException {
        return this.getChildren(_currUser, "GROUPORDER ASC");
    }

    public Groups getChildren(User _currUser, String _sOrder) throws WCMException {
        try {
            WCMFilter filter = new WCMFilter("", "ParentId=" + this.getId(), _sOrder);
            Groups aGroups = new Groups(_currUser);
            aGroups.open(filter);
            return aGroups;
        }
        catch (WCMException ex) {
            throw new WCMException(1100, I18NMessage.get(Group.class, "Group.label7", "\u53d6\u7ec4\u7684\u5b50\u7ec4\u96c6\u5408\u65f6\u51fa\u9519(Group.getChildren)"), ex);
        }
    }

    public boolean addUser(int _addedUserId, User _opUser) throws WCMException {
        User userToAdd = User.findById(_addedUserId);
        return this.addUser(userToAdd, _opUser, false);
    }

    public boolean addUser(int _addedUserId, User _opUser, boolean _isAdministrator) throws WCMException {
        User userToAdd = User.findById(_addedUserId);
        return this.addUser(userToAdd, _opUser, _isAdministrator);
    }

    public boolean addUser(User _userToAdd, User _opUser) throws WCMException {
        return this.addUser(_userToAdd, _opUser, false);
    }

    public boolean addUser(User _userToAdd, User _opUser, boolean _isAdministrator) throws WCMException {
        Connection oConn = null;
        Statement oStmt = null;
        ResultSet rsCount = null;
        Statement oPreStmt = null;
        if (_userToAdd == null || !_userToAdd.isValidInstance()) {
            throw new WCMException(1100, I18NMessage.get(Group.class, "Group.label8", "\u8981\u52a0\u5165\u7ec4\u7684\u7528\u6237\u5bf9\u8c61\u65e0\u6548\uff08Group.addUser\uff09"));
        }
        if (_opUser == null || !_opUser.isValidInstance()) {
            throw new WCMException(1100, I18NMessage.get(Group.class, "Group.label9", "\u6267\u884c\u6dfb\u52a0\u64cd\u4f5c\u7684\u7528\u6237\u5bf9\u8c61\u65e0\u6548\uff08Group.addUser\uff09"));
        }
        int nUserId = _userToAdd.getId();
        boolean blExists = false;
        try {
            oConn = this.getDBManager().getConnection();
            String strSQL = "select count(*) from wcmGrpUser where GroupId=" + this.getId() + " and UserId=" + nUserId;
            oStmt = oConn.createStatement();
            rsCount = oStmt.executeQuery(strSQL);
            rsCount.next();
            blExists = rsCount.getInt(1) > 0;
            rsCount.close();
            oStmt.close();
            if (blExists) {
                boolean bl = false;
                return bl;
            }
            strSQL = "insert into wcmGrpUser(GroupId,UserId, isAdministrator, CrUser,CrTime) values(?,?,?,?,?)";
            CMyDateTime crTime = new CMyDateTime();
            crTime.setDateTimeWithCurrentTime();
            oPreStmt = oConn.prepareStatement(strSQL);
            oPreStmt.setInt(1, this.getId());
            oPreStmt.setInt(2, _userToAdd.getId());
            oPreStmt.setInt(3, _isAdministrator ? 1 : 0);
            oPreStmt.setString(4, _opUser.getName());
            oPreStmt.setTimestamp(5, crTime.toTimestamp());
            oPreStmt.executeUpdate();
            if (_isAdministrator) {
                this.addAdministrator(_userToAdd);
            }
        }
        catch (SQLException ex) {
            throw new WCMException(40, I18NMessage.get(Group.class, "Group.label10", "\u6dfb\u52a0\u6307\u5b9a\u7528\u6237\u5230\u7ec4\u65f6\u51fa\u9519\uff08Group.addUser\uff09"), ex);
        }
        catch (Exception ex) {
            throw new WCMException(0, I18NMessage.get(Group.class, "Group.label10", "\u6dfb\u52a0\u6307\u5b9a\u7528\u6237\u5230\u7ec4\u65f6\u51fa\u9519\uff08Group.addUser\uff09"), ex);
        }
        finally {
            if (oStmt != null) {
                try {
                    oStmt.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (oPreStmt != null) {
                try {
                    oPreStmt.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (oConn != null) {
                this.getDBManager().freeConnection(oConn);
            }
        }
        return true;
    }

    public void addAdministrator(User _user) {
        if (this.hAdministrator == null) {
            this.hAdministrator = new Hashtable(1);
        }
        if (this.hAdministrator.containsKey(new Integer(_user.getId()))) {
            return;
        }
        this.hAdministrator.put(new Integer(_user.getId()), _user);
    }

    public void removeAdministrator(User _user) {
        if (this.hAdministrator == null) {
            this.hAdministrator = new Hashtable(1);
        }
        if (!this.hAdministrator.containsKey(new Integer(_user.getId()))) {
            return;
        }
        this.hAdministrator.remove(new Integer(_user.getId()));
    }

    private void refreshAdministrator() throws WCMException {
        if (this.hAdministrator == null) {
            this.hAdministrator = new Hashtable(1);
        } else {
            this.hAdministrator.clear();
        }
        Users users = null;
        try {
            WCMFilter filter = new WCMFilter("wcmGrpUser", "isAdministrator=1 and GroupId=" + this.getId(), "", "UserId");
            users = new Users(null);
            users.open(filter);
            for (int i = 0; i < users.size(); ++i) {
                User aUser = (User)users.getAt(i);
                if (aUser == null) continue;
                this.hAdministrator.put(new Integer(aUser.getId()), aUser);
            }
        }
        catch (Exception ex) {
            throw new WCMException(1100, I18NMessage.get(Group.class, "Group.label11", "\u53d6\u7528\u6237\u6240\u5728\u7ec4\u96c6\u5408\u65f6\u51fa\u9519(User.getGroups)"), ex);
        }
    }

    public Users getAdministrator(User _opUser) throws WCMException {
        if (this.hAdministrator == null) {
            this.refreshAdministrator();
        }
        Users aUsers = new Users(_opUser);
        Enumeration els = this.hAdministrator.elements();
        while (els.hasMoreElements()) {
            aUsers.addElement((User)els.nextElement());
        }
        return aUsers;
    }

    public boolean isAdministrator(User _currUser) throws WCMException {
        GroupAdminsCacheMgr manager = (GroupAdminsCacheMgr)DreamFactory.createObjectById("GroupAdminsCacheMgr");
        return manager.getAdmins(this).indexOf(_currUser) >= 0;
    }

    public static final Group findById(int _nId) throws WCMException {
        if (_nId <= 0) {
            return null;
        }
        return (Group)BaseObj.findById(Group.class, _nId);
    }

    public static final Group createNewInstance() throws WCMException {
        return (Group)BaseObj.createNewInstance(Group.class);
    }

    public static final Group findByKey(Object _oKey) throws WCMException {
        return (Group)BaseObj.findByKey(Group.class, _oKey);
    }

    @Override
    public String toString() {
        if (this.IS_ENGVERSION) {
            return this.getName();
        }
        return this.getName() + I18NMessage.get(Group.class, "Group.label12", "[\u7ec4\u7ec7-") + this.getId() + "]";
    }

    private void changeOrder() throws WCMException {
        int nParentId = this.getParentId();
        if (this.isAddMode()) {
            String sSql = "select max(grouporder) from " + this.getDbTableName() + " where parentid = " + nParentId;
            DBManager currDBManager = DBManager.getDBManager();
            if (currDBManager == null || !currDBManager.isStarted()) {
                throw new WCMException(10, "DBManaer\u914d\u7f6e\u4e0d\u6b63\u786e\uff01");
            }
            if (!currDBManager.isStarted()) {
                throw new WCMException(10, "DBManaer\u6ca1\u6709\u542f\u52a8\uff01");
            }
            int nGroupOrder = currDBManager.sqlExecuteIntQuery(sSql);
            this.setGroupOrder(++nGroupOrder);
        } else {
            Group toGroup;
            int nToGroupOrder;
            if (this.getGroupOrder() > 0 && !this.isChangeProperty("GroupOrder")) {
                return;
            }
            WCMFilter filter = new WCMFilter("", "PARENTID=" + nParentId, "GROUPORDER DESC", "GroupId");
            Groups currGroups = Groups.openWCMObjs(null, filter);
            int nSize = currGroups.size();
            int nTargetGroupId = 0;
            int nNewGroupOrder = this.getNewPropertyAsInt("GroupOrder", 0);
            int nGroupId = this.getId();
            int nOldGroupOrder = this.getPropertyAsInt("GroupOrder", 0);
            int nPosition = 1;
            if (nNewGroupOrder < 0 || nNewGroupOrder >= nSize) {
                nNewGroupOrder = nSize;
                nPosition = 0;
                nTargetGroupId = currGroups.getIdAt(nNewGroupOrder - 1);
            } else if (nNewGroupOrder == 0) {
                nTargetGroupId = currGroups.getIdAt(0);
            } else if (nNewGroupOrder > 0 && nOldGroupOrder > (nToGroupOrder = (toGroup = Group.findById(nTargetGroupId = currGroups.getIdAt(nNewGroupOrder - 1))).getGroupOrder())) {
                nPosition = 0;
            }
            if (nTargetGroupId != nGroupId) {
                Group oToGroup = Group.findById(nTargetGroupId);
                int nFromGroupOrder = nOldGroupOrder;
                int nToGroupOrder2 = oToGroup.getGroupOrder();
                if (this.equals(oToGroup) || nFromGroupOrder == nToGroupOrder2) {
                    return;
                }
                int nNewOrder = nFromGroupOrder;
                int nOldOffset = nFromGroupOrder - nToGroupOrder2;
                int nMoveBeginAt = 0;
                int nMoveEndAt = 0;
                int nMoveDirection = 0;
                switch (nPosition) {
                    case 1: {
                        if (nOldOffset == 0) {
                            return;
                        }
                        if (nOldOffset > 0) {
                            nMoveBeginAt = nToGroupOrder2;
                            nMoveEndAt = nFromGroupOrder - 1;
                            nNewOrder = nMoveBeginAt;
                            nMoveDirection = 1;
                            break;
                        }
                        if (nOldOffset >= 0) break;
                        nMoveBeginAt = nFromGroupOrder + 1;
                        nNewOrder = nMoveEndAt = nToGroupOrder2;
                        nMoveDirection = -1;
                        break;
                    }
                    case 0: {
                        if (nOldOffset == 0) {
                            return;
                        }
                        if (nOldOffset > 0) {
                            nMoveBeginAt = nToGroupOrder2;
                            nMoveEndAt = nFromGroupOrder - 1;
                            nNewOrder = nMoveBeginAt;
                            nMoveDirection = 1;
                            break;
                        }
                        if (nOldOffset >= 0) break;
                        nMoveBeginAt = nFromGroupOrder + 1;
                        nNewOrder = nMoveEndAt = nToGroupOrder2;
                        nMoveDirection = -1;
                    }
                }
                String sRegionWhere = "GroupOrder>=" + nMoveBeginAt + " AND GroupOrder <=" + nMoveEndAt + " and parentid = " + nParentId;
                String sMoveSql = "UPDATE WCMGROUP SET GroupOrder = GroupOrder+(" + nMoveDirection + ") WHERE " + sRegionWhere;
                WCMFilter aFilter = new WCMFilter("", sRegionWhere, "GROUPORDER DESC");
                Groups groups = Groups.openWCMObjs(null, aFilter);
                DBManager.getDBManager().sqlExecuteUpdate(sMoveSql);
                for (int i = 0; i < groups.size(); ++i) {
                    Group child = (Group)groups.getAt(i);
                    if (child == null) continue;
                    child.refreshProperty("GroupOrder", child.getGroupOrder() + nMoveDirection);
                }
                this.setGroupOrder(nNewOrder);
            } else {
                this.setGroupOrder(this.getGroupOrder());
            }
        }
    }
}

