/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.auth.domain;

import com.trs.cms.auth.domain.IRightHost;
import com.trs.cms.auth.domain.NewRightSet;
import com.trs.cms.auth.persistent.ObjectMember;
import com.trs.cms.auth.persistent.ObjectMembers;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.cms.content.WCMObjHelper;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.Reports;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class ObjectMemberSet {
    public static final int IMPART_MODE_NODE = 0;
    public static final int IMPART_MODE_ADD = 1;
    public static final int IMPART_MODE_MODIFY = 2;
    public static final int IMPART_MODE_DELETE = 3;
    public static final int IMPART_MODE_ALL = 4;
    private int m_nImpartMode = 0;
    private int[] m_pImpartMode = null;
    private User m_currLoginUser = null;
    private IRightHost m_oTopRightHost = null;
    private List m_arCurrObjectMembersList = null;
    private Logger logger = Logger.getLogger(ObjectMemberSet.class);

    public ObjectMemberSet(User _loginUser, IRightHost _rightHost, List _currRightList, int[] _pImpartMode) {
        this.m_currLoginUser = _loginUser;
        this.m_oTopRightHost = _rightHost;
        this.m_arCurrObjectMembersList = _currRightList;
        this.m_pImpartMode = _pImpartMode;
    }

    public boolean save() throws WCMException {
        this.m_oTopRightHost.validateCanDoSetRight(this.m_currLoginUser);
        Reports reports = new Reports("\u8bbf\u95ee\u63a7\u5236\u8bbe\u7f6e");
        for (int i = 0; i < this.m_pImpartMode.length; ++i) {
            this.m_nImpartMode = this.m_pImpartMode[i];
            if (this.m_nImpartMode == 0) continue;
            ArrayList arImpartObjectMembers = this.makeImpartObjectMembers();
            this.impartObjectMembers(this.m_oTopRightHost, arImpartObjectMembers, reports);
        }
        this.saveObjectMembersOfTopHost();
        if (reports.getFailedReporter() == null || reports.getFailedReporter().isEmpty()) {
            return true;
        }
        throw new WCMException("\u540c\u6b65\u8bbe\u7f6e\u5b50\u680f\u76ee\u8bbf\u95ee\u63a7\u5236\u5931\u8d25\uff01\n" + reports.toString());
    }

    private void impartObjectMembers(IRightHost _parentRightHost, ArrayList _arImpartRights, Reports _reports) throws WCMException {
        IRightHost[] pChildren = _parentRightHost.getChildren();
        if (pChildren == null || pChildren.length == 0) {
            return;
        }
        for (IRightHost children : pChildren) {
            if (children == null) continue;
            this.saveRightOfChildNode(_arImpartRights, children, _reports);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean saveRightOfChildNode(ArrayList _arImpartObjectMembers, IRightHost _currRightHost, Reports _reports) throws WCMException {
        this.logger.debug((Object)(_currRightHost.getInfo() + " impart objectMembers..."));
        try {
            _currRightHost.validateCanDoSetRight(this.m_currLoginUser);
        }
        catch (Exception e) {
            _reports.addFailedReport("\u6ca1\u6709\u6743\u9650\u7ed9[" + _currRightHost.getInfo() + "]\u4f20\u9012\u8bbf\u95ee\u63a7\u5236\u8bbe\u7f6e.", null);
            return false;
        }
        switch (this.m_nImpartMode) {
            case 1: 
            case 2: 
            case 3: {
                if (_arImpartObjectMembers != null && !_arImpartObjectMembers.isEmpty()) break;
                return true;
            }
            case 4: {
                if (_arImpartObjectMembers != null && !_arImpartObjectMembers.isEmpty()) break;
                ObjectMembers objectMembers = this.getDeleteObjectMembersOfHost(this.m_currLoginUser, _currRightHost.getSubstance(), new int[0]);
                objectMembers.removeAll(true);
                this.impartObjectMembers(_currRightHost, _arImpartObjectMembers, _reports);
                return true;
            }
            default: {
                return false;
            }
        }
        this.logger.debug((Object)(_currRightHost.getInfo() + " impart objectMember for!"));
        int[] pObjectMemberIds = new int[_arImpartObjectMembers.size()];
        block20: for (int i = 0; i < _arImpartObjectMembers.size(); ++i) {
            int[] pObjectMemberInfo = (int[])_arImpartObjectMembers.get(i);
            int nObjType = _currRightHost.getType();
            int nObjId = _currRightHost.getId();
            int nMemberType = pObjectMemberInfo[0];
            int nMemberId = pObjectMemberInfo[1];
            boolean bVisible = pObjectMemberInfo[2] == 1;
            boolean bDoOperation = pObjectMemberInfo[3] == 1;
            ObjectMember objectMember = ObjectMember.findByMemberObj(nMemberType, nMemberId, nObjType, nObjId);
            try {
                switch (this.m_nImpartMode) {
                    case 1: 
                    case 4: {
                        boolean bAddMode;
                        boolean bl = bAddMode = objectMember == null;
                        if (objectMember == null) {
                            objectMember = ObjectMember.createNewInstance();
                            objectMember.setMember(nMemberType, nMemberId);
                            objectMember.setObj(nObjType, nObjId);
                        } else {
                            pObjectMemberIds[i] = objectMember.getId();
                            if (!objectMember.canEdit(this.m_currLoginUser)) {
                                _reports.addFailedReport(I18NMessage.get(NewRightSet.class, "NewRightSet.label7", "\u6743\u9650\u88ab\u9501\u5b9a\uff0c\u4e0d\u80fd\u4fee\u6539\uff01[ObjType=") + nObjType + ", ObjId=" + nObjId + ", OprType=" + nMemberType + ", OprId=" + nMemberId + "] ", null);
                                continue block20;
                            }
                            if (objectMember.isVisible() == bVisible && objectMember.isDoOperation() == bDoOperation) continue block20;
                        }
                        objectMember.setVisible(bVisible);
                        objectMember.setDoOperation(bDoOperation);
                        this.logger.debug((Object)(_currRightHost.getInfo() + " impart right save right!" + objectMember.isAddMode()));
                        objectMember.save(this.m_currLoginUser);
                        this.logger.debug((Object)(_currRightHost.getInfo() + " impart right save right!" + objectMember.getId()));
                        if (!bAddMode) break;
                        pObjectMemberIds[i] = objectMember.getId();
                        break;
                    }
                    case 2: {
                        this.logger.debug((Object)("modify right:" + objectMember));
                        if (objectMember == null || objectMember.isVisible() == bVisible && objectMember.isDoOperation() == bDoOperation) continue block20;
                        if (!objectMember.canEdit(this.m_currLoginUser)) {
                            _reports.addFailedReport(I18NMessage.get(NewRightSet.class, "NewRightSet.label7", "\u6743\u9650\u88ab\u9501\u5b9a\uff0c\u4e0d\u80fd\u4fee\u6539\uff01[ObjType=") + nObjType + ", ObjId=" + nObjId + ", OprType=" + nMemberType + ", OprId=" + nMemberId + "] ", null);
                            continue block20;
                        }
                        objectMember.setVisible(bVisible);
                        objectMember.setDoOperation(bDoOperation);
                        objectMember.save(this.m_currLoginUser);
                        this.logger.debug((Object)"modify right success!");
                        break;
                    }
                    case 3: 
                }
                continue;
            }
            finally {
                if (objectMember != null && objectMember.isLocked() && objectMember.getLockerUserName().equalsIgnoreCase(this.m_currLoginUser.getName())) {
                    objectMember.unlock();
                }
            }
        }
        if (this.m_nImpartMode == 4) {
            ObjectMembers rights = this.getDeleteObjectMembersOfHost(this.m_currLoginUser, _currRightHost.getSubstance(), pObjectMemberIds);
            this.logger.debug((Object)(_currRightHost.getInfo() + " impart right delete right!" + rights.getIdListAsString()));
            rights.removeAll(true);
        }
        this.impartObjectMembers(_currRightHost, _arImpartObjectMembers, _reports);
        return true;
    }

    private ArrayList makeImpartObjectMembers() throws WCMException {
        int nSize;
        ArrayList<int[]> arImpartObjectMembers = new ArrayList<int[]>(this.m_arCurrObjectMembersList.size());
        switch (this.m_nImpartMode) {
            case 1: {
                nSize = this.m_arCurrObjectMembersList.size();
                for (int i = 0; i < nSize; ++i) {
                    ObjectMember objmember = (ObjectMember)this.m_arCurrObjectMembersList.get(i);
                    if (objmember == null || !objmember.isAddMode()) continue;
                    arImpartObjectMembers.add(new int[]{objmember.getMemberType(), objmember.getMemberId(), objmember.getPropertyAsInt("VISIBLE", 0), objmember.getPropertyAsInt("DOOPERATION", 0)});
                }
                break;
            }
            case 2: {
                nSize = this.m_arCurrObjectMembersList.size();
                for (int i = 0; i < nSize; ++i) {
                    ObjectMember objectMember = (ObjectMember)this.m_arCurrObjectMembersList.get(i);
                    if (objectMember == null || objectMember.isAddMode()) continue;
                    boolean bChangeVisible = objectMember.isChangeProperty("VISIBLE");
                    boolean bChangeDoOperation = objectMember.isChangeProperty("DOOPERATION");
                    if (!bChangeVisible && !bChangeDoOperation) continue;
                    int nVisible = bChangeVisible ? objectMember.getNewPropertyAsInt("VISIBLE", 0) : objectMember.getPropertyAsInt("VISIBLE", 0);
                    int nDoOperation = bChangeDoOperation ? objectMember.getNewPropertyAsInt("DOOPERATION", 0) : objectMember.getPropertyAsInt("DOOPERATION", 0);
                    arImpartObjectMembers.add(new int[]{objectMember.getMemberType(), objectMember.getMemberId(), nVisible, nDoOperation});
                }
                break;
            }
            case 3: {
                int i;
                ObjectMembers delObjectMembers = this.getDeleteObjectMembersOfHost(this.m_currLoginUser, this.m_oTopRightHost.getSubstance(), WCMObjHelper.toIdsString(this.m_arCurrObjectMembersList));
                int nSize2 = delObjectMembers.size();
                for (i = 0; i < nSize2; ++i) {
                    ObjectMember objectMember = (ObjectMember)delObjectMembers.getAt(i);
                    if (objectMember == null) continue;
                    arImpartObjectMembers.add(new int[]{objectMember.getMemberType(), objectMember.getMemberId(), 0, 0});
                }
                break;
            }
            case 4: {
                int i;
                int nSize3 = this.m_arCurrObjectMembersList.size();
                for (i = 0; i < nSize3; ++i) {
                    ObjectMember objectMember = (ObjectMember)this.m_arCurrObjectMembersList.get(i);
                    if (objectMember == null) continue;
                    boolean bChangeVisible = objectMember.isChangeProperty("VISIBLE");
                    boolean bChangeDoOperation = objectMember.isChangeProperty("DOOPERATION");
                    int nVisible = bChangeVisible ? objectMember.getNewPropertyAsInt("VISIBLE", 0) : objectMember.getPropertyAsInt("VISIBLE", 0);
                    int nDoOperation = bChangeDoOperation ? objectMember.getNewPropertyAsInt("DOOPERATION", 0) : objectMember.getPropertyAsInt("DOOPERATION", 0);
                    arImpartObjectMembers.add(new int[]{objectMember.getMemberType(), objectMember.getMemberId(), nVisible, nDoOperation});
                }
                break;
            }
        }
        if (this.logger.isDebugEnabled() && arImpartObjectMembers != null) {
            nSize = arImpartObjectMembers.size();
            for (int i = 0; i < nSize; ++i) {
                int[] pRightInfo = (int[])arImpartObjectMembers.get(i);
                for (int j = 0; j < pRightInfo.length; ++j) {
                    this.logger.debug((Object)(i + "." + j + ":" + pRightInfo[j]));
                }
            }
        }
        return arImpartObjectMembers;
    }

    private ObjectMembers getDeleteObjectMembersOfHost(User _loginUser, CMSObj _host, String _sCurrentRightIds) throws WCMException {
        int[] pRightIds = null;
        if (!CMyString.isEmpty(_sCurrentRightIds)) {
            pRightIds = CMyString.splitToInt(_sCurrentRightIds, ",");
        }
        return this.getDeleteObjectMembersOfHost(_loginUser, _host, pRightIds);
    }

    private ObjectMembers getDeleteObjectMembersOfHost(User _loginUser, CMSObj _host, int[] _pCurrentRightIds) throws WCMException {
        WCMFilter aFilter = new WCMFilter("", "", "");
        String sWhere = "OBJTYPE=? and OBJID=?";
        aFilter.addSearchValues(_host.getWCMType());
        aFilter.addSearchValues(_host.getId());
        if (_pCurrentRightIds != null && _pCurrentRightIds.length > 0) {
            StringBuffer sbRightIdWhere = new StringBuffer(_pCurrentRightIds.length * 3);
            sbRightIdWhere.append(" and OBJECTMEMBERID not in (");
            int nValidRightCount = 0;
            for (int i = 0; i < _pCurrentRightIds.length; ++i) {
                if (_pCurrentRightIds[i] <= 0) continue;
                if (nValidRightCount > 0) {
                    sbRightIdWhere.append(",");
                }
                sbRightIdWhere.append("?");
                aFilter.addSearchValues(_pCurrentRightIds[i]);
                ++nValidRightCount;
            }
            sbRightIdWhere.append(")");
            if (nValidRightCount > 0) {
                sWhere = sWhere + sbRightIdWhere;
            }
        }
        aFilter.setWhere(sWhere);
        this.logger.debug((Object)("delete filter:" + aFilter));
        ObjectMembers delObjectMembers = ObjectMembers.openWCMObjs(_loginUser, aFilter);
        return delObjectMembers;
    }

    private boolean saveObjectMembersOfTopHost() throws WCMException {
        this.deleteRights(this.m_currLoginUser, this.m_oTopRightHost.getSubstance(), WCMObjHelper.toIdsString(this.m_arCurrObjectMembersList));
        if (this.m_arCurrObjectMembersList == null || this.m_arCurrObjectMembersList.isEmpty()) {
            return true;
        }
        for (int i = 0; i < this.m_arCurrObjectMembersList.size(); ++i) {
            ObjectMember currObjectMember = (ObjectMember)this.m_arCurrObjectMembersList.get(i);
            if (currObjectMember == null) {
                this.logger.error((Object)I18NMessage.get(NewRightSet.class, "NewRightSet.label3", "\u4ece\u6743\u9650\u96c6\u5408\u5217\u8868\u4e2d\u53d6\u5f97\u5355\u72ec\u7684\u6743\u9650\u4e3a\u7a7a\uff01"));
                continue;
            }
            if (currObjectMember.getObjType() == 0 || currObjectMember.getId() <= 0) {
                currObjectMember.setObj(this.m_oTopRightHost.getType(), this.m_oTopRightHost.getId());
            }
            currObjectMember.save(this.m_currLoginUser);
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug((Object)("\u4fdd\u5b58[" + this.m_oTopRightHost.getSubstance() + "]objectMember[" + i + "]\uff01<BR>"));
        }
        return true;
    }

    private boolean deleteRights(User loginUser, CMSObj _aObj, String _sCurrentRightIds) throws WCMException {
        if (_aObj == null) {
            return true;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(I18NMessage.get(NewRightSet.class, "NewRightSet.label8", "\u5220\u9664[") + _aObj + "][" + _sCurrentRightIds + "]rights...\n<BR>\n"));
        }
        ObjectMembers delRights = this.getDeleteObjectMembersOfHost(loginUser, _aObj, _sCurrentRightIds);
        delRights.removeAll(true);
        return true;
    }
}

