/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ajaxservice.xmlconvertors;

import com.trs.ajaxservice.xmlconvertors.BaseWCMObjectToXML;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.RightValue;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.content.persistent.WebSites;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.BaseObjs;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.xmlserver.ConvertException;

public class WebSiteToXML
extends BaseWCMObjectToXML {
    @Override
    protected String[][] getSpecialProperty(MethodContext _methodContext, BaseObj _currObj, int _nPropertyId, Object _currValue) {
        return null;
    }

    @Override
    protected String[][] getSpecialRootAttributes(MethodContext context, BaseObjs objects) {
        return null;
    }

    @Override
    protected void registerHostSpecialProperties() {
    }

    @Override
    public String[] registerTargetClassName() {
        return new String[]{WebSites.class.getName(), WebSite.class.getName()};
    }

    @Override
    protected String[][] getSpecialRootAttributes(MethodContext context, BaseObj object) throws ConvertException {
        try {
            boolean bCanEdit = false;
            if (object != null && object.getId() > 0) {
                bCanEdit = AuthServer.hasRight(ContextHelper.getLoginUser(), (CMSObj)((WebSite)object), 1);
            }
            return new String[][]{{"CanEdit", String.valueOf(bCanEdit)}};
        }
        catch (WCMException e) {
            throw new ConvertException(I18NMessage.get(WebSiteToXML.class, "WebSiteToXML.label1", "\u6784\u9020\u7ad9\u70b9\u6839\u8282\u70b9\u5c5e\u6027\u5931\u8d25\uff01"), e);
        }
    }

    @Override
    protected String[][] getSpecialElementAttributes(MethodContext context, BaseObj object) throws ConvertException {
        WebSite site = (WebSite)object;
        if (context.getValue("ContainsRight", false)) {
            try {
                User loginUser = ContextHelper.getLoginUser();
                if (loginUser.isAdministrator()) {
                    return new String[][]{{"Right", RightValue.getAdministratorValues()}};
                }
                return new String[][]{{"Right", AuthServer.getRightValue((CMSObj)site, ContextHelper.getLoginUser()).toString()}};
            }
            catch (Exception e) {
                throw new ConvertException(I18NMessage.get(WebSiteToXML.class, "WebSiteToXML.label2", "\u6784\u9020[") + site + I18NMessage.get(WebSiteToXML.class, "WebSiteToXML.label3", "]\u6743\u9650\u4fe1\u606f\u5931\u8d25!"), e);
            }
        }
        return null;
    }
}

