/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ajaxservice.xmlconvertors;

import com.trs.ajaxservice.WebSiteServiceProvider;
import com.trs.ajaxservice.xmlconvertors.BaseWCMObjectToXML;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.RightValue;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.cms.content.WCMSystemObject;
import com.trs.cms.process.definition.Flow;
import com.trs.cms.process.definition.Flows;
import com.trs.components.infoview.persistent.InfoView;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.infra.I18NMessage;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.BaseObjs;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.xmlserver.ConvertException;
import org.apache.log4j.Logger;

public class FlowToXML
extends BaseWCMObjectToXML {
    private static Logger logger = Logger.getLogger(FlowToXML.class);
    private static final int OWNERID = 1;
    private static final int INFOVIEWID = 2;

    @Override
    protected String[][] getSpecialElementAttributes(MethodContext context, BaseObj object) throws ConvertException {
        Flow flow = (Flow)object;
        if (context.getValue("ContainsRight", false)) {
            try {
                User loginUser = ContextHelper.getLoginUser();
                RightValue rightValue = null;
                boolean bIsRoot = false;
                if (loginUser.isAdministrator() || loginUser.getName().equals(flow.getCrUserName())) {
                    rightValue = new RightValue(RightValue.VALUE_ADMINISTRATOR);
                } else {
                    rightValue = (RightValue)context.getContextCacheData("OwnerValue");
                    if (rightValue == null) {
                        CMSObj owner = (CMSObj)context.getContextCacheData("Owner");
                        if (owner == null) {
                            owner = (CMSObj)flow.getOwner();
                        }
                        if (owner != null && !(owner instanceof WCMSystemObject)) {
                            if (owner instanceof Channel) {
                                owner = ((Channel)owner).getSite();
                            }
                            rightValue = AuthServer.getRightValue(owner, loginUser);
                        } else {
                            rightValue = new RightValue(0L);
                            bIsRoot = true;
                        }
                        context.putContextCacheData("OwnerValue", rightValue);
                    }
                }
                return new String[][]{{"Right", rightValue.toString()}, {"IsRoot", String.valueOf(bIsRoot)}};
            }
            catch (Exception e) {
                throw new ConvertException(I18NMessage.get(FlowToXML.class, "FlowToXML.label1", "\u6784\u9020[") + flow + I18NMessage.get(FlowToXML.class, "FlowToXML.label2", "]\u6743\u9650\u4fe1\u606f\u5931\u8d25!"), e);
            }
        }
        return null;
    }

    @Override
    protected String[][] getSpecialProperty(MethodContext _methodContext, BaseObj _currObj, int _nPropertyId, Object _currValue) {
        Flow flow = (Flow)_currObj;
        switch (_nPropertyId) {
            case 1: {
                try {
                    int nOwnerId = flow.getOwnerId();
                    if (flow.getOwnerType() == 1) {
                        return new String[][]{{"Id", String.valueOf(nOwnerId)}, {"Name", WebSiteServiceProvider.findSiteTypeDesc(nOwnerId)}};
                    }
                    BaseObj baseObj = flow.getOwner();
                    if (baseObj == null) {
                        return new String[][]{{"Id", _currValue.toString()}, {"Name", I18NMessage.get(FlowToXML.class, "FlowToXML.label3", "\u672a\u77e5")}};
                    }
                    return new String[][]{{"Id", _currValue.toString()}, {"Name", baseObj.toString()}};
                }
                catch (Throwable e) {
                    logger.error((Object)I18NMessage.get(FlowToXML.class, "FlowToXML.label4", "\u83b7\u53d6\u5de5\u4f5c\u6d41\u7684Owner\u53d1\u751f\u5f02\u5e38\uff01"), e);
                    return new String[][]{{"Id", _currValue.toString()}, {"Name", I18NMessage.get(FlowToXML.class, "FlowToXML.label3", "\u672a\u77e5")}};
                }
            }
            case 2: {
                int nInfoviewId = flow.getPropertyAsInt("INFOVIEWID", 0);
                if (nInfoviewId <= 0) break;
                try {
                    InfoView infoview = InfoView.findById(nInfoviewId);
                    if (infoview != null) {
                        return new String[][]{{"Id", String.valueOf(nInfoviewId)}, {"Name", infoview.getName()}, {"Desc", infoview.getDesc()}};
                    }
                    break;
                }
                catch (Exception ex) {
                    throw new RuntimeException(I18NMessage.get(FlowToXML.class, "FlowToXML.label5", "\u67e5\u627e[ID=") + nInfoviewId + I18NMessage.get(FlowToXML.class, "FlowToXML.label6", "]\u7684\u8868\u5355\u5931\u8d25\uff01"), ex);
                }
            }
        }
        return null;
    }

    @Override
    protected String[][] getSpecialRootAttributes(MethodContext context, BaseObjs objects) {
        return null;
    }

    @Override
    protected String[][] getSpecialRootAttributes(MethodContext context, BaseObj object) {
        return null;
    }

    @Override
    protected void registerHostSpecialProperties() {
        this.registerHostSpecialProperty("OWNERID", 1, "OWNER");
        this.registerHostSpecialProperty("INFOVIEWID", 2, "INFOVIEW");
    }

    @Override
    public String[] registerTargetClassName() {
        return new String[]{Flows.class.getName(), Flow.class.getName()};
    }
}

