/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ajaxservice.xmlconvertors;

import com.trs.ajaxservice.xmlconvertors.BaseWCMObjectToXML;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.RightValue;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.BaseObjs;
import com.trs.infra.util.CMyString;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.xmlserver.ConvertException;
import org.apache.log4j.Logger;

public class ChannelToXML
extends BaseWCMObjectToXML {
    private static Logger logger = Logger.getLogger(ChannelToXML.class);
    private static final int PARENT_ID = 1;
    private static final int CHNL_TYPE = 2;
    private static final int CHNL_PROP = 3;
    private static final int SITE_ID = 4;
    private static int[] RIGHTS_FORBID_TOPPIC = new int[]{11, 19, 15, 16, 17, 53};

    @Override
    protected String[][] getSpecialProperty(MethodContext _methodContext, BaseObj _currObj, int _nPropertyId, Object _currValue) throws ConvertException {
        Channel channel = (Channel)_currObj;
        switch (_nPropertyId) {
            case 1: {
                return this.makeChannelHostInfo(_currValue, channel, _methodContext.getValue("NeedChannelPath", false));
            }
            case 2: {
                return this.makeChannelTypeInfo(_currValue, channel);
            }
            case 3: {
                return this.makeChannelProInfo(channel);
            }
            case 4: {
                return this.makeChannelSiteInfo(_currValue, channel);
            }
        }
        return null;
    }

    private String[][] makeChannelHostInfo(Object _currValue, Channel _channel, boolean _bNeedChannelPath) throws ConvertException {
        try {
            BaseChannel host = _channel.getHost();
            if (host == null) {
                throw new ConvertException(_channel + CMyString.format(I18NMessage.get(ChannelToXML.class, "ChannelToXML.label1", "{0}\u7684\u7236\u7ed3\u70b9[Id={1}]\u4e0d\u5b58\u5728\uff01"), new String[]{_channel.toString(), _currValue.toString()}));
            }
            return new String[][]{{"Id", host.isSite() ? "0" : String.valueOf(host.getId())}, {"Type", host.isSite() ? "Site" : "Channel"}, {"Name", host.getDispDesc()}, {"Path", _bNeedChannelPath ? "" : this.getAdaptedPath(host)}};
        }
        catch (WCMException e) {
            throw new ConvertException(I18NMessage.get(ChannelToXML.class, "ChannelToXML.label3", "\u6784\u9020\u680f\u76ee\u7684\u7236\u7ed3\u70b9\u4fe1\u606f\u7cfb\u7edf\u53d1\u751f\u5f02\u5e38\uff01"), e);
        }
    }

    private String getAdaptedPath(BaseChannel host) {
        String result = host.getInfo();
        try {
            if (host != null && host instanceof Channel) {
                Channel chnl = (Channel)host;
                StringBuffer sbChannelNav = new StringBuffer(chnl.getDesc() + I18NMessage.get(ChannelToXML.class, "ChannelToXML.label4", "[\u680f\u76ee-") + chnl.getId() + "]");
                for (Channel parent = chnl.getParent(); parent != null && parent != null; parent = parent.getParent()) {
                    sbChannelNav.insert(0, " > ");
                    sbChannelNav.insert(0, parent.getDesc() + I18NMessage.get(ChannelToXML.class, "ChannelToXML.label4", "[\u680f\u76ee-") + parent.getId() + "]");
                }
                result = sbChannelNav.toString();
                sbChannelNav.setLength(0);
            }
        }
        catch (WCMException ex) {
            logger.warn((Object)"failed to get the path of channel!", (Throwable)ex);
        }
        return result;
    }

    private String[][] makeChannelSiteInfo(Object _currValue, Channel _channel) throws ConvertException {
        try {
            User loginUser = ContextHelper.getLoginUser();
            WebSite site = _channel.getSite();
            if (site == null) {
                throw new ConvertException(_channel + CMyString.format(I18NMessage.get(ChannelToXML.class, "ChannelToXML.label5", "{0}\u7684\u7ad9\u70b9[Id={1}]\u4e0d\u5b58\u5728\uff01"), new String[]{_channel.toString(), _currValue.toString()}));
            }
            RightValue rightValue = null;
            rightValue = loginUser.isAdministrator() ? RightValue.getAdministratorRightValue() : AuthServer.getRightValue((CMSObj)site, ContextHelper.getLoginUser());
            return new String[][]{{"Id", _currValue.toString()}, {"Name", site.getDispDesc()}, {"SiteType", String.valueOf(site.getPropertyAsInt("SiteType", 0))}, {"Right", rightValue.toString()}};
        }
        catch (WCMException e) {
            throw new ConvertException(I18NMessage.get(ChannelToXML.class, "ChannelToXML.label6", "\u6784\u9020\u680f\u76ee\u7684\u6240\u5c5e\u7ad9\u70b9\u4fe1\u606f\u7cfb\u7edf\u53d1\u751f\u5f02\u5e38\uff01"), e);
        }
    }

    private String[][] makeChannelTypeInfo(Object _currValue, Channel _channel) {
        return new String[][]{{"Id", _currValue.toString()}, {"Name", _channel.getTypeDesc()}};
    }

    private String[][] makeChannelProInfo(Channel _channel) {
        return new String[][]{{"OnlyManager", String.valueOf(_channel.isOnlyManager())}, {"OnlySearch", String.valueOf(_channel.isOnlySearch())}, {"CanPub", String.valueOf(_channel.isCanPub())}, {"DoDeptFilter", String.valueOf(_channel.isDoDeptFilter())}};
    }

    @Override
    protected String[][] getSpecialRootAttributes(MethodContext context, BaseObjs objects) {
        return null;
    }

    @Override
    protected void registerHostSpecialProperties() {
        this.registerHostSpecialProperty("ParentId", 1, "Parent");
        this.registerHostSpecialProperty("ChnlType", 2);
        this.registerHostSpecialProperty("ChnlProp", 3);
        this.registerHostSpecialProperty("SiteId", 4, "Site");
    }

    @Override
    public String[] registerTargetClassName() {
        return new String[]{Channel.class.getName(), Channels.class.getName()};
    }

    @Override
    protected String[][] getSpecialRootAttributes(MethodContext context, BaseObj object) throws ConvertException {
        Channel channel = (Channel)object;
        try {
            return new String[][]{{"CanEdit", String.valueOf(AuthServer.hasRight(ContextHelper.getLoginUser(), (CMSObj)channel, 13))}};
        }
        catch (WCMException e) {
            throw new ConvertException(I18NMessage.get(ChannelToXML.class, "ChannelToXML.label7", "\u6784\u9020\u680f\u76ee\u6839\u8282\u70b9\u5c5e\u6027\u5931\u8d25\uff01"), e);
        }
    }

    @Override
    protected String[][] getSpecialElementAttributes(MethodContext context, BaseObj object) throws ConvertException {
        Channel channel = (Channel)object;
        String[] pHasChildren = null;
        try {
            pHasChildren = new String[]{"HasChildren", channel.getChildrenSize(null) > 0 ? "true" : "false"};
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String[] pIsVirtual = new String[]{"IsVirtual", String.valueOf(channel.isVirtual())};
        if (context.getValue("ContainsRight", false)) {
            try {
                User loginUser = ContextHelper.getLoginUser();
                RightValue rightValue = null;
                rightValue = loginUser.isAdministrator() || loginUser.getName().equalsIgnoreCase(channel.getCrUserName()) ? new RightValue(RightValue.VALUE_ADMINISTRATOR) : AuthServer.getRightValue((CMSObj)channel, ContextHelper.getLoginUser());
                ChannelToXML.doFilterRight(rightValue, channel);
                return new String[][]{{"Right", rightValue.toString()}, pHasChildren, pIsVirtual};
            }
            catch (Exception e) {
                throw new ConvertException(I18NMessage.get(ChannelToXML.class, "ChannelToXML.label8", "\u6784\u9020[") + channel + I18NMessage.get(ChannelToXML.class, "ChannelToXML.label9", "]\u6743\u9650\u4fe1\u606f\u5931\u8d25!"), e);
            }
        }
        return new String[][]{pHasChildren, pIsVirtual};
    }

    public static void doFilterRight(RightValue _rightValue, Channel _channel) {
        if (_channel.getType() == 2 || _channel.getType() == 1 || _channel.getType() == 11) {
            for (int i = 0; i < RIGHTS_FORBID_TOPPIC.length; ++i) {
                _rightValue.setHasRight(RIGHTS_FORBID_TOPPIC[i], false);
            }
        }
        if (_channel.getType() == 13) {
            _rightValue.setHasRight(11, false);
        }
    }
}

