/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ajaxservice.listener;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.IObjectMemberMgr;
import com.trs.cms.auth.persistent.ObjectMember;
import com.trs.cms.auth.persistent.ObjectMembers;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.webframework.config.ServiceListenerConfig;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.provider.IServiceListener;

public class SaveMembersListenerForObjectMember
implements IServiceListener {
    private IObjectMemberMgr m_oObjectMemberMgr = (IObjectMemberMgr)DreamFactory.createObjectById("IObjectMemberMgr");

    @Override
    public void afterServiceExecuted(ServiceListenerConfig listenerConfig, MethodContext methodContext, Object serviceResult) {
        int nObjType = methodContext.getValue("ObjType", 0);
        int nObjId = methodContext.getValue("ObjId", 0);
        if (nObjId == 0) {
            return;
        }
        User loginUser = this.getLoginUser();
        try {
            BaseChannel currBaseChannel = this.makeCurrBaseChannel(nObjType, nObjId);
            if (currBaseChannel == null) {
                return;
            }
            WCMFilter filter = new WCMFilter("", "ObjType=? and ObjId=?", "");
            filter.addSearchValues(nObjType);
            filter.addSearchValues(nObjId);
            ObjectMembers objectMembers = ObjectMembers.openWCMObjs(loginUser, filter);
            if (objectMembers.size() == 0) {
                return;
            }
            block2: for (int i = 0; i < objectMembers.size(); ++i) {
                ObjectMember currObjMember = (ObjectMember)objectMembers.getAt(i);
                if (currObjMember == null || !currObjMember.isVisible()) continue;
                if (currBaseChannel.isSite()) {
                    return;
                }
                for (BaseChannel parent = currBaseChannel.getHost(); parent != null; parent = parent.getHost()) {
                    this.addVisible(loginUser, currObjMember.getMemberType(), currObjMember.getMemberId(), parent.getWCMType(), parent.getId());
                    if (parent.isSite()) continue block2;
                }
            }
        }
        catch (WCMException e) {
            e.printStackTrace();
        }
    }

    private BaseChannel makeCurrBaseChannel(int _nObjType, int _nObjId) throws WCMException {
        BaseChannel currBaseChannel = null;
        switch (_nObjType) {
            case 101: {
                currBaseChannel = Channel.findById(_nObjId);
                break;
            }
            case 103: {
                currBaseChannel = WebSite.findById(_nObjId);
                break;
            }
            default: {
                return null;
            }
        }
        return currBaseChannel;
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    private void addVisible(User _currUser, int _nMemberType, int _nMemberId, int _nObjType, int _nObjId) throws WCMException {
        CMSObj _oOperator = (CMSObj)BaseObj.findById(_nMemberType, _nMemberId);
        if (this.m_oObjectMemberMgr.isVisible(_oOperator, _nObjType, _nObjId)) {
            return;
        }
        User user = this.getLoginUser();
        ObjectMember oObjectMember = this.m_oObjectMemberMgr.getObjectMember(_nMemberType, _nMemberId, _nObjType, _nObjId);
        if (oObjectMember != null) {
            oObjectMember.setVisible(true);
            oObjectMember.save(user);
        } else {
            oObjectMember = ObjectMember.createNewInstance();
            oObjectMember.setMemberType(_nMemberType);
            oObjectMember.setMemberId(_nMemberId);
            oObjectMember.setObjType(_nObjType);
            oObjectMember.setObjId(_nObjId);
            oObjectMember.setVisible(true);
            oObjectMember.insert(this.getLoginUser());
        }
    }
}

