/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ajaxservice;

import com.trs.cms.auth.config.RightConfigServer;
import com.trs.cms.auth.persistent.RightValue;
import com.trs.cms.auth.persistent.User;
import com.trs.components.wcm.content.ViewDocuments;
import com.trs.components.wcm.content.domain.auth.DocumentAuthServer;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.common.WCMRightTypes;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyString;
import com.trs.webframework.context.MethodContext;
import org.apache.log4j.Logger;

public class WCMDocumentHelper {
    private static Logger logger = Logger.getLogger(WCMDocumentHelper.class);

    public static String makeRightValue(MethodContext _methodContext, User _loginUser, Channel _currChannel, Document _document) throws WCMException {
        String sFlowDesc = _document.getPropertyAsString("FLOWOPERATIONMARK");
        boolean bFlowRightPriority = "true".equalsIgnoreCase(ConfigServer.getServer().getSysConfigValue("FLOW_RIGHT_PRI", "false"));
        boolean bInFlow = bFlowRightPriority && !CMyString.isEmpty(sFlowDesc) && !sFlowDesc.equalsIgnoreCase("RESERVED_FORCED_END") && !sFlowDesc.equals(I18NMessage.get(WCMDocumentHelper.class, "WCMDocumentHelper.label1", "\u7ed3\u675f\u6d41\u8f6c"));
        int[] pRemoveRightIndexs = WCMRightTypes.getRemoveRightIndexs();
        if (DocumentAuthServer.isDefineRightOnDocument(_document)) {
            try {
                RightValue rightValue = new RightValue();
                rightValue.load(_loginUser, 605, _document.getId(), true);
                if (_loginUser.getName().equalsIgnoreCase(_document.getCrUserName())) {
                    int[] pRightIndexesOnOwner = DocumentAuthServer.INDEXES_OWNER_HAS;
                    for (int i = 0; i < pRightIndexesOnOwner.length; ++i) {
                        int nRightIndex = pRightIndexesOnOwner[i];
                        rightValue.setBit(nRightIndex, true);
                    }
                }
                if (bInFlow) {
                    for (int i = 0; i < pRemoveRightIndexs.length; ++i) {
                        rightValue.setBit(pRemoveRightIndexs[i], false);
                    }
                }
                return rightValue.toString();
            }
            catch (WCMException ex) {
                throw new WCMException(1100, I18NMessage.get(WCMDocumentHelper.class, "WCMDocumentHelper.label2", "\u83b7\u53d6\u6307\u5b9a\u5bf9\u8c61\u7684\u6743\u9650\u503c\u65f6\u5931\u8d25"), ex);
            }
        }
        if (_loginUser.isAdministrator()) {
            if (!bInFlow) {
                return RightValue.getAdministratorValues();
            }
            RightValue rightValue = new RightValue(RightValue.getAdministratorRightValue().getValue());
            for (int i = 0; i < pRemoveRightIndexs.length; ++i) {
                rightValue.setBit(pRemoveRightIndexs[i], false);
            }
            return rightValue.toString();
        }
        Channel currChannel = _currChannel;
        if (_currChannel != null && _currChannel.isOnlySearch() && (currChannel = _document.getChannel()) == null) {
            logger.error((Object)(_document + I18NMessage.get(WCMDocumentHelper.class, "WCMDocumentHelper.label3", "\u6240\u5c5e\u680f\u76ee[ID=") + _document.getChannelId() + I18NMessage.get(WCMDocumentHelper.class, "WCMDocumentHelper.label4", "]\u4e0d\u5b58\u5728")));
            return "0";
        }
        int nDocChannelId = _document.getChannelId();
        String sDocChannelRightKey = nDocChannelId + "." + nDocChannelId;
        RightValue newRightValue = new RightValue();
        if (currChannel == null || currChannel.getId() == nDocChannelId) {
            if (currChannel != null && _loginUser.getName().equals(currChannel.getCrUserName())) {
                return RightValue.getAdministratorValues();
            }
            RightValue docChannelRightValue = WCMDocumentHelper.getChannelRightValueFromCache(_methodContext, _loginUser, sDocChannelRightKey, nDocChannelId);
            newRightValue.copy(docChannelRightValue);
        } else {
            String sCurrChannelRightkey = nDocChannelId + "." + currChannel.getId();
            RightValue currChannelRightValue = null;
            currChannelRightValue = _loginUser.getName().equalsIgnoreCase(currChannel.getCrUserName()) ? RightValue.getAdministratorRightValue() : WCMDocumentHelper.getChannelRightValueFromCache(_methodContext, _loginUser, sCurrChannelRightkey, currChannel.getId());
            RightValue docChannelRightValue = WCMDocumentHelper.getChannelRightValueFromCache(_methodContext, _loginUser, sDocChannelRightKey, _document.getChannelId());
            newRightValue.copy(docChannelRightValue);
            int[] pRightIndexesOnChannel = RightConfigServer.getInstance().getRightIndexDefineOnCurrChannel(currChannel.getSiteId());
            for (int i = 0; i < pRightIndexesOnChannel.length; ++i) {
                int nRightIndex = pRightIndexesOnChannel[i];
                newRightValue.setBit(nRightIndex, currChannelRightValue.getBit(nRightIndex));
            }
        }
        if (_loginUser.getName().equalsIgnoreCase(_document.getCrUserName())) {
            int[] pRightIndexesOnOwner = DocumentAuthServer.INDEXES_OWNER_HAS;
            for (int i = 0; i < pRightIndexesOnOwner.length; ++i) {
                int nRightIndex = pRightIndexesOnOwner[i];
                newRightValue.setBit(nRightIndex, true);
            }
        }
        if (bInFlow) {
            for (int i = 0; i < pRemoveRightIndexs.length; ++i) {
                newRightValue.setBit(pRemoveRightIndexs[i], false);
            }
        }
        return newRightValue.toString();
    }

    private static RightValue getChannelRightValueFromCache(MethodContext _methodContext, User _loginUser, String _sCacheKey, int _nChannelId) throws WCMException {
        RightValue oRightValue = (RightValue)_methodContext.getContextCacheData(_sCacheKey);
        if (oRightValue == null) {
            oRightValue = new RightValue();
            oRightValue.load(_loginUser, 101, _nChannelId, true);
            _methodContext.putContextCacheData(_sCacheKey, oRightValue);
        }
        return oRightValue;
    }

    public static ViewDocuments findViewDocumentsByIds(User _loginUser, String _sChnlDocIds) throws WCMException {
        String sChnlDocFields = "RecId,ChnlId,DocId,DocChannel";
        WCMFilter filter = new WCMFilter("WCMChnlDoc", "", "", sChnlDocFields);
        int[] pRecIds = CMyString.splitToInt(_sChnlDocIds, ",");
        StringBuffer sbWhere = new StringBuffer(_sChnlDocIds.length() + pRecIds.length * 1 + 20);
        sbWhere.append("RecId in(?");
        filter.addSearchValues(pRecIds[0]);
        for (int i = 1; i < pRecIds.length; ++i) {
            sbWhere.append(",?");
            filter.addSearchValues(pRecIds[i]);
        }
        sbWhere.append(")");
        filter.setWhere(sbWhere.toString());
        ViewDocuments viewDocuments = new ViewDocuments(_loginUser);
        viewDocuments.setSelectFields("RecId,ChnlId,DocId,DocChannel", "CrUser");
        viewDocuments.setPageSize(pRecIds.length);
        viewDocuments.openViewDocuments(filter);
        return viewDocuments;
    }
}

