/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ajaxservice;

import com.trs.ajaxservice.ChannelHelper;
import com.trs.ajaxservice.JSONHelper;
import com.trs.ajaxservice.WebSiteHelper;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSBaseObjs;
import com.trs.cms.content.CMSObj;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.content.persistent.WebSites;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyString;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.provider.ISelfDefinedServiceProvider;
import java.util.HashMap;

public class SystemServiceProvider
implements ISelfDefinedServiceProvider {
    private boolean isSite = false;
    public static String[][] SITE_TYPES = new String[][]{{"sitetype", I18NMessage.get(SystemServiceProvider.class, "SystemServiceProvider.label1", "\u6587\u5b57\u5e93"), String.valueOf(0)}, {"sitetype", I18NMessage.get(SystemServiceProvider.class, "SystemServiceProvider.label2", "\u56fe\u7247\u5e93"), String.valueOf(1)}, {"sitetype", I18NMessage.get(SystemServiceProvider.class, "SystemServiceProvider.label3", "\u89c6\u9891\u5e93"), String.valueOf(2)}, {"sitetype", I18NMessage.get(SystemServiceProvider.class, "SystemServiceProvider.label4", "\u8d44\u6e90\u5e93"), String.valueOf(4)}};

    public String findNodesByPath(MethodContext _methodContext) throws Throwable {
        Object[] pResult;
        block23: {
            CMSBaseObjs nodes;
            HashMap<String, Object> hParentInfo;
            String sPathPre;
            block25: {
                String sWhere;
                String sPath;
                User loginUser;
                block24: {
                    boolean bFullMatch;
                    block22: {
                        loginUser = this.getLoginUser();
                        pResult = null;
                        sPath = _methodContext.getValue("Path");
                        if (sPath != null) {
                            sPath = sPath.trim();
                        }
                        sPathPre = null;
                        this.isSite = _methodContext.getValue("isSite").equalsIgnoreCase("true");
                        hParentInfo = new HashMap<String, Object>(2);
                        hParentInfo.put("ParentType", "");
                        hParentInfo.put("ParentId", "-1");
                        if (sPath != null && sPath.length() != 0 && !sPath.equals("\\")) break block22;
                        sPathPre = "\\";
                        pResult = new HashMap[SITE_TYPES.length + 1];
                        pResult[0] = hParentInfo;
                        for (int i = 0; i < SITE_TYPES.length; ++i) {
                            pResult[i + 1] = this.makeNodeInfo(SITE_TYPES[i][0], SITE_TYPES[i][1], SITE_TYPES[i][2], sPathPre);
                        }
                        break block23;
                    }
                    nodes = null;
                    if (sPath.charAt(0) != '\\') break block24;
                    String[] pPath = sPath.split("\\\\");
                    int nPathNodesCount = pPath.length - 1;
                    boolean bl = bFullMatch = sPath.charAt(sPath.length() - 1) == '\\';
                    if (bFullMatch) {
                        sPathPre = sPath;
                        hParentInfo = new HashMap(2);
                    } else {
                        int nPos = sPath.lastIndexOf(92);
                        sPathPre = sPath.substring(0, nPos + 1);
                    }
                    switch (nPathNodesCount) {
                        case 1: {
                            if (bFullMatch) {
                                int nSiteType = this.findSiteTypeId(pPath[1]);
                                hParentInfo.put("ParentType", "SiteType");
                                hParentInfo.put("ParentId", String.valueOf(nSiteType));
                                if (nSiteType != -1) {
                                    nodes = WebSiteHelper.getWebSitesByType(loginUser, nSiteType, new WCMFilter("", "", "SiteOrder Desc"));
                                    break;
                                }
                            } else {
                                pResult = new HashMap[SITE_TYPES.length];
                                for (int i = 0; i < SITE_TYPES.length; ++i) {
                                    String sSiteTypeName = SITE_TYPES[i][1];
                                    if (sSiteTypeName.indexOf(pPath[1]) < 0) continue;
                                    pResult[i] = this.makeNodeInfo(SITE_TYPES[i][0], sSiteTypeName, SITE_TYPES[i][2], sPathPre);
                                }
                            }
                            break block25;
                        }
                        case 2: {
                            if (this.isSite) {
                                String sSiteName = pPath[2];
                                String sWhere2 = "Status>=0 and SITENAME=? ";
                                WCMFilter filter = new WCMFilter("", sWhere2, "");
                                filter.addSearchValues(0, sSiteName);
                                nodes = WebSites.openWCMObjs(loginUser, filter);
                                WebSiteHelper.removeNoRightSite(loginUser, (WebSites)nodes, 64);
                                break;
                            }
                            String sSiteName = pPath[2];
                            if (bFullMatch) {
                                WebSite currSite = this.findSiteByName(loginUser, this.findSiteTypeId(pPath[1]), pPath[2]);
                                hParentInfo.put("ParentType", "Site");
                                hParentInfo.put("ParentId", currSite.getKey());
                                nodes = ChannelHelper.getChildren(loginUser, currSite, new WCMFilter("", "", "ChnlOrder Desc"));
                                break;
                            }
                            int nSiteType = this.findSiteTypeId(pPath[1]);
                            if (nSiteType != -1) {
                                nodes = WebSiteHelper.getWebSitesByType(loginUser, nSiteType, null);
                                for (int i = nodes.size() - 1; i >= 0; --i) {
                                    WebSite site = (WebSite)nodes.getAt(i);
                                    if (!this.notSimilar(sSiteName, site)) continue;
                                    nodes.removeAt(i, false);
                                }
                            }
                            break block25;
                        }
                        default: {
                            if (this.isSite) {
                                String sSiteName = pPath[2];
                                String sWhere3 = "Status>=0 and SITENAME=? ";
                                WCMFilter filter = new WCMFilter("", sWhere3, "");
                                filter.addSearchValues(0, sSiteName);
                                nodes = WebSites.openWCMObjs(loginUser, filter);
                                WebSiteHelper.removeNoRightSite(loginUser, (WebSites)nodes, 64);
                                break;
                            }
                            nodes = this.findChannelsByPath(loginUser, pPath, bFullMatch, 2, null, hParentInfo);
                        }
                    }
                    break block25;
                }
                if (this.isSite) {
                    sWhere = "Status>=0 and SITEDESC like ?";
                    WCMFilter filter = new WCMFilter("", sWhere, "");
                    filter.addSearchValues(0, '%' + sPath + '%');
                    nodes = WebSites.openWCMObjs(loginUser, filter);
                    WebSiteHelper.removeNoRightSite(loginUser, (WebSites)nodes, 64);
                } else {
                    sWhere = "Status>=0 and ChnlDesc like ?";
                    WCMFilter filter = new WCMFilter("", sWhere, "");
                    filter.addSearchValues(0, '%' + sPath + '%');
                    nodes = Channels.openWCMObjs(loginUser, filter);
                    ChannelHelper.removeNoRightChannel(loginUser, (Channels)nodes, 64);
                }
            }
            if (sPathPre != null) {
                sPathPre = CMyString.filterForHTMLValue(sPathPre);
            }
            int nFindNodeCount = nodes == null ? 0 : nodes.size();
            pResult = new HashMap[nFindNodeCount + 1];
            pResult[0] = hParentInfo;
            if (nFindNodeCount == 1 && hParentInfo.get("ParentId").toString().equals("-1")) {
                BaseChannel siteOrChannel = (BaseChannel)nodes.getAt(0);
                hParentInfo.put("ParentType", siteOrChannel.isSite() ? "Site" : "Channel");
                hParentInfo.put("ParentId", siteOrChannel.getKey());
            }
            for (int i = 0; i < nFindNodeCount; ++i) {
                BaseChannel siteOrChannel = (BaseChannel)nodes.getAt(i);
                if (siteOrChannel == null) continue;
                String _pathPre = null;
                _pathPre = sPathPre == null ? (!this.isSite ? this.getPathPre(siteOrChannel.isSite() ? siteOrChannel : siteOrChannel.getHost(), "") : this.getPathPre2(siteOrChannel)) : sPathPre;
                pResult[i + 1] = this.makeNodeInfo(siteOrChannel.isSite() ? "site" : "channel", siteOrChannel.getDispDesc(), siteOrChannel.getId(), _pathPre);
            }
        }
        _methodContext.setReturnJSON(true);
        return JSONHelper.toJSON(pResult, 0);
    }

    public boolean isValidChannelId(MethodContext _oMethodContext) throws WCMException {
        User loginUser = this.getLoginUser();
        Channel channel = Channel.findById(_oMethodContext.getObjectId());
        return channel != null && AuthServer.hasRight(loginUser, (CMSObj)channel, 64) && channel.getStatus() >= 0;
    }

    public boolean isValidSiteId(MethodContext _oMethodContext) throws WCMException {
        User loginUser = this.getLoginUser();
        WebSite site = WebSite.findById(_oMethodContext.getObjectId());
        return site != null && AuthServer.hasRight(loginUser, (CMSObj)site, 64) && site.getStatus() >= 0;
    }

    private Channels findChannelsByPath(User _loginUser, String[] pPath, boolean _bFullMatch, int _nLevel, BaseChannel _host, HashMap _hParentInfo) throws WCMException {
        BaseChannel host = _host;
        if (host == null) {
            int nSiteType = this.findSiteTypeId(pPath[1]);
            if (nSiteType == -1) {
                return null;
            }
            WebSite currSite = this.findSiteByName(_loginUser, nSiteType, pPath[2]);
            if (currSite == null) {
                return null;
            }
            host = currSite;
            return this.findChannelsByPath(_loginUser, pPath, _bFullMatch, _nLevel + 1, host, _hParentInfo);
        }
        if (_nLevel < pPath.length - 1 || _bFullMatch) {
            Channel currChannel = this.findChannelByName(_loginUser, host, pPath[_nLevel]);
            if (currChannel == null) {
                return null;
            }
            if (_nLevel == pPath.length - 1) {
                _hParentInfo.put("ParentType", "Channel");
                _hParentInfo.put("ParentId", currChannel.getKey());
                return ChannelHelper.getChildren(_loginUser, currChannel, null);
            }
            return this.findChannelsByPath(_loginUser, pPath, _bFullMatch, _nLevel + 1, currChannel, _hParentInfo);
        }
        return this.findChannelsBySimilarName(_loginUser, host, pPath[_nLevel]);
    }

    private Channel findChannelByName(User user, BaseChannel host, String _sChannelName) throws WCMException {
        WCMFilter filter = new WCMFilter("", "ChnlDesc=? and Status>=0", "");
        filter.addSearchValues(0, _sChannelName);
        Channels channels = ChannelHelper.getChildren(user, host, filter);
        if (!channels.isEmpty()) {
            return (Channel)channels.getAt(0);
        }
        return null;
    }

    private Channels findChannelsBySimilarName(User user, BaseChannel host, String _sChannelName) throws WCMException {
        WCMFilter filter = new WCMFilter("", "ChnlDesc like ? and Status>=0", "");
        filter.addSearchValues(0, '%' + _sChannelName + '%');
        return ChannelHelper.getChildren(user, host, filter);
    }

    private WebSite findSiteByName(User _loginUser, int _nSiteType, String _sSiteName) throws WCMException {
        WCMFilter filter = new WCMFilter("", "SiteType=? and SiteDesc=? and Status>=0", "");
        filter.addSearchValues(0, _nSiteType);
        filter.addSearchValues(1, _sSiteName);
        filter.setMaxRowNumber(1);
        WebSites sites = WebSites.openWCMObjs(_loginUser, filter);
        if (!sites.isEmpty()) {
            return (WebSite)sites.getAt(0);
        }
        return null;
    }

    private boolean notSimilar(String _sSiteName, WebSite _currSite) {
        return _currSite == null || _currSite.getDispDesc().indexOf(_sSiteName) < 0;
    }

    private String getPathPre(BaseChannel siteOrChannel, String _sChildPath) throws WCMException {
        if (siteOrChannel == null) {
            return I18NMessage.get(SystemServiceProvider.class, "SystemServiceProvider.label5", "\u7236\u5bf9\u8c61\u6ca1\u6709\u627e\u5230");
        }
        String sSelfPath = siteOrChannel.getDispDesc();
        if (siteOrChannel.isSite()) {
            WebSite site = (WebSite)siteOrChannel;
            return '\\' + SystemServiceProvider.getSiteTypeDesc(site.getPropertyAsString("SITETYPE")) + "\\" + CMyString.filterForHTMLValue(sSelfPath) + "\\" + _sChildPath;
        }
        return this.getPathPre(siteOrChannel.getHost(), _sChildPath + CMyString.filterForHTMLValue(sSelfPath) + "\\");
    }

    private String getPathPre2(BaseChannel siteOrChannel) throws WCMException {
        if (siteOrChannel == null) {
            return I18NMessage.get(SystemServiceProvider.class, "SystemServiceProvider.label5", "\u7236\u5bf9\u8c61\u6ca1\u6709\u627e\u5230");
        }
        return '\\' + SystemServiceProvider.getSiteTypeDesc(siteOrChannel.getPropertyAsString("SITETYPE")) + "\\";
    }

    public static String getSiteTypeDesc(String _sTypeId) {
        for (int i = 0; i < SITE_TYPES.length; ++i) {
            if (!SITE_TYPES[i][2].equals(_sTypeId)) continue;
            return SITE_TYPES[i][1];
        }
        return I18NMessage.get(SystemServiceProvider.class, "SystemServiceProvider.label6", "\u672a\u77e5\u7ad9\u70b9\u7c7b\u578b");
    }

    private int findSiteTypeId(String _sTypeName) {
        for (int i = 0; i < SITE_TYPES.length; ++i) {
            String sSiteTypeName = SITE_TYPES[i][1];
            if (!sSiteTypeName.equalsIgnoreCase(_sTypeName)) continue;
            return Integer.parseInt(SITE_TYPES[i][2]);
        }
        return -1;
    }

    private HashMap makeNodeInfo(String _sType, String _sName, int _nId, String _sPrePath) {
        return this.makeNodeInfo(_sType, _sName, String.valueOf(_nId), _sPrePath);
    }

    private HashMap makeNodeInfo(String _sType, String _sName, String _sId, String _sPrePath) {
        String sName = CMyString.filterForHTMLValue(_sName);
        HashMap<String, String> hTemp = new HashMap<String, String>(3);
        hTemp.put("type", _sType);
        hTemp.put("name", sName);
        hTemp.put("id", _sId);
        hTemp.put("path", _sPrePath + sName);
        return hTemp;
    }

    private User getLoginUser() {
        User loginUser = ContextHelper.getLoginUser();
        return loginUser;
    }
}

