/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ajaxservice;

import com.trs.DreamFactory;
import com.trs.ajaxservice.DocumentServiceProvider;
import com.trs.ajaxservice.WCMAJAXServiceHelper;
import com.trs.ajaxservice.xmlconvertors.XMLToCMSObj;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.domain.IObjectMemberMgr;
import com.trs.cms.auth.domain.IRightHost;
import com.trs.cms.auth.domain.ObjectMemberSet;
import com.trs.cms.auth.domain.RightHostFactory;
import com.trs.cms.auth.persistent.Group;
import com.trs.cms.auth.persistent.ObjectMember;
import com.trs.cms.auth.persistent.ObjectMembers;
import com.trs.cms.auth.persistent.Role;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.cms.content.WCMObjHelper;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyString;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.provider.IGlueServiceProvider;
import java.util.ArrayList;
import java.util.List;

public class ObjectMemberServiceProvider
implements IGlueServiceProvider {
    @Override
    public void delete(MethodContext _oContext) throws Throwable {
        User loginUser = this.getLoginUser();
        ObjectMembers members = ObjectMembers.findByIds(loginUser, _oContext.getObjectIds());
        members.removeAll(true);
    }

    @Override
    public Object query(MethodContext _oContext) throws Throwable {
        return null;
    }

    @Override
    public int save(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        ObjectMember member = null;
        int nObjectId = _methodContext.getObjectId();
        if (nObjectId == 0) {
            member = new ObjectMember();
        } else {
            member = ObjectMember.findById(nObjectId);
            if (member == null) {
                throw new WCMException(I18NMessage.get(DocumentServiceProvider.class, "ObjectMemberServiceProvider.label19", "\u6307\u5b9a\u7684\u6210\u5458\u4e0d\u5b58\u5728![ObjectId=") + _methodContext.getObjectId() + "]");
            }
        }
        member = (ObjectMember)WCMAJAXServiceHelper.setWCMObjectProperties(loginUser, _methodContext, member, null);
        member.save(loginUser);
        return member.getId();
    }

    @Override
    public Object findById(MethodContext _methodContext) throws Throwable {
        return ObjectMember.findById(_methodContext.getObjectId());
    }

    @Override
    public Object findByIds(MethodContext _oContext) throws Throwable {
        return null;
    }

    public ObjectMembers queryMembersOfObject(MethodContext _methodContext) throws Exception {
        User loginUser = this.getLoginUser();
        int nObjType = _methodContext.getValue("ObjType", 0);
        int nObjId = _methodContext.getValue("ObjId", 0);
        BaseChannel baseChannel = null;
        switch (nObjType) {
            case 101: {
                baseChannel = Channel.findById(nObjId);
                break;
            }
            case 103: {
                baseChannel = WebSite.findById(nObjId);
                break;
            }
            default: {
                throw new WCMException("\u4e0d\u652f\u6301\u60a8\u6307\u5b9a\u7684\u5bf9\u8c61\u7c7b\u578b\uff01[ObjType=" + nObjType + "]");
            }
        }
        if (baseChannel == null) {
            throw new WCMException("\u60a8\u6307\u5b9a\u7684\u5bf9\u8c61\u4e0d\u5b58\u5728\uff01[ObjType=" + nObjType + ", ObjId=" + nObjId + "]");
        }
        WCMFilter filter = new WCMFilter("", "ObjType=? and ObjId=?", "");
        filter.addSearchValues(nObjType);
        filter.addSearchValues(nObjId);
        return ObjectMembers.openWCMObjs(loginUser, filter);
    }

    public ObjectMembers queryObjectsOfMember(MethodContext _methodContext) throws Exception {
        User loginUser = this.getLoginUser();
        int nMemberType = _methodContext.getValue("MemberType", 0);
        int nMemberId = _methodContext.getValue("MemberId", 0);
        this.findMember(nMemberType, nMemberId);
        WCMFilter filter = new WCMFilter("", "MemberType=? and MemberId=?", "");
        filter.addSearchValues(nMemberType);
        filter.addSearchValues(nMemberId);
        return ObjectMembers.openWCMObjs(loginUser, filter);
    }

    public void saveObjectsOfMember(MethodContext _methodContext) throws Exception {
        User loginUser = this.getLoginUser();
        XMLToCMSObj xmlToCMSObj = new XMLToCMSObj(loginUser, new ObjectMember());
        xmlToCMSObj.parse(_methodContext.getValue("ObjectMembersXML"));
        CMSObj[] pChangedObjs = xmlToCMSObj.getCMSObjs();
        int nMemberType = _methodContext.getValue("MemberType", 0);
        int nMemberId = _methodContext.getValue("MemberId", 0);
        ArrayList<BaseChannel> objectsOnPath = new ArrayList<BaseChannel>();
        for (int i = 0; i < pChangedObjs.length; ++i) {
            ObjectMember currObjectMember = (ObjectMember)pChangedObjs[i];
            BaseChannel oBaseChannel = (BaseChannel)BaseChannel.findById(currObjectMember.getObjType(), currObjectMember.getObjId());
            if (!this.canSetRight(loginUser, oBaseChannel)) {
                throw new WCMException(1002, "\u7528\u6237[" + loginUser + "]\u6ca1\u6709\u6743\u9650\u8bbe\u7f6e[" + oBaseChannel + "]\u7684\u53ef\u8bbf\u95ee\u53ef\u64cd\u4f5c\uff01");
            }
            if (currObjectMember.isAddMode()) {
                currObjectMember.setMember(nMemberType, nMemberId);
            }
            currObjectMember.save(loginUser);
            if (!currObjectMember.isVisible() || oBaseChannel.isSite()) continue;
            BaseChannel oParent = oBaseChannel.getHost();
            while (oParent != null) {
                if (objectsOnPath.contains(oParent)) {
                    oParent = oParent.getHost();
                    continue;
                }
                objectsOnPath.add(oParent);
                oParent = oParent.getHost();
            }
        }
        this.addVisible(objectsOnPath, nMemberType, nMemberId);
    }

    private boolean canSetRight(User _oUser, BaseChannel _host) throws WCMException {
        if (_oUser.isSecurityAdmin()) {
            return true;
        }
        if (_host.getWCMType() == 103) {
            return AuthServer.hasRight(_oUser, (CMSObj)_host, 7);
        }
        return AuthServer.hasRight(_oUser, (CMSObj)_host, 55);
    }

    private void addVisible(List _oObjectList, int _nMemberType, int _nMemberId) throws WCMException {
        if (_oObjectList == null || _oObjectList.size() == 0) {
            return;
        }
        IObjectMemberMgr objectMemberMgr = (IObjectMemberMgr)DreamFactory.createObjectById("IObjectMemberMgr");
        CMSObj oOperator = (CMSObj)BaseObj.findById(_nMemberType, _nMemberId);
        User loginUser = this.getLoginUser();
        for (int i = 0; i < _oObjectList.size(); ++i) {
            int nObjId;
            BaseChannel oBaseChannel = (BaseChannel)_oObjectList.get(i);
            int nObjType = oBaseChannel.getWCMType();
            if (objectMemberMgr.isVisible(oOperator, nObjType, nObjId = oBaseChannel.getId())) continue;
            ObjectMember oObjectMember = objectMemberMgr.getObjectMember(_nMemberType, _nMemberId, nObjType, nObjId);
            if (oObjectMember != null) {
                oObjectMember.setVisible(true);
                oObjectMember.save(loginUser);
                continue;
            }
            oObjectMember = ObjectMember.createNewInstance();
            oObjectMember.setMemberType(_nMemberType);
            oObjectMember.setMemberId(_nMemberId);
            oObjectMember.setObjType(nObjType);
            oObjectMember.setObjId(nObjId);
            oObjectMember.setVisible(true);
            oObjectMember.insert(loginUser);
        }
    }

    public void saveMembersOfObject(MethodContext _methodContext) throws Exception {
        User loginUser = this.getLoginUser();
        int nObjType = _methodContext.getValue("ObjType", 0);
        int nObjId = _methodContext.getValue("ObjId", 0);
        this.findBaseChannel(nObjType, nObjId);
        String sImpartModes = _methodContext.getValue("ImpartModes");
        int[] pImpartMode = CMyString.splitToInt(sImpartModes, ",");
        ObjectMember srcObjectMember = ObjectMember.createNewInstance();
        List arObjectMemberList = WCMObjHelper.toWCMObjList(_methodContext.getValue("ObjectMembersXML"), srcObjectMember, loginUser);
        IRightHost rightHost = RightHostFactory.makeRightHostFrom(nObjType, nObjId);
        if (rightHost == null) {
            return;
        }
        rightHost.validateCanDoSetRight(loginUser);
        ObjectMemberSet objectMemberSet = new ObjectMemberSet(loginUser, rightHost, arObjectMemberList, pImpartMode);
        objectMemberSet.save();
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    private CMSObj findMember(int nMemberType, int nMemberId) throws WCMException {
        CMSObj member = null;
        switch (nMemberType) {
            case 204: {
                member = User.findById(nMemberId);
                break;
            }
            case 201: {
                member = Group.findById(nMemberId);
                break;
            }
            case 203: {
                member = Role.findById(nMemberId);
                break;
            }
            default: {
                throw new WCMException("\u4e0d\u652f\u6301\u60a8\u6307\u5b9a\u7684\u6210\u5458\u7c7b\u578b\uff01[MememberType=" + nMemberType + "]");
            }
        }
        if (member == null) {
            throw new WCMException("\u60a8\u6307\u5b9a\u7684\u6210\u5458\u7c7b\u578b\u4e0d\u5b58\u5728\uff01[MememberType=" + nMemberType + ", MememberId=" + nMemberId + "]");
        }
        return member;
    }

    private BaseChannel findBaseChannel(int _nObjType, int _nObjId) throws WCMException {
        BaseChannel baseChannel = null;
        User loginUser = this.getLoginUser();
        switch (_nObjType) {
            case 101: {
                baseChannel = Channel.findById(_nObjId);
                if (AuthServer.hasRight(loginUser, (CMSObj)baseChannel, 55)) break;
                throw new WCMException("\u60a8\u6ca1\u6709\u6743\u9650\u7ef4\u62a4\u5f53\u524d\u5bf9\u8c61\u7684\u6210\u5458\uff01\u5bf9\u8c61\u4fe1\u606f\uff1a[" + baseChannel + "]");
            }
            case 103: {
                baseChannel = WebSite.findById(_nObjId);
                if (AuthServer.hasRight(loginUser, (CMSObj)baseChannel, 7)) break;
                throw new WCMException("\u60a8\u6ca1\u6709\u6743\u9650\u7ef4\u62a4\u5f53\u524d\u5bf9\u8c61\u7684\u6210\u5458\uff01\u5bf9\u8c61\u4fe1\u606f\uff1a[" + baseChannel + "]");
            }
            default: {
                throw new WCMException("\u4e0d\u652f\u6301\u60a8\u6307\u5b9a\u7684\u5bf9\u8c61\u7c7b\u578b\uff01[ObjType=" + _nObjType + "]");
            }
        }
        if (baseChannel == null) {
            throw new WCMException("\u60a8\u6307\u5b9a\u7684\u5bf9\u8c61\u4e0d\u5b58\u5728\uff01[ObjType=" + _nObjType + ", ObjId=" + _nObjId + "]");
        }
        return baseChannel;
    }
}

