/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ajaxservice;

import com.trs.infra.I18NMessage;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class JSONHelper {
    private static Logger logger = Logger.getLogger(JSONHelper.class);

    public static String toJSON(Object _oValue, String _sTagName, int _nLevel) {
        if (_oValue instanceof HashMap) {
            return JSONHelper.toJSON((HashMap)_oValue, _nLevel);
        }
        if (_oValue instanceof String) {
            return JSONHelper.toJSON((String)_oValue, _sTagName, _nLevel);
        }
        if (_oValue instanceof String[]) {
            return JSONHelper.toJSON((String[])_oValue, _sTagName, _nLevel);
        }
        if (_oValue instanceof String[][]) {
            return JSONHelper.toJSON((String[][])_oValue, _nLevel);
        }
        return "";
    }

    public static String toSimpleJSON(Object _oValue, String _sTagName, int _nLevel) {
        if (_oValue instanceof HashMap) {
            return JSONHelper.toJSON((HashMap)_oValue, _nLevel);
        }
        if (_oValue instanceof String) {
            return JSONHelper.toJSON((String)_oValue, _sTagName, _nLevel);
        }
        if (_oValue instanceof String[]) {
            return JSONHelper.toSimpleJSON((String[])_oValue, _sTagName, _nLevel);
        }
        if (_oValue instanceof String[][]) {
            return JSONHelper.toJSON((String[][])_oValue, _nLevel);
        }
        return "";
    }

    public static String toJSON(Object[] _pObject, int _nLevel) {
        StringBuffer sbResult = new StringBuffer();
        int nTabIndex = _nLevel;
        String sRootTabContent = JSONHelper.makeTabStr(nTabIndex++);
        String sElementTabContent = JSONHelper.makeTabStr(nTabIndex++);
        sbResult.append("{/*Root Begin*/\n");
        sbResult.append(sRootTabContent);
        sbResult.append("ROOT:\n");
        sbResult.append(sRootTabContent);
        sbResult.append("{/*Element Begin*/\n");
        sbResult.append(sElementTabContent);
        sbResult.append("ELEMENT:");
        sbResult.append("\n");
        sbResult.append(sElementTabContent);
        sbResult.append("[/*Array Begin*/\n");
        boolean bFirst = true;
        int nCount = _pObject == null ? 0 : _pObject.length;
        for (int i = 0; i < nCount; ++i) {
            if (_pObject[i] == null) continue;
            if (bFirst) {
                bFirst = false;
            } else {
                sbResult.append(",");
                sbResult.append("\n");
            }
            sbResult.append(JSONHelper.toJSON(_pObject[i], null, nTabIndex));
        }
        sbResult.append("\n");
        sbResult.append(sElementTabContent);
        sbResult.append("]/*Array End*/");
        sbResult.append("\n");
        sbResult.append(sRootTabContent);
        sbResult.append("}/*Element END*/");
        sbResult.append("\n}/*Root End*/");
        return sbResult.toString();
    }

    public static String toSimpleJSON(Object[] _pObject, String _sKey, int _nLevel) {
        StringBuffer sbResult = new StringBuffer();
        int nChildLevel = _nLevel + 1;
        String sRootTabContent = JSONHelper.makeTabStr(_nLevel);
        if (_sKey != null && _sKey.length() > 0) {
            sbResult.append(sRootTabContent);
            sbResult.append(_sKey);
            sbResult.append(":\n");
        }
        sbResult.append(sRootTabContent);
        sbResult.append("[/*Array " + _nLevel + " Begin*/\n");
        boolean bFirst = true;
        for (int i = 0; i < _pObject.length; ++i) {
            if (_pObject[i] == null) continue;
            if (bFirst) {
                bFirst = false;
            } else {
                sbResult.append(",");
                sbResult.append("\n");
            }
            sbResult.append(JSONHelper.toSimpleJSON(_pObject[i], null, nChildLevel));
        }
        sbResult.append("\n");
        sbResult.append(sRootTabContent);
        sbResult.append("]/*Array " + _nLevel + " End*/");
        return sbResult.toString();
    }

    private static String makeTabStr(int _nTabCount) {
        StringBuffer sbResult = new StringBuffer(4 * _nTabCount);
        for (int i = 0; i < _nTabCount; ++i) {
            sbResult.append("   ");
        }
        return sbResult.toString();
    }

    public static String toJSON(String _sValue, String _sTagName, int _nLevel) {
        if (_sValue == null) {
            return "";
        }
        boolean bContainsTagName = _sTagName != null && _sTagName.length() > 0;
        int nTagLength = !bContainsTagName ? 0 : _nLevel + _sTagName.length() + 1;
        StringBuffer sbResult = new StringBuffer(_sValue.length() + 2 + nTagLength);
        if (bContainsTagName) {
            sbResult.append(JSONHelper.makeTabStr(_nLevel));
            sbResult.append(_sTagName);
            sbResult.append(':');
        }
        sbResult.append('\"');
        sbResult.append(_sValue.replaceAll("(\n|\r|\"|\\\\)", "\\\\$1"));
        sbResult.append('\"');
        return sbResult.toString();
    }

    public static String toSimpleJSON(HashMap _map, int _nLevel) {
        if (_map == null || _map.isEmpty()) {
            return "";
        }
        String sTabContent = JSONHelper.makeTabStr(_nLevel++);
        int nElementTabCount = _nLevel++;
        int nCount = _map.size() * 50 + 6;
        StringBuffer sbResult = new StringBuffer(nCount);
        Iterator itKeys = _map.keySet().iterator();
        sbResult.append(sTabContent);
        sbResult.append("{\n");
        boolean bFirst = true;
        while (itKeys.hasNext()) {
            String sKey = (String)itKeys.next();
            Object value = _map.get(sKey);
            if (bFirst) {
                bFirst = false;
            } else {
                sbResult.append(",\n");
            }
            sKey = sKey.toUpperCase();
            if (value instanceof String[]) {
                sbResult.append(JSONHelper.toSimpleJSON((String[])value, sKey, nElementTabCount));
                continue;
            }
            if (value instanceof HashMap) {
                sbResult.append(JSONHelper.toSimpleJSON((HashMap)value, nElementTabCount));
                continue;
            }
            if (value instanceof String[][]) {
                sbResult.append(JSONHelper.toJSON((String[][])value, nElementTabCount));
                continue;
            }
            if (value instanceof Object[]) {
                sbResult.append(JSONHelper.toSimpleJSON((Object[])value, sKey, nElementTabCount));
                continue;
            }
            sbResult.append(JSONHelper.toSimpleJSON(value.toString(), sKey, nElementTabCount));
        }
        sbResult.append('\n');
        sbResult.append(sTabContent);
        sbResult.append("}");
        return sbResult.toString();
    }

    public static String toJSON(HashMap _map, int _nLevel) {
        if (_map == null || _map.isEmpty()) {
            return "";
        }
        String sTabContent = JSONHelper.makeTabStr(_nLevel++);
        int nElementTabCount = _nLevel++;
        int nCount = _map.size() * 50 + 6;
        StringBuffer sbResult = new StringBuffer(nCount);
        Iterator itKeys = _map.keySet().iterator();
        sbResult.append(sTabContent);
        sbResult.append("{\n");
        boolean bFirst = true;
        while (itKeys.hasNext()) {
            String sKey = (String)itKeys.next();
            Object value = _map.get(sKey);
            if (bFirst) {
                bFirst = false;
            } else {
                sbResult.append(",\n");
            }
            sKey = sKey.toUpperCase();
            if (value instanceof String[]) {
                sbResult.append(JSONHelper.toSimpleJSON((String[])value, sKey, nElementTabCount));
                continue;
            }
            if (value instanceof HashMap) {
                sbResult.append(JSONHelper.toJSON((HashMap)value, _nLevel));
                continue;
            }
            if (value instanceof String[][]) {
                sbResult.append(JSONHelper.toJSON((String[][])value, _nLevel));
                continue;
            }
            if (value instanceof Object[]) {
                sbResult.append(JSONHelper.toJSON((Object[])value, _nLevel));
                continue;
            }
            sbResult.append(JSONHelper.toJSON(value.toString(), sKey, nElementTabCount));
        }
        sbResult.append('\n');
        sbResult.append(sTabContent);
        sbResult.append("}");
        return sbResult.toString();
    }

    public static String toJSON(String[] _pValues, String _sTagName, int _nLevel) {
        if (_pValues == null) {
            return "";
        }
        boolean bContainsTagName = _sTagName != null && _sTagName.length() > 0;
        int nTagLength = !bContainsTagName ? 0 : (_sTagName.length() + _nLevel + 3) * 2;
        String sRootTabContent = null;
        int nCount = _pValues.length * 50 + 6 + nTagLength;
        StringBuffer sbResult = new StringBuffer(nCount);
        if (bContainsTagName) {
            if (_nLevel == 0) {
                sbResult.append('{');
            }
            int n = ++_nLevel;
            sRootTabContent = JSONHelper.makeTabStr(n);
            int n2 = ++_nLevel;
            ++_nLevel;
            String sElementTabContent = JSONHelper.makeTabStr(n2);
            String sElementName = _sTagName.toUpperCase();
            String sRootName = _sTagName.toUpperCase();
            if (sRootName.lastIndexOf(0) == 83) {
                sElementName = sElementName.substring(0, sElementName.length() - 1);
            } else {
                sRootName = sRootName + 'S';
            }
            sbResult.append(sRootTabContent);
            sbResult.append(sRootName);
            sbResult.append(":\n");
            sbResult.append(sRootTabContent);
            sbResult.append("{\n");
            sbResult.append(sElementTabContent);
            sbResult.append(sElementName);
            sbResult.append(":");
        }
        sbResult.append(JSONHelper.toValueAsJSON(_pValues));
        if (bContainsTagName) {
            sbResult.append('\n');
            sbResult.append(sRootTabContent);
            sbResult.append('}');
            if (_nLevel == 0) {
                sbResult.append('}');
            }
        }
        return sbResult.toString();
    }

    private static String toValueAsJSON(String[] _pValues) {
        int nCount = _pValues.length * 50 + 6;
        StringBuffer sbResult = new StringBuffer(nCount);
        sbResult.append("[");
        boolean bFirst = true;
        for (int i = 0; i < _pValues.length; ++i) {
            if (_pValues[i] == null) continue;
            if (bFirst) {
                bFirst = false;
            } else {
                sbResult.append(",");
            }
            sbResult.append(JSONHelper.toJSON(_pValues[i], null, 0));
        }
        sbResult.append("]");
        int nMaxCount = sbResult.length();
        int nRealLength = sbResult.toString().length();
        if (nMaxCount > nRealLength) {
            logger.warn((Object)("sbResult.length[" + nMaxCount + "]>real.length[" + nRealLength + "]"));
        }
        return sbResult.toString();
    }

    public static String toSimpleJSON(String[] _pValues, String _sTagName, int _nLevel) {
        if (_pValues == null) {
            return "";
        }
        boolean bContainsTagName = _sTagName != null && _sTagName.length() > 0;
        int nTagLength = !bContainsTagName ? 0 : (_sTagName.length() + _nLevel + 3) * 2;
        String sRootTabContent = null;
        int nCount = _pValues.length * 50 + 6 + nTagLength;
        StringBuffer sbResult = new StringBuffer(nCount);
        sRootTabContent = JSONHelper.makeTabStr(_nLevel++);
        sbResult.append(sRootTabContent);
        if (bContainsTagName) {
            if (_nLevel == 0) {
                sbResult.append('{');
                ++_nLevel;
            }
            String sRootName = _sTagName.toUpperCase();
            sbResult.append(sRootName);
            sbResult.append(":");
        }
        sbResult.append(JSONHelper.toValueAsJSON(_pValues));
        return sbResult.toString();
    }

    public static String toJSON(String[][] _pValues, int _nLevel) {
        if (_pValues == null) {
            return "";
        }
        String sRootTabCount = JSONHelper.makeTabStr(_nLevel++);
        String sElementTabCount = JSONHelper.makeTabStr(_nLevel++);
        int nCount = _pValues.length * 50 + 6;
        StringBuffer sbResult = new StringBuffer(nCount);
        sbResult.append(sRootTabCount);
        sbResult.append("{\n");
        boolean bFirst = true;
        for (int i = 0; i < _pValues.length; ++i) {
            if (_pValues[i] == null || _pValues[i].length < 2) continue;
            if (bFirst) {
                bFirst = false;
            } else {
                sbResult.append(",\n");
            }
            sbResult.append(sElementTabCount);
            sbResult.append(_pValues[i][0]);
            sbResult.append(" : ");
            sbResult.append(JSONHelper.toJSON(_pValues[i][1], null, 0));
        }
        sbResult.append('\n');
        sbResult.append(sRootTabCount);
        sbResult.append("}");
        sbResult.append('\n');
        return sbResult.toString();
    }

    public static String toSimpleJSON2(HashMap _map, int _nLevel) {
        if (_map == null || _map.isEmpty()) {
            return "{}";
        }
        String sTabContent = JSONHelper.makeTabStr(_nLevel++);
        int nElementTabCount = _nLevel++;
        int nCount = _map.size() * 50 + 6;
        StringBuffer sbResult = new StringBuffer(nCount);
        Iterator itKeys = _map.keySet().iterator();
        sbResult.append(sTabContent);
        sbResult.append("{\n");
        boolean bFirst = true;
        while (itKeys.hasNext()) {
            String sKey = (String)itKeys.next();
            Object value = _map.get(sKey);
            if (bFirst) {
                bFirst = false;
            } else {
                sbResult.append(",\n");
            }
            sKey = sKey.toUpperCase();
            if (value instanceof String[]) {
                sbResult.append(JSONHelper.toSimpleJSON((String[])value, sKey, nElementTabCount));
                continue;
            }
            if (value instanceof HashMap) {
                sbResult.append(JSONHelper.toSimpleJSON2((HashMap)value, nElementTabCount));
                continue;
            }
            if (value instanceof Object[]) {
                sbResult.append(JSONHelper.toSimpleJSON2((Object[])value, sKey, nElementTabCount));
                continue;
            }
            sbResult.append(JSONHelper.toSimpleJSON2(value.toString(), sKey, nElementTabCount));
        }
        sbResult.append('\n');
        sbResult.append(sTabContent);
        sbResult.append("}");
        return sbResult.toString();
    }

    public static String toSimpleJSON2(Object[] _pObject, String _sKey, int _nLevel) {
        StringBuffer sbResult = new StringBuffer();
        int nChildLevel = _nLevel + 1;
        String sRootTabContent = JSONHelper.makeTabStr(_nLevel);
        if (_sKey != null && _sKey.length() > 0) {
            sbResult.append(sRootTabContent);
            sbResult.append(_sKey);
            sbResult.append(":\n");
        }
        sbResult.append(sRootTabContent);
        sbResult.append("[\n");
        boolean bFirst = true;
        for (int i = 0; i < _pObject.length; ++i) {
            if (_pObject[i] == null) continue;
            if (bFirst) {
                bFirst = false;
            } else {
                sbResult.append(",");
                sbResult.append("\n");
            }
            sbResult.append(JSONHelper.toSimpleJSON2(_pObject[i], null, nChildLevel));
        }
        sbResult.append("\n");
        sbResult.append(sRootTabContent);
        sbResult.append("]");
        return sbResult.toString();
    }

    public static String toSimpleJSON2(Object _oValue, String _sTagName, int _nLevel) {
        if (_oValue instanceof HashMap) {
            return JSONHelper.toJSON((HashMap)_oValue, _nLevel);
        }
        if (_oValue instanceof String) {
            return JSONHelper.toJSON((String)_oValue, _sTagName, _nLevel);
        }
        if (_oValue instanceof String[]) {
            return JSONHelper.toSimpleJSON((String[])_oValue, _sTagName, _nLevel);
        }
        if (_oValue instanceof Object[]) {
            return JSONHelper.toSimpleJSON2((Object[])_oValue, _sTagName, _nLevel);
        }
        return "";
    }

    public static void main(String[] args) {
        String[][] pValues = new String[][]{{"Prop1", I18NMessage.get(JSONHelper.class, "JSONHelper.label1", "\u4e2d\u6587")}, {"Pro2", I18NMessage.get(JSONHelper.class, "JSONHelper.label2", "\u4e2d\u65872")}};
        System.out.println(JSONHelper.toJSON(pValues, 0));
        System.out.println(JSONHelper.toJSON(pValues, 1));
        HashMap<String, Object> hmValues = new HashMap<String, Object>(3);
        hmValues.put("Prop1", I18NMessage.get(JSONHelper.class, "JSONHelper.label3", "\u6d4b\u8bd5\n\rfdfdsfdsfsdafdsf\")dfadfdfads\"dfdsfa\ndfdasfdsfdsf\r\ndfasfsdfds\"fdaf"));
        hmValues.put("Prop3", I18NMessage.get(JSONHelper.class, "JSONHelper.label4", "\u6d4b\u8bd52"));
        hmValues.put("ArrayProp4", new String[]{"Prop1", I18NMessage.get(JSONHelper.class, "JSONHelper.label5", "\u6d4b\u8bd5")});
        System.out.println(JSONHelper.toJSON(hmValues, 1));
        String[] pValue = new String[]{"Prop1", I18NMessage.get(JSONHelper.class, "JSONHelper.label5", "\u6d4b\u8bd5")};
        System.out.println(JSONHelper.toJSON(pValue, null, 0));
        System.out.println(JSONHelper.toJSON(pValue, "test", 1));
        String[][] p2Value = new String[][]{{"Prop1", I18NMessage.get(JSONHelper.class, "JSONHelper.label5", "\u6d4b\u8bd5")}, {I18NMessage.get(JSONHelper.class, "JSONHelper.label6", "\u5929\u554a"), I18NMessage.get(JSONHelper.class, "JSONHelper.label7", "\u6211\u662f\u4e8c\u7ef4\u7684")}};
        hmValues = new HashMap(1);
        hmValues.put("URLS", p2Value);
        System.out.println(JSONHelper.toSimpleJSON(hmValues, 0));
        System.out.println(JSONHelper.toSimpleJSON2(hmValues, 0));
        String[][][] p3Value = new String[][][]{{{"Prop1", "HAHAHA"}, {I18NMessage.get(JSONHelper.class, "JSONHelper.label5", "\u6d4b\u8bd5")}}, {{I18NMessage.get(JSONHelper.class, "JSONHelper.label6", "\u5929\u554a"), "009"}, {I18NMessage.get(JSONHelper.class, "JSONHelper.label7", "\u6211\u662f\u4e8c\u7ef4\u7684"), "good"}}};
        hmValues = new HashMap(1);
        hmValues.put("URLS", p3Value);
        System.out.println(JSONHelper.toSimpleJSON(hmValues, 0));
        System.out.println(JSONHelper.toSimpleJSON2(hmValues, 0));
    }
}

