/*
 * Decompiled with CFR 0.152.
 */
package com.trs.idm.util;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.text.AttributedString;
import java.util.Random;
import javax.imageio.ImageIO;

public class VerifyCodeUtil {
    private static Random imgGenerator = new Random();
    private static char[] captchars = new char[]{'a', 'b', 'c', 'd', 'e', '2', '3', '4', '5', '6', '7', '8', 'g', 'f', 'y', 'n', 'm', 'n', 'p', 'w', 'x'};

    private static char getSingalVerifyCode() {
        int car = captchars.length - 1;
        return captchars[imgGenerator.nextInt(car) + 1];
    }

    public static String getVerifyCode(int length) {
        String verifyCode = "";
        int i = 0;
        while (i < length) {
            verifyCode = String.valueOf(verifyCode) + VerifyCodeUtil.getSingalVerifyCode();
            ++i;
        }
        return verifyCode;
    }

    public static BufferedImage drawChar(String verifyCode, Font font) {
        BufferedImage bi = new BufferedImage(320, 100, 13);
        Graphics2D graphics = bi.createGraphics();
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, bi.getWidth(), bi.getHeight());
        graphics.setColor(Color.black);
        int i = 0;
        while (i < 600) {
            graphics.setColor(VerifyCodeUtil.getRandColor());
            graphics.drawRect(imgGenerator.nextInt(320), imgGenerator.nextInt(100), 1, 1);
            ++i;
        }
        AffineTransform fontAT = new AffineTransform();
        fontAT.shear(3.0, -2.0);
        fontAT.rotate(Math.toRadians(imgGenerator.nextInt(10)));
        fontAT.scale(0.8, 2.0);
        AttributedString as = new AttributedString(verifyCode);
        int i2 = 0;
        while (i2 < verifyCode.length()) {
            Font actualFont = font == null ? VerifyCodeUtil.getRandomFontFromSelectedOnLinux() : font;
            as.addAttribute(TextAttribute.FONT, actualFont, i2, i2 + 1);
            as.addAttribute(TextAttribute.FOREGROUND, VerifyCodeUtil.getRandColor(), i2, i2 + 1);
            as.addAttribute(TextAttribute.TRANSFORM, fontAT, i2, i2 + 1);
            as.addAttribute(TextAttribute.WIDTH, new Integer(imgGenerator.nextInt(1) * 10 + 20), i2, i2 + 1);
            as.addAttribute(TextAttribute.STRIKETHROUGH, new Boolean(imgGenerator.nextInt(2) == 1), i2, i2 + 1);
            as.addAttribute(TextAttribute.SUPERSCRIPT, imgGenerator.nextInt(2) == 1 ? TextAttribute.SUPERSCRIPT_SUB : TextAttribute.SUPERSCRIPT_SUPER, i2, i2 + 1);
            ++i2;
        }
        graphics.drawString(as.getIterator(), 10 + imgGenerator.nextInt(1) * 10, 70);
        int w = bi.getWidth();
        int h = bi.getHeight();
        VerifyCodeUtil.shear(graphics, w, h, Color.white);
        return bi;
    }

    public static BufferedImage drawChar(String verifyCode) {
        return VerifyCodeUtil.drawChar(verifyCode, null);
    }

    public static Font getRandomFont() {
        Random random = new Random();
        Font[] font = VerifyCodeUtil.getAllFonts();
        Font result = font[random.nextInt(font.length)];
        return result.deriveFont(0, 45.0f);
    }

    public static Font getRandomFontFromSelectedOnLinux() {
        Random random = new Random();
        Font[] font = VerifyCodeUtil.getAllSelectedFontsOnLinux();
        Font result = font[random.nextInt(font.length)];
        return result;
    }

    public static Color getRandColor() {
        Random random = new Random();
        Color[] color = new Color[10];
        color[0] = new Color(32, 158, 25);
        color[1] = new Color(218, 42, 19);
        color[2] = new Color(31, 75, 208);
        return color[random.nextInt(3)];
    }

    private static void shear(Graphics g, int w1, int h1, Color color) {
        VerifyCodeUtil.shearX(g, w1, h1, color);
        VerifyCodeUtil.shearY(g, w1, h1, color);
    }

    private static void shearX(Graphics g, int w1, int h1, Color color) {
        int period = imgGenerator.nextInt(2);
        boolean borderGap = true;
        int frames = 10;
        int phase = imgGenerator.nextInt(2);
        int i = 0;
        while (i < h1) {
            double d = (double)(period >> 1) * Math.sin((double)i / (double)period + Math.PI * 2 * (double)phase / (double)frames);
            g.copyArea(0, i, w1, 1, (int)d, 0);
            if (borderGap) {
                g.setColor(color);
                g.drawLine((int)d, i, 0, i);
                g.drawLine((int)d + w1, i, w1, i);
            }
            ++i;
        }
    }

    private static void shearY(Graphics g, int w1, int h1, Color color) {
        int period = imgGenerator.nextInt(40) + 10;
        boolean borderGap = true;
        int frames = 20;
        int phase = 10;
        int i = 0;
        while (i < w1) {
            double d = (double)(period >> 1) * Math.sin((double)i / (double)period + Math.PI * 2 * (double)phase / (double)frames);
            g.copyArea(i, 0, 1, h1, 0, (int)d);
            if (borderGap) {
                g.setColor(color);
                g.drawLine(i, (int)d, i, 0);
                g.drawLine(i, (int)d + h1, i, h1);
            }
            ++i;
        }
    }

    public static Font[] getAllFonts() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        return ge.getAllFonts();
    }

    public static Font[] getAllSelectedFontsOnLinux() {
        int fontStyle = 0;
        int fontSize = 45;
        Font[] font = new Font[]{new Font("AR PL ShanHeiSun Uni", fontStyle, fontSize), new Font("AR PL ZenKai Uni", fontStyle, fontSize), new Font("Bitstream Charter Bold", fontStyle, fontSize), new Font("Bitstream Charter Italic", fontStyle, fontSize), new Font("Bitstream Vera Sans", fontStyle, fontSize), new Font("Bitstream Vera Sans Bold1", fontStyle, fontSize), new Font("Bitstream Vera Sans Bold Oblique", fontStyle, fontSize), new Font("Bitstream Vera Sans Mono1", fontStyle, fontSize), new Font("Bitstream Vera Sans Mono Bold", fontStyle, fontSize), new Font("Bitstream Vera Sans Mono Bold Oblique", fontStyle, fontSize), new Font("Bitstream Vera Sans Mono Oblique", fontStyle, fontSize), new Font("Bitstream Vera Serif Bold", fontStyle, fontSize), new Font("Century Schoolbook L Bold", fontStyle, fontSize), new Font("Century Schoolbook L Italic", fontStyle, fontSize), new Font("Century Schoolbook L Bold Italic", fontStyle, fontSize), new Font("Courier 10 Pitch Bold", fontStyle, fontSize), new Font("Courier Italic", fontStyle, fontSize), new Font("Courier Bold Italic", fontStyle, fontSize), new Font("DejaVu LGC Sans ExtraLight", fontStyle, fontSize), new Font("DejaVu LGC Sans Mono", fontStyle, fontSize), new Font("DejaVu LGC Serif Bold", fontStyle, fontSize), new Font("DejaVu LGC Serif Condensed Bold Oblique", fontStyle, fontSize), new Font("DialogInput.italic", fontStyle, fontSize), new Font("Luxi Serif Bold", fontStyle, fontSize), new Font("Monospaced.bold", fontStyle, fontSize), new Font("Nimbus Mono L Regular", fontStyle, fontSize), new Font("Nimbus Roman No9 L Bold", fontStyle, fontSize), new Font("Nimbus Sans L Bold Italic", fontStyle, fontSize), new Font("URW Bookman L Demi Bold Italic", fontStyle, fontSize), new Font("URW Chancery L Medium Italic", fontStyle, fontSize), new Font("URW Palladio L Bold Italic", 0, fontSize)};
        return font;
    }

    public static void main(String[] args) {
        File fRandom = new File("server-work/java2d/picture.jpg");
        try {
            ImageIO.write((RenderedImage)VerifyCodeUtil.drawChar("small\u5c0f\u5c0f\u9e1f"), "jpg", fRandom);
        }
        catch (IOException e) {
            System.err.println("err: " + e);
            e.printStackTrace();
        }
        Font[] fonts = VerifyCodeUtil.getAllFonts();
        int i = 0;
        while (i < fonts.length) {
            System.out.println(fonts[i].getFontName());
            File f = new File("server-work/java2d/picture-" + fonts[i].getFontName() + ".jpg");
            try {
                ImageIO.write((RenderedImage)VerifyCodeUtil.drawChar("small\u5c0f\u5c0f\u9e1f", fonts[i].deriveFont(0, 45.0f)), "jpg", f);
            }
            catch (IOException e) {
                System.err.println("err: " + fonts[i].getFontName());
                e.printStackTrace();
            }
            ++i;
        }
    }
}

