/*
 * Decompiled with CFR 0.152.
 */
package com.trs.net.http.rfc1867.impl;

import com.trs.net.URLCoder;
import com.trs.net.http.rfc1867.FormPart;
import com.trs.net.http.rfc1867.FormPartFactory;
import com.trs.net.http.rfc1867.ProgressMonitor;
import com.trs.net.http.rfc1867.RFC1867Exception;
import com.trs.net.http.rfc1867.impl.FileFormPart;
import com.trs.net.http.rfc1867.impl.RFC1867InputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;

public class RFC1867Processer {
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String CONTENT_DISPOSITION = "Content-Disposition";
    public static final String FORM_DATA = "form-data";
    public static final String ATTACHMENT = "attachment";
    public static final String MULTIPART = "multipart/";
    public static final String MULTIPART_FORM_DATA = "multipart/form-data";
    public static final String MULTIPART_MIXED = "multipart/mixed";
    private FormPartFactory m_oFormPartFactory;

    public RFC1867Processer(FormPartFactory formPartFactory) {
        this.m_oFormPartFactory = formPartFactory;
    }

    static final void addPart(FormPart part, Map map) {
        FileFormPart newPart = (FileFormPart)part;
        FileFormPart oldPart = map.put(newPart.getName(), newPart);
        if (oldPart != null) {
            newPart.m_iBrotherCount = oldPart.m_iBrotherCount + 1;
            newPart.m_rfNextBrother = oldPart;
        }
    }

    private String getFileName(String strHeader) {
        int iIndex2;
        int iIndex1;
        if (strHeader != null && (strHeader.startsWith(FORM_DATA) || strHeader.startsWith(ATTACHMENT)) && (iIndex1 = strHeader.indexOf("filename=\"")) > 0 && (iIndex2 = strHeader.indexOf(34, iIndex1 += "filename=\"".length())) > iIndex1) {
            return strHeader.substring(iIndex1, iIndex2).trim();
        }
        return null;
    }

    private String getFileName(Hashtable headers) {
        return this.getFileName(this.getHeader(headers, CONTENT_DISPOSITION));
    }

    private String getHeader(Hashtable headers, String strKey) {
        return (String)headers.get(strKey);
    }

    private String getPartName(String strHeader) {
        int iIndex2;
        int iIndex1;
        if (strHeader != null && strHeader.startsWith(FORM_DATA) && (iIndex1 = strHeader.indexOf("name=\"")) > 0 && (iIndex2 = strHeader.indexOf(34, iIndex1 += "name=\"".length())) > iIndex1) {
            return strHeader.substring(iIndex1, iIndex2).trim();
        }
        return null;
    }

    private String getPartName(Hashtable headers) {
        return this.getPartName(this.getHeader(headers, CONTENT_DISPOSITION));
    }

    private final void fillPartData(FormPart part, RFC1867InputStream ris) {
        IOException _ex_;
        block15: {
            _ex_ = null;
            OutputStream fpos = null;
            try {
                try {
                    fpos = part.getOutputStream();
                    ris.readBody(fpos);
                }
                catch (IOException ioe) {
                    _ex_ = ioe;
                    if (fpos != null) {
                        try {
                            fpos.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (fpos != null) {
                    try {
                        fpos.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            if (fpos != null) {
                try {
                    fpos.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        if (_ex_ != null) {
            throw new RFC1867Exception(_ex_);
        }
    }

    public void process(HttpServletRequest req, Map map, ProgressMonitor progress) {
        if (req == null) {
            throw new NullPointerException("Request is null");
        }
        if (map == null) {
            throw new NullPointerException("Parameters container is null");
        }
        String strContentType = req.getHeader(CONTENT_TYPE);
        if (strContentType == null) {
            throw new NullPointerException("ContentType is null");
        }
        if (!strContentType.startsWith(MULTIPART_FORM_DATA) && !strContentType.startsWith(MULTIPART_MIXED)) {
            throw new RFC1867Exception("\"" + strContentType + "\" not " + MULTIPART_FORM_DATA + "or" + MULTIPART_MIXED);
        }
        int iContentLength = req.getContentLength();
        if (iContentLength == -1) {
            throw new RFC1867Exception("unknown size");
        }
        int iIndex = strContentType.indexOf("boundary=");
        if (iIndex < 0) {
            throw new RFC1867Exception("missing boundary");
        }
        byte[] boundary = strContentType.substring(iIndex + "boundary=".length() - 2).getBytes();
        boundary[0] = 45;
        boundary[1] = 45;
        try {
            if (progress != null) {
                progress.init(iContentLength);
            }
            String enc = req.getCharacterEncoding();
            this.parseQueryString(req.getQueryString(), enc, map);
            this.parseRequestForm(new RFC1867InputStream((InputStream)req.getInputStream(), boundary, enc, progress), map);
        }
        catch (IOException ioe) {
            throw new RFC1867Exception(ioe);
        }
    }

    void parseQueryString(String sQueryString, String enc, Map map) throws IOException {
        if (sQueryString != null) {
            StringTokenizer tok = new StringTokenizer(sQueryString, "&", false);
            while (tok.hasMoreTokens()) {
                String sPair = tok.nextToken();
                int iPos = sPair.indexOf(61);
                if (iPos == -1) continue;
                String sKey = URLCoder.decode(sPair.substring(0, iPos++), enc);
                String sVal = URLCoder.decode(sPair.substring(iPos, sPair.length()), enc);
                FormPart part = this.m_oFormPartFactory.createFormPart(sKey, sVal);
                RFC1867Processer.addPart(part, map);
            }
        }
    }

    void parseRequestForm(RFC1867InputStream ris, Map map) {
        String sPartName = null;
        while (ris.hasMorePart()) {
            int iIndex;
            Hashtable headers = ris.readHeaders();
            if (!ris.inMixedPart()) {
                sPartName = this.getPartName(headers);
            }
            if (sPartName == null) continue;
            String sFilePath = this.getFileName(headers);
            String sMimeType = this.getHeader(headers, CONTENT_TYPE);
            if (!ris.inMixedPart() && sMimeType != null && sMimeType.startsWith(MULTIPART_MIXED) && (iIndex = sMimeType.indexOf("boundary=")) > 0) {
                ris.pushBoundary(sMimeType.substring(iIndex + "boundary=".length()).getBytes());
                continue;
            }
            if (sFilePath == null && ris.inMixedPart()) continue;
            FormPart part = this.m_oFormPartFactory.createFormPart(sPartName, sFilePath, sMimeType);
            this.fillPartData(part, ris);
            RFC1867Processer.addPart(part, map);
        }
    }
}

