/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.discover.impl;

import com.trs.infra.discover.impl.Node;
import com.trs.infra.discover.impl.Utils;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class NodeDirectory
extends Node {
    private List m_oChildren;

    public NodeDirectory(String name) {
        super(name);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString());
        sb.append(",children=").append(this.m_oChildren);
        return sb.toString();
    }

    public void cleanup() {
        super.cleanup();
        if (this.m_oChildren != null) {
            Iterator itr = this.m_oChildren.iterator();
            while (itr.hasNext()) {
                Node c = (Node)itr.next();
                if (c == null) continue;
                c.cleanup();
            }
            this.m_oChildren.clear();
            this.m_oChildren = null;
        }
    }

    protected void trimMemory() {
        super.trimMemory();
        if (this.m_oChildren != null) {
            Iterator itr = this.m_oChildren.iterator();
            while (itr.hasNext()) {
                Node c = (Node)itr.next();
                if (c == null) continue;
                c.trimMemory();
            }
            Utils.trimArrayList(this.m_oChildren);
        }
    }

    public void tree(PrintWriter pw, String prefix) {
        List list = this.m_oChildren;
        if (list == null) {
            return;
        }
        int limit = list.size() - 1;
        int i = 0;
        while (i <= limit) {
            String p = null;
            Node n = (Node)list.get(i);
            if (i == limit) {
                pw.print(prefix);
                pw.print("\u2514\u2500");
                p = String.valueOf(prefix) + "    ";
            } else {
                pw.print(prefix);
                pw.print("\u251c\u2500");
                p = String.valueOf(prefix) + "\u2502  ";
            }
            pw.println(n.getName());
            if (n.isDirectory()) {
                ((NodeDirectory)n).tree(pw, p);
            }
            ++i;
        }
    }

    public boolean hasChild() {
        return this.m_oChildren != null && this.m_oChildren.size() > 0;
    }

    public void addChild(Node node) {
        if (this.m_oChildren == null) {
            this.m_oChildren = new ArrayList();
        }
        this.m_oChildren.add(node);
        node.setParent(this);
    }

    public List children() {
        return this.m_oChildren;
    }

    public boolean isDirectory() {
        return true;
    }

    protected NodeDirectory getDirectoryNode(String name) {
        if (this.m_oChildren != null) {
            Iterator itr = this.m_oChildren.iterator();
            while (itr.hasNext()) {
                Node node = (Node)itr.next();
                if (!node.getName().equals(name)) continue;
                return (NodeDirectory)node;
            }
        }
        NodeDirectory nd = new NodeDirectory(name);
        this.addChild(nd);
        return nd;
    }
}

