/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.transport.http;

import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.StringTokenizer;
import java.util.Vector;

public class Cookie {
    private static final int DEFAULT_HTTP_PORT = 80;
    private long createdMillis;
    private URL url;
    private String defaultDomain;
    private int defaultPort;
    private String defaultPath;
    private String name;
    private String value;
    private String comment = null;
    private String domain = null;
    private long maxAge = Long.MAX_VALUE;
    private String path = null;
    private boolean secure = false;
    private String version = null;
    private String commentURL = null;
    private boolean discard = false;
    private int[] port = null;
    private long expires = Long.MAX_VALUE;
    private static SimpleDateFormat dateParser = new SimpleDateFormat("EEE, dd-MMM-yyyy HH:mm:ss z");

    public Cookie(URL url, String cookieString) {
        String attributes;
        String nameValue;
        cookieString = Cookie.removeLeadingSpaces(cookieString);
        int index = cookieString.indexOf(59);
        if (index != -1) {
            nameValue = cookieString.substring(0, index);
            attributes = cookieString.length() > index ? cookieString.substring(index + 1) : "";
        } else {
            nameValue = cookieString;
            attributes = "";
        }
        index = nameValue.indexOf(61);
        if (index != -1) {
            this.name = nameValue.substring(0, index);
            this.value = nameValue.length() > index ? Cookie.removeEnclosingQuotes(nameValue.substring(index + 1)) : "";
        } else {
            this.name = nameValue;
            this.value = "";
        }
        StringTokenizer st = new StringTokenizer(attributes, ";");
        while (st.hasMoreTokens()) {
            String attrValue;
            String attrName;
            nameValue = Cookie.removeLeadingSpaces(st.nextToken());
            index = nameValue.indexOf(61);
            if (index != -1) {
                attrName = nameValue.substring(0, index);
                attrValue = nameValue.length() > index ? Cookie.removeEnclosingQuotes(nameValue.substring(index + 1)) : "";
            } else {
                attrName = nameValue;
                attrValue = "";
            }
            if (attrName.equalsIgnoreCase("Comment")) {
                if (this.comment != null) continue;
                this.comment = attrValue;
                continue;
            }
            if (attrName.equalsIgnoreCase("Domain")) {
                if (this.domain != null) continue;
                this.domain = attrValue;
                continue;
            }
            if (attrName.equalsIgnoreCase("Max-Age")) {
                if (this.maxAge != Long.MAX_VALUE) continue;
                try {
                    this.maxAge = Long.parseLong(attrValue);
                    this.expires = System.currentTimeMillis() + this.maxAge * 1000L;
                }
                catch (NumberFormatException e) {}
                continue;
            }
            if (attrName.equalsIgnoreCase("Path")) {
                if (this.path != null) continue;
                this.path = attrValue;
                continue;
            }
            if (attrName.equalsIgnoreCase("Secure")) {
                this.secure = true;
                continue;
            }
            if (attrName.equalsIgnoreCase("Version")) {
                if (this.version != null) continue;
                this.version = attrValue;
                continue;
            }
            if (attrName.equalsIgnoreCase("CommentURL")) {
                if (this.commentURL != null) continue;
                this.commentURL = attrValue;
                continue;
            }
            if (attrName.equalsIgnoreCase("Discard")) {
                this.version = attrValue;
                continue;
            }
            if (attrName.equalsIgnoreCase("Port")) {
                if (this.port != null) continue;
                if (attrValue.length() == 0) {
                    this.port = new int[0];
                    continue;
                }
                try {
                    StringTokenizer st2 = new StringTokenizer(attrValue, ",");
                    int[] ports = new int[st2.countTokens()];
                    int portNum = 0;
                    while (st2.hasMoreTokens()) {
                        ports[portNum++] = Integer.parseInt(st2.nextToken());
                    }
                    this.port = ports;
                }
                catch (NumberFormatException e) {}
                continue;
            }
            if (!attrName.equalsIgnoreCase("Expires") || this.expires != Long.MAX_VALUE) continue;
            try {
                this.expires = dateParser.parse(attrValue).getTime();
            }
            catch (ParseException e) {}
        }
        this.setURL(url);
        this.createdMillis = System.currentTimeMillis();
    }

    public static String buildCookieValue(URL url, Cookie[] cookies) {
        StringBuffer buf = new StringBuffer(512);
        for (int i = 0; i < cookies.length; ++i) {
            Cookie cookie = cookies[i];
            if (cookie.getExpired() || !cookie.sendToURL(url)) continue;
            if (buf.length() > 0) {
                buf.append(';');
            }
            buf.append(cookie.toString());
        }
        return buf.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Cookie)) {
            return false;
        }
        Cookie cookie = (Cookie)obj;
        return this.name.equals(cookie.name) && this.value.equals(cookie.value) && Cookie.sameAttribute(this.domain, this.defaultDomain, cookie.domain, cookie.defaultDomain) && Cookie.sameAttribute(this.path, this.defaultPath, cookie.path, cookie.defaultPath) && Cookie.samePort(this.port, this.defaultPort, cookie.port, cookie.defaultPort);
    }

    public boolean getExpired() {
        return System.currentTimeMillis() > this.expires;
    }

    public static Cookie[] parseCookies(URL url, String setCookieValue) {
        int cookieOffset = 0;
        boolean inQuote = false;
        Vector<Cookie> cookieV = new Vector<Cookie>();
        for (int i = 0; i < setCookieValue.length(); ++i) {
            char c = setCookieValue.charAt(i);
            if (c == '\"') {
                inQuote = !inQuote;
                continue;
            }
            if (c != ',' || inQuote || i >= 11 && setCookieValue.substring(i - 11, i - 3).equalsIgnoreCase("expires=")) continue;
            cookieV.addElement(new Cookie(url, setCookieValue.substring(cookieOffset, i)));
            cookieOffset = i + 1;
        }
        if (cookieOffset < setCookieValue.length()) {
            cookieV.addElement(new Cookie(url, setCookieValue.substring(cookieOffset)));
        }
        Cookie[] cookies = new Cookie[cookieV.size()];
        for (int i = 0; i < cookieV.size(); ++i) {
            cookies[i] = (Cookie)cookieV.elementAt(i);
        }
        return cookies;
    }

    private static String removeEnclosingQuotes(String s) {
        return s.startsWith("\"") && s.endsWith("\"") ? s.substring(1, s.length() - 1) : s;
    }

    private static String removeLeadingSpaces(String s) {
        int i;
        for (i = 0; i < s.length() && s.charAt(i) == ' '; ++i) {
        }
        return i == 0 ? s : s.substring(i);
    }

    private static boolean sameAttribute(String a1, String da1, String a2, String da2) {
        if (a1 != null && a2 != null) {
            return a1.equals(a2);
        }
        if (a1 == null && a2 == null) {
            return da1.equals(da2);
        }
        return false;
    }

    public static boolean sameCookie(Cookie cookie1, Cookie cookie2) {
        return cookie1.name.equals(cookie2.name) && Cookie.sameAttribute(cookie1.domain, cookie1.defaultDomain, cookie2.domain, cookie2.defaultDomain) && Cookie.sameAttribute(cookie1.path, cookie1.defaultPath, cookie2.path, cookie2.defaultPath) && Cookie.samePort(cookie1.port, cookie1.defaultPort, cookie2.port, cookie2.defaultPort);
    }

    private static boolean samePort(int[] port1, int dport1, int[] port2, int dport2) {
        if (port1 != null && port2 != null) {
            if (port1.length != port2.length) {
                return false;
            }
            if (port1.length == 0) {
                return dport1 == dport2;
            }
            for (int i = 0; i < port1.length; ++i) {
                int j;
                for (j = 0; j < port2.length && port1[i] != port2[j]; ++j) {
                }
                if (j < port2.length) continue;
                return false;
            }
            return true;
        }
        return port1 == null && port2 == null;
    }

    public boolean sendToURL(URL url) {
        if (this.domain != null ? url.getHost().indexOf(this.domain) == -1 : url.getHost().indexOf(this.defaultDomain) == -1) {
            return false;
        }
        if (this.path != null ? !url.getFile().startsWith(this.path) : !url.getFile().startsWith(this.defaultPath)) {
            return false;
        }
        if (this.port != null) {
            int urlPort = url.getPort();
            if (urlPort == -1) {
                urlPort = 80;
            }
            if (this.port.length == 0) {
                if (this.defaultPort != urlPort) {
                    return false;
                }
            } else {
                int i;
                for (i = 0; i < this.port.length && this.port[i] != urlPort; ++i) {
                }
                if (i >= this.port.length) {
                    return false;
                }
            }
        }
        return true;
    }

    private void setURL(URL url) {
        this.url = url;
        this.defaultDomain = url.getHost();
        this.defaultPort = url.getPort();
        if (this.defaultPort == -1) {
            this.defaultPort = 80;
        }
        this.defaultPath = url.getFile();
        int index = this.defaultPath.lastIndexOf(47);
        if (index != -1) {
            this.defaultPath = this.defaultPath.substring(0, index);
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(512);
        if (this.version != null) {
            buf.append(";$version=");
            buf.append(this.version);
        }
        buf.append(this.name);
        buf.append('=');
        buf.append(this.value);
        if (this.domain != null) {
            buf.append(";$domain=");
            buf.append(this.domain);
        }
        if (this.path != null) {
            buf.append(";$path=");
            buf.append(this.path);
        }
        if (this.port != null) {
            buf.append(";$port");
            if (this.port.length > 0) {
                buf.append("=\"");
                for (int i = 0; i < this.port.length; ++i) {
                    if (i > 0) {
                        buf.append(',');
                    }
                    buf.append(this.port[i]);
                }
                buf.append('\"');
            }
        }
        return buf.toString();
    }

    public static Cookie[] updateCookies(Cookie[] cookies1, Cookie[] cookies2) {
        int j;
        int i;
        Vector<Cookie> newCookies = new Vector<Cookie>();
        for (i = 0; i < cookies2.length; ++i) {
            Cookie cookie2 = cookies2[i];
            Cookie cookie1 = null;
            for (j = 0; j < cookies1.length && !Cookie.sameCookie(cookie1 = cookies1[j], cookie2); ++j) {
            }
            if (j < cookies1.length) {
                cookie1.value = cookie2.value;
                cookie1.comment = cookie2.comment;
                cookie1.commentURL = cookie2.commentURL;
                cookie1.maxAge = cookie2.maxAge;
                cookie1.secure = cookie2.secure;
                cookie1.version = cookie2.version;
                cookie1.expires = cookie2.expires;
                continue;
            }
            newCookies.addElement(cookie2);
        }
        if (newCookies.size() == 0) {
            return cookies1;
        }
        Cookie[] c = new Cookie[cookies1.length + newCookies.size()];
        for (i = 0; i < cookies1.length; ++i) {
            c[i] = cookies1[i];
        }
        for (j = 0; j < newCookies.size(); ++j) {
            c[i + j] = (Cookie)newCookies.elementAt(j);
        }
        return c;
    }
}

