/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.server;

import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.ServletContext;
import org.apache.soap.Constants;
import org.apache.soap.SOAPException;
import org.apache.soap.server.DeploymentDescriptor;
import org.apache.soap.util.ConfigManager;

public abstract class BaseConfigManager
implements ConfigManager {
    protected Hashtable dds = new Hashtable();
    protected String[] serviceNamesCache;
    protected ServletContext context = null;

    public void setContext(ServletContext context) {
        this.context = context;
    }

    public void init() throws SOAPException {
        this.loadRegistry();
    }

    public void deploy(DeploymentDescriptor dd) throws SOAPException {
        String id = dd.getID();
        this.dds.put(id, dd);
        this.saveRegistry();
        this.serviceNamesCache = null;
    }

    public DeploymentDescriptor undeploy(String id) throws SOAPException {
        DeploymentDescriptor dd = (DeploymentDescriptor)this.dds.remove(id);
        if (dd == null) {
            throw new SOAPException(Constants.FAULT_CODE_SERVER, "Service '" + id + "' unknown");
        }
        this.saveRegistry();
        this.serviceNamesCache = null;
        return dd;
    }

    public String[] list() throws SOAPException {
        if (this.serviceNamesCache != null) {
            return this.serviceNamesCache;
        }
        Enumeration e = this.dds.keys();
        int count = this.dds.size();
        this.serviceNamesCache = new String[count];
        for (int i = 0; i < count; ++i) {
            this.serviceNamesCache[i] = (String)e.nextElement();
        }
        return this.serviceNamesCache;
    }

    public DeploymentDescriptor query(String id) throws SOAPException {
        DeploymentDescriptor dd = (DeploymentDescriptor)this.dds.get(id);
        return dd;
    }

    public abstract void loadRegistry() throws SOAPException;

    public abstract void saveRegistry() throws SOAPException;
}

