/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.rpc;

import java.io.IOException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;
import javax.mail.MessagingException;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeBodyPart;
import org.apache.soap.Constants;
import org.apache.soap.Envelope;
import org.apache.soap.Header;
import org.apache.soap.SOAPException;
import org.apache.soap.encoding.SOAPMappingRegistry;
import org.apache.soap.rpc.RPCMessage;
import org.apache.soap.rpc.Response;
import org.apache.soap.rpc.SOAPContext;
import org.apache.soap.server.ServiceManager;
import org.apache.soap.transport.SOAPTransport;
import org.apache.soap.transport.http.SOAPHTTPConnection;
import org.apache.soap.util.mime.MimeUtils;
import org.apache.soap.util.xml.XMLParserUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class Call
extends RPCMessage {
    private SOAPMappingRegistry smr = null;
    private SOAPTransport st = null;
    private int to = 0;
    private boolean useDocumentBuilder = true;

    public Call() {
        this(null, null, null, null, null);
    }

    public Call(String targetObjectURI, String methodName, Vector params, Header header, String encodingStyleURI) {
        this(targetObjectURI, methodName, params, header, encodingStyleURI, new SOAPContext());
    }

    public Call(String targetObjectURI, String methodName, Vector params, Header header, String encodingStyleURI, SOAPContext ctx) {
        super(targetObjectURI, methodName, params, header, encodingStyleURI, ctx);
    }

    public void setSOAPMappingRegistry(SOAPMappingRegistry smr) {
        this.smr = smr;
    }

    public SOAPMappingRegistry getSOAPMappingRegistry() {
        if (this.smr == null) {
            this.smr = new SOAPMappingRegistry();
        }
        return this.smr;
    }

    public void setSOAPTransport(SOAPTransport st) {
        this.st = st;
    }

    public SOAPTransport getSOAPTransport() {
        return this.st;
    }

    public void setTimeout(int value) {
        this.to = value;
    }

    public int getTimeout() {
        return this.to;
    }

    public boolean getUseDocumentBuilder() {
        return this.useDocumentBuilder;
    }

    public void setUseDocumentBuilder(boolean useDocumentBuilder) {
        this.useDocumentBuilder = useDocumentBuilder;
    }

    public void addBodyPart(MimeBodyPart part) throws MessagingException {
        this.ctx.addBodyPart(part);
    }

    public void removeBodyPart(MimeBodyPart part) throws MessagingException {
        this.ctx.removeBodyPart(part);
    }

    public Envelope buildEnvelope() {
        return super.buildEnvelope(false);
    }

    public static Call extractFromEnvelope(Envelope env, ServiceManager svcMgr, SOAPContext ctx) throws IllegalArgumentException {
        return (Call)RPCMessage.extractFromEnvelope(env, svcMgr, false, null, ctx);
    }

    public static String getEnvelopeString(SOAPTransport st) throws SOAPException, MessagingException, IOException {
        SOAPContext respCtx = st.getResponseSOAPContext();
        Object in = null;
        String payloadStr = null;
        String ctype = respCtx.getRootPartContentType();
        ContentType type = null;
        type = MimeUtils.getContentType(ctype);
        if (type != null && Constants.CTYPE_TEXT_ALL.match(type)) {
            payloadStr = respCtx.getEnvelope();
        }
        if (type == null || !Constants.CTYPE_TEXT_XML.match(type)) {
            throw new SOAPException(Constants.FAULT_CODE_PROTOCOL, "Unsupported response content type \"" + ctype + "\", must be: \"" + "text/xml" + "\"." + (payloadStr == null ? "" : " Response was:\n" + payloadStr));
        }
        return payloadStr;
    }

    public Response invoke(URL url, String SOAPActionURI) throws SOAPException {
        return this.invoke(url, SOAPActionURI, null);
    }

    public Response invoke(URL url, String SOAPActionURI, Hashtable headers) throws SOAPException {
        if (SOAPActionURI == null) {
            SOAPActionURI = "";
        }
        if (this.smr == null) {
            this.smr = new SOAPMappingRegistry();
        }
        try {
            Envelope callEnv = this.buildEnvelope();
            if (this.st == null) {
                this.st = new SOAPHTTPConnection();
            }
            if (this.to != 0 && this.st instanceof SOAPHTTPConnection) {
                ((SOAPHTTPConnection)this.st).setTimeout(this.to);
            }
            this.st.send(url, SOAPActionURI, headers, callEnv, this.smr, this.ctx);
            SOAPContext respCtx = this.st.getResponseSOAPContext();
            if (respCtx.getOneWay()) {
                return null;
            }
            String payloadStr = Call.getEnvelopeString(this.st);
            Document respDoc = XMLParserUtils.parse(payloadStr, this.useDocumentBuilder);
            Element payload = null;
            if (respDoc == null) {
                throw new SOAPException(Constants.FAULT_CODE_CLIENT, "Parsing error, response was:\n" + payloadStr);
            }
            payload = respDoc.getDocumentElement();
            Envelope respEnv = Envelope.unmarshall(payload, respCtx);
            Response resp = Response.extractFromEnvelope(respEnv, this.smr, respCtx);
            String fullTargetObjectURI = resp.getFullTargetObjectURI();
            if (fullTargetObjectURI != null) {
                this.setTargetObjectURI(fullTargetObjectURI);
            }
            return resp;
        }
        catch (MessagingException me) {
            throw new SOAPException(Constants.FAULT_CODE_CLIENT, me.getMessage(), me);
        }
        catch (IllegalArgumentException e) {
            throw new SOAPException(Constants.FAULT_CODE_CLIENT, e.getMessage(), e);
        }
        catch (SAXException e) {
            throw new SOAPException(Constants.FAULT_CODE_CLIENT, "Parsing error, response was:\n" + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new SOAPException(Constants.FAULT_CODE_PROTOCOL, e.getMessage(), e);
        }
    }
}

