/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap;

import java.io.PrintStream;
import java.io.PrintWriter;

public class SOAPException
extends Exception {
    private String faultCode;
    private Throwable targetException;

    public SOAPException(String faultCode, String msg) {
        super(msg);
        this.faultCode = faultCode;
    }

    public SOAPException(String faultCode, String msg, Throwable targetException) {
        this(faultCode, msg);
        this.targetException = targetException;
    }

    public void setFaultCode(String faultCode) {
        this.faultCode = faultCode;
    }

    public String getFaultCode() {
        return this.faultCode;
    }

    public void setTargetException(Throwable targetException) {
        this.targetException = targetException;
    }

    public Throwable getTargetException() {
        return this.targetException;
    }

    public Throwable getRootException() {
        return this.targetException != null ? this.targetException : this;
    }

    public String getMessage() {
        String msg;
        String superMsg = super.getMessage();
        String targetMsg = this.targetException != null ? this.targetException.getMessage() : null;
        String string = msg = (superMsg == null || superMsg.equals("")) && targetMsg != null && !targetMsg.equals("") ? targetMsg : superMsg;
        if (msg == null || msg.equals("")) {
            msg = this.targetException != null ? this.targetException.toString() : this.toString();
        }
        return msg;
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(PrintStream ps) {
        PrintStream printStream = ps;
        synchronized (printStream) {
            super.printStackTrace(ps);
            if (this.targetException != null) {
                ps.print("Caused by: ");
                this.targetException.printStackTrace(ps);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(PrintWriter pw) {
        PrintWriter printWriter = pw;
        synchronized (printWriter) {
            super.printStackTrace(pw);
            if (this.targetException != null) {
                pw.print("Caused by: ");
                this.targetException.printStackTrace(pw);
            }
        }
    }

    public String toString() {
        return "[SOAPException: faultCode=" + this.faultCode + "; msg=" + super.getMessage() + (this.targetException != null ? "; targetException=" + this.targetException : "") + "]";
    }
}

